/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.extractInterface;

import com.goide.formatter.GoFormatterUtil;
import com.goide.psi.GoFile;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.refactor.GoRefactoringProcessorBase;
import com.goide.refactor.extractInterface.GoExtractInterfaceInfoModel;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.refactor.util.GoReferenceConverter;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public class GoExtractInterfaceProcessor
extends GoRefactoringProcessorBase<GoExtractInterfaceInfoModel> {
    private static final Logger LOG = Logger.getInstance(GoExtractInterfaceProcessor.class);

    @VisibleForTesting
    public GoExtractInterfaceProcessor(@NotNull Project project, @NotNull GoExtractInterfaceInfoModel model, boolean openInEditor) {
        if (project == null) {
            GoExtractInterfaceProcessor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            GoExtractInterfaceProcessor.$$$reportNull$$$0(1);
        }
        super(project, model, openInEditor);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            GoExtractInterfaceProcessor.$$$reportNull$$$0(2);
        }
        SmartList declarations = new SmartList();
        GoTypeSpec typeSpec = ((GoExtractInterfaceInfoModel)this.myModel).getTypeSpec();
        if (((GoExtractInterfaceInfoModel)this.myModel).isRenameTypeSpec() || GoTypeUtil.isInterface(typeSpec)) {
            declarations.add(typeSpec);
        }
        ContainerUtil.addAll((Collection)declarations, (Object[])((GoExtractInterfaceInfoModel)this.myModel).getDeclarationsToChangeVisibility());
        return new BaseUsageViewDescriptor(declarations.toArray(PsiElement.EMPTY_ARRAY));
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = ((GoExtractInterfaceInfoModel)this.myModel).findUsages();
        if (usageInfoArray == null) {
            GoExtractInterfaceProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        GoFile file;
        if (usages == null) {
            GoExtractInterfaceProcessor.$$$reportNull$$$0(4);
        }
        if ((file = this.prepareFile()) == null) {
            return;
        }
        this.changeDeclarationsVisibility(usages);
        this.createInterfaceAndOpenInEditor(file);
        this.embedInterfaceIfNecessary(file);
    }

    private void createInterfaceAndOpenInEditor(@NotNull GoFile file) {
        if (file == null) {
            GoExtractInterfaceProcessor.$$$reportNull$$$0(5);
        }
        StringBuilder builder = new StringBuilder();
        for (GoNamedElement method : ((GoExtractInterfaceInfoModel)this.myModel).getDeclarationsToRefactor()) {
            String name = Objects.requireNonNull(method.getName());
            GoSignature signature = Objects.requireNonNull(((GoNamedSignatureOwner)method).getSignature());
            String signatureText = GoReferenceConverter.on(signature, file).getText();
            builder.append(name).append(signatureText).append('\n');
        }
        String newTypeName = ((GoExtractInterfaceInfoModel)this.myModel).getNewTypeName();
        GoTypeDeclaration declaration = GoElementFactory.createTypeDeclaration(this.myProject, newTypeName, "interface", builder.toString());
        PsiElement addedDeclaration = file.add(declaration);
        GoFormatterUtil.reformat(addedDeclaration);
        file.add(GoElementFactory.createNewLine(this.myProject));
        if (this.myOpenInEditor && addedDeclaration.isValid()) {
            ApplicationManager.getApplication().invokeLater(() -> EditorHelper.openInEditor((PsiElement)addedDeclaration));
        }
    }

    private void embedInterfaceIfNecessary(@NotNull GoFile file) {
        GoTypeSpec typeSpec;
        if (file == null) {
            GoExtractInterfaceProcessor.$$$reportNull$$$0(6);
        }
        if (GoTypeUtil.isInterface(typeSpec = ((GoExtractInterfaceInfoModel)this.myModel).getTypeSpec())) {
            GoFile specFile = typeSpec.getContainingFile();
            boolean samePackage = GoUtil.isDirectlyAccessible((PsiFile)specFile, (PsiFile)file);
            String newTypeName = ((GoExtractInterfaceInfoModel)this.myModel).getNewTypeName();
            if (samePackage || StringUtil.isCapitalized((String)newTypeName)) {
                String qualifier = "";
                if (!samePackage) {
                    String importPath = file.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file));
                    qualifier = GoRefactoringUtil.importPackageIfNeeded(specFile, StringUtil.notNullize((String)importPath));
                }
                String methodSpecText = qualifier.isEmpty() ? newTypeName : qualifier + "." + newTypeName;
                GoMethodSpec embeddedInterface = GoElementFactory.createMethodSpec(this.myProject, methodSpecText);
                GoInterfaceType interfaceType = (GoInterfaceType)typeSpec.getSpecType().getContextlessUnderlyingType();
                interfaceType.addBefore(embeddedInterface, PsiTreeUtil.skipWhitespacesForward((PsiElement)interfaceType.getLbrace()));
                StreamEx.of((Object[])((GoExtractInterfaceInfoModel)this.myModel).getDeclarationsToRefactor()).forEach(PsiElement::delete);
            }
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"extract.interface.title");
        if (string == null) {
            GoExtractInterfaceProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected Logger getLog() {
        Logger logger = LOG;
        if (logger == null) {
            GoExtractInterfaceProcessor.$$$reportNull$$$0(8);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/extractInterface/GoExtractInterfaceProcessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/extractInterface/GoExtractInterfaceProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInterfaceAndOpenInEditor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "embedInterfaceIfNecessary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8 -> new IllegalStateException(string);
        };
    }
}

