/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.changeSignature;

import com.goide.GoFileType;
import com.goide.GoTypes;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportList;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.refactor.changeSignature.GoParameterInfo;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditorBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class GoParameterTableModel
extends ParameterTableModelBase<GoParameterInfo, Item> {
    private final Project myProject;

    GoParameterTableModel(@NotNull Project project, @Nullable PsiElement typeContext, @Nullable PsiElement defaultValueContext) {
        if (project == null) {
            GoParameterTableModel.$$$reportNull$$$0(0);
        }
        super(typeContext, defaultValueContext, GoParameterTableModel.getColumns(project));
        this.myProject = project;
    }

    private static ColumnInfo @NotNull [] getColumns(@NotNull Project project) {
        if (project == null) {
            GoParameterTableModel.$$$reportNull$$$0(1);
        }
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new GoNameColumn(project), new GoTypeColumn(project), new GoDefaultValueColumn(project)};
        if (columnInfoArray == null) {
            GoParameterTableModel.$$$reportNull$$$0(2);
        }
        return columnInfoArray;
    }

    GoParameterInfo[] getParameters() {
        return (GoParameterInfo[])ContainerUtil.map2Array((Collection)this.getItems(), (Object[])GoParameterInfo.EMPTY_ARRAY, item -> ((GoParameterInfo)item.parameter).updateFrom((Item)((Object)item)));
    }

    protected Item createRowItem(@Nullable GoParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new GoParameterInfo();
        }
        GoCodeFragment typeCodeFragment = this.createTypeCodeFragment(parameterInfo);
        GoCodeFragment defaultValueCodeFragment = GoCodeFragment.createExpression(this.myProject, parameterInfo.getDefaultValue(), true, this.myDefaultValueContext, true);
        defaultValueCodeFragment.setExpectedType(parameterInfo.getType());
        return new Item(parameterInfo, typeCodeFragment, defaultValueCodeFragment);
    }

    @NotNull
    private GoCodeFragment createTypeCodeFragment(@NotNull GoParameterInfo parameter) {
        if (parameter == null) {
            GoParameterTableModel.$$$reportNull$$$0(3);
        }
        GoCodeFragment fragment = GoCodeFragment.createType(this.myProject, parameter.getTypeText(), true, this.myTypeContext, true);
        this.replaceImports(fragment, this.myTypeContext);
        GoImportList importList = fragment.getImportList();
        if (importList != null) {
            parameter.getImports().forEach(i -> importList.addImport(i.getImportPath(), i.getAlias()));
        }
        GoType type = parameter.getType();
        if (importList != null && type != null) {
            GoRefactoringUtil.TypeTextWithImports textWithImports = GoRefactoringUtil.getTypeTextWithImports(fragment, type);
            Document document = Objects.requireNonNull(PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)fragment));
            WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])new PsiFile[]{fragment}).run(() -> {
                textWithImports.imports.forEach(i -> importList.addImport(i.getImportPath(), i.getAlias()));
                document.setText((CharSequence)((parameter.isVariadic() ? "..." : "") + textWithImports.typeText));
            });
        }
        GoCodeFragment goCodeFragment = fragment;
        if (goCodeFragment == null) {
            GoParameterTableModel.$$$reportNull$$$0(4);
        }
        return goCodeFragment;
    }

    private void replaceImports(@NotNull GoCodeFragment fragment, @NotNull PsiElement context) {
        GoImportList contextImportList;
        if (fragment == null) {
            GoParameterTableModel.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GoParameterTableModel.$$$reportNull$$$0(6);
        }
        GoImportList fragmentImportList = fragment.getImportList();
        GoFile contextFile = (GoFile)((Object)ObjectUtils.tryCast((Object)context.getContainingFile(), GoFile.class));
        if (fragmentImportList != null && contextFile != null && (contextImportList = contextFile.getImportList()) != null) {
            WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])new PsiFile[]{fragment}).run(() -> fragmentImportList.replace(contextImportList));
        }
    }

    public void setValueAtWithoutUpdate(Object value, int rowIndex, int columnIndex) {
        GoType type;
        super.setValueAtWithoutUpdate(value, rowIndex, columnIndex);
        if (columnIndex == 1 && value instanceof String && (type = GoElementFactory.createTypeCheap(this.myProject, (String)value, this.myTypeContext)) != null) {
            ParameterTableModelItemBase item = (ParameterTableModelItemBase)this.getItem(rowIndex);
            ((GoCodeFragment)item.defaultValueCodeFragment).setExpectedType(type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/changeSignature/GoParameterTableModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/changeSignature/GoParameterTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypeCodeFragment";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    private static final class GoNameColumn
    extends ParameterTableModelBase.NameColumn<GoParameterInfo, Item> {
        private GoNameColumn(@NotNull Project project) {
            if (project == null) {
                GoNameColumn.$$$reportNull$$$0(0);
            }
            super(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/goide/refactor/changeSignature/GoParameterTableModel$GoNameColumn", "<init>"));
        }
    }

    private static final class GoTypeColumn
    extends ParameterTableModelBase.TypeColumn<GoParameterInfo, Item> {
        private GoTypeColumn(Project project) {
            super(project, (FileType)GoFileType.INSTANCE);
        }
    }

    private static final class GoDefaultValueColumn
    extends ParameterTableModelBase.DefaultValueColumn<GoParameterInfo, Item> {
        private final Project myProject;

        private GoDefaultValueColumn(Project project) {
            super(project, (FileType)GoFileType.INSTANCE);
            this.myProject = project;
        }

        public TableCellEditor doCreateEditor(Item item) {
            return new CodeFragmentTableCellEditorBase(this.myProject, (FileType)GoFileType.INSTANCE){

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    GoType type = ((GoCodeFragment)((Item)((Object)((GoParameterTableModel)((Object)table.getModel())).getItem((int)row))).typeCodeFragment).getType();
                    if (type != null) {
                        ((GoCodeFragment)this.myCodeFragment).setExpectedType(type);
                    }
                    return editor;
                }
            };
        }
    }

    static class Item
    extends ParameterTableModelItemBase<GoParameterInfo> {
        private Item(@NotNull GoParameterInfo info, @NotNull GoCodeFragment type, @NotNull GoCodeFragment defaultValue) {
            if (info == null) {
                Item.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Item.$$$reportNull$$$0(1);
            }
            if (defaultValue == null) {
                Item.$$$reportNull$$$0(2);
            }
            super((Object)info, (PsiCodeFragment)type, (PsiCodeFragment)defaultValue);
        }

        @TestOnly
        Item(@NotNull GoParameterInfo info) {
            if (info == null) {
                Item.$$$reportNull$$$0(3);
            }
            super((Object)info, null, null);
        }

        public boolean isEllipsisType() {
            ASTNode node = (ASTNode)ObjectUtils.doIfNotNull((Object)this.typeCodeFragment.getFirstChild(), PsiElement::getNode);
            return node != null && node.getElementType() == GoTypes.TRIPLE_DOT;
        }

        @Nullable
        GoType getType() {
            return ((GoCodeFragment)this.typeCodeFragment).getType();
        }

        @Nullable
        GoExpression getDefaultValue() {
            return ((GoCodeFragment)this.defaultValueCodeFragment).getExpression();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
            }
            objectArray[1] = "com/goide/refactor/changeSignature/GoParameterTableModel$Item";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

