/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.changeSignature;

import com.goide.codeInsight.imports.GoImport;
import com.goide.psi.GoExpression;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.refactor.changeSignature.GoParameterTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoParameterInfo
implements ParameterInfo {
    public static final GoParameterInfo[] EMPTY_ARRAY = new GoParameterInfo[0];
    private final int myOldIndex;
    private final String myOldName;
    private final GoType myOldType;
    private final boolean myOldVariadic;
    private String myName;
    private GoType myType;
    private GoExpression myDefaultValue;
    private boolean myVariadic;
    private final Set<GoImport> myImports;

    GoParameterInfo(@NotNull GoParamDefinition definition) {
        if (definition == null) {
            GoParameterInfo.$$$reportNull$$$0(0);
        }
        this.myName = "";
        this.myOldIndex = ((GoParameters)definition.getParent().getParent()).getIndexOfDefinition(definition);
        this.myOldName = this.myName = StringUtil.notNullize((String)definition.getName());
        this.myOldType = this.myType = GoTypeUtil.unwrapVariadicArrayOrSliceType(definition.getGoType(null), definition.isVariadic());
        this.myOldVariadic = this.myVariadic = definition.isVariadic();
        this.myImports = Collections.emptySet();
    }

    GoParameterInfo(@NotNull GoParameterDeclaration declaration) {
        if (declaration == null) {
            GoParameterInfo.$$$reportNull$$$0(1);
        }
        this.myName = "";
        GoType type = declaration.getType();
        this.myOldIndex = ((GoParameters)declaration.getParent()).getIndexOfType(type);
        this.myOldName = "";
        this.myOldType = this.myType = type;
        this.myOldVariadic = this.myVariadic = declaration.isVariadic();
        this.myImports = Collections.emptySet();
    }

    GoParameterInfo(int oldIndex, @NotNull GoType type, boolean variadic) {
        if (type == null) {
            GoParameterInfo.$$$reportNull$$$0(2);
        }
        this(oldIndex, "", type, variadic);
    }

    public GoParameterInfo(int oldIndex, @NotNull String name, @NotNull GoType type, boolean variadic) {
        if (name == null) {
            GoParameterInfo.$$$reportNull$$$0(3);
        }
        if (type == null) {
            GoParameterInfo.$$$reportNull$$$0(4);
        }
        this(oldIndex, name, type, variadic, Collections.emptySet());
    }

    public GoParameterInfo(int oldIndex, @NotNull String name, @NotNull GoType type, boolean variadic, Set<GoImport> imports) {
        if (name == null) {
            GoParameterInfo.$$$reportNull$$$0(5);
        }
        if (type == null) {
            GoParameterInfo.$$$reportNull$$$0(6);
        }
        this.myName = "";
        this.myOldIndex = oldIndex;
        this.myOldName = this.myName = name;
        this.myOldType = this.myType = type;
        this.myOldVariadic = this.myVariadic = variadic;
        this.myDefaultValue = null;
        this.myImports = imports;
    }

    public GoParameterInfo(@NotNull GoParameterInfo info, @NotNull GoType type, boolean variadic, @Nullable GoExpression defaultValue) {
        if (info == null) {
            GoParameterInfo.$$$reportNull$$$0(7);
        }
        if (type == null) {
            GoParameterInfo.$$$reportNull$$$0(8);
        }
        this.myName = "";
        this.myOldIndex = info.myOldIndex;
        this.myOldName = info.myOldName;
        this.myOldType = info.myOldType;
        this.myOldVariadic = info.myOldVariadic;
        this.myName = info.myName;
        this.myType = type;
        this.myDefaultValue = defaultValue;
        this.myVariadic = variadic;
        this.myImports = Collections.emptySet();
    }

    GoParameterInfo() {
        this.myName = "";
        this.myOldIndex = -1;
        this.myOldName = "";
        this.myOldType = null;
        this.myOldVariadic = false;
        this.myImports = Collections.emptySet();
    }

    private GoParameterInfo(@NotNull GoParameterInfo info) {
        if (info == null) {
            GoParameterInfo.$$$reportNull$$$0(9);
        }
        this.myName = "";
        this.myOldIndex = info.myOldIndex != -1 ? info.myOldIndex + 1 : -1;
        this.myOldName = info.myOldName;
        this.myOldType = info.myOldType;
        this.myOldVariadic = info.myOldVariadic;
        this.myName = info.myName;
        this.myType = info.myType;
        this.myDefaultValue = info.myDefaultValue;
        this.myVariadic = info.myVariadic;
        this.myImports = Collections.emptySet();
    }

    @NotNull
    @Contract(value="_ -> new")
    static GoParameterInfo incrementOldIndex(@NotNull GoParameterInfo info) {
        if (info == null) {
            GoParameterInfo.$$$reportNull$$$0(10);
        }
        return new GoParameterInfo(info);
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    boolean isNameChanged() {
        return this.myOldIndex != -1 && !this.myName.equals(this.myOldName);
    }

    boolean isTypeChanged() {
        return this.myOldIndex != -1 && (this.myVariadic != this.myOldVariadic || !GoParameterInfo.getText(this.myOldType).equals(GoParameterInfo.getText(this.myType)));
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GoParameterInfo.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            GoParameterInfo.$$$reportNull$$$0(12);
        }
        this.myName = name;
    }

    @NotNull
    public String getTypeText() {
        String string = (this.myVariadic ? "..." : "") + GoParameterInfo.getText(this.myType);
        if (string == null) {
            GoParameterInfo.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getText(@Nullable GoType type) {
        return type != null ? type.getText() : "";
    }

    @Nullable
    public GoType getType() {
        return this.myType;
    }

    @NotNull
    public String getDefaultValue() {
        return this.myDefaultValue != null ? this.myDefaultValue.getText() : "";
    }

    @Nullable
    GoExpression getDefaultValueExpression() {
        return this.myDefaultValue;
    }

    public boolean isVariadic() {
        return this.myVariadic;
    }

    @NotNull
    GoParameterInfo updateFrom(@NotNull GoParameterTableModel.Item item) {
        if (item == null) {
            GoParameterInfo.$$$reportNull$$$0(14);
        }
        this.myType = item.getType();
        this.myDefaultValue = item.getDefaultValue();
        this.myVariadic = item.isEllipsisType();
        GoParameterInfo goParameterInfo = this;
        if (goParameterInfo == null) {
            GoParameterInfo.$$$reportNull$$$0(15);
        }
        return goParameterInfo;
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean useAnySingleVariable) {
    }

    public Set<GoImport> getImports() {
        return this.myImports;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/changeSignature/GoParameterInfo";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/changeSignature/GoParameterInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "incrementOldIndex";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13, 15 -> new IllegalStateException(string);
        };
    }
}

