/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.changeSignature;

import com.goide.GoTypes;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParameters;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.refactor.changeSignature.GoParameterInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoMethodDescriptor
implements MethodDescriptor<GoParameterInfo, Void> {
    private final GoNamedSignatureOwner myMethod;
    private final GoSignature mySignature;
    private final List<GoParameterInfo> myParameters;
    private final List<GoParameterInfo> myResultParameters;
    private final GoCompositeElement myLocationToSkip;
    private final boolean myRefactorImplementations;
    private final boolean myReuseTypes;
    private boolean myNewReuseTypes;

    GoMethodDescriptor(@NotNull GoNamedSignatureOwner method, @NotNull GoSignature signature, @NotNull List<GoParameterInfo> parameters, @NotNull List<GoParameterInfo> resultParameters, @Nullable GoCompositeElement locationToSkip, boolean refactorImplementations, boolean reuseTypes) {
        if (method == null) {
            GoMethodDescriptor.$$$reportNull$$$0(0);
        }
        if (signature == null) {
            GoMethodDescriptor.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            GoMethodDescriptor.$$$reportNull$$$0(2);
        }
        if (resultParameters == null) {
            GoMethodDescriptor.$$$reportNull$$$0(3);
        }
        this.myMethod = method;
        this.mySignature = signature;
        this.myParameters = parameters;
        this.myResultParameters = resultParameters;
        this.myLocationToSkip = locationToSkip;
        this.myRefactorImplementations = refactorImplementations;
        this.myReuseTypes = this.myNewReuseTypes = reuseTypes;
    }

    @Nullable
    public String getName() {
        return this.myMethod.getName();
    }

    @NotNull
    public List<GoParameterInfo> getParameters() {
        List<GoParameterInfo> list = this.myParameters;
        if (list == null) {
            GoMethodDescriptor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    List<GoParameterInfo> getResultParameters() {
        List<GoParameterInfo> list = this.myResultParameters;
        if (list == null) {
            GoMethodDescriptor.$$$reportNull$$$0(5);
        }
        return list;
    }

    public int getParametersCount() {
        return this.getParameters().size();
    }

    @NotNull
    public GoNamedSignatureOwner getMethod() {
        GoNamedSignatureOwner goNamedSignatureOwner = this.myMethod;
        if (goNamedSignatureOwner == null) {
            GoMethodDescriptor.$$$reportNull$$$0(6);
        }
        return goNamedSignatureOwner;
    }

    @NotNull
    GoSignature getSignature() {
        GoSignature goSignature = this.mySignature;
        if (goSignature == null) {
            GoMethodDescriptor.$$$reportNull$$$0(7);
        }
        return goSignature;
    }

    boolean hasParameterTrailingComma() {
        return GoMethodDescriptor.hasTrailingComma(this.mySignature.getParameters().getRparen());
    }

    boolean hasResultParameterTrailingComma() {
        GoParameters parameters = (GoParameters)ObjectUtils.doIfNotNull((Object)this.mySignature.getResult(), GoResult::getParameters);
        return parameters != null && GoMethodDescriptor.hasTrailingComma(parameters.getRparen());
    }

    @Contract(value="null -> false")
    static boolean hasTrailingComma(@Nullable PsiElement rparen) {
        PsiElement comma = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)rparen);
        return comma != null && comma.getNode().getElementType() == GoTypes.COMMA;
    }

    @Nullable
    GoCompositeElement getLocationToSkip() {
        return this.myLocationToSkip;
    }

    boolean isRefactorImplementations() {
        return this.myRefactorImplementations;
    }

    boolean isReuseTypes() {
        return this.myNewReuseTypes;
    }

    void setReuseTypes(boolean newReuseTypes) {
        this.myNewReuseTypes = newReuseTypes;
    }

    boolean isReuseTypesChanged() {
        return this.myReuseTypes != this.myNewReuseTypes;
    }

    @NotNull
    public Void getVisibility() {
        throw new AbstractMethodError();
    }

    public boolean canChangeParameters() {
        return true;
    }

    public boolean canChangeName() {
        return true;
    }

    public boolean canChangeVisibility() {
        return false;
    }

    @NotNull
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        MethodDescriptor.ReadWriteOption readWriteOption = MethodDescriptor.ReadWriteOption.None;
        if (readWriteOption == null) {
            GoMethodDescriptor.$$$reportNull$$$0(8);
        }
        return readWriteOption;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/changeSignature/GoMethodDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/changeSignature/GoMethodDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "canChangeReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

