/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoDuplicatesSearch;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoViewAllDuplicatesQuickFix<T extends PsiElement>
implements LocalQuickFix {
    @NotNull
    private final String myName;
    @NotNull
    private final GoDuplicatesSearch<? super T> mySearch;
    @NotNull
    private final SmartPsiElementPointer<T> myContainerPointer;

    public GoViewAllDuplicatesQuickFix(@NotNull String name, @NotNull T container, @NotNull GoDuplicatesSearch<? super T> search) {
        if (name == null) {
            GoViewAllDuplicatesQuickFix.$$$reportNull$$$0(0);
        }
        if (container == null) {
            GoViewAllDuplicatesQuickFix.$$$reportNull$$$0(1);
        }
        if (search == null) {
            GoViewAllDuplicatesQuickFix.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myContainerPointer = SmartPointerManager.getInstance((Project)container.getProject()).createSmartPsiElementPointer(container);
        this.mySearch = search;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = GoBundle.message((String)"go.fix.view.all.duplicates.text", (Object[])new Object[]{this.myName});
        if (string == null) {
            GoViewAllDuplicatesQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.fix.view.all.duplicates.name", (Object[])new Object[0]);
        if (string == null) {
            GoViewAllDuplicatesQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement container;
        if (project == null) {
            GoViewAllDuplicatesQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            GoViewAllDuplicatesQuickFix.$$$reportNull$$$0(6);
        }
        if ((container = this.myContainerPointer.getElement()) == null || !container.isValid()) {
            return;
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        String searchTitle = this.mySearch.getTitle();
        String title = GoBundle.message((String)"go.fix.view.all.duplicates.targets.tab.text", (Object[])new Object[]{this.myName});
        presentation.setTabText(title);
        presentation.setToolwindowTitle(GoBundle.message((String)"go.fix.view.all.duplicates.targets.tool.window.title", (Object[])new Object[]{title, searchTitle}));
        presentation.setSearchString(StringUtil.decapitalize((String)title));
        presentation.setCodeUsagesString(GoBundle.message((String)"go.fix.view.all.duplicates.targets.code.usages.string", (Object[])new Object[0]));
        presentation.setCodeUsages(true);
        presentation.setUsageTypeFilteringAvailable(true);
        presentation.setScopeText(searchTitle);
        UsageTarget[] targets = new UsageTarget[]{new DuplicatesUsageTarget(presentation.getToolwindowTitle())};
        UsageViewManager.getInstance((Project)project).searchAndShowUsages(targets, this.createUsageSearchFactory(), false, false, presentation, null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    private Factory<UsageSearcher> createUsageSearchFactory() {
        Factory factory = () -> processor2 -> ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement container = this.myContainerPointer.getElement();
            if (container != null && container.isValid()) {
                this.mySearch.processElementsWithName(this.myName, container, (Processor<GoDuplicatesSearch.Duplicate>)((Processor)d -> processor2.process((Object)new UsageInfo2UsageAdapter(new UsageInfo(d.sourceElement)))));
            }
        });
        if (factory == null) {
            GoViewAllDuplicatesQuickFix.$$$reportNull$$$0(7);
        }
        return factory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoViewAllDuplicatesQuickFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoViewAllDuplicatesQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageSearchFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7 -> new IllegalStateException(string);
        };
    }

    private static final class DuplicatesUsageTarget
    implements UsageTarget {
        private final String title;

        private DuplicatesUsageTarget(@NotNull String title) {
            if (title == null) {
                DuplicatesUsageTarget.$$$reportNull$$$0(0);
            }
            this.title = title;
        }

        public void findUsages() {
        }

        public boolean isValid() {
            return true;
        }

        @NotNull
        public String getName() {
            String string = this.title;
            if (string == null) {
                DuplicatesUsageTarget.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return new PresentationData(this.getName(), "", null, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/quickfix/GoViewAllDuplicatesQuickFix$DuplicatesUsageTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/quickfix/GoViewAllDuplicatesQuickFix$DuplicatesUsageTarget";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

