/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoBlock;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoElementFactory;
import com.goide.quickfix.GoSimplifyIfStatementUtil;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoSimplifyIfStatementQuickFixBase
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(GoSimplifyIfStatementQuickFixBase.class);

    protected GoSimplifyIfStatementQuickFixBase(@Nullable PsiElement element) {
        super(element);
    }

    @Nullable
    protected static GoElseStatement createElseStatement(@NotNull Project project, @NotNull List<GoStatement> statements) {
        if (project == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(0);
        }
        if (statements == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(1);
        }
        String elseBlock = StringUtil.join(statements, GoSimplifyIfStatementQuickFixBase::getTextWithComments, (String)"\n");
        return GoElementFactory.createIfStatement(project, "true", "", elseBlock).getElseStatement();
    }

    @NotNull
    protected static List<GoStatement> blockStatements(@NotNull GoStatement statement) {
        GoBlock block;
        if (statement == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(2);
        }
        List<GoStatement> list = (block = statement.getBlock()) != null ? block.getStatementList() : Collections.emptyList();
        if (list == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected static void replace(@Nullable PsiElement targetParent, @NotNull PsiElement target, @NotNull List<? extends PsiElement> replacement, @Nullable Project project, @Nullable Editor editor) {
        if (target == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(4);
        }
        if (replacement == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(5);
        }
        if (targetParent == null) {
            return;
        }
        GoRefactoringUtil.withVerticalScrollingSaved(editor, () -> {
            SmartList results = new SmartList();
            GoSimplifyIfStatementUtil.processElementsWithComments(replacement, (Processor<? super PsiElement>)((Processor)arg_0 -> GoSimplifyIfStatementQuickFixBase.lambda$replace$0((List)results, targetParent, target, arg_0)));
            results.forEach(r -> CodeEditUtil.markToReformat((ASTNode)r.getNode(), (boolean)true));
            target.delete();
            GoFormatterUtil.reformat(targetParent.getContainingFile(), (Collection<? extends PsiElement>)results);
            PsiElement firstResult = (PsiElement)ContainerUtil.getFirstItem((List)results);
            if (editor != null && firstResult != null) {
                editor.getCaretModel().moveToOffset(firstResult.getTextRange().getStartOffset());
            }
            GoRefactoringUtil.highlightSearchResults(project, editor, (List<PsiElement>)results);
        });
    }

    protected static void handleElseCreationError(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement context) {
        if (project == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(7);
        }
        LOG.error("Failed to create else statement", new Attachment[]{GoInspectionUtil.createAttachment(context)});
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)GoBundle.message((String)"go.fix.failed.to.simplify.if.statement", (Object[])new Object[0]), (String)"", (String)"");
    }

    protected static void handleExtractionError(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement context) {
        if (project == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(8);
        }
        if (context == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(9);
        }
        LOG.error("Failed to prepare code for extraction", new Attachment[]{GoInspectionUtil.createAttachment(context)});
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)GoBundle.message((String)"go.fix.failed.to.simplify.if.statement", (Object[])new Object[0]), (String)"", (String)"");
    }

    @NotNull
    private static String getTextWithComments(@NotNull GoStatement statement) {
        if (statement == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(10);
        }
        StringBuilder builder = new StringBuilder();
        GoDocumentationProvider.getUpperComments(statement).forEach(c -> builder.append(c.getText()).append('\n'));
        builder.append(statement.getText());
        GoDocumentationProvider.getAfterComments(statement).forEach(c -> builder.append(c.getText()).append(" "));
        String string = builder.toString();
        if (string == null) {
            GoSimplifyIfStatementQuickFixBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$replace$0(List results, PsiElement targetParent, PsiElement target, PsiElement e) {
        return results.add(targetParent.addBefore(e, target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoSimplifyIfStatementQuickFixBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoSimplifyIfStatementQuickFixBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "blockStatements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createElseStatement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "blockStatements";
                break;
            }
            case 3: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElseCreationError";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleExtractionError";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithComments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 11 -> new IllegalStateException(string);
        };
    }
}

