/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.GoTypes;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoExpression;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoStatement;
import com.goide.psi.GoType;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoExtractEmptySliceToVarDeclarationQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    @Nls
    @NotNull
    public static String getQuickFixName() {
        String string = GoBundle.message((String)"go.fix.extract.empty.slice.to.var.declaration.name", (Object[])new Object[0]);
        if (string == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public GoExtractEmptySliceToVarDeclarationQuickFix(@NotNull PsiElement element) {
        if (element == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(1);
        }
        super(element);
    }

    @NotNull
    public String getText() {
        return GoExtractEmptySliceToVarDeclarationQuickFix.getQuickFixName();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return GoExtractEmptySliceToVarDeclarationQuickFix.getQuickFixName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        List<GoVarDefinition> targetDefs;
        GoExpression assignedExpr;
        block10: {
            block9: {
                if (project == null) {
                    GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(2);
                }
                if (file == null) {
                    GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(3);
                }
                if (startElement == null) {
                    GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(4);
                }
                if (endElement == null) {
                    GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(5);
                }
                if (!(startElement instanceof GoExpression)) break block9;
                assignedExpr = (GoExpression)startElement;
                if (startElement.isValid()) break block10;
            }
            return;
        }
        GoVarSpec varSpec = (GoVarSpec)ObjectUtils.tryCast((Object)assignedExpr.getParent(), GoVarSpec.class);
        if (varSpec == null) {
            return;
        }
        List<GoExpression> assignedExprs = varSpec.getRightExpressionsList();
        GoVarDefinition targetDef = GoPsiUtil.getCorrespondingLeftExpr(assignedExpr, assignedExprs, targetDefs = varSpec.getVarDefinitionList());
        if (targetDef == null) {
            return;
        }
        GoExtractEmptySliceToVarDeclarationQuickFix.extractVar(project, editor, varSpec, targetDef, assignedExpr);
    }

    private static void extractVar(@NotNull Project project, @Nullable Editor editor, @NotNull GoVarSpec varSpec, @NotNull GoVarDefinition targetDef, @NotNull GoExpression assignedExpr) {
        String typeText;
        if (project == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(6);
        }
        if (varSpec == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(7);
        }
        if (targetDef == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(8);
        }
        if (assignedExpr == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(9);
        }
        String varNameText = targetDef.getName();
        GoType type = assignedExpr.getGoType(null);
        String string = typeText = type != null ? type.getText() : null;
        if (StringUtil.isEmpty((String)varNameText) || StringUtil.isEmpty((String)typeText)) {
            return;
        }
        PsiElement extracted = GoExtractEmptySliceToVarDeclarationQuickFix.extract(project, varSpec, targetDef, varNameText, typeText);
        if (editor != null && extracted != null) {
            editor.getCaretModel().moveToOffset(extracted.getTextRange().getEndOffset());
        }
    }

    @Nullable
    private static PsiElement extract(@NotNull Project project, @NotNull GoVarSpec varSpec, @NotNull GoVarDefinition targetDef, @NotNull String varNameText, @NotNull String typeText) {
        PsiElement enclosingDecl;
        if (project == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(10);
        }
        if (varSpec == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(11);
        }
        if (targetDef == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(12);
        }
        if (varNameText == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(13);
        }
        if (typeText == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(14);
        }
        if ((enclosingDecl = PsiTreeUtil.getNonStrictParentOfType((PsiElement)varSpec, (Class[])new Class[]{GoVarDeclaration.class, GoShortVarDeclaration.class})) == null) {
            return null;
        }
        if (enclosingDecl instanceof GoVarDeclaration && ((GoVarDeclaration)enclosingDecl).getLparen() != null) {
            Object newSpec = ((GoVarDeclaration)enclosingDecl).addSpec(varNameText, typeText, null, varSpec);
            varSpec.deleteDefinition(targetDef);
            return newSpec;
        }
        GoVarDeclaration newDecl = GoElementFactory.createVarDeclaration(project, varNameText + " " + typeText);
        GoStatement newDeclarationStatement = (GoStatement)ObjectUtils.tryCast((Object)newDecl.getParent(), GoStatement.class);
        LOG.assertTrue(newDeclarationStatement != null, (Object)("Create declaration is not in statement: " + newDecl.getText()));
        boolean isSingleVarSpec = varSpec.getVarDefinitionList().size() == 1 && varSpec.getVarDefinitionList().size() == varSpec.getExpressionList().size();
        PsiElement parent = enclosingDecl.getParent();
        if (isSingleVarSpec) {
            return parent instanceof GoStatement ? parent.replace((PsiElement)newDeclarationStatement) : enclosingDecl.replace((PsiElement)newDecl);
        }
        if (parent == null) {
            return null;
        }
        PsiElement extracted = parent instanceof GoStatement ? parent.getParent().addBefore((PsiElement)newDeclarationStatement, parent) : parent.addBefore((PsiElement)newDecl, enclosingDecl);
        varSpec.deleteDefinition(targetDef);
        if (enclosingDecl instanceof GoShortVarDeclaration) {
            GoExtractEmptySliceToVarDeclarationQuickFix.replaceWithAssignmentIfNeeded((GoShortVarDeclaration)enclosingDecl);
        }
        return extracted;
    }

    private static void replaceWithAssignmentIfNeeded(@NotNull GoShortVarDeclaration shortVarDeclaration) {
        List<GoVarDefinition> defs;
        if (shortVarDeclaration == null) {
            GoExtractEmptySliceToVarDeclarationQuickFix.$$$reportNull$$$0(15);
        }
        if (GoInspectionUtil.hasNoNewVariables(defs = shortVarDeclaration.getVarDefinitionList())) {
            ASTNode parentNode;
            PsiElement varAssign = shortVarDeclaration.getVarAssign();
            PsiElement parent = varAssign.getParent();
            ASTNode aSTNode = parentNode = parent != null ? parent.getNode() : null;
            if (parentNode == null) {
                return;
            }
            parentNode.addLeaf(GoTypes.ASSIGN, (CharSequence)"=", varAssign.getNode());
            varAssign.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoExtractEmptySliceToVarDeclarationQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varSpec";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedExpr";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varNameText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortVarDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoExtractEmptySliceToVarDeclarationQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractVar";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithAssignmentIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

