/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.i18n.GoBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDeleteRangeQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(GoDeleteRangeQuickFix.class);
    @IntentionName
    private final String myName;

    public GoDeleteRangeQuickFix(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull @IntentionName String name) {
        if (startElement == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(1);
        }
        if (name == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(2);
        }
        super(startElement, endElement);
        if (!startElement.getParent().equals(endElement.getParent())) {
            LOG.error("Cannot delete range of elements with different parents");
        }
        this.myName = name;
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.fix.delete.range.name", (Object[])new Object[0]);
        if (string == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement start, @NotNull PsiElement end) {
        if (project == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(6);
        }
        if (start == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(7);
        }
        if (end == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(8);
        }
        GoDeleteRangeQuickFix.deleteRange(start, end);
    }

    public static void deleteRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        PsiElement parent;
        if (start == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(9);
        }
        if (end == null) {
            GoDeleteRangeQuickFix.$$$reportNull$$$0(10);
        }
        if (start.isValid() && end.isValid() && (parent = start.getParent()) != null && parent.equals(end.getParent())) {
            parent.getNode().removeRange(start.getNode(), end.getNode().getTreeNext());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoDeleteRangeQuickFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoDeleteRangeQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

