/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.expectedTypes.GoCoreStringExpectedType;
import com.goide.psi.impl.expectedTypes.GoExpectedType;
import com.goide.psi.impl.expectedTypes.GoStringLikeExpectedType;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoConvertToExpectedTypeQuickFix
implements LocalQuickFix {
    @NotNull
    private final String myExpectedTypePresentationText;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiElementPointer<GoType> myExpressionType;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiElementPointer<GoType> myExpectedType;

    @Nls
    @NotNull
    static String getQuickFixName() {
        String string = GoBundle.message((String)"go.fix.convert.to.expected.type.name", (Object[])new Object[0]);
        if (string == null) {
            GoConvertToExpectedTypeQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public GoConvertToExpectedTypeQuickFix(@NotNull GoType expectedType, @NotNull GoType expressionType) {
        if (expectedType == null) {
            GoConvertToExpectedTypeQuickFix.$$$reportNull$$$0(1);
        }
        if (expressionType == null) {
            GoConvertToExpectedTypeQuickFix.$$$reportNull$$$0(2);
        }
        this.myExpressionType = SmartPointerManager.getInstance((Project)expectedType.getProject()).createSmartPsiElementPointer((PsiElement)expressionType);
        this.myExpectedType = SmartPointerManager.getInstance((Project)expectedType.getProject()).createSmartPsiElementPointer((PsiElement)expectedType);
        this.myExpectedTypePresentationText = expectedType.getPresentationText();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = GoBundle.message((String)"go.fix.convert.to.expected.type.text", (Object[])new Object[]{this.myExpectedTypePresentationText});
        if (string == null) {
            GoConvertToExpectedTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return GoConvertToExpectedTypeQuickFix.getQuickFixName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            GoConvertToExpectedTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            GoConvertToExpectedTypeQuickFix.$$$reportNull$$$0(5);
        }
        if ((element = descriptor.getStartElement()) == null || !element.isValid()) {
            return;
        }
        GoType expressionTypeBefore = (GoType)this.myExpressionType.getElement();
        GoType expectedTypeBefore = (GoType)this.myExpectedType.getElement();
        if (expressionTypeBefore == null || expectedTypeBefore == null) {
            return;
        }
        GoExpression expression = (GoExpression)ObjectUtils.tryCast((Object)element, GoExpression.class);
        if (expression == null) {
            return;
        }
        GoType expressionType = expression.getGoType(null);
        if (!GoTypeUtil.equalTypes(expressionType, expressionTypeBefore, expression, true)) {
            return;
        }
        if (!GoConvertToExpectedTypeQuickFix.expectedTypeNotChanged(expression, expectedTypeBefore, expression)) {
            return;
        }
        GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class));
        if (file == null) {
            return;
        }
        String expectedTypeText = GoRefactoringUtil.getTypeTextMakingImports(expectedTypeBefore, file, true, false);
        Object wrappedTypeText = expectedTypeBefore instanceof GoPointerType ? "(" + expectedTypeText + ")" : expectedTypeText;
        String conversionText = String.format("%s(%s)", wrappedTypeText, expression.getText());
        GoFormatterUtil.reformat(expression.replace(GoElementFactory.createExpression(project, conversionText)));
    }

    private static boolean expectedTypeNotChanged(@NotNull GoExpression expression, @NotNull GoType expectedTypeBefore, @NotNull PsiElement context) {
        if (expression == null) {
            GoConvertToExpectedTypeQuickFix.$$$reportNull$$$0(6);
        }
        if (expectedTypeBefore == null) {
            GoConvertToExpectedTypeQuickFix.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GoConvertToExpectedTypeQuickFix.$$$reportNull$$$0(8);
        }
        List<GoExpectedType> expectedTypes = GoTypeUtil.getExpectedTypes(expression, context).asList();
        GoType stringType = GoPsiImplUtil.getBuiltinType("string", context);
        for (GoExpectedType expectedType : expectedTypes) {
            if ((!(expectedType instanceof GoStringLikeExpectedType) && !(expectedType instanceof GoCoreStringExpectedType) || !GoTypeUtil.equalTypes(stringType, expectedTypeBefore, context, true)) && !GoTypeUtil.equalTypes(expectedType.getType(), expectedTypeBefore, context, true)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoConvertToExpectedTypeQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeBefore";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoConvertToExpectedTypeQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expectedTypeNotChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

