/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl.manipulator;

import com.goide.psi.GoStringLiteral;
import com.goide.utils.GoStringUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoStringManipulator
extends AbstractElementManipulator<GoStringLiteral> {
    public GoStringLiteral handleContentChange(@NotNull GoStringLiteral literal, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (literal == null) {
            GoStringManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            GoStringManipulator.$$$reportNull$$$0(1);
        }
        if (!literal.isValid() || !TextRange.from((int)0, (int)literal.getTextLength()).contains(range)) {
            return literal;
        }
        if (newContent.length() > 2 && literal.createLiteralTextEscaper().isOneLine()) {
            newContent = GoStringUtil.escapeString(newContent);
        }
        return literal.updateText(range.replace(literal.getText(), newContent));
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull GoStringLiteral element) {
        TextRange elementTextRange;
        PsiLanguageInjectionHost host;
        if (element == null) {
            GoStringManipulator.$$$reportNull$$$0(2);
        }
        if ((host = GoStringManipulator.getHost(element)) != null && (elementTextRange = GoStringManipulator.getRangeInHost(host, element)) != null) {
            LiteralTextEscaper escaper = host.createLiteralTextEscaper();
            StringBuilder decodedText = new StringBuilder();
            assert (escaper.getRelevantTextRange().contains(elementTextRange)) : escaper.getRelevantTextRange() + " " + elementTextRange;
            if (escaper.decode(elementTextRange, decodedText)) {
                TextRange range = GoStringManipulator.unquotedRange(decodedText.toString());
                int startOffset = escaper.getOffsetInHost(range.getStartOffset(), elementTextRange);
                int endOffset = escaper.getOffsetInHost(range.getEndOffset(), elementTextRange);
                if (startOffset != -1 && endOffset != -1) {
                    TextRange textRange = TextRange.create((int)startOffset, (int)endOffset).shiftLeft(elementTextRange.getStartOffset());
                    if (textRange == null) {
                        GoStringManipulator.$$$reportNull$$$0(3);
                    }
                    return textRange;
                }
            }
        }
        String elementText = element.getText();
        return GoStringManipulator.unquotedRange(elementText);
    }

    @Nullable
    private static PsiLanguageInjectionHost getHost(@NotNull GoStringLiteral element) {
        Place shreds;
        if (element == null) {
            GoStringManipulator.$$$reportNull$$$0(4);
        }
        if ((shreds = InjectedLanguageUtilBase.getShreds((PsiFile)element.getContainingFile())) != null) {
            for (PsiLanguageInjectionHost.Shred shred : shreds) {
                if (!shred.getRange().contains(element.getTextRange().getStartOffset())) continue;
                return shred.getHost();
            }
        }
        return null;
    }

    @Nullable
    private static TextRange getRangeInHost(@NotNull PsiLanguageInjectionHost host, @NotNull GoStringLiteral element) {
        if (host == null) {
            GoStringManipulator.$$$reportNull$$$0(5);
        }
        if (element == null) {
            GoStringManipulator.$$$reportNull$$$0(6);
        }
        TextRange elementTextRange = element.getTextRange();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)element.getProject());
        TextRange injectedToHost = manager.injectedToHost((PsiElement)element, elementTextRange);
        int hostStartOffset = host.getTextRange().getStartOffset();
        if (!injectedToHost.equals((Object)elementTextRange) && injectedToHost.getStartOffset() >= hostStartOffset) {
            return injectedToHost.shiftLeft(hostStartOffset);
        }
        return null;
    }

    @NotNull
    public static TextRange unquotedRange(@Nullable String s) {
        if (StringUtil.isEmpty((String)s)) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                GoStringManipulator.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        char quote = s.charAt(0);
        int startOffset = GoStringManipulator.isQuote(quote) ? 1 : 0;
        int endOffset = s.length();
        if (s.length() > 1) {
            char lastChar = s.charAt(s.length() - 1);
            if (GoStringManipulator.isQuote(quote) && lastChar == quote) {
                endOffset = s.length() - 1;
            }
            if (!GoStringManipulator.isQuote(quote) && GoStringManipulator.isQuote(lastChar)) {
                endOffset = s.length() - 1;
            }
        }
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            GoStringManipulator.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @NotNull
    public static String unquote(@Nullable String s) {
        return s != null ? GoStringManipulator.unquotedRange(s).substring(s) : "";
    }

    public static boolean isQuotedImportString(@NotNull String s) {
        if (s == null) {
            GoStringManipulator.$$$reportNull$$$0(9);
        }
        return s.length() > 1 && GoStringManipulator.isQuote(s.charAt(0)) && s.charAt(0) == s.charAt(s.length() - 1);
    }

    private static boolean isQuote(char ch) {
        return ch == '\"' || ch == '\'' || ch == '`';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/manipulator/GoStringManipulator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/manipulator/GoStringManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "unquotedRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHost";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInHost";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedImportString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8 -> new IllegalStateException(string);
        };
    }
}

