/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl.imports;

import com.goide.GoLanguage;
import com.goide.codeInsight.imports.GoImportPackageQuickFix;
import com.goide.codeInsight.imports.GoImportsSettings;
import com.goide.psi.GoCompositeElement;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

public final class GoReferenceImporter
implements ReferenceImporter {
    public BooleanSupplier computeAutoImportAtOffset(@NotNull Editor editor, @NotNull PsiFile file, int caretOffset, boolean allowCaretNearReference) {
        if (editor == null) {
            GoReferenceImporter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GoReferenceImporter.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caretOffset);
        int startOffset = document.getLineStartOffset(lineNumber);
        int endOffset = document.getLineEndOffset(lineNumber);
        Project project = file.getProject();
        List elements = CollectHighlightsUtil.getElementsInRange((PsiElement)file, (int)startOffset, (int)endOffset);
        for (PsiElement element : elements) {
            if (!(element instanceof GoCompositeElement)) continue;
            for (PsiReference reference : element.getReferences()) {
                GoImportPackageQuickFix fix;
                if (reference.resolve() != null || !(fix = GoReferenceImporter.findOrCreateFix(editor, file, reference)).isAvailable(project, editor, file)) continue;
                return () -> {
                    if (!fix.canAddUnambiguousImportsOnTheFly(project, file)) {
                        return false;
                    }
                    return fix.doAutoImportOrShowHint(editor, false);
                };
            }
        }
        return () -> false;
    }

    public boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile file) {
        if (file == null) {
            GoReferenceImporter.$$$reportNull$$$0(2);
        }
        return file.getViewProvider().getLanguages().contains(GoLanguage.INSTANCE) && GoImportsSettings.getInstance(file.getProject()).isAddUnambiguousImportsOnTheFly();
    }

    @NotNull
    private static GoImportPackageQuickFix findOrCreateFix(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiReference reference) {
        if (editor == null) {
            GoReferenceImporter.$$$reportNull$$$0(3);
        }
        if (file == null) {
            GoReferenceImporter.$$$reportNull$$$0(4);
        }
        if (reference == null) {
            GoReferenceImporter.$$$reportNull$$$0(5);
        }
        Ref fix = Ref.create();
        TextRange range = reference.getElement().getTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        DaemonCodeAnalyzerEx.processHighlights((Document)editor.getDocument(), (Project)file.getProject(), (HighlightSeverity)HighlightSeverity.ERROR, (int)start, (int)end, info -> {
            GoImportPackageQuickFix found = (GoImportPackageQuickFix)((Object)((Object)info.findRegisteredQuickFix((descriptor, fixRange) -> {
                GoImportPackageQuickFix action = (GoImportPackageQuickFix)((Object)((Object)((Object)ObjectUtils.tryCast((Object)descriptor.getAction(), GoImportPackageQuickFix.class))));
                if (action != null && reference.equals(GoImportPackageQuickFix.getReference(action.getStartElement()))) {
                    return action;
                }
                return null;
            })));
            if (found != null) {
                fix.set((Object)found);
                return false;
            }
            return true;
        });
        GoImportPackageQuickFix goImportPackageQuickFix = fix.isNull() ? new GoImportPackageQuickFix(reference) : (GoImportPackageQuickFix)((Object)fix.get());
        if (goImportPackageQuickFix == null) {
            GoReferenceImporter.$$$reportNull$$$0(6);
        }
        return goImportPackageQuickFix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/imports/GoReferenceImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/imports/GoReferenceImporter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAutoImportAtOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAddUnambiguousImportsOnTheFlyEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateFix";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

