/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.psi.GoType;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedElement;
import com.goide.util.GoCacheUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class GoTypeIdenticalCache {
    private final ConcurrentMap<Trinity<GoType, GoType, EnumSet<Flags>>, Boolean> myIdenticalMap = ContainerUtil.createConcurrentWeakMap();

    public static GoTypeIdenticalCache getInstance() {
        return (GoTypeIdenticalCache)ApplicationManager.getApplication().getService(GoTypeIdenticalCache.class);
    }

    public GoTypeIdenticalCache() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            public void beforePsiChanged(boolean isPhysical) {
                GoTypeIdenticalCache.this.myIdenticalMap.clear();
            }
        });
        messageBus.connect().subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                GoTypeIdenticalCache.this.myIdenticalMap.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/goide/psi/impl/GoTypeIdenticalCache$2", "projectClosed"));
            }
        });
    }

    public boolean identical(@NotNull GoType left, @NotNull GoType right, boolean strict, boolean forceIgnoreTags, @Nullable PsiElement context, @NotNull TypeIdenticalPredicate predicate) {
        if (left == null) {
            GoTypeIdenticalCache.$$$reportNull$$$0(0);
        }
        if (right == null) {
            GoTypeIdenticalCache.$$$reportNull$$$0(1);
        }
        if (predicate == null) {
            GoTypeIdenticalCache.$$$reportNull$$$0(2);
        }
        EnumSet<Flags> flags = EnumSet.noneOf(Flags.class);
        if (strict) {
            flags.add(Flags.STRICT);
        }
        if (forceIgnoreTags) {
            flags.add(Flags.FORCE_IGNORE_STRUCT_TAGS);
        }
        Trinity key = Trinity.create((Object)left, (Object)right, flags);
        return this.getCacheMap(context).computeIfAbsent((Trinity<GoType, GoType, EnumSet<Flags>>)key, t -> (Boolean)ObjectUtils.notNull((Object)((Boolean)RecursionManager.doPreventingRecursion((Object)key, (boolean)true, () -> predicate.identical((GoType)t.first, (GoType)t.second, ((EnumSet)t.third).contains((Object)Flags.STRICT), ((EnumSet)t.third).contains((Object)Flags.FORCE_IGNORE_STRUCT_TAGS)))), (Object)false));
    }

    private ConcurrentMap<Trinity<GoType, GoType, EnumSet<Flags>>, Boolean> getCacheMap(@Nullable PsiElement context) {
        if (context == null) {
            return this.myIdenticalMap;
        }
        PsiFile file = context.getContainingFile();
        if (file == null && context instanceof GoInstantiatedElement) {
            file = ((GoInstantiatedElement)context).getInstantiationContext().getContainingFile();
        }
        if (file == null) {
            return this.myIdenticalMap;
        }
        Project project = file.getProject();
        return (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> GoCacheUtilKt.createResolveDependentResult(project, ContainerUtil.createConcurrentWeakMap(), new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "left";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "right";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "predicate";
                break;
            }
        }
        objectArray[1] = "com/goide/psi/impl/GoTypeIdenticalCache";
        objectArray[2] = "identical";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Flags {
        STRICT,
        FORCE_IGNORE_STRUCT_TAGS;

    }

    @FunctionalInterface
    public static interface TypeIdenticalPredicate {
        public boolean identical(GoType var1, GoType var2, boolean var3, boolean var4);
    }
}

