/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.GoCommentsConverter;
import com.goide.GoFileType;
import com.goide.GoIcons;
import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.completion.GoCompletionUtil;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.execution.testing.GoTestFinder;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoAddExpr;
import com.goide.psi.GoAndExpr;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoAssignOp;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCallLikeExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoCommCase;
import com.goide.psi.GoCommClause;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoConstraintElem;
import com.goide.psi.GoConstraintTerm;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoElement;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoFile;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoKey;
import com.goide.psi.GoLabelRef;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMapType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoMulExpr;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoOrExpr;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoParType;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoPsiTreeChangeProcessor;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResult;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoTag;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameter;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoCaching;
import com.goide.psi.impl.GoCompositeElementImpl;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoElementWithSubst;
import com.goide.psi.impl.GoExpressionEvaluator;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoFieldNameReference;
import com.goide.psi.impl.GoItemPresentation;
import com.goide.psi.impl.GoLabelReference;
import com.goide.psi.impl.GoLightMethodDeclaration;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoMethodDeclarationImpl;
import com.goide.psi.impl.GoMethodSpecImpl;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoParserPsiTreeUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReference;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoResolveResult;
import com.goide.psi.impl.GoScopeProcessorBase;
import com.goide.psi.impl.GoStringLiteralImpl;
import com.goide.psi.impl.GoTypeReference;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.GoVarReference;
import com.goide.psi.impl.ResolveUtil;
import com.goide.psi.impl.generics.GoGenericsUtilKt;
import com.goide.psi.impl.generics.GoReverseTypeInferenceContext;
import com.goide.psi.impl.generics.GoSubstitution;
import com.goide.psi.impl.generics.GoTypeInferenceKt;
import com.goide.psi.impl.generics.GoTypeInferenceResult;
import com.goide.psi.impl.generics.GoTypeInstantiationKt;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedElement;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedSignature;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedType;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedTypeFactory;
import com.goide.psi.impl.imports.GoImportReferenceSet;
import com.goide.psi.impl.manipulator.GoStringManipulator;
import com.goide.psi.presentation.GoPsiPresentationBuilder;
import com.goide.psi.properties.GoFileProperties;
import com.goide.refactor.GoNamesValidator;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.stubs.GoConstSpecStub;
import com.goide.stubs.GoConstraintTermStub;
import com.goide.stubs.GoFieldDeclarationStub;
import com.goide.stubs.GoFileStub;
import com.goide.stubs.GoFunctionDeclarationStub;
import com.goide.stubs.GoImportSpecStub;
import com.goide.stubs.GoLightASTUtil;
import com.goide.stubs.GoMethodDeclarationStub;
import com.goide.stubs.GoMethodSpecStub;
import com.goide.stubs.GoNamedStub;
import com.goide.stubs.GoPackageClauseStub;
import com.goide.stubs.GoParameterDeclarationStub;
import com.goide.stubs.GoTypeSpecStub;
import com.goide.stubs.GoTypeStub;
import com.goide.stubs.GoVarOrConstSpecStub;
import com.goide.stubs.index.GoMethodIndex;
import com.goide.stubs.index.GoTypeAliasIndex;
import com.goide.util.GoCacheUtilKt;
import com.goide.util.GoImportsSorter;
import com.goide.util.GoStdlibUtil;
import com.goide.util.GoStringLiteralEscaper;
import com.goide.util.GoUtil;
import com.goide.util.Value;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPsiImplUtil {
    private static final Logger LOG = Logger.getInstance(GoPsiImplUtil.class);
    private static final Key<SmartPsiElementPointer<PsiElement>> CONTEXT = Key.create((String)"CONTEXT");
    private static final Key<SmartPsiElementPointer<PsiElement>> CURRENT_ELEMENT = Key.create((String)"CURRENT_ELEMENT");
    private static final Key<Boolean> UNDER_REVERSE_TYPE_INFERENCE = Key.create((String)"UNDER_REVERSE_TYPE_INFERENCE");
    private static final int INVALID_ARRAY_LENGTH = -2;
    static final int STACK_DEPTH_THRESHOLD = 100;
    private static final RecursionGuard<GoType> underlyingTypeGuard = RecursionManager.createGuard((String)"go underlying type");

    public static boolean builtin(@Nullable PsiElement resolve) {
        return resolve != null && resolve.isValid() && GoPsiImplUtil.isBuiltinFile(resolve.getContainingFile());
    }

    @Nullable
    public static GoReferenceExpression unwrapMulOrParOfReference(@Nullable GoExpression e) {
        return (GoReferenceExpression)ObjectUtils.tryCast((Object)GoPsiImplUtil.unwrapMulOrPar(e), GoReferenceExpression.class);
    }

    @Nullable
    public static GoExpression unwrapMulOrPar(@Nullable GoExpression e) {
        while (true) {
            if (e instanceof GoParenthesesExpr) {
                e = ((GoParenthesesExpr)e).getExpression();
                continue;
            }
            if (!(e instanceof GoUnaryExpr) || ((GoUnaryExpr)e).getMul() == null) break;
            e = ((GoUnaryExpr)e).getExpression();
        }
        return e;
    }

    @Contract(value="null -> false")
    public static boolean isPanic(@Nullable GoCallExpr o) {
        return o != null && GoPsiImplUtil.stdLibCall(o, "panic");
    }

    public static boolean isRecover(@NotNull GoCallExpr o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(0);
        }
        return GoPsiImplUtil.stdLibCall(o, "recover");
    }

    private static boolean stdLibCall(@NotNull GoCallExpr o, @NotNull String name) {
        GoExpression e;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(1);
        }
        if (name == null) {
            GoPsiImplUtil.$$$reportNull$$$0(2);
        }
        if ((e = o.getExpression()).textMatches(name) && e instanceof GoReferenceExpression) {
            GoReferenceExpression ref = (GoReferenceExpression)e;
            PsiElement resolve = ref.getReference().resolve();
            return resolve instanceof GoFunctionDeclaration && GoPsiImplUtil.isBuiltinFile(resolve.getContainingFile());
        }
        return false;
    }

    public static boolean isUnsafeFile(@Nullable PsiFile file) {
        return GoPsiImplUtil.hasSameNameAndPackage(file, "unsafe", "unsafe.go");
    }

    public static boolean isBuiltinFile(@Nullable PsiFile file) {
        return GoPsiImplUtil.hasSameNameAndPackage(file, "builtin", "builtin.go");
    }

    public static boolean hasSameNameAndPackage(@Nullable PsiFile file, @NotNull CharSequence packageName, @NotNull CharSequence fileName) {
        if (packageName == null) {
            GoPsiImplUtil.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            GoPsiImplUtil.$$$reportNull$$$0(4);
        }
        return file instanceof GoFile && StringUtil.equals((CharSequence)fileName, (CharSequence)file.getViewProvider().getVirtualFile().getNameSequence()) && packageName.equals(((GoFile)file).getPackageName()) && packageName.equals(((GoFile)file).getImportPath(false));
    }

    @Nullable
    public static GoTopLevelDeclaration getTopLevelDeclaration(@Nullable PsiElement startElement) {
        GoTopLevelDeclaration declaration = (GoTopLevelDeclaration)PsiTreeUtil.getTopmostParentOfType((PsiElement)startElement, GoTopLevelDeclaration.class);
        if (declaration == null || !(declaration.getParent() instanceof GoFile)) {
            return null;
        }
        return declaration;
    }

    public static int getArity(@NotNull GoSignatureOwner s) {
        GoNamedStub stub;
        if (s == null) {
            GoPsiImplUtil.$$$reportNull$$$0(5);
        }
        if (s instanceof GoMethodDeclarationImpl && (stub = (GoMethodDeclarationStub)((GoMethodDeclarationImpl)s).getGreenStub()) != null) {
            return ((GoMethodDeclarationStub)stub).getArity();
        }
        if (s instanceof GoMethodSpecImpl && (stub = (GoMethodSpecStub)((GoMethodSpecImpl)s).getGreenStub()) != null) {
            return ((GoMethodSpecStub)stub).getArity();
        }
        return (Integer)CachedValuesManager.getCachedValue((PsiElement)s, () -> {
            GoSignature signature = s.getSignature();
            int result = signature == null ? -1 : signature.getParameters().getParameterDeclarationList().stream().mapToInt(d -> {
                int defsCount = d.getParamDefinitionList().size();
                return defsCount == 0 ? 1 : defsCount;
            }).sum();
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{s});
        });
    }

    @Nullable
    public static PsiElement getContextElement(@Nullable ResolveState state) {
        SmartPsiElementPointer context = state != null ? (SmartPsiElementPointer)state.get(CONTEXT) : null;
        return context != null ? context.getElement() : null;
    }

    @Nullable
    public static PsiElement getCurrentElement(@Nullable ResolveState state) {
        SmartPsiElementPointer context = state != null ? (SmartPsiElementPointer)state.get(CURRENT_ELEMENT) : null;
        return context != null ? context.getElement() : null;
    }

    private static boolean isUnderReverseTypeInference(@Nullable ResolveState state) {
        return state != null && Boolean.TRUE.equals(state.get(UNDER_REVERSE_TYPE_INFERENCE));
    }

    @NotNull
    private static ResolveState withReverseTypeInference(@NotNull ResolveState state) {
        if (state == null) {
            GoPsiImplUtil.$$$reportNull$$$0(6);
        }
        ResolveState resolveState = state.put(UNDER_REVERSE_TYPE_INFERENCE, (Object)true);
        if (resolveState == null) {
            GoPsiImplUtil.$$$reportNull$$$0(7);
        }
        return resolveState;
    }

    @NotNull
    public static ResolveState createContextOnElement(@Nullable PsiElement context) {
        ResolveState state = ResolveState.initial();
        if (context == null || !context.isValid()) {
            ResolveState resolveState = state;
            if (resolveState == null) {
                GoPsiImplUtil.$$$reportNull$$$0(8);
            }
            return resolveState;
        }
        ResolveState resolveState = state.put(CONTEXT, (Object)SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context));
        if (resolveState == null) {
            GoPsiImplUtil.$$$reportNull$$$0(9);
        }
        return resolveState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R withContextOnElement(@Nullable PsiElement contextElement, @NotNull Function<? super ResolveState, R> action) {
        if (action == null) {
            GoPsiImplUtil.$$$reportNull$$$0(10);
        }
        ResolveState state = ResolveState.initial();
        if (contextElement == null || !contextElement.isValid()) {
            return action.apply((ResolveState)state);
        }
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)contextElement.getProject());
        SmartPsiElementPointer pointer = pointerManager.createSmartPsiElementPointer(contextElement);
        try {
            R r = action.apply((ResolveState)state.put(CONTEXT, (Object)pointer));
            return r;
        }
        finally {
            pointerManager.removePointer(pointer);
        }
    }

    @Nullable
    public static GoQualifier getQualifier(@NotNull GoTypeReferenceExpression o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(11);
        }
        return GoPsiImplUtil.getRawQualifier(o);
    }

    @Nullable
    public static GoQualifier getRawQualifier(@NotNull GoTypeReferenceExpression o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(12);
        }
        return (GoQualifier)PsiTreeUtil.getStubChildOfType((PsiElement)o, GoTypeReferenceExpression.class);
    }

    @NotNull
    public static Collection<GoPackage> resolve(@NotNull GoImportSpec spec, @NotNull ResolveState state) {
        if (spec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(13);
        }
        if (state == null) {
            GoPsiImplUtil.$$$reportNull$$$0(14);
        }
        PsiElement contextFromState = GoPsiImplUtil.getContextElement(state);
        PsiElement context = (PsiElement)ObjectUtils.notNull((Object)contextFromState, (Object)spec);
        ResolveState resolveState = state.put(CURRENT_ELEMENT, (Object)SmartPointerManager.createPointer((PsiElement)spec));
        if (contextFromState == null) {
            resolveState = resolveState.put(CONTEXT, (Object)SmartPointerManager.createPointer((PsiElement)context));
        }
        Collection<GoPackage> collection = GoPackageUtil.findByImportPath(spec.getPath(), context.getProject(), GoUtil.module(context), resolveState);
        if (collection == null) {
            GoPsiImplUtil.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public static PsiReference getReference(@NotNull GoTypeReferenceExpression o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(16);
        }
        PsiReference psiReference = (PsiReference)CachedValuesManager.getCachedValue((PsiElement)o, () -> CachedValueProvider.Result.create((Object)((Object)GoTypeReference.create(o)), (Object[])new Object[]{o}));
        if (psiReference == null) {
            GoPsiImplUtil.$$$reportNull$$$0(17);
        }
        return psiReference;
    }

    @NotNull
    public static PsiReference getReference(@NotNull GoLabelRef o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(18);
        }
        PsiReference psiReference = (PsiReference)CachedValuesManager.getCachedValue((PsiElement)o, () -> CachedValueProvider.Result.create((Object)((Object)new GoLabelReference(o)), (Object[])new Object[]{o}));
        if (psiReference == null) {
            GoPsiImplUtil.$$$reportNull$$$0(19);
        }
        return psiReference;
    }

    @Nullable
    public static PsiReference getReference(@NotNull GoVarDefinition o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(20);
        }
        return (PsiReference)CachedValuesManager.getCachedValue((PsiElement)o, () -> {
            PsiElement shortDeclaration = (PsiElement)ObjectUtils.tryCast((Object)o.getParent(), GoShortVarDeclaration.class);
            boolean createRef = PsiTreeUtil.getParentOfType((PsiElement)shortDeclaration, (Class[])new Class[]{GoStatementsHolder.class, GoForStatement.class, GoIfStatement.class, GoSwitchStatement.class, GoSelectStatement.class}) instanceof GoStatementsHolder;
            return CachedValueProvider.Result.create((Object)((Object)(createRef ? new GoVarReference(o) : null)), (Object[])new Object[]{o});
        });
    }

    @NotNull
    public static PsiReference getReference(@NotNull GoFieldName o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(21);
        }
        PsiReference psiReference = (PsiReference)CachedValuesManager.getCachedValue((PsiElement)o, () -> {
            PsiMultiReference reference = new PsiMultiReference(new PsiReference[]{new GoFieldNameReference(o), GoReference.create(o)}, o){

                public PsiElement resolve() {
                    GoReference ordinal;
                    GoFieldNameReference field;
                    PsiReference[] references = this.getReferences();
                    if (references[0] instanceof GoFieldNameReference) {
                        field = (GoFieldNameReference)references[0];
                        ordinal = (GoReference)references[1];
                    } else {
                        field = (GoFieldNameReference)references[1];
                        ordinal = (GoReference)references[0];
                    }
                    PsiElement resolve = field.resolve();
                    return resolve != null ? resolve : (field.inStructTypeKey() ? null : ordinal.resolve());
                }

                public boolean isReferenceTo(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return GoUtil.couldBeReferenceTo(element, this.getElement()) && this.getElement().getManager().areElementsEquivalent(this.resolve(), element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/psi/impl/GoPsiImplUtil$1", "isReferenceTo"));
                }
            };
            return CachedValueProvider.Result.create((Object)reference, (Object[])new Object[]{o});
        });
        if (psiReference == null) {
            GoPsiImplUtil.$$$reportNull$$$0(22);
        }
        return psiReference;
    }

    @Nullable
    public static GoReferenceExpression getQualifier(@NotNull GoFieldName o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(23);
        }
        return null;
    }

    @Nullable
    public static GoReferenceExpression getRawQualifier(@NotNull GoFieldName o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(24);
        }
        return null;
    }

    public static PsiReference @NotNull [] getReferences(@NotNull GoImportSpec o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(25);
        }
        if (o.getTextLength() < 2) {
            if (PsiReference.EMPTY_ARRAY == null) {
                GoPsiImplUtil.$$$reportNull$$$0(26);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)o, () -> CachedValueProvider.Result.create((Object)GoPsiImplUtil.getReferencesFor(o), (Object[])new Object[]{o}));
        if (psiReferenceArray == null) {
            GoPsiImplUtil.$$$reportNull$$$0(27);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static @NotNull PsiReference @NotNull [] getReferencesFor(@NotNull GoImportSpec importSpec) {
        PsiReference[] providedReferences;
        if (importSpec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(28);
        }
        Object[] objectArray = (providedReferences = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)importSpec)).length != 0 ? providedReferences : new GoImportReferenceSet(importSpec).getAllReferences();
        if (objectArray == null) {
            GoPsiImplUtil.$$$reportNull$$$0(29);
        }
        return objectArray;
    }

    public static boolean processDeclarations(@NotNull GoCompositeElement o, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        boolean isAncestor;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(30);
        }
        if (processor2 == null) {
            GoPsiImplUtil.$$$reportNull$$$0(31);
        }
        if (state == null) {
            GoPsiImplUtil.$$$reportNull$$$0(32);
        }
        if (place == null) {
            GoPsiImplUtil.$$$reportNull$$$0(33);
        }
        PsiElement parent = lastParent == null ? null : lastParent.getParent();
        boolean bl = isAncestor = parent == o;
        if (o instanceof GoVarSpec) {
            return isAncestor || GoCompositeElementImpl.processDeclarationsDefault(o, processor2, state, lastParent, place);
        }
        if (isAncestor) {
            return GoCompositeElementImpl.processDeclarationsDefault(o, processor2, state, lastParent, place);
        }
        if (o instanceof GoStatementsHolder || o instanceof GoIfStatement || o instanceof GoForStatement || o instanceof GoFunctionLit) {
            return processor2.execute((PsiElement)o, state);
        }
        return GoCompositeElementImpl.processDeclarationsDefault(o, processor2, state, lastParent, place);
    }

    @Nullable
    public static GoType getGoTypeInner(@NotNull GoReceiver o, @Nullable ResolveState context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(34);
        }
        return o.getType();
    }

    @Nullable
    public static String getName(@NotNull GoPackageClause packageClause) {
        GoPackageClauseStub stub;
        if (packageClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(35);
        }
        if ((stub = (GoPackageClauseStub)packageClause.getStub()) != null) {
            return stub.getName();
        }
        PsiElement packageIdentifier = packageClause.getIdentifier();
        return packageIdentifier != null ? packageIdentifier.getText().trim() : null;
    }

    public static int getTextOffset(@NotNull GoPackageClause packageClause) {
        PsiElement packageIdentifier;
        if (packageClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(36);
        }
        return (packageIdentifier = packageClause.getIdentifier()) != null ? packageIdentifier.getTextRange().getStartOffset() : packageClause.getTextRange().getEndOffset();
    }

    public static PsiElement setName(@NotNull GoPackageClause packageClause, @NotNull String name) {
        PsiElement identifier;
        if (packageClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            GoPsiImplUtil.$$$reportNull$$$0(38);
        }
        if ((identifier = packageClause.getIdentifier()) != null) {
            identifier.replace(GoElementFactory.createIdentifierFromText(packageClause.getProject(), name));
        }
        return packageClause;
    }

    @NotNull
    public static SearchScope getUseScope(@NotNull GoPackageClause packageClause) {
        if (packageClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(39);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)packageClause.getContainingFile());
        if (globalSearchScope == null) {
            GoPsiImplUtil.$$$reportNull$$$0(40);
        }
        return globalSearchScope;
    }

    @Nullable
    public static String getCanonicalPath(@NotNull GoPackageClause packageClause) {
        GoPackageClauseStub stub;
        if (packageClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(41);
        }
        if ((stub = (GoPackageClauseStub)packageClause.getStub()) != null) {
            return stub.getCanonicalPath();
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)packageClause, () -> CachedValueProvider.Result.create((Object)GoPsiImplUtil.calcCanonicalPath(packageClause), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static String calcCanonicalPath(@NotNull GoPackageClause packageClause) {
        PsiElement sibling;
        GoPackageClauseStub stub;
        if (packageClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(42);
        }
        if ((stub = (GoPackageClauseStub)packageClause.getStub()) != null) {
            return stub.getCanonicalPath();
        }
        for (sibling = packageClause.getNextSibling(); sibling != null && !sibling.textContains('\n') && sibling.getNode().getElementType() != GoTypes.SEMICOLON && !(sibling instanceof PsiComment); sibling = sibling.getNextSibling()) {
        }
        if (sibling instanceof PsiComment && !sibling.textContains('\n')) {
            String commentText = new GoCommentsConverter().getValidCommentText((PsiComment)sibling);
            return GoPsiImplUtil.getCanonicalPath(commentText);
        }
        return null;
    }

    @Nullable
    public static String calcCanonicalPath(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        LighterASTNode comment;
        LighterASTNode parent;
        if (tree == null) {
            GoPsiImplUtil.$$$reportNull$$$0(43);
        }
        if (node == null) {
            GoPsiImplUtil.$$$reportNull$$$0(44);
        }
        if (parentStub == null) {
            GoPsiImplUtil.$$$reportNull$$$0(45);
        }
        if ((parent = tree.getParent(node)) == null) {
            return null;
        }
        assert (parentStub instanceof GoFileStub) : "This method should be called only for top-level element whose parent stub is a GoFileStub";
        List<LighterASTNode> comments = GoLightASTUtil.getCommentsForTopLevelNode(tree, node, (GoFileStub)parentStub);
        LighterASTNode lighterASTNode = comment = comments.isEmpty() ? null : comments.get(0);
        if (comment != null) {
            String text = GoLightASTUtil.getNodeText(tree, comment);
            String commentText = GoPsiImplUtil.getValidCommentText(text, comment.getTokenType());
            return GoPsiImplUtil.getCanonicalPath(commentText);
        }
        return null;
    }

    @Nullable
    private static String getCanonicalPath(@Nullable String commentText) {
        if (commentText == null || !commentText.startsWith("import")) {
            return null;
        }
        if ((commentText = StringUtil.trimStart((String)commentText, (String)"import")).isEmpty()) {
            return "";
        }
        char c = commentText.charAt(0);
        if (Character.isLetter(c) || Character.isDigit(c) || c == '_') {
            return null;
        }
        return GoStringManipulator.isQuotedImportString(commentText = commentText.trim()) ? StringUtil.nullize((String)GoStringManipulator.unquote(commentText)) : "";
    }

    @Nullable
    private static String getValidCommentText(@NotNull String text, IElementType type) {
        if (text == null) {
            GoPsiImplUtil.$$$reportNull$$$0(46);
        }
        if (text.contains("\n")) {
            return null;
        }
        if (type == GoParserDefinition.Lazy.LINE_COMMENT) {
            return StringUtil.trimStart((String)text, (String)"//").trim();
        }
        if (type == GoParserDefinition.Lazy.MULTILINE_COMMENT) {
            String commentText = StringUtil.trimStart((String)text, (String)"/*");
            return commentText.endsWith("*/") ? StringUtil.trimEnd((String)commentText, (String)"*/").trim() : null;
        }
        return null;
    }

    @Nullable
    public static GoTypeReferenceExpression getTypeReferenceExpression(@NotNull GoAnonymousFieldDefinition o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(47);
        }
        return GoPsiImplUtil.findTypeReference(o.getRawType());
    }

    @Nullable
    public static PsiElement getIdentifier(@NotNull GoAnonymousFieldDefinition o) {
        GoTypeReferenceExpression expression;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(48);
        }
        return (expression = GoPsiImplUtil.getTypeReferenceExpression(o)) != null ? expression.getIdentifier() : null;
    }

    @NotNull
    public static GoType getGoTypeInner(@NotNull GoAnonymousFieldDefinition o, @Nullable ResolveState context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(49);
        }
        GoType goType = o.getType();
        if (goType == null) {
            GoPsiImplUtil.$$$reportNull$$$0(50);
        }
        return goType;
    }

    @Nullable
    public static String getValue(@NotNull GoTag tag, @NotNull String key) {
        if (tag == null) {
            GoPsiImplUtil.$$$reportNull$$$0(51);
        }
        if (key == null) {
            GoPsiImplUtil.$$$reportNull$$$0(52);
        }
        StringBuilder tagText = new StringBuilder(tag.getStringLiteral().getDecodedText());
        while (tagText.length() > 0) {
            int i;
            for (i = 0; i < tagText.length() && tagText.charAt(i) == ' '; ++i) {
            }
            tagText.delete(0, i);
            if (tagText.length() == 0) {
                return null;
            }
            for (i = 0; i < tagText.length() && tagText.charAt(i) > ' ' && tagText.charAt(i) != ':' && tagText.charAt(i) != '\"' && tagText.charAt(i) != '\u007f'; ++i) {
            }
            if (i == 0 || i + 1 > tagText.length() || tagText.charAt(i) != ':') {
                return null;
            }
            String name = tagText.substring(0, i);
            tagText.delete(0, i + 1);
            for (i = 1; i < tagText.length() && tagText.charAt(i) != '\"'; ++i) {
                if (tagText.charAt(i) != '\\') continue;
                ++i;
            }
            if (i >= tagText.length()) {
                return null;
            }
            if (key.equals(name)) {
                return GoStringManipulator.unquote(tagText.substring(0, i + 1));
            }
            tagText.delete(0, i + 1);
        }
        return null;
    }

    @Nullable
    public static String getName(@NotNull GoMethodSpec o) {
        GoNamedStub stub;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(53);
        }
        if ((stub = (GoNamedStub)o.getStub()) != null) {
            return stub.getName();
        }
        PsiElement identifier = o.getIdentifier();
        if (identifier != null) {
            return identifier.getText();
        }
        GoTypeReferenceExpression typeRef = o.getTypeReferenceExpression();
        return typeRef != null ? typeRef.getIdentifier().getText() : null;
    }

    @Nullable
    public static GoType getReceiverType(@NotNull GoMethodDeclaration o) {
        GoReceiver receiver;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(54);
        }
        return (receiver = o.getReceiver()) == null ? null : receiver.getType();
    }

    @Nullable
    public static GoTypeSpec resolveTypeSpec(@NotNull GoMethodDeclaration o) {
        GoTypeReferenceExpression expression;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(55);
        }
        return (GoTypeSpec)ObjectUtils.tryCast((Object)((expression = GoPsiImplUtil.findTypeReference(o.getReceiverType())) != null ? expression.resolve() : null), GoTypeSpec.class);
    }

    @Nullable
    public static GoTypeReferenceExpression findTypeReference(@Nullable GoType o) {
        if (o == null) {
            return null;
        }
        GoTypeReferenceExpression ref = o.getTypeReferenceExpression();
        if (ref != null) {
            return ref;
        }
        if (o instanceof GoPointerType) {
            GoType inner = ((GoPointerType)o).getRawType();
            return inner != null ? inner.getTypeReferenceExpression() : null;
        }
        return null;
    }

    @Nullable
    public static GoType getGoTypeInner(@NotNull GoParamDefinition o, @Nullable ResolveState context) {
        GoType type;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(56);
        }
        if ((type = o.findSiblingType()) == null) {
            return null;
        }
        return o.isVariadic() ? new GoLightType.LightSliceType(type) : type;
    }

    @Nullable
    public static GoType getType(@NotNull GoTypeParameterDeclaration declaration) {
        GoType type;
        GoType underlying;
        GoConstraintElem constraintElem;
        if (declaration == null) {
            GoPsiImplUtil.$$$reportNull$$$0(57);
        }
        if ((constraintElem = declaration.getConstraintElem()) == null) {
            return null;
        }
        List<GoConstraintTerm> terms = constraintElem.getConstraintTermList();
        GoConstraintTerm term = (GoConstraintTerm)ContainerUtil.getOnlyItem(terms);
        if (term != null && !term.hasTilde() && (underlying = GoPsiImplUtil.getUnderlyingType(type = term.getType(), term)) instanceof GoInterfaceType) {
            return type;
        }
        return new GoLightType.LightSingleConstraintElemInterfaceType(constraintElem);
    }

    @NotNull
    public static GoType getGoTypeInner(@NotNull GoTypeParamDefinition o, @Nullable ResolveState context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(58);
        }
        GoTypeParameter goTypeParameter = o.getTypeParameter();
        if (goTypeParameter == null) {
            GoPsiImplUtil.$$$reportNull$$$0(59);
        }
        return goTypeParameter;
    }

    @Nullable
    public static GoType getConstraintType(@NotNull GoTypeParameter o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(60);
        }
        return GoPsiImplUtil.getInstantiatedConstraintType(o, null);
    }

    @NotNull
    public static GoTypeParamDefinition getTypeParamDefinition(@NotNull GoTypeParameter o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(61);
        }
        GoTypeParamDefinition goTypeParamDefinition = Objects.requireNonNull((GoTypeParamDefinition)ObjectUtils.tryCast((Object)PsiTreeUtil.getStubOrPsiParent((PsiElement)o), GoTypeParamDefinition.class));
        if (goTypeParamDefinition == null) {
            GoPsiImplUtil.$$$reportNull$$$0(62);
        }
        return goTypeParamDefinition;
    }

    @Nullable
    public static GoType getInstantiatedConstraintType(@NotNull GoTypeParameter o, @Nullable GoInstantiatedElement instantiated2) {
        GoTypeParamDefinition definition;
        PsiElement parent;
        GoTypeParameterDeclaration decl;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(63);
        }
        if ((decl = (GoTypeParameterDeclaration)ObjectUtils.tryCast((Object)(parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)(definition = o.getTypeParamDefinition()))), GoTypeParameterDeclaration.class)) != null) {
            GoType declType = decl.getType();
            return instantiated2 != null ? GoPsiImplUtil.withInstantiation(declType, instantiated2) : declType;
        }
        if (parent instanceof GoType) {
            GoMethodDeclaration methodDeclaration = (GoMethodDeclaration)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)parent, GoMethodDeclaration.class);
            if (methodDeclaration == null) {
                return null;
            }
            GoType receiverType = methodDeclaration.getReceiverType();
            if (receiverType == null) {
                return null;
            }
            return GoTypeInstantiationKt.getConstraintTypeForMethodReceiverTypeParameter(receiverType, GoPsiImplUtil.createContextOnElement(o), parent, instantiated2);
        }
        return null;
    }

    @Nullable
    public static GoType getGoTypeInner(@NotNull GoConstDefinition o, @Nullable ResolveState state) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(64);
        }
        Pair<GoType, Boolean> fromSpec = GoPsiImplUtil.findTypeInConstSpec(o, state);
        if (((Boolean)fromSpec.second).booleanValue()) {
            return (GoType)fromSpec.first;
        }
        return (GoType)RecursionManager.doPreventingRecursion((Object)o, (boolean)true, (Computable)((NullableComputable)() -> {
            GoConstSpec prev = GoPsiTreeUtil.getPrevSiblingOfTypeSafe(o.getParent(), GoConstSpec.class);
            while (prev != null) {
                GoType type = prev.getType();
                if (type != null) {
                    return type;
                }
                GoVarOrConstSpecStub stub = (GoVarOrConstSpecStub)prev.getStub();
                List<GoExpression> es = stub != null ? stub.getExpressionList() : prev.getExpressionList();
                GoExpression expr = (GoExpression)ContainerUtil.getFirstItem(es);
                if (expr != null) {
                    return expr.getGoType(state);
                }
                prev = GoPsiTreeUtil.getPrevSiblingOfTypeSafe(prev, GoConstSpec.class);
            }
            return null;
        }));
    }

    @NotNull
    private static Pair<GoType, Boolean> findTypeInConstSpec(@NotNull GoConstDefinition o, @Nullable ResolveState state) {
        List<GoExpression> es;
        PsiElement parent;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(65);
        }
        if (!((parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)o)) instanceof GoConstSpec)) {
            Pair pair = Pair.create(null, (Object)false);
            if (pair == null) {
                GoPsiImplUtil.$$$reportNull$$$0(66);
            }
            return pair;
        }
        GoConstSpec spec = (GoConstSpec)parent;
        GoType commonType = spec.getType();
        if (commonType != null) {
            Pair pair = Pair.create((Object)commonType, (Object)true);
            if (pair == null) {
                GoPsiImplUtil.$$$reportNull$$$0(67);
            }
            return pair;
        }
        List<GoConstDefinition> varList = spec.getConstDefinitionList();
        int i = Math.max(varList.indexOf(o), 0);
        GoConstSpecStub specStub = (GoConstSpecStub)spec.getStub();
        List<GoExpression> list = es = specStub != null ? specStub.getExpressionList() : spec.getExpressionList();
        if (es.size() <= i) {
            Pair pair = Pair.create(null, (Object)false);
            if (pair == null) {
                GoPsiImplUtil.$$$reportNull$$$0(68);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)es.get(i).getGoType(state), (Object)true);
        if (pair == null) {
            GoPsiImplUtil.$$$reportNull$$$0(69);
        }
        return pair;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static GoType getResultType(@NotNull GoSignature signature) {
        GoResult result;
        if (signature == null) {
            GoPsiImplUtil.$$$reportNull$$$0(70);
        }
        if ((result = signature.getResult()) == null) {
            return new GoLightType.LightVoidType(signature);
        }
        GoType type = result.getType();
        if (type != null) {
            GoType goType = type;
            if (goType == null) {
                GoPsiImplUtil.$$$reportNull$$$0(71);
            }
            return goType;
        }
        GoParameters parameters = result.getParameters();
        if (parameters == null) {
            return new GoLightType.LightVoidType(signature);
        }
        @NotNull SmartList typeList = new SmartList();
        for (GoParameterDeclaration declaration : parameters.getParameterDeclarationList()) {
            List<GoParamDefinition> definitions = declaration.getParamDefinitionList();
            if (definitions.isEmpty()) {
                ContainerUtil.addIfNotNull((Collection)typeList, (Object)declaration.getType());
                continue;
            }
            for (GoParamDefinition definition : definitions) {
                ContainerUtil.addIfNotNull((Collection)typeList, (Object)definition.getGoType(null));
            }
        }
        if (typeList.isEmpty()) {
            return new GoLightType.LightVoidType(signature);
        }
        if (typeList.size() == 1) {
            GoType goType = (GoType)typeList.get(0);
            if (goType == null) {
                GoPsiImplUtil.$$$reportNull$$$0(72);
            }
            return goType;
        }
        return new GoLightType.LightTypeList(parameters, (List<GoType>)typeList);
    }

    @Nullable
    public static GoExpression findVarOrConstExpression(@NotNull GoVarOrConstDefinition o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(73);
        }
        if (o instanceof GoConstDefinition) {
            Pair<GoExpression, Integer> expressionAndIndexForConstDefinition = GoPsiImplUtil.getExpressionAndIndexOfConstDefinition((GoConstDefinition)o);
            return expressionAndIndexForConstDefinition == null ? null : (GoExpression)expressionAndIndexForConstDefinition.first;
        }
        GoVarSpec spec = (GoVarSpec)ObjectUtils.tryCast((Object)PsiTreeUtil.getStubOrPsiParent((PsiElement)o), GoVarSpec.class);
        if (spec == null) {
            return null;
        }
        List<GoVarDefinition> definitionList = spec.getDefinitionList();
        int i = definitionList.indexOf(o);
        if (i < 0) {
            return null;
        }
        List<GoExpression> expressionList = spec.getExpressionList();
        if (i >= expressionList.size()) {
            return null;
        }
        return expressionList.get(i);
    }

    @Nullable
    public static Pair<GoExpression, Integer> getExpressionAndIndexOfConstDefinition(@NotNull GoConstDefinition definition) {
        GoConstSpec spec;
        GoConstDeclaration declaration;
        if (definition == null) {
            GoPsiImplUtil.$$$reportNull$$$0(74);
        }
        GoConstDeclaration goConstDeclaration = declaration = (spec = (GoConstSpec)ObjectUtils.tryCast((Object)definition.getParent(), GoConstSpec.class)) != null ? (GoConstDeclaration)ObjectUtils.tryCast((Object)spec.getParent(), GoConstDeclaration.class) : null;
        if (declaration == null) {
            return null;
        }
        List<GoConstSpec> specList = declaration.getConstSpecList();
        int indexOfSpec = specList.indexOf(spec);
        if (indexOfSpec < 0) {
            return null;
        }
        GoExpression expression = GoPsiImplUtil.getExpressionForConstDefinition(specList.subList(0, indexOfSpec + 1), spec, definition);
        return expression != null ? Pair.create((Object)expression, (Object)indexOfSpec) : null;
    }

    @Nullable
    private static GoExpression getExpressionForConstDefinition(@NotNull List<GoConstSpec> specs, @NotNull GoConstSpec spec, @NotNull GoConstDefinition definition) {
        if (specs == null) {
            GoPsiImplUtil.$$$reportNull$$$0(75);
        }
        if (spec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(76);
        }
        if (definition == null) {
            GoPsiImplUtil.$$$reportNull$$$0(77);
        }
        List<GoConstDefinition> definitions = spec.getConstDefinitionList();
        for (GoConstSpec prevSpec : ContainerUtil.reverse(specs)) {
            GoConstSpecStub specStub = (GoConstSpecStub)prevSpec.getStub();
            List<GoExpression> expressions = specStub != null ? specStub.getExpressionList() : prevSpec.getExpressionList();
            if (expressions.isEmpty()) continue;
            int index = definitions.indexOf(definition);
            return index >= 0 && expressions.size() == definitions.size() ? expressions.get(index) : null;
        }
        return null;
    }

    @Nullable
    public static GoType getGoUnderlyingType(@NotNull GoExpression o, @Nullable ResolveState context) {
        GoType type;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(78);
        }
        if ((type = o.getGoType(context)) == null) {
            return null;
        }
        return context != null ? type.getUnderlyingType(context) : type.getUnderlyingType(o);
    }

    @Nullable
    public static GoType getGoType(@NotNull GoExpression o, @Nullable ResolveState context) {
        GoType baseType;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(79);
        }
        if ((baseType = GoPsiImplUtil.getGoTypeRecursionSafe(o, context)) != null && GoTypeInferenceKt.isReverseTypeInferenceEnabled(o) && GoGenericsUtilKt.isGenericFunctionType(baseType)) {
            if (GoPsiImplUtil.isUnderReverseTypeInference(context)) {
                return baseType;
            }
            context = GoPsiImplUtil.withReverseTypeInference(context != null ? context : GoPsiImplUtil.createContextOnElement(o));
            GoReverseTypeInferenceContext typeInferenceContext = GoTypeInstantiationKt.getReverseTypeInferenceContext(o);
            if (typeInferenceContext == null) {
                return baseType;
            }
            GoTypeInferenceResult typeInferenceResult = GoTypeInstantiationKt.inferTypeArguments(o, typeInferenceContext, context);
            if (typeInferenceResult != null && typeInferenceResult.getOk()) {
                GoSubstitution typeSubstitution = new GoSubstitution(typeInferenceResult.getSubstitution(), new HashMap());
                return GoInstantiatedTypeFactory.create(baseType, typeSubstitution.getParams(), o);
            }
        }
        return baseType;
    }

    @Nullable
    private static GoType getGoTypeRecursionSafe(@NotNull GoExpression o, @Nullable ResolveState context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(80);
        }
        if (GoPsiImplUtil.getContextElement(context) != null) {
            RecursionGuard<GoExpression> guard = GoPsiImplUtil.checkDepth(o, "GoPsiImplUtil.getGoType.context");
            if (guard == null) {
                return null;
            }
            return (GoType)guard.doPreventingRecursion((Object)o, false, () -> GoPsiImplUtil.unwrapGoParType(GoPsiImplUtil.getGoTypeInner(o, context)));
        }
        PsiElement contextElement = GoReferenceBase.getSubstitutionContext(o);
        if (contextElement != null) {
            ConcurrentMap typeCache = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)o, () -> GoCacheUtilKt.createResolveDependentResult(o.getProject(), ContainerUtil.createConcurrentWeakMap(), new Object[0]));
            Optional type = typeCache.computeIfAbsent(contextElement, contextElem -> {
                RecursionGuard<GoExpression> guard = GoPsiImplUtil.checkDepth(o, "GoPsiImplUtil.getGoType.context");
                if (guard == null) {
                    return Optional.empty();
                }
                GoType resolvedType = (GoType)guard.doPreventingRecursion((Object)o, false, () -> {
                    GoType result = GoPsiImplUtil.withContextOnElement(contextElem, newContext -> GoPsiImplUtil.getGoTypeInner(o, newContext));
                    return GoPsiImplUtil.unwrapGoParType(result);
                });
                return Optional.ofNullable(resolvedType);
            });
            return type.orElse(null);
        }
        if (!GoCaching.isEnabled()) {
            RecursionGuard<GoExpression> guard = GoPsiImplUtil.checkDepth(o, "GoPsiImplUtil.getGoType.null");
            if (guard == null) {
                return null;
            }
            return (GoType)guard.doPreventingRecursion((Object)o, true, () -> {
                GoType result = GoPsiImplUtil.withContextOnElement(o, newContext -> GoPsiImplUtil.getGoTypeInner(o, newContext));
                return GoPsiImplUtil.unwrapGoParType(result);
            });
        }
        return (GoType)CachedValuesManager.getCachedValue((PsiElement)o, () -> {
            RecursionGuard<GoExpression> guard = GoPsiImplUtil.checkDepth(o, "GoPsiImplUtil.getGoType.null");
            if (guard == null) {
                return GoCacheUtilKt.createResolveDependentResult(o.getProject(), null, new Object[0]);
            }
            return (CachedValueProvider.Result)guard.doPreventingRecursion((Object)o, true, () -> {
                GoType result = GoPsiImplUtil.withContextOnElement(o, newContext -> GoPsiImplUtil.getGoTypeInner(o, newContext));
                return GoCacheUtilKt.createResolveDependentResult(o.getProject(), GoPsiImplUtil.unwrapGoParType(result), new Object[0]);
            });
        });
    }

    @Nullable
    private static RecursionGuard<GoExpression> checkDepth(@NotNull GoExpression o, @NotNull String id) {
        RecursionGuard guard;
        List stack;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(81);
        }
        if (id == null) {
            GoPsiImplUtil.$$$reportNull$$$0(82);
        }
        if ((stack = (guard = RecursionManager.createGuard((String)id)).currentStack()).size() > 100) {
            guard.prohibitResultCaching((Object)o);
            LOG.warn("StackOverflowError has been prevented during type inference of too long chain of expressions");
            return null;
        }
        return guard;
    }

    @Nullable
    private static GoType getArithmeticExpressionType(@NotNull GoExpression left, @Nullable GoExpression right, @Nullable IElementType operator, @Nullable ResolveState state) {
        if (left == null) {
            GoPsiImplUtil.$$$reportNull$$$0(83);
        }
        if (right == null || operator == null) {
            return null;
        }
        GoType l = left.getGoType(state);
        if (l == null) {
            return null;
        }
        GoType r = right.getGoType(state);
        if (r == null) {
            return null;
        }
        PsiElement context = (PsiElement)ObjectUtils.notNull((Object)GoPsiImplUtil.getContextElement(state), (Object)left);
        if (GoTypes.PLUS.equals(operator) || GoTypes.MINUS.equals(operator) || GoTypes.MUL.equals(operator) || GoTypes.QUOTIENT.equals(operator)) {
            if (GoTypes.PLUS.equals(operator) && GoTypeUtil.isString(l, context) && GoTypeUtil.isString(r, context)) {
                return l instanceof GoLightType.LightUntypedStringType ? r : l;
            }
            if (l instanceof GoLightType.LightUntypedNumericType && r instanceof GoLightType.LightUntypedNumericType) {
                return GoPsiImplUtil.getUntypedNumericTypeRank((GoLightType.LightUntypedNumericType)l) > GoPsiImplUtil.getUntypedNumericTypeRank((GoLightType.LightUntypedNumericType)r) ? l : r;
            }
            if (l instanceof GoLightType.LightUntypedNumericType) {
                return GoTypeUtil.isNumericType(r.getUnderlyingType(state), context) ? r : null;
            }
            if (r instanceof GoLightType.LightUntypedNumericType) {
                return GoTypeUtil.isNumericType(l.getUnderlyingType(state), context) ? l : null;
            }
            return GoTypeUtil.isNumericType(l.getUnderlyingType(state), context) && GoTypeUtil.isNumericType(r.getUnderlyingType(state), context) ? l : null;
        }
        if (GoTypes.REMAINDER.equals(operator) || GoTypes.BIT_AND.equals(operator) || GoTypes.BIT_OR.equals(operator) || GoTypes.BIT_XOR.equals(operator) || GoTypes.BIT_CLEAR.equals(operator)) {
            if (GoTypeUtil.isUntypedIntegerType(l) && GoTypeUtil.isUntypedIntegerType(r)) {
                return GoPsiImplUtil.getUntypedNumericTypeRank((GoLightType.LightUntypedNumericType)l) > GoPsiImplUtil.getUntypedNumericTypeRank((GoLightType.LightUntypedNumericType)r) ? l : r;
            }
            if (GoTypeUtil.isUntypedIntegerType(l)) {
                return GoTypeUtil.isIntegerType(r.getUnderlyingType(state), context) ? r : null;
            }
            if (GoTypeUtil.isUntypedIntegerType(r)) {
                return GoTypeUtil.isIntegerType(l.getUnderlyingType(state), context) ? l : null;
            }
            return GoTypeUtil.isIntegerType(l.getUnderlyingType(state), context) && GoTypeUtil.isIntegerType(r.getUnderlyingType(state), context) ? l : null;
        }
        if (GoTypes.SHIFT_LEFT.equals(operator) || GoTypes.SHIFT_RIGHT.equals(operator)) {
            if (l instanceof GoLightType.LightUntypedNumericType) {
                return r instanceof GoLightType.LightUntypedNumericType || GoTypeUtil.isUintType(r.getUnderlyingType(state), context) ? GoLightType.getIntType(l) : null;
            }
            if (GoTypeUtil.isIntegerType(l.getUnderlyingType(state), context) && (r instanceof GoLightType.LightUntypedNumericType || GoTypeUtil.isUintType(r.getUnderlyingType(state), context))) {
                return l;
            }
        }
        return null;
    }

    public static int getUntypedNumericTypeRank(@NotNull GoLightType.LightUntypedNumericType type) {
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(84);
        }
        if (type instanceof GoLightType.LightUntypedIntType) {
            return 0;
        }
        if (type instanceof GoLightType.LightUntypedRuneType) {
            return 1;
        }
        if (type instanceof GoLightType.LightUntypedFloatType) {
            return 2;
        }
        if (type instanceof GoLightType.LightUntypedComplexType) {
            return 3;
        }
        LOG.error("Unexpected untyped type " + type.getClass().getName());
        return -1;
    }

    @Nullable
    private static GoType getArithmeticExpressionTypeCheap(@Nullable GoExpression right, @Nullable IElementType operator, @Nullable ResolveState state) {
        if (right == null || operator == null) {
            return null;
        }
        GoType r = right.getGoType(state);
        if (r == null) {
            return null;
        }
        PsiElement context = (PsiElement)ObjectUtils.chooseNotNull((Object)GoPsiImplUtil.getContextElement(state), (Object)right);
        if (GoTypes.PLUS.equals(operator) || GoTypes.MINUS.equals(operator) || GoTypes.MUL.equals(operator) || GoTypes.QUOTIENT.equals(operator)) {
            return GoTypes.PLUS.equals(operator) && GoTypeUtil.isString(r, context) || r instanceof GoLightType.LightUntypedNumericType || GoTypeUtil.isNumericType(r.getUnderlyingType(state), context) ? r : null;
        }
        if (GoTypes.REMAINDER.equals(operator) || GoTypes.BIT_AND.equals(operator) || GoTypes.BIT_OR.equals(operator) || GoTypes.BIT_XOR.equals(operator) || GoTypes.BIT_CLEAR.equals(operator)) {
            return GoTypeUtil.isIntegerType(r.getUnderlyingType(state), context) ? r : null;
        }
        if (GoTypes.SHIFT_LEFT.equals(operator) || GoTypes.SHIFT_RIGHT.equals(operator)) {
            return r instanceof GoLightType.LightUntypedNumericType || GoTypeUtil.isUintType(r.getUnderlyingType(state), context) ? GoLightType.getIntType(r) : null;
        }
        return null;
    }

    @Nullable
    private static GoType getGoTypeInner(@NotNull GoExpression o, @Nullable ResolveState state) {
        GoType conversionType;
        GoCallLikeExpr call;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(85);
        }
        PsiElement context = (PsiElement)ObjectUtils.notNull((Object)GoPsiImplUtil.getContextElement(state), (Object)o);
        if (o instanceof GoUnaryExpr) {
            GoType basePointerType;
            GoType base;
            GoUnaryExpr u = (GoUnaryExpr)o;
            GoType typeFromExpression = GoPsiUtil.getTypeIfTypeReference(u);
            if (typeFromExpression != null) {
                return typeFromExpression;
            }
            GoExpression e = u.getExpression();
            if (e == null) {
                return null;
            }
            GoType type = e.getGoType(state);
            GoType goType = base = type == null || type.getTypeReferenceExpression() == null ? type : type.getUnderlyingType(state);
            if (u.getBitAnd() != null) {
                return type != null ? new GoLightType.LightPointerType(type) : null;
            }
            if (u.getArrow() != null) {
                GoType goType2;
                GoType coreType = GoTypeUtil.getCoreType(type, o);
                if (coreType instanceof GoChannelType) {
                    GoChannelType channelType = (GoChannelType)coreType;
                    goType2 = channelType.getType();
                } else {
                    goType2 = type;
                }
                return goType2;
            }
            if (u.getMul() != null && (basePointerType = GoTypeUtil.getBasePointerType(base, o)) != null) {
                return basePointerType;
            }
            return type;
        }
        if (o instanceof GoBinaryExpr) {
            GoBinaryExpr b = (GoBinaryExpr)o;
            GoExpression l = b.getLeft();
            GoExpression r = b.getRight();
            if (o instanceof GoAddExpr) {
                if (((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)o)).traverse().size() > 500) {
                    return GoPsiImplUtil.getArithmeticExpressionTypeCheap(r, GoExpressionUtil.getOperatorType((GoBinaryExpr)o), state);
                }
                return GoPsiImplUtil.getArithmeticExpressionType(l, r, GoExpressionUtil.getOperatorType((GoBinaryExpr)o), state);
            }
            if (o instanceof GoMulExpr) {
                return GoPsiImplUtil.getArithmeticExpressionType(l, r, GoExpressionUtil.getOperatorType((GoBinaryExpr)o), state);
            }
            if (GoExpressionUtil.isBoolExpression(o)) {
                if (r == null) {
                    return null;
                }
                GoType lType = l.getGoType(state);
                if (lType == null) {
                    return null;
                }
                GoType rType = r.getGoType(state);
                if (rType == null) {
                    return null;
                }
                if (GoPsiImplUtil.isRealBool(lType, state)) {
                    return rType;
                }
                if (GoPsiImplUtil.isRealBool(rType, state)) {
                    return lType;
                }
                return GoTypeUtil.isBoolean(lType, context) && GoTypeUtil.identical(lType, rType, context) ? lType : null;
            }
        }
        if (o instanceof GoCompositeLit) {
            GoCompositeLit compositeLit = (GoCompositeLit)o;
            GoType type = compositeLit.getType();
            if (type != null) {
                return type;
            }
            GoTypeReferenceExpression typeRef = compositeLit.getTypeReferenceExpression();
            if (typeRef != null) {
                GoType resolvedType = typeRef.resolveType(state);
                if (resolvedType == null) {
                    return null;
                }
                GoTypeArguments typeArguments = compositeLit.getTypeArguments();
                List<Object> typeArgumentList = typeArguments != null ? typeArguments.getTypes() : Collections.emptyList();
                return GoPsiImplUtil.createTypeFromReference(typeRef, typeArgumentList);
            }
            return null;
        }
        if (o instanceof GoFunctionLit) {
            return new GoLightType.LightFunctionType((GoFunctionLit)o, null);
        }
        if (o instanceof GoBuiltinCallExpr) {
            call = (GoBuiltinCallExpr)o;
            if (call.isTrulyBuiltin()) {
                conversionType = GoPsiUtil.getTypeIfConversion((GoBuiltinCallExpr)call);
                if (conversionType != null) {
                    return conversionType;
                }
                String text = call.getExpression().getText();
                boolean isNew = "new".equals(text);
                boolean isMake = "make".equals(text);
                if (isNew || isMake) {
                    GoType type = call.getBuiltinArgumentList().getType();
                    return isNew ? (type == null ? null : new GoLightType.LightPointerType(type)) : type;
                }
                return null;
            }
            return GoPsiImplUtil.getUserDefinedCallExpressionType(call.getExpression(), state);
        }
        if (o instanceof GoCallExpr) {
            GoType type;
            List<GoExpression> args;
            call = (GoCallExpr)o;
            conversionType = GoPsiUtil.getTypeIfConversion((GoCallExpr)call);
            if (conversionType != null) {
                return conversionType;
            }
            if (GoPsiUtil.isBuiltinFunctionCall((GoCallExpr)call, "imag", "real")) {
                GoType argType;
                args = call.getArgumentList().getExpressionList();
                if (args.size() != 1) {
                    return GoLightType.getFloatType(o);
                }
                GoExpression arg2 = (GoExpression)ContainerUtil.getFirstItem(args);
                GoType goType = argType = arg2 != null ? GoPsiImplUtil.getGoTypeInner(arg2, state) : null;
                if (GoTypeUtil.isComplex64(argType, context)) {
                    return GoPsiImplUtil.getBuiltinType("float32", context);
                }
                if (GoTypeUtil.isComplex128(argType, context)) {
                    return GoPsiImplUtil.getBuiltinType("float64", context);
                }
                return GoLightType.getFloatType(o);
            }
            if (GoPsiUtil.isBuiltinFunctionCall((GoCallExpr)call, "complex")) {
                GoType sndType;
                args = call.getArgumentList().getExpressionList();
                if (args.size() != 2) {
                    return GoLightType.getComplexType(o);
                }
                GoExpression fstArg = args.get(0);
                GoType fstType = fstArg != null ? GoPsiImplUtil.getGoTypeInner(fstArg, state) : null;
                GoExpression sndArg = args.get(1);
                GoType goType = sndType = sndArg != null ? GoPsiImplUtil.getGoTypeInner(sndArg, state) : null;
                if (GoTypeUtil.isFloat32(fstType, context) && (GoTypeUtil.isFloat32(sndType, context) || GoTypeUtil.isUntypedNumericType(sndType)) || GoTypeUtil.isFloat32(sndType, context) && (GoTypeUtil.isFloat32(fstType, context) || GoTypeUtil.isUntypedNumericType(fstType))) {
                    return GoPsiImplUtil.getBuiltinType("complex64", context);
                }
                if (GoTypeUtil.isFloat64(fstType, context) && (GoTypeUtil.isFloat64(sndType, context) || GoTypeUtil.isUntypedNumericType(sndType)) || GoTypeUtil.isFloat64(sndType, context) && (GoTypeUtil.isFloat64(fstType, context) || GoTypeUtil.isUntypedNumericType(fstType))) {
                    return GoPsiImplUtil.getBuiltinType("complex128", context);
                }
                return GoLightType.getComplexType(o);
            }
            if (GoPsiUtil.isBuiltinFunctionCall((GoCallExpr)call, "append")) {
                List<GoExpression> l = call.getArgumentList().getExpressionList();
                GoExpression f = (GoExpression)ContainerUtil.getFirstItem(l);
                return f == null ? null : f.getGoType(state);
            }
            if (GoStdlibUtil.isUnsafeFunctionCall((GoCallExpr)call, "Slice")) {
                return call.getArgumentList().getExpressionList().stream().findFirst().map(arg -> arg.getGoType(state)).map(t -> t.getUnderlyingType(state)).map(t -> t instanceof GoPointerType ? ((GoPointerType)t).getType() : null).map(GoLightType.LightSliceType::new).orElse(null);
            }
            if (GoStdlibUtil.isUnsafeFunctionCall((GoCallExpr)call, "SliceData")) {
                return call.getArgumentList().getExpressionList().stream().findFirst().map(arg -> arg.getGoType(state)).map(t -> t.getUnderlyingType(state)).map(t -> {
                    GoArrayOrSliceType arrayOrSliceType;
                    return t instanceof GoArrayOrSliceType && !(arrayOrSliceType = (GoArrayOrSliceType)t).isArray() ? arrayOrSliceType.getType() : null;
                }).map(GoLightType.LightPointerType::new).orElse(null);
            }
            GoSignature signature = call.resolveSignature();
            GoType goType = type = signature != null ? signature.getResultType() : null;
            if (type != null && GoPsiUtil.isBuiltinFunctionCall((GoCallExpr)call, "min", "max") && GoExpressionUtil.isConstant(o, context)) {
                if (GoTypeUtil.isIntegerType(type, context)) {
                    return GoLightType.getIntType(type);
                }
                if (GoTypeUtil.isFloatType(type, context)) {
                    return GoLightType.getFloatType(type);
                }
            }
            return type != null ? type : GoPsiImplUtil.getUserDefinedCallExpressionType(call.getExpression(), state);
        }
        if (o instanceof GoReferenceExpression) {
            PsiElement resolve;
            GoReferenceExpression reference = (GoReferenceExpression)o;
            GoResolveResult resolveResult = reference.getGoResolveResult(null);
            PsiElement psiElement = resolve = resolveResult != null ? resolveResult.getElement() : null;
            if (!o.textMatches("_") && resolve == o) {
                return new GoCType(o);
            }
            if ((o.textMatches("true") || o.textMatches("false")) && GoPsiImplUtil.builtin(resolve)) {
                return GoLightType.getBoolType(o);
            }
            if (resolve instanceof GoTypeOwner) {
                GoType type;
                GoTypeOwner typeOwner = (GoTypeOwner)resolve;
                GoSubstitution typeSubstitution = resolveResult.getTypeSubstitution();
                if (typeOwner instanceof GoSignatureOwner) {
                    GoSignatureOwner signatureOwner = (GoSignatureOwner)((Object)typeOwner);
                    type = new GoLightType.LightFunctionType(signatureOwner, GoPsiImplUtil.getMethodExpressionQualifierTypeName(reference, GoPsiImplUtil.createContextOnElement(typeOwner)));
                } else {
                    ResolveState state2 = ResolveUtil.put(state, typeSubstitution);
                    type = typeOwner.getGoType(state2);
                }
                return type != null ? GoInstantiatedTypeFactory.create(type, typeSubstitution.getParams(), reference) : null;
            }
            return null;
        }
        if (o instanceof GoParenthesesExpr) {
            GoExpression expression = GoPsiImplUtil.unwrapParentheses(o);
            return expression != null ? expression.getGoType(state) : null;
        }
        if (o instanceof GoIndexOrSliceExpr) {
            GoType type;
            GoIndexOrSliceExpr indexOrSliceExpr = (GoIndexOrSliceExpr)o;
            GoType referenceType = GoPsiImplUtil.getIndexedExpressionReferenceType(indexOrSliceExpr, state);
            if (referenceType != null && GoPsiUtil.isCallOrConversionWithTypeInstantiation(indexOrSliceExpr)) {
                return GoTypeInstantiationKt.getInstantiatedType(indexOrSliceExpr, referenceType, state);
            }
            GoType goType = type = referenceType != null ? GoTypeUtil.getCoreType(referenceType, state) : null;
            if (o.getNode().findChildByType(GoTypes.COLON) != null) {
                GoArrayOrSliceType arrayOrSlice;
                if (type instanceof GoArrayOrSliceType && (arrayOrSlice = (GoArrayOrSliceType)type).isArray()) {
                    return new GoLightType.LightSliceType(arrayOrSlice.getType());
                }
                return referenceType;
            }
            if (type instanceof GoMapType) {
                return ((GoMapType)type).getValueType();
            }
            if (type instanceof GoArrayOrSliceType) {
                return ((GoArrayOrSliceType)type).getType();
            }
            if (GoTypeUtil.isString(type, context)) {
                return GoPsiImplUtil.getBuiltinType("byte", context);
            }
            if (GoTypeUtil.isCType(type, context)) {
                return type;
            }
        }
        if (o instanceof GoTypeAssertionExpr) {
            return ((GoTypeAssertionExpr)o).getType_() != null ? ((GoTypeAssertionExpr)o).getExpression().getGoType(state) : ((GoTypeAssertionExpr)o).getType();
        }
        if (o instanceof GoConversionExpr) {
            return ((GoConversionExpr)o).getType();
        }
        if (o instanceof GoStringLiteral) {
            return GoLightType.getStringType(o);
        }
        if (o instanceof GoConditionalExpr) {
            return GoLightType.getBoolType(o);
        }
        if (o instanceof GoLiteral) {
            GoLiteral l = (GoLiteral)o;
            if (l.getChar() != null) {
                return GoLightType.getRuneType(o);
            }
            if (l.getInt() != null || l.getHex() != null || l.getOct() != null || l.getBin() != null) {
                return GoLightType.getIntType(o);
            }
            if (l.getFloat() != null) {
                return GoLightType.getFloatType(o);
            }
            if (l.getFloati() != null || l.getDecimali() != null) {
                return GoLightType.getComplexType(o);
            }
        }
        return null;
    }

    @Nullable
    public static GoSignature getSignature(@NotNull GoCallExpr callExpr) {
        GoSignature goSignature;
        GoReferenceExpression callReference;
        PsiElement resolvedCall;
        if (callExpr == null) {
            GoPsiImplUtil.$$$reportNull$$$0(86);
        }
        PsiElement psiElement = resolvedCall = (callReference = GoPsiUtil.getCallReference(callExpr)) != null ? callReference.resolve() : null;
        if (resolvedCall instanceof GoNamedSignatureOwner) {
            GoNamedSignatureOwner owner = (GoNamedSignatureOwner)resolvedCall;
            goSignature = owner.getSignature();
        } else {
            goSignature = null;
        }
        return goSignature;
    }

    private static boolean isRealBool(@NotNull GoType type, @Nullable ResolveState state) {
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(87);
        }
        if (type instanceof GoLightType.LightUntypedBoolType) {
            return true;
        }
        PsiElement resolve = type.resolve(state);
        return resolve instanceof GoTypeSpec && GoPsiImplUtil.builtin(resolve) && "bool".equals(((GoTypeSpec)resolve).getName());
    }

    @Nullable
    private static GoType getUserDefinedCallExpressionType(@NotNull GoExpression calledExpression, @Nullable ResolveState state) {
        GoType byRef;
        if (calledExpression == null) {
            GoPsiImplUtil.$$$reportNull$$$0(88);
        }
        if (calledExpression instanceof GoReferenceExpression && ((GoReferenceExpression)calledExpression).resolve() == calledExpression) {
            return new GoCType(calledExpression);
        }
        GoType type = calledExpression.getGoType(state);
        if (type instanceof GoFunctionType) {
            return ((GoFunctionType)type).getResultType();
        }
        GoType goType = byRef = type != null && type.getTypeReferenceExpression() != null ? GoTypeUtil.getCoreType(type, state) : null;
        if (byRef instanceof GoFunctionType) {
            return ((GoFunctionType)byRef).getResultType();
        }
        return GoPsiImplUtil.getTypeFromSpecIfNeeded(type);
    }

    @Nullable
    public static GoType getTypeFromSpecIfNeeded(@Nullable GoType type) {
        if (!(type instanceof GoSpecType)) {
            return type;
        }
        GoTypeStub stub = (GoTypeStub)type.getStub();
        if (stub != null) {
            String name;
            StubElement parentStub = stub.getParentStub();
            GoTypeSpec typeSpec = parentStub == null ? null : (GoTypeSpec)ObjectUtils.tryCast((Object)parentStub.getPsi(), GoTypeSpec.class);
            String string = name = typeSpec != null ? typeSpec.getName() : null;
            if (name != null) {
                return GoElementFactory.createTypeCheap(type.getProject(), name, type);
            }
        }
        String identifierText = ((GoSpecType)type).getIdentifier().getText();
        return GoElementFactory.createTypeCheap(type.getProject(), identifierText, type);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static GoType createTypeFromReference(@Nullable PsiElement typeReference, @NotNull List<? extends PsiElement> typeArguments) {
        if (typeArguments == null) {
            GoPsiImplUtil.$$$reportNull$$$0(89);
        }
        if (typeReference == null) {
            return null;
        }
        Project project = typeReference.getProject();
        String typeReferenceText = typeReference.getText();
        PsiElement substitutionContext = GoReferenceBase.getSubstitutionContextOrSelf(typeReference);
        if (typeArguments.isEmpty() || GoPsiImplUtil.areTypeArgumentsNullsOnly(typeArguments)) {
            return GoElementFactory.createTypeCheap(project, typeReferenceText, substitutionContext);
        }
        String typeArgumentsText = "[" + StringUtil.join(typeArguments, PsiElement::getText, (String)", ") + "]";
        return GoElementFactory.createTypeCheap(project, typeReferenceText + typeArgumentsText, substitutionContext);
    }

    private static boolean areTypeArgumentsNullsOnly(@NotNull List<? extends PsiElement> typeArguments) {
        if (typeArguments == null) {
            GoPsiImplUtil.$$$reportNull$$$0(90);
        }
        return ContainerUtil.and(typeArguments, x -> x == null);
    }

    @Nullable
    public static String getMethodExpressionQualifierTypeName(@Nullable GoReferenceExpression o, @Nullable ResolveState context) {
        if (o == null) {
            return null;
        }
        return GoPsiImplUtil.getMethodExpressionQualifierTypeName(o.getQualifier(), context);
    }

    @Nullable
    public static String getMethodExpressionQualifierTypeName(@Nullable GoQualifier qualifier, @Nullable ResolveState context) {
        if (qualifier instanceof GoExpression) {
            qualifier = GoPsiImplUtil.unwrapParentheses((GoExpression)qualifier);
        }
        if (qualifier instanceof GoReferenceExpression) {
            GoReferenceExpression ref = (GoReferenceExpression)qualifier;
            PsiElement qualifierResolve = ref.resolve();
            if (qualifierResolve instanceof GoTypeSpec) {
                GoTypeSpec typeSpec = (GoTypeSpec)qualifierResolve;
                return typeSpec.getName();
            }
            if (qualifierResolve instanceof GoTypeParamDefinition) {
                GoTypeParamDefinition typeParamDefinition = (GoTypeParamDefinition)qualifierResolve;
                return typeParamDefinition.getName();
            }
            return null;
        }
        if (qualifier instanceof GoExpression) {
            GoType inner;
            GoExpression baseExpr;
            GoExpression expr = (GoExpression)qualifier;
            if (expr instanceof GoCompositeLit || expr instanceof GoCallExpr || expr instanceof GoBuiltinCallExpr) {
                return null;
            }
            if (GoPsiImplUtil.isPointerValueOrValueDeref(expr)) {
                return null;
            }
            if (expr instanceof GoIndexOrSliceExpr) {
                GoIndexOrSliceExpr indexOrSliceExpr = (GoIndexOrSliceExpr)expr;
                v0 = indexOrSliceExpr.getExpression();
            } else {
                v0 = baseExpr = expr;
            }
            if (baseExpr == null) {
                return null;
            }
            GoType type = baseExpr.getGoType(context);
            boolean isPointer = type instanceof GoPointerType;
            GoType goType = inner = isPointer ? ((GoPointerType)type).getType() : type;
            if (inner == null) {
                return null;
            }
            PsiElement resolve = (PsiElement)ObjectUtils.notNull((Object)inner.resolve(context), (Object)inner);
            if (!(resolve instanceof GoSpecType) && !(resolve instanceof GoTypeSpec)) {
                return null;
            }
            GoTypeSpec typeSpec = resolve instanceof GoTypeSpec ? (GoTypeSpec)resolve : (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolve, GoTypeSpec.class);
            return GoPsiImplUtil.getTypeSpecText(typeSpec, GoPsiImplUtil.isMulExpression(expr));
        }
        if (qualifier instanceof GoType) {
            GoType inner;
            GoType type = (GoType)qualifier;
            boolean isPointer = type instanceof GoPointerType;
            GoType goType = inner = isPointer ? ((GoPointerType)type).getType() : type;
            if (inner == null || inner instanceof GoPointerType) {
                return null;
            }
            return (isPointer ? "*" : "") + inner.getText();
        }
        return null;
    }

    private static boolean isMulExpression(@NotNull GoExpression expr) {
        GoUnaryExpr unaryExpr;
        if (expr == null) {
            GoPsiImplUtil.$$$reportNull$$$0(91);
        }
        return expr instanceof GoUnaryExpr && (unaryExpr = (GoUnaryExpr)expr).getMul() != null;
    }

    private static boolean isPointerValueOrValueDeref(@NotNull GoExpression expr) {
        GoIndexOrSliceExpr indexOrSliceExpr;
        GoUnaryExpr unaryExpr;
        if (expr == null) {
            GoPsiImplUtil.$$$reportNull$$$0(92);
        }
        if ((unaryExpr = (GoUnaryExpr)ObjectUtils.tryCast((Object)expr, GoUnaryExpr.class)) == null) {
            return false;
        }
        if (unaryExpr.getBitAnd() != null) {
            return true;
        }
        if (unaryExpr.getMul() == null) {
            return false;
        }
        GoExpression operandExpr = unaryExpr.getExpression();
        if (operandExpr != null) {
            operandExpr = operandExpr.unwrapParentheses();
        }
        boolean isTypeInstantiation = operandExpr instanceof GoIndexOrSliceExpr && GoPsiUtil.isCallOrConversionWithTypeInstantiation(indexOrSliceExpr = (GoIndexOrSliceExpr)operandExpr);
        return !isTypeInstantiation && GoPsiUtil.isExpression(operandExpr);
    }

    @Nullable
    private static String getTypeSpecText(@Nullable GoTypeSpec typeSpec, boolean isPointer) {
        if (typeSpec == null) {
            return null;
        }
        String name = typeSpec.getName();
        if (name == null) {
            return null;
        }
        String pointer = isPointer ? "*" : "";
        return pointer + name + GoPsiImplUtil.getTypeParametersText(typeSpec.getSpecType().getTypeParameters());
    }

    @NotNull
    private static String getTypeParametersText(@Nullable GoTypeParameters typeParameters) {
        if (typeParameters == null) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>();
        for (GoTypeParameterDeclaration typeParameterDeclaration : typeParameters.getTypeParameterDeclarationList()) {
            for (GoTypeParamDefinition typeParamDefinition : typeParameterDeclaration.getTypeParamDefinitionList()) {
                result.add(typeParamDefinition.getName());
            }
        }
        String string = "[" + StringUtil.join(result, (String)", ") + "]";
        if (string == null) {
            GoPsiImplUtil.$$$reportNull$$$0(93);
        }
        return string;
    }

    @Nullable
    public static GoType getIndexedExpressionReferenceType(@NotNull GoIndexOrSliceExpr o, @Nullable ResolveState context) {
        GoExpression first;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(94);
        }
        return GoPsiImplUtil.unwrapPointerIfNeeded((first = (GoExpression)ContainerUtil.getFirstItem(o.getExpressionList())) != null ? first.getGoType(context) : null);
    }

    @Nullable
    public static GoType unwrapPointerIfNeeded(@Nullable GoType type) {
        return type instanceof GoPointerType ? ((GoPointerType)type).getType() : type;
    }

    @Nullable
    public static GoType getBuiltinType(@NotNull String name, @NotNull PsiElement context) {
        GoTypeSpec spec;
        GoFile builtin;
        if (name == null) {
            GoPsiImplUtil.$$$reportNull$$$0(95);
        }
        if (context == null) {
            GoPsiImplUtil.$$$reportNull$$$0(96);
        }
        if ((builtin = GoSdkUtil.findBuiltinFile(context)) != null && (spec = (GoTypeSpec)ContainerUtil.getFirstItem(builtin.getTypes(name))) != null) {
            return spec.getSpecType().getType();
        }
        return null;
    }

    @Nullable
    public static PsiElement contextlessResolve(@NotNull GoType type) {
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(97);
        }
        return GoPsiImplUtil.resolve(type, (ResolveState)null);
    }

    @Nullable
    public static PsiElement resolve(@NotNull GoType type, @Nullable PsiElement context) {
        GoTypeReferenceExpression expression;
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(98);
        }
        if ((expression = type.getTypeReferenceExpression()) == null) {
            return null;
        }
        if (context == null) {
            return expression.resolve(null);
        }
        return expression.resolve(GoPsiImplUtil.createContextOnElement(context));
    }

    @Nullable
    public static PsiElement resolve(@NotNull GoType type, @Nullable ResolveState state) {
        GoTypeReferenceExpression expression;
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(99);
        }
        return (expression = type.getTypeReferenceExpression()) != null ? expression.resolve(state) : null;
    }

    @Nullable
    public static GoType getUnwrappedTypeOfLiteralValue(@Nullable PsiElement element) {
        PsiElement context = (PsiElement)ObjectUtils.doIfNotNull((Object)element, GoReferenceBase::getSubstitutionContextOrSelf);
        return GoPsiImplUtil.getUnwrappedTypeOfLiteralValue(element, context);
    }

    @Nullable
    public static GoType getUnwrappedTypeOfLiteralValue(@Nullable PsiElement element, @Nullable PsiElement context) {
        GoLiteralValue literalValue = (GoLiteralValue)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoLiteralValue.class});
        GoType type = GoPsiImplUtil.getLiteralType(literalValue);
        return GoPsiImplUtil.unwrapLiteralType(type, literalValue != null && literalValue.getParent() instanceof GoCompositeLit, context);
    }

    @Nullable
    public static GoType getKeyType(@Nullable GoKey key) {
        return key != null ? GoPsiImplUtil.getValueOrKeyType(key, (type, isCompositeLiteral) -> GoPsiImplUtil.getTypeForKey(type, isCompositeLiteral, key)) : null;
    }

    @Nullable
    public static GoType getValueType(@Nullable GoValue value) {
        return GoPsiImplUtil.getValueOrKeyType(value, (type, isCompositeLiteral) -> GoPsiImplUtil.getTypeForValue(type, isCompositeLiteral, value));
    }

    @Nullable
    private static GoType getValueOrKeyType(@Nullable PsiElement keyOrValue, @NotNull BiFunction<GoType, Boolean, GoType> getInnerType) {
        if (getInnerType == null) {
            GoPsiImplUtil.$$$reportNull$$$0(100);
        }
        GoElement element = keyOrValue != null ? (GoElement)ObjectUtils.tryCast((Object)keyOrValue.getParent(), GoElement.class) : null;
        GoLiteralValue literalValue = element != null ? (GoLiteralValue)ObjectUtils.tryCast((Object)element.getParent(), GoLiteralValue.class) : null;
        GoType type = literalValue != null ? GoPsiImplUtil.getLiteralType(literalValue) : null;
        return getInnerType.apply(type, literalValue != null && literalValue.getParent() instanceof GoCompositeLit);
    }

    @Nullable
    @Contract(value="null->null")
    public static GoType getLiteralType(@Nullable GoLiteralValue literalValue) {
        PsiElement parent;
        PsiElement psiElement = parent = literalValue != null ? literalValue.getParent() : null;
        return parent instanceof GoCompositeLit ? ((GoCompositeLit)parent).getGoType(null) : (parent instanceof GoValue ? GoPsiImplUtil.getValueType((GoValue)parent) : (parent instanceof GoKey ? GoPsiImplUtil.getKeyType((GoKey)parent) : null));
    }

    @Nullable
    private static GoType getTypeForKey(@Nullable GoType type, boolean isCompositeLiteral, @NotNull GoCompositeElement context) {
        if (context == null) {
            GoPsiImplUtil.$$$reportNull$$$0(101);
        }
        if ((type = GoPsiImplUtil.unwrapLiteralType(type, isCompositeLiteral, context)) instanceof GoArrayOrSliceType) {
            return GoLightType.getIntType(context);
        }
        if (type instanceof GoMapType) {
            return ((GoMapType)type).getKeyType();
        }
        if (type instanceof GoStructType && context instanceof GoKey) {
            PsiElement resolve;
            GoFieldName field = ((GoKey)context).getFieldName();
            PsiElement psiElement = resolve = field != null ? field.resolve() : null;
            if (resolve instanceof GoFieldDefinition) {
                return ((GoFieldDefinition)resolve).getGoType(null);
            }
        }
        return null;
    }

    @Nullable
    private static GoType getTypeForValue(@Nullable GoType type, boolean isCompositeLiteral, @Nullable GoValue value) {
        if ((type = GoPsiImplUtil.unwrapLiteralType(type, isCompositeLiteral, value)) instanceof GoArrayOrSliceType) {
            return ((GoArrayOrSliceType)type).getType();
        }
        if (type instanceof GoMapType) {
            return ((GoMapType)type).getValueType();
        }
        if (type instanceof GoStructType) {
            if (value == null) {
                return null;
            }
            GoLiteralValue literalValue = (GoLiteralValue)PsiTreeUtil.getParentOfType((PsiElement)value, GoLiteralValue.class);
            if (literalValue == null || GoPsiImplUtil.isKeysExpected(literalValue)) {
                PsiElement resolve;
                GoKey key = (GoKey)PsiTreeUtil.getPrevSiblingOfType((PsiElement)value, GoKey.class);
                GoFieldName field = key != null ? key.getFieldName() : null;
                PsiElement psiElement = resolve = field != null ? field.resolve() : null;
                if (resolve instanceof GoFieldDefinition) {
                    GoType fieldType = ((GoFieldDefinition)resolve).getGoType(null);
                    return fieldType != null ? fieldType.withInstantiation(type.toInstantiated()) : null;
                }
            } else {
                GoElement element = (GoElement)ObjectUtils.tryCast((Object)value.getParent(), GoElement.class);
                if (element == null) {
                    return null;
                }
                GoNamedElement definition = GoPsiUtil.getCorrespondingLeftExpr(element, literalValue.getElementList(), ((GoStructType)type).getFieldDefinitions());
                return definition != null ? definition.getGoType(null) : null;
            }
        }
        return null;
    }

    private static boolean isKeysExpected(@NotNull GoLiteralValue value) {
        List<GoElement> elementList;
        if (value == null) {
            GoPsiImplUtil.$$$reportNull$$$0(102);
        }
        return (elementList = value.getElementList()).isEmpty() || ContainerUtil.exists(elementList, e -> e.getKey() != null);
    }

    @NotNull
    public static List<GoNamedElement> getFieldDefinitions(@NotNull GoStructType type) {
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(103);
        }
        SmartList result = new SmartList();
        for (GoFieldDeclaration declaration : type.getFieldDeclarationList()) {
            result.addAll(declaration.getFieldDefinitionList());
            ContainerUtil.addIfNotNull((Collection)result, (Object)declaration.getAnonymousFieldDefinition());
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoPsiImplUtil.$$$reportNull$$$0(104);
        }
        return smartList;
    }

    public static List<GoAnonymousFieldDefinition> getAnonymousFieldDefinitions(@NotNull GoStructType type) {
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(105);
        }
        return ContainerUtil.mapNotNull(type.getFieldDeclarationList(), GoFieldDeclaration::getAnonymousFieldDefinition);
    }

    @Nullable
    public static String getTagText(@NotNull GoFieldDeclaration o) {
        GoFieldDeclarationStub stub;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(106);
        }
        if ((stub = (GoFieldDeclarationStub)o.getStub()) != null) {
            return stub.getTag();
        }
        GoTag tag = o.getTag();
        return tag == null ? null : tag.getText();
    }

    @Nullable
    public static GoType unwrapLiteralType(@Nullable GoType type, boolean isCompositeLiteral, @Nullable PsiElement context) {
        if (type instanceof GoParType) {
            type = ((GoParType)type).getType();
        }
        if (type != null && type.getTypeReferenceExpression() != null) {
            type = GoTypeUtil.getCoreType(type, context);
        }
        if (!isCompositeLiteral && GoTypeUtil.isPointer(type, context)) {
            GoType inner = GoTypeUtil.getBasePointerType(type, context);
            if (inner != null && inner.getTypeReferenceExpression() != null) {
                type = GoTypeUtil.getCoreType(inner, context);
            } else if (GoPsiImplUtil.isValidLiteralType(inner)) {
                type = inner;
            }
        }
        return type instanceof GoSpecType ? ((GoSpecType)type).getType() : type;
    }

    @Contract(value="null -> false")
    public static boolean isValidLiteralType(@Nullable GoType type) {
        if (type instanceof GoInstantiatedType) {
            return GoPsiImplUtil.isValidLiteralType((GoType)((GoInstantiatedType)type).getGeneric());
        }
        return type instanceof GoArrayOrSliceType || type instanceof GoStructType || type instanceof GoMapType || GoTypeUtil.matchTypeConstraints(type, type, it -> GoPsiImplUtil.isValidLiteralType(it));
    }

    @Nullable
    public static GoType resolveType(@NotNull GoTypeReferenceExpression expression, @Nullable ResolveState state) {
        PsiElement resolve;
        if (expression == null) {
            GoPsiImplUtil.$$$reportNull$$$0(107);
        }
        if ((resolve = expression.resolve(state)) instanceof GoTypeSpec) {
            return ((GoTypeSpec)resolve).getSpecType();
        }
        if (resolve instanceof GoTypeParamDefinition) {
            return ((GoTypeParamDefinition)resolve).getTypeParameter();
        }
        return resolve == expression ? new GoCType(expression) : null;
    }

    public static boolean isVariadic(@NotNull GoParamDefinition o) {
        PsiElement parent;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(108);
        }
        return (parent = o.getParent()) instanceof GoParameterDeclaration && ((GoParameterDeclaration)parent).isVariadic();
    }

    public static boolean isVariadic(@NotNull GoParameterDeclaration o) {
        GoParameterDeclarationStub stub;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(109);
        }
        return (stub = (GoParameterDeclarationStub)o.getStub()) != null ? stub.isVariadic() : o.getTripleDot() != null;
    }

    public static boolean isVariadic(@NotNull GoArgumentList argumentList) {
        if (argumentList == null) {
            GoPsiImplUtil.$$$reportNull$$$0(110);
        }
        return argumentList.getTripleDot() != null;
    }

    @NotNull
    public static GoType getGoTypeInner(@NotNull GoTypeSpec o, @Nullable ResolveState context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(111);
        }
        GoSpecType goSpecType = o.getSpecType();
        if (goSpecType == null) {
            GoPsiImplUtil.$$$reportNull$$$0(112);
        }
        return goSpecType;
    }

    public static boolean isVoid(@NotNull GoResult result) {
        GoType type;
        if (result == null) {
            GoPsiImplUtil.$$$reportNull$$$0(113);
        }
        if ((type = result.getType()) != null) {
            return false;
        }
        GoParameters parameters = result.getParameters();
        return parameters == null || parameters.getParameterDeclarationList().isEmpty();
    }

    public static boolean isMapIndexExpr(@Nullable GoExpression e, @Nullable ResolveState state) {
        if (!(e instanceof GoIndexOrSliceExpr)) {
            return false;
        }
        GoExpression mapExpr = ((GoIndexOrSliceExpr)e).getExpression();
        GoType mapType = mapExpr != null ? mapExpr.getGoType(state) : null;
        return GoPsiImplUtil.isMapType(mapType, state);
    }

    public static boolean isMapType(@Nullable GoType type, @Nullable ResolveState resolveState) {
        GoType underlying;
        GoType goType = underlying = type != null ? type.getUnderlyingType(resolveState) : null;
        if (underlying instanceof GoInterfaceType) {
            return GoTypeUtil.matchTypeConstraints(underlying, resolveState, t -> GoPsiImplUtil.isMapType(t, resolveState));
        }
        return underlying instanceof GoMapType;
    }

    @Contract(value="null -> null; !null -> !null")
    public static GoType unwrapGoParType(@Nullable GoType o) {
        while (o instanceof GoParType) {
            o = ((GoParType)o).getType();
        }
        return o;
    }

    @NotNull
    @NlsSafe
    public static String getPresentationText(@Nullable GoType o) {
        String string = GoPsiPresentationBuilder.create().withoutResolve().withoutStructureAndInterfaceContent().build(o);
        if (string == null) {
            GoPsiImplUtil.$$$reportNull$$$0(114);
        }
        return string;
    }

    public static String getFqn(@Nullable String packageName, @NotNull String elementName) {
        if (elementName == null) {
            GoPsiImplUtil.$$$reportNull$$$0(115);
        }
        return StringUtil.isNotEmpty((String)packageName) ? packageName + "." + elementName : elementName;
    }

    @NotNull
    public static List<GoMethodSpec> getMethods(@NotNull GoInterfaceType o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(116);
        }
        List list = ContainerUtil.filter(o.getMethodSpecList(), spec -> spec.getTypeReferenceExpression() == null);
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(117);
        }
        return list;
    }

    @NotNull
    public static List<GoMethodSpec> getAllMethods(@Nullable GoInterfaceType o) {
        return GoPsiImplUtil.getAllMethods(o, null);
    }

    @NotNull
    public static List<GoMethodSpec> getAllMethods(@Nullable GoInterfaceType o, @Nullable PsiElement context) {
        List list = ContainerUtil.map(GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(o, null, context), it -> (GoMethodSpec)it.getElement());
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(118);
        }
        return list;
    }

    @NotNull
    public static List<GoElementWithSubst<GoMethodSpec>> calcAllMethodsWithSubstitutionSource(@Nullable GoInterfaceType o, @Nullable GoType substitutionSource, @Nullable PsiElement context) {
        if (o == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GoPsiImplUtil.$$$reportNull$$$0(119);
            }
            return list;
        }
        if (context == null && substitutionSource == null && GoCaching.isEnabled()) {
            List list = (List)CachedValuesManager.getCachedValue((PsiElement)o, () -> GoCacheUtilKt.createResolveDependentResult(o.getProject(), GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(o, null, null, new HashSet<GoType>()), new Object[0]));
            if (list == null) {
                GoPsiImplUtil.$$$reportNull$$$0(120);
            }
            return list;
        }
        return GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(o, substitutionSource, context, new HashSet<GoType>());
    }

    @NotNull
    private static List<GoElementWithSubst<GoMethodSpec>> calcAllMethodsWithSubstitutionSource(@Nullable GoInterfaceType o, @Nullable GoType substitutionSource, @Nullable PsiElement context, @NotNull Set<GoType> visitedTypes) {
        if (visitedTypes == null) {
            GoPsiImplUtil.$$$reportNull$$$0(121);
        }
        if (o == null || !visitedTypes.add(o)) {
            List<GoElementWithSubst<GoMethodSpec>> list = Collections.emptyList();
            if (list == null) {
                GoPsiImplUtil.$$$reportNull$$$0(122);
            }
            return list;
        }
        SmartList result = new SmartList();
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
        GoType substSource = substitutionSource != null ? substitutionSource : o;
        for (GoMethodSpec method : o.getMethodSpecList()) {
            GoType underlying;
            GoInterfaceType innerInterface;
            GoTypeReferenceExpression reference = method.getTypeReferenceExpression();
            if (reference == null) {
                result.add(GoElementWithSubst.create(method, substSource));
                if (!IdempotenceChecker.isLoggingEnabled()) continue;
                String methodHex = Integer.toHexString(method.hashCode());
                String interfaceHex = Integer.toHexString(o.hashCode());
                IdempotenceChecker.logTrace((String)("Added method " + methodHex + " from interface " + interfaceHex));
                continue;
            }
            PsiElement resolve = reference.resolve(resolveState);
            if (!(resolve instanceof GoTypeSpec)) continue;
            GoType specType = ((GoTypeSpec)resolve).getSpecType();
            GoTypeArguments typeArguments = method.getTypeArguments();
            if (typeArguments != null) {
                specType = GoTypeInstantiationKt.getInstantiatedSpecType(specType, typeArguments.getTypes());
                if (substSource instanceof GoInstantiatedType) {
                    GoInstantiatedType instantiated2 = (GoInstantiatedType)substSource;
                    specType = GoPsiImplUtil.withInstantiation(specType, instantiated2);
                }
            }
            if ((innerInterface = (GoInterfaceType)ObjectUtils.tryCast((Object)GoPsiImplUtil.unwrapInstantiation(underlying = specType.getUnderlyingType(context)), GoInterfaceType.class)) != null && IdempotenceChecker.isLoggingEnabled()) {
                String interfaceHex = Integer.toHexString(o.hashCode());
                String innerInterfaceHex = Integer.toHexString(innerInterface.hashCode());
                IdempotenceChecker.logTrace((String)("Processing inner interface " + innerInterfaceHex + " of interface " + interfaceHex));
            }
            result.addAll(GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(innerInterface, specType, context, visitedTypes));
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoPsiImplUtil.$$$reportNull$$$0(123);
        }
        return smartList;
    }

    @NotNull
    public static List<GoTypeReferenceExpression> getBaseTypesReferences(@NotNull GoInterfaceType o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(124);
        }
        List<GoTypeReferenceExpression> list = o.getMethodSpecList().stream().map(GoMethodSpec::getTypeReferenceExpression).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(125);
        }
        return list;
    }

    @NotNull
    public static List<GoMethodDeclaration> getMethods(@NotNull GoTypeSpec o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(126);
        }
        GoTypeSpec spec = GoCompletionUtil.getPhysicalOriginalOrSelf(o);
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)spec, () -> GoCacheUtilKt.createStubIndexDependentResult(spec.getProject(), (List)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> GoPsiImplUtil.calcMethods(spec)), GoPsiTreeChangeProcessor.packageModificationTracker(spec)));
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(127);
        }
        return list;
    }

    @NotNull
    public static List<GoNamedSignatureOwner> getAllMethods(@NotNull GoTypeSpec o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(128);
        }
        return GoPsiImplUtil.getAllMethods(o, null);
    }

    @NotNull
    public static List<GoNamedSignatureOwner> getAllMethods(@NotNull GoTypeSpec o, @Nullable PsiElement context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(129);
        }
        List list = ContainerUtil.map(GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(o, null, context), it -> (GoNamedSignatureOwner)it.getElement());
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(130);
        }
        return list;
    }

    @NotNull
    public static List<GoElementWithSubst<? extends GoNamedSignatureOwner>> calcAllMethodsWithSubstitutionSource(@NotNull GoTypeSpec o, @Nullable GoType typeArgumentsSource, @Nullable PsiElement context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(131);
        }
        if (context == null && typeArgumentsSource == null && GoCaching.isEnabled()) {
            List list = (List)CachedValuesManager.getCachedValue((PsiElement)o, () -> GoCacheUtilKt.createResolveDependentResult(o.getProject(), GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(o, null, null, new HashSet<GoType>()), new Object[0]));
            if (list == null) {
                GoPsiImplUtil.$$$reportNull$$$0(132);
            }
            return list;
        }
        return GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(o, typeArgumentsSource, context, new HashSet<GoType>());
    }

    public static boolean allowed(@NotNull PsiFile declarationFile, @Nullable PsiFile referenceFile, @Nullable Module contextModule) {
        if (declarationFile == null) {
            GoPsiImplUtil.$$$reportNull$$$0(133);
        }
        if (declarationFile.getFileType() != GoFileType.INSTANCE) {
            return false;
        }
        if (GoPsiImplUtil.notAllowed(declarationFile)) {
            return false;
        }
        if (GoUtil.fileToIgnore(declarationFile.getName())) {
            return false;
        }
        if (!(referenceFile == null || !GoTestFinder.isTestFile(declarationFile) || GoTestFinder.isTestFile(referenceFile) && GoUtil.inSamePackage(declarationFile, referenceFile))) {
            return false;
        }
        return GoUtil.matchedForModuleBuildTarget(declarationFile, contextModule);
    }

    private static boolean notAllowed(@NotNull PsiFile declarationFile) {
        if (declarationFile == null) {
            GoPsiImplUtil.$$$reportNull$$$0(134);
        }
        Project project = declarationFile.getProject();
        VirtualFile declarationVirtualFile = declarationFile.getOriginalFile().getVirtualFile();
        if (declarationVirtualFile != null && !project.isDefault() && FileIndexFacade.getInstance((Project)project).isExcludedFile(declarationVirtualFile)) {
            return true;
        }
        GoFileProperties fileProperties = GoFileProperties.of(declarationFile);
        return fileProperties == null || "documentation".equals(fileProperties.packageName);
    }

    static boolean processNamedElements(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull Collection<? extends GoNamedElement> elements) {
        if (processor2 == null) {
            GoPsiImplUtil.$$$reportNull$$$0(135);
        }
        if (state == null) {
            GoPsiImplUtil.$$$reportNull$$$0(136);
        }
        if (elements == null) {
            GoPsiImplUtil.$$$reportNull$$$0(137);
        }
        return GoPsiImplUtil.processNamedElements(processor2, state, elements, false);
    }

    static boolean processNamedElements(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull Collection<? extends GoNamedElement> elements, boolean checkContainingFile) {
        if (processor2 == null) {
            GoPsiImplUtil.$$$reportNull$$$0(138);
        }
        if (state == null) {
            GoPsiImplUtil.$$$reportNull$$$0(139);
        }
        if (elements == null) {
            GoPsiImplUtil.$$$reportNull$$$0(140);
        }
        return GoPsiImplUtil.processNamedElements(processor2, state, elements, (Condition<? super GoNamedElement>)Conditions.alwaysTrue(), checkContainingFile);
    }

    static boolean processNamedElements(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull Collection<? extends GoNamedElement> elements, @NotNull Condition<? super GoNamedElement> condition, boolean checkContainingFile) {
        if (processor2 == null) {
            GoPsiImplUtil.$$$reportNull$$$0(141);
        }
        if (state == null) {
            GoPsiImplUtil.$$$reportNull$$$0(142);
        }
        if (elements == null) {
            GoPsiImplUtil.$$$reportNull$$$0(143);
        }
        if (condition == null) {
            GoPsiImplUtil.$$$reportNull$$$0(144);
        }
        PsiFile contextFile = checkContainingFile ? GoReference.getContextFile(state) : null;
        Module module = GoUtil.module((PsiElement)contextFile);
        for (GoNamedElement goNamedElement : elements) {
            if (!condition.value((Object)goNamedElement) || !goNamedElement.isValid() || checkContainingFile && !GoPsiImplUtil.allowed((PsiFile)goNamedElement.getContainingFile(), contextFile, module) || processor2.execute((PsiElement)goNamedElement, state)) continue;
            return false;
        }
        return true;
    }

    static boolean processSignatureOwner(@NotNull GoSignatureOwner o, @NotNull GoScopeProcessorBase processor2) {
        GoReceiver receiver;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(145);
        }
        if (processor2 == null) {
            GoPsiImplUtil.$$$reportNull$$$0(146);
        }
        if (o instanceof GoMethodDeclaration && (receiver = ((GoMethodDeclaration)o).getReceiver()) != null && !GoPsiImplUtil.processNamedElements(processor2, ResolveState.initial(), Collections.singleton(receiver))) {
            return false;
        }
        GoSignature signature = o.getSignature();
        if (signature == null) {
            return true;
        }
        if (!GoPsiImplUtil.processParameters(processor2, signature.getParameters())) {
            return false;
        }
        GoResult result = signature.getResult();
        GoParameters resultParameters = result != null ? result.getParameters() : null;
        return resultParameters == null || GoPsiImplUtil.processParameters(processor2, resultParameters);
    }

    private static boolean processParameters(@NotNull GoScopeProcessorBase processor2, @NotNull GoParameters parameters) {
        if (processor2 == null) {
            GoPsiImplUtil.$$$reportNull$$$0(147);
        }
        if (parameters == null) {
            GoPsiImplUtil.$$$reportNull$$$0(148);
        }
        for (GoParameterDeclaration declaration : parameters.getParameterDeclarationList()) {
            if (GoPsiImplUtil.processNamedElements(processor2, ResolveState.initial(), declaration.getParamDefinitionList())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<GoMethodDeclaration> calcMethods(@NotNull GoTypeSpec o) {
        PsiFile file;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(149);
        }
        if ((file = o.getContainingFile().getOriginalFile()) instanceof GoFile) {
            GoFile baseTypeFile;
            GoTypeSpec baseTypeSpec = (GoTypeSpec)GoUtil.logExecTime(() -> GoPsiUtil.findBaseAliasedTypeSpec(o), 5, ms -> "GoPsiImplUtil#calcMethods: findBaseAliasedTypeSpec take " + ms + " for " + o.getName() + " in " + GoPsiImplUtil.getPath((PsiFile)o.getContainingFile()));
            GoFile goFile = baseTypeFile = baseTypeSpec != null ? baseTypeSpec.getContainingFile() : null;
            if (baseTypeSpec == null) {
                List<GoMethodDeclaration> list = Collections.emptyList();
                if (list == null) {
                    GoPsiImplUtil.$$$reportNull$$$0(150);
                }
                return list;
            }
            String typeName = baseTypeSpec.getName();
            if (StringUtil.isEmpty((String)typeName)) {
                List<GoMethodDeclaration> list = Collections.emptyList();
                if (list == null) {
                    GoPsiImplUtil.$$$reportNull$$$0(151);
                }
                return list;
            }
            String packageName = baseTypeFile.getPackageName();
            LinkedHashSet<GoMethodDeclaration> declarations = new LinkedHashSet<GoMethodDeclaration>();
            if (StringUtil.isEmpty((String)packageName) || ScratchUtil.isScratch((VirtualFile)baseTypeFile.getOriginalFile().getVirtualFile()) || baseTypeFile.isPhysicalCopy()) {
                declarations.addAll(baseTypeFile.getMethods());
            } else {
                Project project = baseTypeFile.getProject();
                GlobalSearchScope scope = (GlobalSearchScope)GoUtil.logExecTime(() -> GoPackageUtil.packageScope(baseTypeFile), 9, ms -> "GoPsiImplUtil#calcMethods: packageScope takes " + ms + " for " + GoPsiImplUtil.getPath((PsiFile)baseTypeFile));
                declarations.addAll(GoMethodIndex.find(packageName + "." + typeName, project, scope, null));
                ArrayList<GoTypeSpec> aliases = new ArrayList<GoTypeSpec>();
                aliases.addAll(GoTypeAliasIndex.findAll(typeName, project, scope));
                aliases.addAll(GoTypeAliasIndex.findAll("*" + typeName, project, scope));
                for (GoTypeSpec spec : aliases) {
                    String aliasName = spec.getName();
                    if (!StringUtil.isNotEmpty((String)aliasName)) continue;
                    declarations.addAll(GoMethodIndex.find(packageName + "." + aliasName, project, scope, null));
                }
            }
            Condition filter = methodDeclaration -> {
                GoTypeSpec methodTypeSpec = methodDeclaration.resolveTypeSpec();
                return GoPsiUtil.findBaseAliasedTypeSpec(methodTypeSpec) == baseTypeSpec;
            };
            List list = (List)GoUtil.logExecTime(() -> ContainerUtil.filter((Collection)declarations, (Condition)filter), 11, ms -> "GoPsiImplUtil#calcMethods: filter&resolve take " + ms + " for " + o.getName() + " in " + GoPsiImplUtil.getPath((PsiFile)o.getContainingFile()));
            if (list == null) {
                GoPsiImplUtil.$$$reportNull$$$0(152);
            }
            return list;
        }
        List<GoMethodDeclaration> list = Collections.emptyList();
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(153);
        }
        return list;
    }

    @Nullable
    private static String getPath(@Nullable PsiFile file) {
        VirtualFile virtualFile = file != null ? file.getVirtualFile() : null;
        return virtualFile != null ? virtualFile.getPath() : null;
    }

    @NotNull
    private static List<GoElementWithSubst<? extends GoNamedSignatureOwner>> calcAllMethodsWithSubstitutionSource(@NotNull GoTypeSpec o, @Nullable GoType typeArgumentsSource, @Nullable PsiElement context, @NotNull Set<GoType> visitedTypes) {
        GoType subsSource;
        GoTypeSpec baseTypeSpec;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(154);
        }
        if (visitedTypes == null) {
            GoPsiImplUtil.$$$reportNull$$$0(155);
        }
        if ((baseTypeSpec = GoPsiUtil.findBaseAliasedTypeSpec(o)) == null || !baseTypeSpec.isValid()) {
            List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = Collections.emptyList();
            if (list == null) {
                GoPsiImplUtil.$$$reportNull$$$0(156);
            }
            return list;
        }
        GoType underlyingType = baseTypeSpec.getSpecType().getUnderlyingType(context);
        if (visitedTypes.contains(underlyingType)) {
            List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = Collections.emptyList();
            if (list == null) {
                GoPsiImplUtil.$$$reportNull$$$0(157);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (GoMethodDeclaration method : o.getMethods()) {
            result.add(GoElementWithSubst.create(method, typeArgumentsSource));
        }
        GoType goType = subsSource = typeArgumentsSource != null ? GoTypeInstantiationKt.getInstantiatedSpecType(baseTypeSpec.getSpecType(), typeArgumentsSource) : null;
        if (underlyingType instanceof GoStructType) {
            result.addAll(GoPsiImplUtil.calcAllMethodsWithSubstitutionSource((GoStructType)underlyingType, subsSource, context, visitedTypes));
        }
        if (underlyingType instanceof GoInterfaceType) {
            result.addAll(GoPsiImplUtil.calcAllMethodsWithSubstitutionSource((GoInterfaceType)underlyingType, subsSource, context, visitedTypes));
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoPsiImplUtil.$$$reportNull$$$0(158);
        }
        return smartList;
    }

    @NotNull
    public static List<GoNamedSignatureOwner> getAllMethods(@NotNull GoStructType o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(159);
        }
        return GoPsiImplUtil.getAllMethods(o, null);
    }

    @NotNull
    public static List<GoNamedSignatureOwner> getAllMethods(@NotNull GoStructType o, @Nullable PsiElement context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(160);
        }
        if (context != null) {
            return GoPsiImplUtil.calcAllMethods(o, context, new HashSet<GoType>());
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)o, () -> GoCacheUtilKt.createResolveDependentResult(o.getProject(), GoPsiImplUtil.calcAllMethods(o, null, new HashSet<GoType>()), new Object[0]));
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(161);
        }
        return list;
    }

    @NotNull
    private static List<GoNamedSignatureOwner> calcAllMethods(@NotNull GoStructType o, @Nullable PsiElement context, @NotNull Set<GoType> visitedTypes) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(162);
        }
        if (visitedTypes == null) {
            GoPsiImplUtil.$$$reportNull$$$0(163);
        }
        List list = ContainerUtil.map(GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(o, null, context, visitedTypes), it -> (GoNamedSignatureOwner)it.getElement());
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(164);
        }
        return list;
    }

    @NotNull
    public static List<GoElementWithSubst<? extends GoNamedSignatureOwner>> calcAllMethodsWithSubstitutionSource(@NotNull GoStructType o, @Nullable GoType substitutionSource, @Nullable PsiElement context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(165);
        }
        return GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(o, substitutionSource, context, new HashSet<GoType>());
    }

    @NotNull
    private static List<GoElementWithSubst<? extends GoNamedSignatureOwner>> calcAllMethodsWithSubstitutionSource(@NotNull GoStructType o, @Nullable GoType substitutionSource, @Nullable PsiElement context, @NotNull Set<GoType> visitedTypes) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(166);
        }
        if (visitedTypes == null) {
            GoPsiImplUtil.$$$reportNull$$$0(167);
        }
        if (!visitedTypes.add(o)) {
            List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = Collections.emptyList();
            if (list == null) {
                GoPsiImplUtil.$$$reportNull$$$0(168);
            }
            return list;
        }
        SmartList result = new SmartList();
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
        GoType substSource = substitutionSource != null ? substitutionSource : o;
        for (GoAnonymousFieldDefinition anon : GoPsiImplUtil.getAnonymousFieldDefinitions(o)) {
            GoTypeReferenceExpression expression = anon.getTypeReferenceExpression();
            GoTypeSpec resolve = (GoTypeSpec)ObjectUtils.tryCast((Object)(expression != null ? expression.resolve(resolveState) : null), GoTypeSpec.class);
            if (resolve == null) continue;
            GoType embeddedType = GoPsiImplUtil.withInstantiation(anon.getType(), substSource.toInstantiated());
            GoType underlyingType = resolve.getSpecType().getUnderlyingType(context);
            if (underlyingType instanceof GoStructType && GoPsiImplUtil.unwrapInstantiation(embeddedType) instanceof GoPointerType) {
                List<GoElementWithSubst<? extends GoNamedSignatureOwner>> methodsWithSubstitutionSource = GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(resolve, embeddedType, context, visitedTypes);
                for (GoElementWithSubst<? extends GoNamedSignatureOwner> m : methodsWithSubstitutionSource) {
                    GoNamedSignatureOwner method = m.getElement();
                    GoNamedSignatureOwner wrappedMethod = method instanceof GoMethodDeclaration ? GoLightMethodDeclaration.wrap((GoMethodDeclaration)method) : method;
                    result.add(GoElementWithSubst.create(wrappedMethod, m.getSubstitutionSource()));
                }
                continue;
            }
            result.addAll(GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(resolve, embeddedType, context, visitedTypes));
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoPsiImplUtil.$$$reportNull$$$0(169);
        }
        return smartList;
    }

    @NotNull
    public static GoType getContextlessUnderlyingType(@NotNull GoType o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(170);
        }
        return GoPsiImplUtil.calcInstantiatedUnderlyingType(o, null, null);
    }

    @NotNull
    public static GoType getUnderlyingType(@NotNull GoType o, @Nullable PsiElement context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(171);
        }
        return GoPsiImplUtil.calcInstantiatedUnderlyingType(o, null, context);
    }

    @NotNull
    public static GoType getUnderlyingType(@NotNull GoType o, @Nullable ResolveState state) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(172);
        }
        return GoPsiImplUtil.calcInstantiatedUnderlyingType(o, state, null);
    }

    @NotNull
    private static GoType calcInstantiatedUnderlyingType(@NotNull GoType o, @Nullable ResolveState state, @Nullable PsiElement context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(173);
        }
        GoType goType = GoTypeInstantiationKt.getInstantiatedUnderlyingType(GoPsiImplUtil.calcUnderlyingTypeRecursionSafe(o, state, context), o);
        if (goType == null) {
            GoPsiImplUtil.$$$reportNull$$$0(174);
        }
        return goType;
    }

    @NotNull
    private static GoType calcUnderlyingTypeRecursionSafe(@NotNull GoType o, @Nullable ResolveState state, @Nullable PsiElement context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(175);
        }
        GoType type = (GoType)underlyingTypeGuard.doPreventingRecursion((Object)o, true, () -> GoPsiImplUtil.calcUnderlyingType(o, state, context));
        GoType goType = (GoType)ObjectUtils.notNull((Object)type, (Object)o);
        if (goType == null) {
            GoPsiImplUtil.$$$reportNull$$$0(176);
        }
        return goType;
    }

    @NotNull
    private static GoType calcUnderlyingType(@NotNull GoType o, @Nullable ResolveState state, @Nullable PsiElement context) {
        PsiElement resolve;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(177);
        }
        if (o instanceof GoArrayOrSliceType || o instanceof GoStructType || o instanceof GoPointerType || o instanceof GoFunctionType || o instanceof GoInterfaceType || o instanceof GoMapType || o instanceof GoChannelType) {
            GoType goType = o;
            if (goType == null) {
                GoPsiImplUtil.$$$reportNull$$$0(178);
            }
            return goType;
        }
        if (o instanceof GoParType) {
            return GoPsiImplUtil.calcUnderlyingTypeRecursionSafe(((GoParType)o).getType(), state, context);
        }
        if (o instanceof GoSpecType) {
            GoType type;
            if (GoPsiImplUtil.builtin(o)) {
                GoTypeSpec typeSpec = (GoTypeSpec)Objects.requireNonNull(PsiTreeUtil.getStubOrPsiParent((PsiElement)o));
                String name = typeSpec.getName();
                if (name != null && GoTypeUtil.DOC_ONLY_TYPES.contains(name)) {
                    GoType goType = o;
                    if (goType == null) {
                        GoPsiImplUtil.$$$reportNull$$$0(179);
                    }
                    return goType;
                }
                if (!typeSpec.isTypeAlias()) {
                    GoType type2 = ((GoSpecType)o).getType();
                    GoType goType = type2 != null ? type2 : o;
                    if (goType == null) {
                        GoPsiImplUtil.$$$reportNull$$$0(180);
                    }
                    return goType;
                }
            }
            if ((type = ((GoSpecType)o).getType()) == null) {
                GoType goType = o;
                if (goType == null) {
                    GoPsiImplUtil.$$$reportNull$$$0(181);
                }
                return goType;
            }
            return GoPsiImplUtil.calcInstantiatedUnderlyingType(type, state, context);
        }
        if (o instanceof GoTypeParameter) {
            GoType constraintType = ((GoTypeParameter)o).getConstraintType();
            GoType goType = constraintType != null ? GoPsiImplUtil.calcInstantiatedUnderlyingType(constraintType, state, context) : o;
            if (goType == null) {
                GoPsiImplUtil.$$$reportNull$$$0(182);
            }
            return goType;
        }
        PsiElement psiElement = resolve = state != null ? o.resolve(state) : o.resolve(context);
        if (resolve instanceof GoTypeParamDefinition) {
            return GoPsiImplUtil.calcUnderlyingTypeRecursionSafe(((GoTypeParamDefinition)resolve).getTypeParameter(), state, context);
        }
        if (resolve instanceof GoTypeSpec) {
            GoTypeSpec typeSpec = (GoTypeSpec)resolve;
            GoSpecType specType = typeSpec.getSpecType();
            GoType underlying = GoPsiImplUtil.calcUnderlyingTypeRecursionSafe(specType, state, context);
            GoType instantiatedSpecType = GoTypeInstantiationKt.getInstantiatedSpecType(specType, o, (PsiElement)(context != null ? context : specType));
            GoType goType = underlying.withInstantiation(instantiatedSpecType.toInstantiated());
            if (goType == null) {
                GoPsiImplUtil.$$$reportNull$$$0(183);
            }
            return goType;
        }
        if (resolve instanceof GoTypeReferenceExpression) {
            GoCType cType = new GoCType((GoCompositeElement)resolve);
            return GoPsiImplUtil.calcUnderlyingTypeRecursionSafe(cType, state, context);
        }
        GoTypeParamDefinition receiverTypeParam = GoPsiImplUtil.getReceiverTypeParam(o, state, context);
        if (receiverTypeParam != null) {
            return GoPsiImplUtil.calcUnderlyingTypeRecursionSafe(receiverTypeParam.getTypeParameter(), state, context);
        }
        GoType goType = o;
        if (goType == null) {
            GoPsiImplUtil.$$$reportNull$$$0(184);
        }
        return goType;
    }

    @Nullable
    public static GoTypeParamDefinition getReceiverTypeParam(@NotNull GoType type, @Nullable ResolveState state, @Nullable PsiElement context) {
        GoTypeParameters receiverTypeParams;
        List<GoTypeParamDefinition> definitions;
        PsiElement resolvedReceiver;
        int receiverTypeArgIndex;
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(185);
        }
        if ((receiverTypeArgIndex = GoPsiImplUtil.getReceiverTypeArgIndex(type)) == -1) {
            return null;
        }
        GoReceiver receiver = (GoReceiver)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)type, GoReceiver.class);
        GoType receiverType = GoTypeUtil.unwrapPointerAndParTypes(receiver != null ? receiver.getType() : null);
        if (receiverType == null) {
            return null;
        }
        PsiElement psiElement = resolvedReceiver = state != null ? receiverType.resolve(state) : receiverType.resolve(context);
        if (resolvedReceiver instanceof GoTypeSpec && receiverTypeArgIndex < (definitions = GoPsiImplUtil.getTypeParamDefinitions(receiverTypeParams = ((GoTypeSpec)resolvedReceiver).getSpecType().getTypeParameters())).size()) {
            return definitions.get(receiverTypeArgIndex);
        }
        return null;
    }

    private static int getReceiverTypeArgIndex(@NotNull GoType type) {
        GoTypeParamDefinition typeParamDef;
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(186);
        }
        if ((typeParamDef = (GoTypeParamDefinition)PsiTreeUtil.getStubChildOfType((PsiElement)type, GoTypeParamDefinition.class)) != null) {
            PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)type);
            if (parent instanceof GoTypeArguments) {
                return 0;
            }
            if (parent instanceof GoTypeList) {
                return ((GoTypeList)parent).getTypeList().indexOf(type);
            }
        }
        return -1;
    }

    @NotNull
    public static GoType getGoTypeInner(@NotNull GoSignatureOwner o, @Nullable ResolveState context) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(187);
        }
        if (o instanceof GoFunctionType) {
            GoFunctionType goFunctionType = (GoFunctionType)o;
            if (goFunctionType == null) {
                GoPsiImplUtil.$$$reportNull$$$0(188);
            }
            return goFunctionType;
        }
        PsiElement contextElement = GoPsiImplUtil.getContextElement(context);
        if (contextElement instanceof GoReferenceExpression) {
            return new GoLightType.LightFunctionType(o, GoPsiImplUtil.getMethodExpressionQualifierTypeName((GoReferenceExpression)contextElement, context));
        }
        GoType type = o instanceof GoMethodDeclaration ? ((GoMethodDeclaration)o).getReceiverType() : null;
        return new GoLightType.LightFunctionType(o, type != null ? type.getText() : "");
    }

    @NotNull
    public static GoImportSpec addImport(@NotNull GoImportList importList, @NotNull String packagePath, @Nullable String alias) {
        PsiFile file;
        GoImportsSorter.NewImportInfo importInfo;
        if (importList == null) {
            GoPsiImplUtil.$$$reportNull$$$0(189);
        }
        if (packagePath == null) {
            GoPsiImplUtil.$$$reportNull$$$0(190);
        }
        GoImportsSorter.NewImportInfo newImportInfo = importInfo = (file = importList.getContainingFile()) instanceof GoFile ? GoImportsSorter.forFile((GoFile)file).findBeforeAnchorForNewImport(packagePath) : null;
        if (importInfo != null) {
            GoImportSpec result = importInfo.declaration.addImportSpec(packagePath, alias, importInfo.anchor);
            if (importInfo.newGroup) {
                PsiElement doubleWhiteSpace = GoElementFactory.createNewLine(file.getProject(), 2);
                GoImportDeclaration newDeclaration = (GoImportDeclaration)ObjectUtils.tryCast((Object)result.getParent(), GoImportDeclaration.class);
                if (newDeclaration != null) {
                    newDeclaration.addAfter(doubleWhiteSpace, result);
                    newDeclaration.addBefore(doubleWhiteSpace, result);
                }
            }
            GoImportSpec goImportSpec = result;
            if (goImportSpec == null) {
                GoPsiImplUtil.$$$reportNull$$$0(191);
            }
            return goImportSpec;
        }
        Project project = importList.getProject();
        List<GoImportDeclaration> existingImports = importList.getImportDeclarationList();
        ListIterator<GoImportDeclaration> iterator = existingImports.listIterator(existingImports.size());
        while (iterator.hasPrevious()) {
            GoImportDeclaration existingImport = iterator.previous();
            List<GoImportSpec> importSpecList = existingImport.getImportSpecList();
            if (importSpecList.isEmpty() && (existingImport.getRparen() == null || existingImport.getLparen() == null) || !importSpecList.isEmpty() && existingImport.getRparen() == null && importSpecList.get(0).isCImport()) continue;
            GoImportSpec goImportSpec = existingImport.addImportSpec(packagePath, alias, null);
            if (goImportSpec == null) {
                GoPsiImplUtil.$$$reportNull$$$0(192);
            }
            return goImportSpec;
        }
        boolean withParens = ((GoCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(GoCodeStyleSettings.class)).ADD_PARENTHESES_FOR_SINGLE_IMPORT;
        return GoPsiImplUtil.addImportDeclaration(importList, GoElementFactory.createImportDeclaration(file, packagePath, alias, withParens));
    }

    @NotNull
    private static GoImportSpec addImportDeclaration(@NotNull GoImportList importList, @NotNull GoImportDeclaration newImportDeclaration) {
        if (importList == null) {
            GoPsiImplUtil.$$$reportNull$$$0(193);
        }
        if (newImportDeclaration == null) {
            GoPsiImplUtil.$$$reportNull$$$0(194);
        }
        GoImportDeclaration importDeclaration = GoPsiImplUtil.addDeclarationBeforeOrAfter(importList, newImportDeclaration);
        PsiElement importListNextSibling = importList.getNextSibling();
        if (!(importListNextSibling instanceof PsiWhiteSpace)) {
            importList.addAfter(GoElementFactory.createNewLine(importList.getProject(), importListNextSibling != null ? 2 : 1), importDeclaration);
        }
        importList.addBefore(GoElementFactory.createNewLine(importList.getProject()), importDeclaration);
        GoImportSpec result = (GoImportSpec)ContainerUtil.getFirstItem(importDeclaration.getImportSpecList());
        if (result == null) {
            throw new AssertionError((Object)("Cannot add new import declaration. Import: " + newImportDeclaration.getText() + "; List: " + importList.getText()));
        }
        GoImportSpec goImportSpec = result;
        if (goImportSpec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(195);
        }
        return goImportSpec;
    }

    private static GoImportDeclaration addDeclarationBeforeOrAfter(@NotNull GoImportList importList, @NotNull GoImportDeclaration newImportDeclaration) {
        GoImportDeclaration lastImport;
        if (importList == null) {
            GoPsiImplUtil.$$$reportNull$$$0(196);
        }
        if (newImportDeclaration == null) {
            GoPsiImplUtil.$$$reportNull$$$0(197);
        }
        if ((lastImport = (GoImportDeclaration)ContainerUtil.getLastItem(importList.getImportDeclarationList())) != null && lastImport.getLparen() != null && lastImport.getRparen() == null) {
            return (GoImportDeclaration)importList.addBefore(newImportDeclaration, lastImport);
        }
        return (GoImportDeclaration)importList.addAfter(newImportDeclaration, lastImport);
    }

    @NotNull
    public static GoImportSpec addImportSpec(@NotNull GoImportDeclaration declaration, @NotNull String packagePath, @Nullable String alias, @Nullable PsiElement beforeAnchor) {
        if (declaration == null) {
            GoPsiImplUtil.$$$reportNull$$$0(198);
        }
        if (packagePath == null) {
            GoPsiImplUtil.$$$reportNull$$$0(199);
        }
        LOG.assertTrue(beforeAnchor == null || beforeAnchor.getParent() == declaration, (Object)"beforeAnchor.getParent() != declaration");
        PsiElement rParen = declaration.getRparen();
        if (rParen == null) {
            List<GoImportSpec> importSpecList = declaration.getImportSpecList();
            GoImportDeclaration newDeclaration = GoElementFactory.createImportDeclaration(declaration.getProject(), "(\n\n)");
            int importSpecAnchorIndex = -1;
            for (int i = 0; i < importSpecList.size(); ++i) {
                GoImportSpec spec = importSpecList.get(i);
                newDeclaration.addImportSpec(spec.getPath(), spec.getAlias(), null);
                if (spec != beforeAnchor) continue;
                importSpecAnchorIndex = i;
            }
            LOG.assertTrue((declaration = (GoImportDeclaration)declaration.replace(newDeclaration)).getRparen() != null);
            PsiElement replacedBeforeAnchor = importSpecAnchorIndex > -1 ? (PsiElement)ContainerUtil.getOrElse(declaration.getImportSpecList(), (int)importSpecAnchorIndex, null) : null;
            GoImportSpec goImportSpec = declaration.addImportSpec(packagePath, alias, replacedBeforeAnchor);
            if (goImportSpec == null) {
                GoPsiImplUtil.$$$reportNull$$$0(200);
            }
            return goImportSpec;
        }
        PsiElement anchor = (PsiElement)ObjectUtils.notNull((Object)(beforeAnchor instanceof PsiErrorElement ? null : beforeAnchor), (Object)rParen);
        GoImportSpec newImportSpec = GoElementFactory.createImportSpec(declaration.getContainingFile(), packagePath, alias);
        GoImportSpec result = (GoImportSpec)declaration.addBefore(newImportSpec, anchor);
        declaration.addAfter(GoElementFactory.createNewLine(declaration.getProject()), result);
        GoImportSpec goImportSpec = result;
        if (goImportSpec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(201);
        }
        return goImportSpec;
    }

    public static String sanitizePackageName(@NotNull String importPath) {
        if (importPath == null) {
            GoPsiImplUtil.$$$reportNull$$$0(202);
        }
        String fileName = !StringUtil.endsWithChar((CharSequence)importPath, (char)'/') && !StringUtil.endsWithChar((CharSequence)importPath, (char)'\\') ? PathUtil.getFileName((String)importPath) : "";
        StringBuilder name = null;
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (!(Character.isLetter(c) || c == '_' || i != 0 && Character.isDigit(c))) {
                if (name == null) {
                    name = new StringBuilder(fileName.length());
                    name.append(fileName, 0, i);
                }
                name.append('_');
                continue;
            }
            if (name == null) continue;
            name.append(c);
        }
        String result = name == null ? fileName : name.toString();
        return GoNamesValidator.INSTANCE.isKeyword(result, null) ? "_" + result : result;
    }

    public static boolean isCImport(@NotNull GoImportSpec importSpec) {
        if (importSpec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(203);
        }
        return "C".equals(importSpec.getPath());
    }

    public static boolean isDot(@NotNull GoImportSpec importSpec) {
        GoImportSpecStub stub;
        if (importSpec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(204);
        }
        return (stub = (GoImportSpecStub)importSpec.getStub()) != null ? stub.isDot() : importSpec.getDot() != null;
    }

    @NotNull
    public static String getPath(@NotNull GoImportSpec importSpec) {
        GoImportSpecStub stub;
        if (importSpec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(205);
        }
        String string = (stub = (GoImportSpecStub)importSpec.getStub()) != null ? stub.getPath() : importSpec.getStringLiteral().getDecodedText();
        if (string == null) {
            GoPsiImplUtil.$$$reportNull$$$0(206);
        }
        return string;
    }

    @Nullable
    public static String getName(@NotNull GoImportSpec importSpec) {
        if (importSpec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(207);
        }
        return importSpec.getAlias();
    }

    @Nullable
    public static String getAlias(@NotNull GoImportSpec importSpec) {
        GoImportSpecStub stub;
        if (importSpec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(208);
        }
        if ((stub = (GoImportSpecStub)importSpec.getStub()) != null) {
            return stub.getAlias();
        }
        PsiElement identifier = importSpec.getIdentifier();
        if (identifier != null) {
            return identifier.getText();
        }
        return importSpec.isDot() ? "." : null;
    }

    @NotNull
    public static Set<String> getImportQualifiersToUseInFile(@Nullable GoImportSpec importSpec) {
        return GoPsiImplUtil.getImportQualifiersToUseInFile(importSpec, null);
    }

    @NotNull
    public static Set<String> getImportQualifiersToUseInFile(@Nullable GoImportSpec importSpec, @Nullable PsiElement context) {
        if (importSpec == null || importSpec.isForSideEffects()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GoPsiImplUtil.$$$reportNull$$$0(209);
            }
            return set;
        }
        if (importSpec.isDot()) {
            Set<String> set = Collections.singleton("");
            if (set == null) {
                GoPsiImplUtil.$$$reportNull$$$0(210);
            }
            return set;
        }
        String alias = importSpec.getAlias();
        if (alias != null) {
            Set<String> set = Collections.singleton(alias);
            if (set == null) {
                GoPsiImplUtil.$$$reportNull$$$0(211);
            }
            return set;
        }
        return GoPsiImplUtil.getImportQualifiersToUseInFile(importSpec.resolve(GoPsiImplUtil.createContextOnElement(context)), importSpec.getPath());
    }

    @NotNull
    public static Set<String> getImportQualifiersToUseInFile(@NotNull Collection<GoPackage> resolvedPackages, @NotNull String importPath) {
        if (resolvedPackages == null) {
            GoPsiImplUtil.$$$reportNull$$$0(212);
        }
        if (importPath == null) {
            GoPsiImplUtil.$$$reportNull$$$0(213);
        }
        Set set = resolvedPackages.isEmpty() ? Collections.singleton(GoPsiImplUtil.sanitizePackageName(importPath)) : ContainerUtil.map2Set(resolvedPackages, GoPackage::getName);
        if (set == null) {
            GoPsiImplUtil.$$$reportNull$$$0(214);
        }
        return set;
    }

    public static boolean shouldGoDeeper(GoTypeSpec o) {
        return false;
    }

    public static boolean shouldGoDeeper(@NotNull GoType o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(215);
        }
        return o instanceof GoInterfaceType || o instanceof GoStructType;
    }

    public static boolean isForSideEffects(@NotNull GoImportSpec o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(216);
        }
        return "_".equals(o.getAlias());
    }

    public static boolean isValidHost(@NotNull GoStringLiteral o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(217);
        }
        return !(o.getParent() instanceof GoImportSpec);
    }

    @NotNull
    public static GoStringLiteralImpl updateText(@NotNull GoStringLiteral o, @NotNull String text) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(218);
        }
        if (text == null) {
            GoPsiImplUtil.$$$reportNull$$$0(219);
        }
        ASTNode valueNode = o.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        GoStringLiteralImpl goStringLiteralImpl = (GoStringLiteralImpl)o;
        if (goStringLiteralImpl == null) {
            GoPsiImplUtil.$$$reportNull$$$0(220);
        }
        return goStringLiteralImpl;
    }

    @NotNull
    public static GoStringLiteralEscaper createLiteralTextEscaper(@NotNull GoStringLiteral o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(221);
        }
        return new GoStringLiteralEscaper(o);
    }

    public static boolean prevDot(@Nullable PsiElement e) {
        PsiElement prev;
        PsiElement psiElement = prev = e != null ? GoPsiImplUtil.prevVisibleLeaf(e) : null;
        if (!(prev instanceof LeafElement)) {
            return false;
        }
        IElementType type = ((LeafElement)prev).getElementType();
        if (type == GoTypes.DOT) {
            return true;
        }
        if (type == GoTypes.FLOAT) {
            String text = prev.getText();
            return text != null && text.endsWith(".");
        }
        return false;
    }

    @Nullable
    private static PsiElement prevVisibleLeaf(@NotNull PsiElement element) {
        if (element == null) {
            GoPsiImplUtil.$$$reportNull$$$0(222);
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true);
        while (prevLeaf != null && StringUtil.isEmptyOrSpaces((String)prevLeaf.getText()) && prevLeaf.getText().indexOf(10) < 0) {
            prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)prevLeaf, (boolean)true);
        }
        return prevLeaf;
    }

    @Nullable
    public static GoSignatureOwner resolveCall(@Nullable GoExpression call) {
        PsiElement resolve = GoPsiImplUtil.resolveCallRaw(call);
        return resolve instanceof GoSignatureOwner ? (GoSignatureOwner)resolve : (resolve instanceof GoTypeOwner ? (GoSignatureOwner)ObjectUtils.tryCast((Object)((GoTypeOwner)resolve).getGoType(null), GoSignatureOwner.class) : null);
    }

    @Nullable
    private static PsiElement resolveCallRaw(@Nullable GoExpression call) {
        if (!(call instanceof GoCallExpr)) {
            return null;
        }
        GoExpression e = GoPsiImplUtil.unwrapParentheses(((GoCallExpr)call).getExpression());
        if (e == null) {
            return null;
        }
        if (e instanceof GoCallExpr) {
            GoSignatureOwner resolve = GoPsiImplUtil.resolveCall(e);
            if (resolve != null) {
                GoResult result = resolve.getResult();
                return result != null ? result.getType() : null;
            }
            return null;
        }
        if (e instanceof GoFunctionLit) {
            return e;
        }
        GoReferenceExpression r = e instanceof GoReferenceExpression ? (GoReferenceExpression)e : (GoReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)e, GoReferenceExpression.class);
        PsiReference reference = (r != null ? r : e).getReference();
        return reference != null ? reference.resolve() : null;
    }

    public static boolean isUnaryBitAndExpressionOperand(@Nullable PsiElement e) {
        PsiElement parent = e != null ? e.getParent() : null;
        return parent instanceof GoUnaryExpr && ((GoUnaryExpr)parent).getBitAnd() != null;
    }

    @Nullable
    public static Value getValue(@NotNull GoVarOrConstDefinition o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(223);
        }
        return GoExpressionEvaluator.evaluateDefinition(o);
    }

    @Nullable
    public static GoTypeSpec getTypeSpec(@NotNull GoSpecType specType) {
        GoTypeStub stub;
        if (specType == null) {
            GoPsiImplUtil.$$$reportNull$$$0(224);
        }
        PsiElement parent = (stub = (GoTypeStub)specType.getStub()) == null ? specType.getParent() : stub.getParentStub().getPsi();
        return (GoTypeSpec)ObjectUtils.tryCast((Object)parent, GoTypeSpec.class);
    }

    public static boolean canBeAutoImported(@NotNull GoFile file, boolean allowMain, @Nullable Module module, boolean withVendoring) {
        if (file == null) {
            GoPsiImplUtil.$$$reportNull$$$0(225);
        }
        if (GoPsiImplUtil.isBuiltinFile((PsiFile)file)) {
            return false;
        }
        if (!allowMain && (StringUtil.equals((CharSequence)file.getPackageName(), (CharSequence)"main") || StringUtil.equals((CharSequence)file.getImportPath(withVendoring), (CharSequence)"main"))) {
            return false;
        }
        return GoPsiImplUtil.allowed((PsiFile)file, null, module) && !GoUtil.isExcludedFile(file);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getNonStrictTopmostParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            GoPsiImplUtil.$$$reportNull$$$0(226);
        }
        PsiElement first = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{aClass});
        PsiElement topMost = PsiTreeUtil.getTopmostParentOfType((PsiElement)first, aClass);
        return (T)((PsiElement)ObjectUtils.chooseNotNull((Object)topMost, (Object)first));
    }

    @Nullable
    public static GoExpression getExpression(@NotNull GoIndexOrSliceExpr slice) {
        if (slice == null) {
            GoPsiImplUtil.$$$reportNull$$$0(227);
        }
        return (GoExpression)ContainerUtil.getFirstItem(GoPsiImplUtil.getExpressionsBefore(slice.getExpressionList(), slice.getLbrack()));
    }

    @NotNull
    public static List<GoExpression> getLeftExpressionsList(@NotNull GoRangeClause rangeClause) {
        if (rangeClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(228);
        }
        return GoPsiImplUtil.getExpressionsBefore(rangeClause.getExpressionList(), rangeClause.getRange());
    }

    @NotNull
    public static List<GoExpression> getLeftExpressionsList(@NotNull GoRecvStatement recvStatement) {
        if (recvStatement == null) {
            GoPsiImplUtil.$$$reportNull$$$0(229);
        }
        return GoPsiImplUtil.getExpressionsBefore(recvStatement.getExpressionList(), (PsiElement)ObjectUtils.chooseNotNull((Object)recvStatement.getAssign(), (Object)recvStatement.getVarAssign()));
    }

    @NotNull
    public static Trinity<GoExpression, GoExpression, GoExpression> getIndices(@NotNull GoIndexOrSliceExpr slice) {
        if (slice == null) {
            GoPsiImplUtil.$$$reportNull$$$0(230);
        }
        GoExpression end = null;
        GoExpression max = null;
        ASTNode[] colons = slice.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{GoTypes.COLON}));
        List<GoExpression> exprList = slice.getExpressionList();
        GoExpression start = (GoExpression)ContainerUtil.getFirstItem(GoPsiImplUtil.getExpressionsInRange(exprList, slice.getLbrack(), colons.length > 0 ? colons[0].getPsi() : null));
        if (colons.length == 1) {
            end = (GoExpression)ContainerUtil.getFirstItem(GoPsiImplUtil.getExpressionsInRange(exprList, colons[0].getPsi(), slice.getRbrack()));
        }
        if (colons.length == 2) {
            end = (GoExpression)ContainerUtil.getFirstItem(GoPsiImplUtil.getExpressionsInRange(exprList, colons[0].getPsi(), colons[1].getPsi()));
            max = (GoExpression)ContainerUtil.getFirstItem(GoPsiImplUtil.getExpressionsInRange(exprList, colons[1].getPsi(), slice.getRbrack()));
        }
        Trinity trinity = Trinity.create((Object)start, end, max);
        if (trinity == null) {
            GoPsiImplUtil.$$$reportNull$$$0(231);
        }
        return trinity;
    }

    public static boolean isIndexExpression(@NotNull GoIndexOrSliceExpr indexOrSliceExpression) {
        if (indexOrSliceExpression == null) {
            GoPsiImplUtil.$$$reportNull$$$0(232);
        }
        return indexOrSliceExpression.getNode().findChildByType(GoTypes.COLON) == null;
    }

    @NotNull
    public static List<GoExpression> getRightExpressionsList(@NotNull GoRangeClause rangeClause) {
        if (rangeClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(233);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)rangeClause.getRangeExpression());
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(234);
        }
        return list;
    }

    @NotNull
    public static List<GoExpression> getRightExpressionsList(@NotNull GoRecvStatement recvStatement) {
        if (recvStatement == null) {
            GoPsiImplUtil.$$$reportNull$$$0(235);
        }
        GoExpression expression = GoPsiImplUtil.getLastExpressionAfter(recvStatement.getExpressionList(), (PsiElement)ObjectUtils.chooseNotNull((Object)recvStatement.getAssign(), (Object)recvStatement.getVarAssign()));
        List list = ContainerUtil.createMaybeSingletonList((Object)expression);
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(236);
        }
        return list;
    }

    @Nullable
    public static GoExpression getRangeExpression(@NotNull GoRangeClause rangeClause) {
        if (rangeClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(237);
        }
        return GoPsiImplUtil.getLastExpressionAfter(rangeClause.getExpressionList(), rangeClause.getRange());
    }

    @Nullable
    public static GoExpression getRecvExpression(@NotNull GoRecvStatement recvStatement) {
        if (recvStatement == null) {
            GoPsiImplUtil.$$$reportNull$$$0(238);
        }
        return (GoExpression)ContainerUtil.getLastItem(recvStatement.getExpressionList());
    }

    @NotNull
    public static ChannelDirection getDirection(@NotNull GoChannelType o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(239);
        }
        ChannelDirection channelDirection = (ChannelDirection)((Object)CachedValuesManager.getCachedValue((PsiElement)o, () -> CachedValueProvider.Result.create((Object)((Object)GoPsiImplUtil.getDirectionInner(o)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT})));
        if (channelDirection == null) {
            GoPsiImplUtil.$$$reportNull$$$0(240);
        }
        return channelDirection;
    }

    @NotNull
    private static ChannelDirection getDirectionInner(@NotNull GoChannelType o) {
        GoTypeStub stub;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(241);
        }
        if ((stub = (GoTypeStub)o.getStub()) != null) {
            String text = o.getText();
            GoChannelType type = (GoChannelType)ObjectUtils.tryCast((Object)GoElementFactory.createTypeCheap(o.getProject(), text), GoChannelType.class);
            if (type != null) {
                return GoPsiImplUtil.getDirectionByPsi(type);
            }
        }
        return GoPsiImplUtil.getDirectionByPsi(o);
    }

    @NotNull
    private static ChannelDirection getDirectionByPsi(@NotNull GoChannelType o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(242);
        }
        PsiElement send = o.getArrow();
        PsiElement chan = o.getChan();
        if (send == null || chan == null) {
            ChannelDirection channelDirection = ChannelDirection.BIDIRECTIONAL;
            if (channelDirection == null) {
                GoPsiImplUtil.$$$reportNull$$$0(243);
            }
            return channelDirection;
        }
        ChannelDirection channelDirection = send.getStartOffsetInParent() < chan.getStartOffsetInParent() ? ChannelDirection.RECEIVE : ChannelDirection.SEND;
        if (channelDirection == null) {
            GoPsiImplUtil.$$$reportNull$$$0(244);
        }
        return channelDirection;
    }

    @Nullable
    private static GoExpression getLastExpressionAfter(@NotNull List<GoExpression> list, @Nullable PsiElement anchor) {
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(245);
        }
        if (anchor == null) {
            return null;
        }
        GoExpression last = (GoExpression)ContainerUtil.getLastItem(list);
        return last != null && last.getTextRange().getStartOffset() >= anchor.getTextRange().getEndOffset() ? last : null;
    }

    @NotNull
    private static List<GoExpression> getExpressionsInRange(@NotNull List<GoExpression> list, @Nullable PsiElement start, @Nullable PsiElement end) {
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(246);
        }
        if (start == null && end == null) {
            List<GoExpression> list2 = list;
            if (list2 == null) {
                GoPsiImplUtil.$$$reportNull$$$0(247);
            }
            return list2;
        }
        List list3 = ContainerUtil.filter(list, expression -> !(end != null && expression.getTextRange().getEndOffset() > end.getTextRange().getStartOffset() || start != null && expression.getTextRange().getStartOffset() < start.getTextRange().getEndOffset()));
        if (list3 == null) {
            GoPsiImplUtil.$$$reportNull$$$0(248);
        }
        return list3;
    }

    @NotNull
    private static List<GoExpression> getExpressionsBefore(@NotNull List<GoExpression> list, @Nullable PsiElement anchor) {
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(249);
        }
        return GoPsiImplUtil.getExpressionsInRange(list, null, anchor);
    }

    public static int getLength(@NotNull GoArrayOrSliceType o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(250);
        }
        return (Integer)CachedValuesManager.getCachedValue((PsiElement)o, () -> GoCacheUtilKt.createResolveDependentResult(o.getProject(), GoPsiImplUtil.getLengthInner(o), new Object[0]));
    }

    @Nullable
    public static Value getValue(@NotNull GoKey o) {
        GoExpression expression;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(251);
        }
        if ((expression = o.getExpression()) != null) {
            return expression.getValue();
        }
        GoFieldName fieldName = o.getFieldName();
        PsiElement resolve = fieldName != null ? fieldName.resolve() : null;
        return resolve instanceof GoConstDefinition ? ((GoConstDefinition)resolve).getValue() : null;
    }

    private static int getLengthInner(@NotNull GoArrayOrSliceType o) {
        String text;
        GoArrayOrSliceType type;
        GoTypeStub stub;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(252);
        }
        if ((stub = (GoTypeStub)o.getStub()) != null && (type = (GoArrayOrSliceType)ObjectUtils.tryCast((text = stub.getText()) == null ? null : GoElementFactory.createTypeCheap(o.getProject(), text, o), GoArrayOrSliceType.class)) != null) {
            return GoPsiImplUtil.calcLength(type);
        }
        return GoPsiImplUtil.calcLength(o);
    }

    private static int calcLength(@NotNull GoArrayOrSliceType o) {
        PsiElement tripleDot;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(253);
        }
        if ((tripleDot = o.getTripleDot()) == null && o.getExpression() == null) {
            return -1;
        }
        if (tripleDot != null) {
            GoLiteralValue literal;
            GoCompositeLit compositeLit = (GoCompositeLit)ObjectUtils.tryCast((Object)o.getParent(), GoCompositeLit.class);
            GoLiteralValue goLiteralValue = literal = compositeLit != null ? compositeLit.getLiteralValue() : null;
            if (literal == null) {
                return -2;
            }
            int maxIndex = 0;
            int index = 0;
            for (GoElement e : literal.getElementList()) {
                Long integer;
                GoKey key = e.getKey();
                Value value = key != null ? key.getValue() : null;
                Long l = integer = value != null ? value.getInteger() : null;
                if (integer != null) {
                    index = integer.intValue();
                }
                maxIndex = Math.max(maxIndex, ++index);
            }
            return maxIndex;
        }
        GoExpression expr = o.getExpression();
        Value value = expr != null ? expr.getValue() : null;
        Long length = value != null ? value.getInteger() : null;
        return length != null ? length.intValue() : -2;
    }

    public static boolean isArray(@NotNull GoArrayOrSliceType o) {
        GoTypeStub stub;
        String stubText;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(254);
        }
        String string = stubText = (stub = (GoTypeStub)o.getStub()) != null ? stub.getText() : null;
        if (stubText != null && stubText.startsWith("[]")) {
            return false;
        }
        return o.getExpression() != null || o.getTripleDot() != null;
    }

    public static boolean isTypeAlias(@NotNull GoTypeSpec o) {
        GoTypeSpecStub stub;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(255);
        }
        return (stub = (GoTypeSpecStub)o.getStub()) != null ? stub.isTypeAlias() : o.getSpecType().getAssign() != null;
    }

    public static Set<String> getReceiversNames(@Nullable GoTypeSpec typeSpec, boolean ignoreGenerated) {
        if (typeSpec == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> namesSet = new LinkedHashSet<String>();
        for (GoMethodDeclaration method : typeSpec.getMethods()) {
            String name;
            if (ignoreGenerated && method.getContainingFile().isGenerated() || (name = GoPsiImplUtil.getReceiverName(method)) == null || "_".equals(name)) continue;
            namesSet.add(name);
        }
        return namesSet;
    }

    public static boolean isEmbeddedByPointer(@NotNull GoMethodDeclaration o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(256);
        }
        return false;
    }

    @Nullable
    private static String getReceiverName(@NotNull GoMethodDeclaration method) {
        GoReceiver receiver;
        if (method == null) {
            GoPsiImplUtil.$$$reportNull$$$0(257);
        }
        return (receiver = method.getReceiver()) != null ? receiver.getName() : null;
    }

    @Contract(value="null -> false")
    public static boolean isFieldDefinition(@Nullable PsiElement e) {
        return e instanceof GoAnonymousFieldDefinition || e instanceof GoFieldDefinition;
    }

    @NotNull
    public static Icon getTypeSpecIcon(@NotNull GoTypeSpec typeSpec) {
        if (typeSpec == null) {
            GoPsiImplUtil.$$$reportNull$$$0(258);
        }
        Icon icon = GoTypeUtil.isInterface(typeSpec) ? GoIcons.INTERFACE : GoIcons.TYPE;
        if (icon == null) {
            GoPsiImplUtil.$$$reportNull$$$0(259);
        }
        return icon;
    }

    @Nullable
    @Contract(value="null -> null", pure=true)
    public static GoExpression unwrapParentheses(@Nullable GoExpression o) {
        while (o instanceof GoParenthesesExpr) {
            o = ((GoParenthesesExpr)o).getExpression();
        }
        return o;
    }

    @Contract(value="null -> false")
    public static boolean isIota(@Nullable PsiElement e) {
        return e instanceof GoReferenceExpression && e.textMatches((CharSequence)"iota") && GoPsiImplUtil.builtin(((GoReferenceExpression)e).resolve());
    }

    @NotNull
    public static String getDecodedText(@NotNull GoStringLiteral o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(260);
        }
        StringBuilder builder = new StringBuilder();
        TextRange range = ElementManipulators.getManipulator((PsiElement)o).getRangeInElement((PsiElement)o);
        o.createLiteralTextEscaper().decode(range, builder);
        String string = builder.toString();
        if (string == null) {
            GoPsiImplUtil.$$$reportNull$$$0(261);
        }
        return string;
    }

    @Nullable
    public static PsiElement getOperator(@NotNull GoUnaryExpr o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(262);
        }
        return GoPsiImplUtil.getNotNullElement(o.getNot(), o.getMinus(), o.getPlus(), o.getBitAnd(), o.getBitXor(), o.getMul(), o.getArrow());
    }

    @Nullable
    public static PsiElement getOperator(@NotNull GoBinaryExpr o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(263);
        }
        if (o instanceof GoAndExpr) {
            return ((GoAndExpr)o).getCondAnd();
        }
        if (o instanceof GoOrExpr) {
            return ((GoOrExpr)o).getCondOr();
        }
        if (o instanceof GoMulExpr) {
            GoMulExpr m = (GoMulExpr)o;
            return GoPsiImplUtil.getNotNullElement(m.getMul(), m.getQuotient(), m.getRemainder(), m.getShiftRight(), m.getShiftLeft(), m.getBitAnd(), m.getBitClear());
        }
        if (o instanceof GoAddExpr) {
            GoAddExpr a = (GoAddExpr)o;
            return GoPsiImplUtil.getNotNullElement(a.getBitXor(), a.getBitOr(), a.getMinus(), a.getPlus());
        }
        if (o instanceof GoConditionalExpr) {
            GoConditionalExpr c = (GoConditionalExpr)o;
            return GoPsiImplUtil.getNotNullElement(c.getEq(), c.getNotEq(), c.getGreater(), c.getGreaterOrEqual(), c.getLess(), c.getLessOrEqual());
        }
        return null;
    }

    @Nullable
    private static PsiElement getNotNullElement(PsiElement ... elements) {
        if (elements == null) {
            return null;
        }
        for (PsiElement e : elements) {
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public static int getPathOffset(@NotNull GoImportSpec o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(264);
        }
        GoStringLiteral lit = o.getStringLiteral();
        return lit.getStartOffsetInParent() + ElementManipulators.getManipulator((PsiElement)lit).getRangeInElement((PsiElement)lit).getStartOffset();
    }

    public static boolean isSingleCharLiteral(@NotNull GoStringLiteral literal) {
        if (literal == null) {
            GoPsiImplUtil.$$$reportNull$$$0(265);
        }
        return literal.getDecodedText().length() == 1;
    }

    @Nullable
    public static Value getValue(@NotNull GoExpression o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(266);
        }
        return GoExpressionEvaluator.evaluateExpression(o);
    }

    public static boolean isConstant(@NotNull GoExpression o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(267);
        }
        return GoExpressionUtil.isConstant(o);
    }

    @Nullable
    public static GoTypeSpec getTypeSpecFromReceiver(@Nullable GoTypeOwner receiver) {
        GoType type = receiver != null ? receiver.getGoType(null) : null;
        return GoTypeUtil.findTypeSpec(type, receiver, true);
    }

    @NotNull
    public static List<GoVarSpec> getSpecList(@NotNull GoVarDeclaration o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(268);
        }
        List<GoVarSpec> list = o.getVarSpecList();
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(269);
        }
        return list;
    }

    @NotNull
    public static List<GoConstSpec> getSpecList(@NotNull GoConstDeclaration o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(270);
        }
        List<GoConstSpec> list = o.getConstSpecList();
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(271);
        }
        return list;
    }

    @NotNull
    public static List<GoVarDefinition> getDefinitionList(@NotNull GoVarSpec o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(272);
        }
        List<GoVarDefinition> list = o.getVarDefinitionList();
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(273);
        }
        return list;
    }

    @NotNull
    public static List<GoConstDefinition> getDefinitionList(@NotNull GoConstSpec o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(274);
        }
        List<GoConstDefinition> list = o.getConstDefinitionList();
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(275);
        }
        return list;
    }

    public static void deleteElementFromCommaSeparatedList(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        GoDocumentationProvider.getUpperComments(element).stream().filter(GoPsiImplUtil::isPhysicalComment).forEach(PsiElement::delete);
        GoDocumentationProvider.getAfterComments(element).stream().filter(GoPsiImplUtil::isPhysicalComment).forEach(PsiElement::delete);
        PsiElement prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)element);
        PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)element);
        if (prevVisibleLeaf != null && prevVisibleLeaf.textMatches((CharSequence)",")) {
            prevVisibleLeaf.delete();
        } else if (nextVisibleLeaf != null && nextVisibleLeaf.textMatches((CharSequence)",")) {
            nextVisibleLeaf.delete();
        }
        element.delete();
    }

    public static boolean isPhysicalComment(PsiComment comment) {
        return comment.isPhysical() || IntentionPreviewUtils.isPreviewElement((PsiElement)comment);
    }

    public static void delete(@NotNull GoSimpleStatement o) throws IncorrectOperationException {
        PsiElement parent;
        PsiElement sibling;
        ASTNode node;
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(276);
        }
        ASTNode aSTNode = node = (sibling = o.getNextSibling()) instanceof PsiWhiteSpace ? sibling.getNode() : null;
        if (node != null && node.textContains('\n')) {
            sibling.delete();
        }
        if ((parent = o.getParent()) instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable((PsiElement)o);
            ((ASTDelegatePsiElement)parent).deleteChildInternal(o.getNode());
        } else if (parent instanceof CompositeElement) {
            CheckUtil.checkWritable((PsiElement)o);
            ((CompositeElement)parent).deleteChildInternal(o.getNode());
        }
    }

    public static boolean deleteExpression(@NotNull GoAssignmentStatement assignment, @NotNull GoExpression expression) {
        if (assignment == null) {
            GoPsiImplUtil.$$$reportNull$$$0(277);
        }
        if (expression == null) {
            GoPsiImplUtil.$$$reportNull$$$0(278);
        }
        List<GoExpression> leftExpressions = assignment.getLeftHandExprList().getExpressionList();
        int index = leftExpressions.indexOf(expression);
        List<GoExpression> rightExpressions = assignment.getExpressionList();
        if (index == -1) {
            index = rightExpressions.indexOf(expression);
        }
        if (index == -1) {
            return false;
        }
        int rightSize = rightExpressions.size();
        int leftSize = leftExpressions.size();
        if (leftSize == 1 && rightSize == 1) {
            assignment.delete();
            return true;
        }
        if (leftSize <= 1 || rightSize <= 1) {
            return false;
        }
        if (leftSize > index && leftSize == rightSize) {
            GoPsiImplUtil.deleteElementFromCommaSeparatedList(leftExpressions.get(index));
            GoPsiImplUtil.deleteElementFromCommaSeparatedList(rightExpressions.get(index));
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getOperator(@NotNull GoAssignOp o) {
        if (o == null) {
            GoPsiImplUtil.$$$reportNull$$$0(279);
        }
        return GoPsiImplUtil.getNotNullElement(o.getAssign(), o.getBitAndAssign(), o.getBitClearAssign(), o.getBitOrAssign(), o.getBitXorAssign(), o.getMinusAssign(), o.getMulAssign(), o.getPlusAssign(), o.getQuotientAssign(), o.getRemainderAssign(), o.getShiftLeftAssign(), o.getShiftRightAssign());
    }

    @Nullable
    public static PsiElement getDefault(@NotNull GoCommClause commClause) {
        GoCommCase commCase;
        if (commClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(280);
        }
        return (commCase = commClause.getCommCase()) != null ? commCase.getDefault() : null;
    }

    public static void deleteTypeSpec(@NotNull GoTypeDeclaration declaration, @NotNull GoTypeSpec specToDelete) {
        if (declaration == null) {
            GoPsiImplUtil.$$$reportNull$$$0(281);
        }
        if (specToDelete == null) {
            GoPsiImplUtil.$$$reportNull$$$0(282);
        }
        if (declaration.getTypeSpecList().size() == 1) {
            GoDocumentationProvider.getCommentsForElement(declaration).stream().filter(GoPsiImplUtil::isPhysicalComment).forEach(PsiElement::delete);
            declaration.delete();
        } else {
            GoDocumentationProvider.getAfterComments(specToDelete).stream().filter(GoPsiImplUtil::isPhysicalComment).forEach(PsiElement::delete);
            specToDelete.delete();
        }
    }

    @Nullable
    public static GoExpression getCondition(@NotNull GoIfStatement ifStatement) {
        GoExpression expr;
        if (ifStatement == null) {
            GoPsiImplUtil.$$$reportNull$$$0(283);
        }
        if ((expr = ifStatement.getExpression()) != null) {
            return expr;
        }
        if (ifStatement.getNode().findChildByType(GoTypes.SEMICOLON) != null) {
            return null;
        }
        return GoPsiImplUtil.findConditionInConditionStatement(ifStatement.getStatement());
    }

    @Nullable
    public static GoStatement getInitStatement(@NotNull GoIfStatement ifStatement) {
        if (ifStatement == null) {
            GoPsiImplUtil.$$$reportNull$$$0(284);
        }
        if (ifStatement.getExpression() != null || ifStatement.getSemicolon() != null) {
            return ifStatement.getStatement();
        }
        GoStatement statement = ifStatement.getStatement();
        return GoPsiUtil.hasNewLineAfter(statement) ? statement : null;
    }

    @Nullable
    public static GoExpression getCondition(@NotNull GoExprSwitchStatement switchStatement) {
        GoExpression expr;
        if (switchStatement == null) {
            GoPsiImplUtil.$$$reportNull$$$0(285);
        }
        if ((expr = switchStatement.getExpression()) != null) {
            return expr;
        }
        if (switchStatement.getSemicolon() != null) {
            return null;
        }
        return GoPsiImplUtil.findConditionInConditionStatement(switchStatement.getStatement());
    }

    @Nullable
    private static GoExpression findConditionInConditionStatement(@Nullable GoStatement conditionStatement) {
        GoSimpleStatement simpleStatement = (GoSimpleStatement)ObjectUtils.tryCast((Object)conditionStatement, GoSimpleStatement.class);
        if (GoPsiUtil.hasNewLineAfter(simpleStatement)) {
            return null;
        }
        GoLeftHandExprList exprList = simpleStatement != null ? simpleStatement.getLeftHandExprList() : null;
        return exprList != null ? (GoExpression)ContainerUtil.getFirstItem(exprList.getExpressionList()) : null;
    }

    @Nullable
    public static GoStatement getInitStatement(@NotNull GoExprSwitchStatement switchStatement) {
        if (switchStatement == null) {
            GoPsiImplUtil.$$$reportNull$$$0(286);
        }
        if (switchStatement.getExpression() != null || switchStatement.getSemicolon() != null) {
            return switchStatement.getStatement();
        }
        GoStatement statement = switchStatement.getStatement();
        return GoPsiUtil.hasNewLineAfter(statement) ? statement : null;
    }

    @Nullable
    public static GoStatement getInitStatement(@NotNull GoForClause forClause) {
        GoStatement statement;
        if (forClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(287);
        }
        PsiElement prevElement = (statement = (GoStatement)ContainerUtil.getFirstItem(forClause.getStatementList())) != null ? PsiTreeUtil.prevVisibleLeaf((PsiElement)statement) : null;
        return prevElement != null && prevElement.getNode().getElementType() == GoTypes.FOR ? statement : null;
    }

    @Nullable
    public static GoStatement getPostStatement(@NotNull GoForClause forClause) {
        GoStatement statement;
        if (forClause == null) {
            GoPsiImplUtil.$$$reportNull$$$0(288);
        }
        PsiElement nextElement = (statement = (GoStatement)ContainerUtil.getLastItem(forClause.getStatementList())) != null ? PsiTreeUtil.nextVisibleLeaf((PsiElement)statement) : null;
        return nextElement != null && nextElement.getNode().getElementType() == GoTypes.LBRACE ? statement : null;
    }

    @Nullable
    public static String getExampleCode(@NotNull GoFunctionDeclaration declaration) {
        GoFunctionDeclarationStub stub;
        if (declaration == null) {
            GoPsiImplUtil.$$$reportNull$$$0(289);
        }
        if ((stub = (GoFunctionDeclarationStub)declaration.getStub()) != null) {
            return stub.getExampleCode();
        }
        Pair<String, String> codeAndOutput = GoTestFinder.isExampleFunction(declaration) ? GoPsiUtil.getExampleCodeAndOutput(declaration) : null;
        return codeAndOutput != null ? (String)codeAndOutput.first : null;
    }

    @Nullable
    public static String getExampleOutput(@NotNull GoFunctionDeclaration declaration) {
        GoFunctionDeclarationStub stub;
        if (declaration == null) {
            GoPsiImplUtil.$$$reportNull$$$0(290);
        }
        if ((stub = (GoFunctionDeclarationStub)declaration.getStub()) != null) {
            return stub.getExampleOutput();
        }
        Pair<String, String> codeAndOutput = GoTestFinder.isExampleFunction(declaration) ? GoPsiUtil.getExampleCodeAndOutput(declaration) : null;
        return codeAndOutput != null ? (String)codeAndOutput.second : null;
    }

    public static boolean isTrulyBuiltin(@NotNull GoBuiltinCallExpr callExpr) {
        GoReferenceExpression ref;
        if (callExpr == null) {
            GoPsiImplUtil.$$$reportNull$$$0(291);
        }
        PsiElement resolve = (ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)callExpr.getExpression().unwrapParentheses(), GoReferenceExpression.class)) != null ? ref.resolve() : null;
        return GoPsiImplUtil.isBuiltinFile(resolve != null ? resolve.getContainingFile() : null);
    }

    @NotNull
    public static Icon getIcon(@NotNull GoFunctionLit functionLit, @Iconable.IconFlags int flags) {
        if (functionLit == null) {
            GoPsiImplUtil.$$$reportNull$$$0(292);
        }
        Icon icon = GoIcons.FUNCTION;
        if (icon == null) {
            GoPsiImplUtil.$$$reportNull$$$0(293);
        }
        return icon;
    }

    @NotNull
    public static List<GoType> getTypes(@NotNull GoTypeArguments typeArguments) {
        if (typeArguments == null) {
            GoPsiImplUtil.$$$reportNull$$$0(294);
        }
        List<GoType> list = GoTypeUtil.getListOfTypesFromTypeList(typeArguments.getTypeList());
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(295);
        }
        return list;
    }

    public static boolean hasTilde(@NotNull GoConstraintTerm constraintTerm) {
        GoConstraintTermStub stub;
        if (constraintTerm == null) {
            GoPsiImplUtil.$$$reportNull$$$0(296);
        }
        if ((stub = (GoConstraintTermStub)constraintTerm.getStub()) != null) {
            return stub.hasTilde();
        }
        return constraintTerm.getTilde() != null;
    }

    @NotNull
    public static ItemPresentation getPresentation(final @NotNull GoFunctionLit functionLit) {
        if (functionLit == null) {
            GoPsiImplUtil.$$$reportNull$$$0(297);
        }
        return new GoItemPresentation<GoFunctionLit>(functionLit){
            private String presentableText;

            public String getPresentableText() {
                if (this.presentableText == null) {
                    this.presentableText = GoPsiPresentationBuilder.create().withoutResolve().withoutParameterNames().oneline().build(functionLit, true);
                }
                return this.presentableText;
            }

            @Override
            @NotNull
            public Icon getIcon(boolean b) {
                Icon icon = GoIcons.FUNCTION;
                if (icon == null) {
                    2.$$$reportNull$$$0(0);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/psi/impl/GoPsiImplUtil$2", "getIcon"));
            }
        };
    }

    @NotNull
    public static GoInstantiatedType toInstantiated(@NotNull GoType type) {
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(298);
        }
        GoInstantiatedType<?> goInstantiatedType = type instanceof GoInstantiatedType ? (GoInstantiatedType<?>)type : GoInstantiatedType.createTrivial(type);
        if (goInstantiatedType == null) {
            GoPsiImplUtil.$$$reportNull$$$0(299);
        }
        return goInstantiatedType;
    }

    @Contract(value="null -> null; !null -> !null")
    public static GoType unwrapInstantiation(@Nullable GoType type) {
        return type instanceof GoInstantiatedType ? (GoType)((GoInstantiatedType)type).getGeneric() : type;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static GoType withInstantiation(@Nullable GoType type, @NotNull GoInstantiatedElement instantiatedElement) {
        if (instantiatedElement == null) {
            GoPsiImplUtil.$$$reportNull$$$0(300);
        }
        if (type == null) {
            return null;
        }
        return GoInstantiatedTypeFactory.create(type, instantiatedElement.getSubstitution().getParams(), instantiatedElement.getInstantiationContext());
    }

    @NotNull
    public static GoInstantiatedSignature toInstantiated(@NotNull GoSignature signature) {
        if (signature == null) {
            GoPsiImplUtil.$$$reportNull$$$0(301);
        }
        GoInstantiatedSignature goInstantiatedSignature = signature instanceof GoInstantiatedSignature ? (GoInstantiatedSignature)signature : GoInstantiatedSignature.createTrivial(signature);
        if (goInstantiatedSignature == null) {
            GoPsiImplUtil.$$$reportNull$$$0(302);
        }
        return goInstantiatedSignature;
    }

    @Nullable
    public static GoType getType(@NotNull GoReceiver receiver) {
        if (receiver == null) {
            GoPsiImplUtil.$$$reportNull$$$0(303);
        }
        return GoParserPsiTreeUtil.getStubChildOfType(receiver, GoType.class);
    }

    @NotNull
    public static List<GoTypeParamDefinition> getTypeParamDefinitions(@Nullable GoTypeParameters typeParameters) {
        if (typeParameters == null) {
            List<GoTypeParamDefinition> list = Collections.emptyList();
            if (list == null) {
                GoPsiImplUtil.$$$reportNull$$$0(304);
            }
            return list;
        }
        List list = StreamEx.of(typeParameters.getTypeParameterDeclarationList()).flatCollection(GoTypeParameterDeclaration::getTypeParamDefinitionList).toList();
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(305);
        }
        return list;
    }

    @NotNull
    public static List<GoType> getTypeArguments(@Nullable GoType type) {
        GoTypeArguments typeArgsElement = type != null ? type.getTypeArguments() : null;
        List<GoType> list = typeArgsElement != null ? typeArgsElement.getTypes() : Collections.emptyList();
        if (list == null) {
            GoPsiImplUtil.$$$reportNull$$$0(306);
        }
        return list;
    }

    @Contract(value="null -> false")
    public static boolean isReceiverTypeReferenceExpression(@Nullable PsiElement element) {
        if (!(element instanceof GoTypeReferenceExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        return grandParent instanceof GoReceiver;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoNamedElement findFieldOrMethod(@Nullable GoTypeSpec typeSpec, @NotNull Predicate<GoNamedElement> predicate) {
        if (predicate == null) {
            GoPsiImplUtil.$$$reportNull$$$0(307);
        }
        if (typeSpec == null) {
            return null;
        }
        GoType goType = typeSpec.getSpecType().getType();
        if (goType instanceof GoStructType) {
            for (GoNamedElement fieldDefinition : ((GoStructType)goType).getFieldDefinitions()) {
                if (!predicate.test(fieldDefinition)) continue;
                return fieldDefinition;
            }
        }
        if (goType instanceof GoInterfaceType) {
            for (GoMethodSpec methodSpec : ((GoInterfaceType)goType).getMethods()) {
                if (!predicate.test(methodSpec)) continue;
                return methodSpec;
            }
        } else {
            for (GoMethodDeclaration methodDecl : GoPsiImplUtil.getMethods(typeSpec)) {
                if (!predicate.test(methodDecl)) continue;
                return methodDecl;
            }
        }
        return null;
    }

    public static int getArgumentCount(@NotNull GoArgumentList argumentList) {
        List<GoExpression> expressionList;
        int actualSize;
        if (argumentList == null) {
            GoPsiImplUtil.$$$reportNull$$$0(308);
        }
        return (actualSize = (expressionList = argumentList.getExpressionList()).size()) == 1 ? GoInspectionUtil.getExpressionResultCount((GoExpression)ContainerUtil.getFirstItem(expressionList)) : actualSize;
    }

    @Nullable
    public static GoSpecType getSpecType(@NotNull GoType type) {
        PsiElement parent;
        if (type == null) {
            GoPsiImplUtil.$$$reportNull$$$0(309);
        }
        if (type instanceof GoSpecType) {
            GoSpecType specType = (GoSpecType)type;
            return specType;
        }
        GoTypeStub stub = (GoTypeStub)type.getStub();
        PsiElement psiElement = parent = stub == null ? type.getParent() : stub.getParentStub().getPsi();
        if (parent instanceof GoSpecType) {
            GoSpecType parentSpecType = (GoSpecType)parent;
            return parentSpecType;
        }
        return null;
    }

    public static boolean isAnonymous(@NotNull GoInterfaceType interfaceType) {
        if (interfaceType == null) {
            GoPsiImplUtil.$$$reportNull$$$0(310);
        }
        return GoPsiImplUtil.getSpecType(interfaceType) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 15, 17, 19, 22, 26, 27, 29, 40, 50, 59, 62, 66, 67, 68, 69, 71, 72, 93, 104, 112, 114, 117, 118, 119, 120, 122, 123, 125, 127, 130, 132, 150, 151, 152, 153, 156, 157, 158, 161, 164, 168, 169, 174, 176, 178, 179, 180, 181, 182, 183, 184, 188, 191, 192, 195, 200, 201, 206, 209, 210, 211, 214, 220, 231, 234, 236, 240, 243, 244, 247, 248, 259, 261, 269, 271, 273, 275, 293, 295, 299, 302, 304, 305, 306 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 38: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: 
            case 14: 
            case 32: 
            case 136: 
            case 139: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 40: 
            case 50: 
            case 59: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 93: 
            case 104: 
            case 112: 
            case 114: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 127: 
            case 130: 
            case 132: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 164: 
            case 168: 
            case 169: 
            case 174: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 188: 
            case 191: 
            case 192: 
            case 195: 
            case 200: 
            case 201: 
            case 206: 
            case 209: 
            case 210: 
            case 211: 
            case 214: 
            case 220: 
            case 231: 
            case 234: 
            case 236: 
            case 240: 
            case 243: 
            case 244: 
            case 247: 
            case 248: 
            case 259: 
            case 261: 
            case 269: 
            case 271: 
            case 273: 
            case 275: 
            case 293: 
            case 295: 
            case 299: 
            case 302: 
            case 304: 
            case 305: 
            case 306: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoPsiImplUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 28: 
            case 203: 
            case 204: 
            case 205: 
            case 207: 
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 31: 
            case 135: 
            case 138: 
            case 141: 
            case 146: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageClause";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 46: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 57: 
            case 198: 
            case 281: 
            case 289: 
            case 290: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 70: 
            case 301: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specs";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 84: 
            case 87: 
            case 97: 
            case 98: 
            case 99: 
            case 103: 
            case 105: 
            case 185: 
            case 186: 
            case 298: 
            case 309: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 86: 
            case 291: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledExpression";
                break;
            }
            case 89: 
            case 90: 
            case 294: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 96: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getInnerType";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 107: 
            case 278: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 110: 
            case 308: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 121: 
            case 155: 
            case 163: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedTypes";
                break;
            }
            case 133: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationFile";
                break;
            }
            case 137: 
            case 140: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 189: 
            case 193: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importList";
                break;
            }
            case 190: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePath";
                break;
            }
            case 194: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newImportDeclaration";
                break;
            }
            case 202: 
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedPackages";
                break;
            }
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specType";
                break;
            }
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 227: 
            case 230: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slice";
                break;
            }
            case 228: 
            case 233: 
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeClause";
                break;
            }
            case 229: 
            case 235: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recvStatement";
                break;
            }
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexOrSliceExpression";
                break;
            }
            case 245: 
            case 246: 
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 257: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 277: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 280: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commClause";
                break;
            }
            case 282: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specToDelete";
                break;
            }
            case 283: 
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 285: 
            case 286: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 287: 
            case 288: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forClause";
                break;
            }
            case 292: 
            case 297: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionLit";
                break;
            }
            case 296: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintTerm";
                break;
            }
            case 300: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiatedElement";
                break;
            }
            case 303: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 307: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 310: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoPsiImplUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withReverseTypeInference";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextOnElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesFor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 50: 
            case 59: 
            case 112: 
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoTypeInner";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParamDefinition";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "findTypeInConstSpec";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultType";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParametersText";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDefinitions";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
            case 117: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 118: 
            case 130: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 132: 
            case 156: 
            case 157: 
            case 158: 
            case 168: 
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAllMethodsWithSubstitutionSource";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseTypesReferences";
                break;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMethods";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAllMethods";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInstantiatedUnderlyingType";
                break;
            }
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "calcUnderlyingTypeRecursionSafe";
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "calcUnderlyingType";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "addImport";
                break;
            }
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "addImportDeclaration";
                break;
            }
            case 200: 
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "addImportSpec";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 209: 
            case 210: 
            case 211: 
            case 214: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportQualifiersToUseInFile";
                break;
            }
            case 220: {
                objectArray = objectArray2;
                objectArray2[1] = "updateText";
                break;
            }
            case 231: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 234: 
            case 236: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightExpressionsList";
                break;
            }
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirection";
                break;
            }
            case 243: 
            case 244: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectionByPsi";
                break;
            }
            case 247: 
            case 248: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsInRange";
                break;
            }
            case 259: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSpecIcon";
                break;
            }
            case 261: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecodedText";
                break;
            }
            case 269: 
            case 271: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecList";
                break;
            }
            case 273: 
            case 275: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionList";
                break;
            }
            case 293: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 295: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 299: 
            case 302: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstantiated";
                break;
            }
            case 304: 
            case 305: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParamDefinitions";
                break;
            }
            case 306: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRecover";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stdLibCall";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasSameNameAndPackage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getArity";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withReverseTypeInference";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 26: 
            case 27: 
            case 29: 
            case 40: 
            case 50: 
            case 59: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 93: 
            case 104: 
            case 112: 
            case 114: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 127: 
            case 130: 
            case 132: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 164: 
            case 168: 
            case 169: 
            case 174: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 188: 
            case 191: 
            case 192: 
            case 195: 
            case 200: 
            case 201: 
            case 206: 
            case 209: 
            case 210: 
            case 211: 
            case 214: 
            case 220: 
            case 231: 
            case 234: 
            case 236: 
            case 240: 
            case 243: 
            case 244: 
            case 247: 
            case 248: 
            case 259: 
            case 261: 
            case 269: 
            case 271: 
            case 273: 
            case 275: 
            case 293: 
            case 295: 
            case 299: 
            case 302: 
            case 304: 
            case 305: 
            case 306: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withContextOnElement";
                break;
            }
            case 11: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 12: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRawQualifier";
                break;
            }
            case 13: 
            case 14: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesFor";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 34: 
            case 49: 
            case 56: 
            case 58: 
            case 64: 
            case 85: 
            case 111: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "getGoTypeInner";
                break;
            }
            case 35: 
            case 53: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTextOffset";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPath";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "calcCanonicalPath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getValidCommentText";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTypeReferenceExpression";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifier";
                break;
            }
            case 51: 
            case 52: 
            case 223: 
            case 251: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverType";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeSpec";
                break;
            }
            case 57: 
            case 303: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getConstraintType";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParamDefinition";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getInstantiatedConstraintType";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findTypeInConstSpec";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getResultType";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findVarOrConstExpression";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAndIndexOfConstDefinition";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionForConstDefinition";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getGoUnderlyingType";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getGoType";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getGoTypeRecursionSafe";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "checkDepth";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getArithmeticExpressionType";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getUntypedNumericTypeRank";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "isRealBool";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedCallExpressionType";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromReference";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "areTypeArgumentsNullsOnly";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isMulExpression";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isPointerValueOrValueDeref";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedExpressionReferenceType";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinType";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "contextlessResolve";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getValueOrKeyType";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForKey";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "isKeysExpected";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getFieldDefinitions";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousFieldDefinitions";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getTagText";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "resolveType";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isVariadic";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isVoid";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getFqn";
                break;
            }
            case 116: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getMethods";
                break;
            }
            case 121: 
            case 131: 
            case 154: 
            case 155: 
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "calcAllMethodsWithSubstitutionSource";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getBaseTypesReferences";
                break;
            }
            case 128: 
            case 129: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethods";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "allowed";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "notAllowed";
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "processNamedElements";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "processSignatureOwner";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "processParameters";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "calcMethods";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "calcAllMethods";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "getContextlessUnderlyingType";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getUnderlyingType";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "calcInstantiatedUnderlyingType";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "calcUnderlyingTypeRecursionSafe";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "calcUnderlyingType";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverTypeParam";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverTypeArgIndex";
                break;
            }
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 193: 
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "addImportDeclaration";
                break;
            }
            case 196: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "addDeclarationBeforeOrAfter";
                break;
            }
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "addImportSpec";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "sanitizePackageName";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "isCImport";
                break;
            }
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "isDot";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "getAlias";
                break;
            }
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "getImportQualifiersToUseInFile";
                break;
            }
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "shouldGoDeeper";
                break;
            }
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "isForSideEffects";
                break;
            }
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "isValidHost";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralTextEscaper";
                break;
            }
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "prevVisibleLeaf";
                break;
            }
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSpec";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "canBeAutoImported";
                break;
            }
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictTopmostParentOfType";
                break;
            }
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
            case 228: 
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "getLeftExpressionsList";
                break;
            }
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "isIndexExpression";
                break;
            }
            case 233: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "getRightExpressionsList";
                break;
            }
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "getRangeExpression";
                break;
            }
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "getRecvExpression";
                break;
            }
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "getDirection";
                break;
            }
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "getDirectionInner";
                break;
            }
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "getDirectionByPsi";
                break;
            }
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "getLastExpressionAfter";
                break;
            }
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsInRange";
                break;
            }
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsBefore";
                break;
            }
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 252: {
                objectArray = objectArray;
                objectArray[2] = "getLengthInner";
                break;
            }
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "calcLength";
                break;
            }
            case 254: {
                objectArray = objectArray;
                objectArray[2] = "isArray";
                break;
            }
            case 255: {
                objectArray = objectArray;
                objectArray[2] = "isTypeAlias";
                break;
            }
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "isEmbeddedByPointer";
                break;
            }
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverName";
                break;
            }
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSpecIcon";
                break;
            }
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "getDecodedText";
                break;
            }
            case 262: 
            case 263: 
            case 279: {
                objectArray = objectArray;
                objectArray[2] = "getOperator";
                break;
            }
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "getPathOffset";
                break;
            }
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "isSingleCharLiteral";
                break;
            }
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "isConstant";
                break;
            }
            case 268: 
            case 270: {
                objectArray = objectArray;
                objectArray[2] = "getSpecList";
                break;
            }
            case 272: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionList";
                break;
            }
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "deleteExpression";
                break;
            }
            case 280: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 281: 
            case 282: {
                objectArray = objectArray;
                objectArray[2] = "deleteTypeSpec";
                break;
            }
            case 283: 
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "getCondition";
                break;
            }
            case 284: 
            case 286: 
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "getInitStatement";
                break;
            }
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "getPostStatement";
                break;
            }
            case 289: {
                objectArray = objectArray;
                objectArray[2] = "getExampleCode";
                break;
            }
            case 290: {
                objectArray = objectArray;
                objectArray[2] = "getExampleOutput";
                break;
            }
            case 291: {
                objectArray = objectArray;
                objectArray[2] = "isTrulyBuiltin";
                break;
            }
            case 292: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 294: {
                objectArray = objectArray;
                objectArray[2] = "getTypes";
                break;
            }
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "hasTilde";
                break;
            }
            case 297: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 298: 
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "toInstantiated";
                break;
            }
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "withInstantiation";
                break;
            }
            case 307: {
                objectArray = objectArray;
                objectArray[2] = "findFieldOrMethod";
                break;
            }
            case 308: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentCount";
                break;
            }
            case 309: {
                objectArray = objectArray;
                objectArray[2] = "getSpecType";
                break;
            }
            case 310: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymous";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 15, 17, 19, 22, 26, 27, 29, 40, 50, 59, 62, 66, 67, 68, 69, 71, 72, 93, 104, 112, 114, 117, 118, 119, 120, 122, 123, 125, 127, 130, 132, 150, 151, 152, 153, 156, 157, 158, 161, 164, 168, 169, 174, 176, 178, 179, 180, 181, 182, 183, 184, 188, 191, 192, 195, 200, 201, 206, 209, 210, 211, 214, 220, 231, 234, 236, 240, 243, 244, 247, 248, 259, 261, 269, 271, 273, 275, 293, 295, 299, 302, 304, 305, 306 -> new IllegalStateException(string);
        };
    }

    public static enum ChannelDirection {
        SEND,
        RECEIVE,
        BIDIRECTIONAL;

    }
}

