/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi;

import com.goide.psi.impl.GoResolveResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GoResolveCache {
    private static final Logger LOG = Logger.getInstance(GoResolveCache.class);
    private static GoResolveCacheListener ourResolveCacheListener;
    private final ConcurrentHashMap<String, Map<PsiElement, ResolveResult[]>> myMap = new ConcurrentHashMap();

    public <T extends PsiReference> ResolveResult @Nullable [] computeIfAbsent(@NotNull T ref, @NotNull Function<? super T, ResolveResult[]> resultCalculator, @NotNull Function<? super T, ? extends PsiElement> contextCalculator) {
        ResolveResult[] cachedResults;
        if (ref == null) {
            GoResolveCache.$$$reportNull$$$0(0);
        }
        if (resultCalculator == null) {
            GoResolveCache.$$$reportNull$$$0(1);
        }
        if (contextCalculator == null) {
            GoResolveCache.$$$reportNull$$$0(2);
        }
        String text = ref.getCanonicalText();
        PsiElement context = contextCalculator.apply(ref);
        if (context == null) {
            if (ourResolveCacheListener != null || LOG.isDebugEnabled()) {
                LOG.debug("Cache miss as context is null for " + text + " " + GoResolveCache.getRangeInfo(ref));
                if (ourResolveCacheListener != null) {
                    ourResolveCacheListener.miss(ref);
                }
            }
            return resultCalculator.apply(ref);
        }
        Map cache = this.myMap.computeIfAbsent(text, __ -> new ConcurrentHashMap());
        if (ourResolveCacheListener != null || LOG.isDebugEnabled()) {
            if (cache.containsKey(context)) {
                if (ourResolveCacheListener != null) {
                    ourResolveCacheListener.hit(ref);
                }
                LOG.debug("Cache hit for " + text + " in " + context);
            } else {
                if (ourResolveCacheListener != null) {
                    ourResolveCacheListener.miss(ref);
                }
                LOG.debug("Cache miss for " + text + " in " + context);
            }
        }
        if ((cachedResults = (ResolveResult[])cache.get(context)) != null) {
            return cachedResults;
        }
        Object[] results = resultCalculator.apply(ref);
        if (!GoResolveCache.canCache((ResolveResult[])results)) {
            return results;
        }
        Object[] existingResults = cache.putIfAbsent(context, results);
        if (existingResults == null) {
            return results;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !Arrays.equals(existingResults, results)) {
            LOG.error("Resolution produced different results for the same context");
        }
        return existingResults;
    }

    private static boolean canCache(ResolveResult[] results) {
        return ContainerUtil.and((Object[])results, it -> GoResolveCache.canCache(it));
    }

    private static boolean canCache(ResolveResult result) {
        GoResolveResult goResult = (GoResolveResult)ObjectUtils.tryCast((Object)result, GoResolveResult.class);
        return goResult == null || goResult.getTypeSubstitution().isEmpty();
    }

    private static <T extends PsiReference> String getRangeInfo(@NotNull T ref) {
        StubBasedPsiElement stubBasedElement;
        if (ref == null) {
            GoResolveCache.$$$reportNull$$$0(3);
        }
        StubElement stub = (stubBasedElement = (StubBasedPsiElement)ObjectUtils.tryCast((Object)ref.getElement(), StubBasedPsiElement.class)) != null ? stubBasedElement.getStub() : null;
        return stub == null ? ref.getElement().getTextRange().toString() : "<stub>";
    }

    @TestOnly
    public static void setResolveCacheListener(@NotNull GoResolveCacheListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            GoResolveCache.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            GoResolveCache.$$$reportNull$$$0(5);
        }
        ourResolveCacheListener = listener2;
        Disposer.register((Disposable)parentDisposable, () -> {
            ourResolveCacheListener = null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultCalculator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextCalculator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/goide/psi/GoResolveCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeIfAbsent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setResolveCacheListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface GoResolveCacheListener {
        public void hit(@NotNull PsiReference var1);

        public void miss(@NotNull PsiReference var1);
    }
}

