/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.dlv.DlvDebugProcess;
import com.goide.execution.GoRunUtil;
import com.goide.project.GoProjectLibrariesService;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoTargetSystem;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.project.VgoWorkspaceModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.intellij.util.containers.SmartHashSet;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class GoTroubleInfoCollector
implements TroubleInfoCollector {
    @NotNull
    public String collectInfo(@NotNull Project project) {
        if (project == null) {
            GoTroubleInfoCollector.$$$reportNull$$$0(0);
        }
        StringBuilder result = new StringBuilder();
        result.append("==== ").append(this).append(" ====\n");
        for (Module module : GoSdkUtil.getGoModules(project)) {
            VirtualFile[] contentRoots;
            result.append("Module `").append(module.getName()).append("`\n");
            GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
            result.append("GOROOT (").append(sdk.getVersion()).append("): ").append(sdk.getHomeUrl()).append('\n');
            result.append("GOPATH: ").append(GoSdkUtil.retrieveGoPath(project, module)).append('\n');
            result.append("GOPATH indexing: ").append(GoProjectLibrariesService.getInstance(project).isIndexEntireGopath() ? "enabled" : "disabled").append('\n');
            result.append("go.work files: ").append(GoTroubleInfoCollector.getGoWorkFilePaths(project, module)).append('\n');
            result.append("Build target: ").append(GoTargetSystem.forModule(module)).append('\n');
            result.append("Content roots\n");
            for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                result.append(root.getPath()).append('\n');
            }
            result.append("\n\n");
        }
        String delvePath = GoRunUtil.localDlv().getAbsolutePath();
        result.append("Delve path: ").append(delvePath).append('\n');
        result.append("Delve version:\n'").append(GoTroubleInfoCollector.getDelveVersion(delvePath)).append("'\n");
        try {
            String bundledDelveCommit = (String)DlvDebugProcess.getBundledDelveArtifactVersionAndCommit().second;
            result.append("Bundled delve commit: ").append(bundledDelveCommit).append("\n");
        }
        catch (Exception e) {
            result.append("Failed to get bundled delve commit: ").append(GoTroubleInfoCollector.getErrorDetails(e)).append("\n");
        }
        String string = result.toString();
        if (string == null) {
            GoTroubleInfoCollector.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static Set<String> getGoWorkFilePaths(@NotNull Project project, Module module) {
        if (project == null) {
            GoTroubleInfoCollector.$$$reportNull$$$0(2);
        }
        SmartHashSet goWorkFilePaths = new SmartHashSet();
        for (VgoModule vgoModule : VgoModulesRegistry.getInstance(project).getModules(module)) {
            if (!(vgoModule instanceof VgoWorkspaceModule)) continue;
            String goWorkFilePath = ((VgoWorkspaceModule)vgoModule).getWorkspace().getGoWork().getPresentableUrl();
            goWorkFilePaths.add(goWorkFilePath);
        }
        SmartHashSet smartHashSet = goWorkFilePaths;
        if (smartHashSet == null) {
            GoTroubleInfoCollector.$$$reportNull$$$0(3);
        }
        return smartHashSet;
    }

    @NotNull
    private static String getDelveVersion(@NotNull String delvePath) {
        String string;
        if (delvePath == null) {
            GoTroubleInfoCollector.$$$reportNull$$$0(4);
        }
        try {
            Process process = new ProcessBuilder(new String[0]).command(delvePath, "version").start();
            process.waitFor(5L, TimeUnit.SECONDS);
            string = StreamUtil.readText((Reader)new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8)).trim();
        }
        catch (Exception e) {
            String string2 = "failed to execute 'dlv version': " + GoTroubleInfoCollector.getErrorDetails(e);
            if (string2 == null) {
                GoTroubleInfoCollector.$$$reportNull$$$0(6);
            }
            return string2;
        }
        if (string == null) {
            GoTroubleInfoCollector.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getErrorDetails(@NotNull Exception e) {
        String details;
        if (e == null) {
            GoTroubleInfoCollector.$$$reportNull$$$0(7);
        }
        if ((details = e.getMessage()) == null) {
            details = e.getClass().getName();
        }
        String string = details;
        if (string == null) {
            GoTroubleInfoCollector.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String toString() {
        return "Go";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/GoTroubleInfoCollector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delvePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/GoTroubleInfoCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoWorkFilePaths";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelveVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGoWorkFilePaths";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDelveVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDetails";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

