/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project;

import com.goide.GoIcons;
import com.goide.sdk.GoBasedSdkVetoer;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class GoSdkLibraryRootProvider
extends AdditionalLibraryRootsProvider {
    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            GoSdkLibraryRootProvider.$$$reportNull$$$0(0);
        }
        HashSet<SyntheticLibrary> result = new HashSet<SyntheticLibrary>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
            boolean vetoThisSdk = GoBasedSdkVetoer.isSdkVetoedByAnyEP(sdk, module);
            if (!sdk.isValid() || vetoThisSdk) continue;
            result.add(new GoSdkLibrary(sdk));
        }
        HashSet<SyntheticLibrary> hashSet = result;
        if (hashSet == null) {
            GoSdkLibraryRootProvider.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public Collection<VirtualFile> getRootsToWatch(@NotNull Project project) {
        if (project == null) {
            GoSdkLibraryRootProvider.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                GoSdkLibraryRootProvider.$$$reportNull$$$0(3);
            }
            return set;
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
            boolean vetoThisSdk = GoBasedSdkVetoer.isSdkVetoedByAnyEP(sdk, module);
            if (!sdk.isValid() || vetoThisSdk) continue;
            ContainerUtil.addIfNotNull(result, (Object)sdk.getSdkRoot());
        }
        HashSet<VirtualFile> hashSet = result;
        if (hashSet == null) {
            GoSdkLibraryRootProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/GoSdkLibraryRootProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/GoSdkLibraryRootProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectLibraries";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectLibraries";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToWatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class GoSdkLibrary
    extends SyntheticLibrary
    implements ItemPresentation {
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final String myVersion;

        private GoSdkLibrary(@NotNull GoSdk sdk) {
            if (sdk == null) {
                GoSdkLibrary.$$$reportNull$$$0(0);
            }
            super("GoSdkLib::" + sdk.getHomeUrl(), (isDir, name, isRoot, isStrictRootChild, hasParentAndGrandparent) -> "testdata".contentEquals(name));
            this.myRoots = sdk.getRootsToAttach();
            this.myVersion = StringUtil.notNullize((String)sdk.getVersion());
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            Collection<VirtualFile> collection = this.myRoots;
            if (collection == null) {
                GoSdkLibrary.$$$reportNull$$$0(1);
            }
            return collection;
        }

        @NotNull
        public String getPresentableText() {
            String string = "Go SDK " + this.myVersion;
            if (string == null) {
                GoSdkLibrary.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Icon getIcon(boolean unused) {
            Icon icon = GoIcons.ICON;
            if (icon == null) {
                GoSdkLibrary.$$$reportNull$$$0(3);
            }
            return icon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            GoSdkLibrary library = (GoSdkLibrary)((Object)o);
            if (!this.myRoots.equals(library.myRoots)) {
                return false;
            }
            return this.myVersion.equals(library.myVersion);
        }

        public int hashCode() {
            int result = this.myRoots.hashCode();
            result = 31 * result + this.myVersion.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/project/GoSdkLibraryRootProvider$GoSdkLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/project/GoSdkLibraryRootProvider$GoSdkLibrary";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceRoots";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

