/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.generate.constructor;

import com.goide.GoParserDefinition;
import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.generate.constructor.GoMemberChooser;
import com.goide.intentions.generate.constructor.GoMemberChooserNode;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.refactor.template.GoTemplate;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoGenerateConstructorIntention
extends GoBaseIntentionAction {
    static List<GoMemberChooserNode> ourTestSelectedFields;

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.generate.constructor.name", (Object[])new Object[0]);
        if (string == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(2);
        }
        return currentFile;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        GoTypeSpec typeSpec;
        if (project == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(5);
        }
        if (!GoPsiUtil.isTopLevelDeclaration(typeSpec = GoGenerateConstructorIntention.findTypeSpec(element))) {
            return false;
        }
        return typeSpec.getSpecType().getType() instanceof GoStructType;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        GoTypeSpec typeSpec;
        if (project == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(8);
        }
        if (!GoPsiUtil.isTopLevelDeclaration(typeSpec = GoGenerateConstructorIntention.findTypeSpec(element))) {
            return;
        }
        GoStructType structType = (GoStructType)ObjectUtils.tryCast((Object)typeSpec.getSpecType().getType(), GoStructType.class);
        if (structType == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            WriteAction.run(() -> GoGenerateConstructorIntention.generate(editor, typeSpec, ourTestSelectedFields));
            return;
        }
        List definitions = ContainerUtil.filter(structType.getFieldDefinitions(), fd -> !fd.isBlank());
        if (definitions.isEmpty()) {
            WriteAction.run(() -> GoGenerateConstructorIntention.generate(editor, typeSpec, ContainerUtil.emptyList()));
            return;
        }
        GoMemberChooserNode[] chooserNodes = (GoMemberChooserNode[])ContainerUtil.map2Array((Collection)definitions, GoMemberChooserNode.class, GoMemberChooserNode::new);
        GoMemberChooser memberChooser = new GoMemberChooser(chooserNodes, project, null);
        memberChooser.setTitle(GoBundle.message((String)"go.intention.select.fields.dialog.title", (Object[])new Object[0]));
        if (memberChooser.showAndGet()) {
            WriteAction.run(() -> GoGenerateConstructorIntention.generate(editor, typeSpec, memberChooser.getSelectedElements()));
        }
    }

    @Nullable
    private static GoTypeSpec findTypeSpec(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(9);
        }
        if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoTypeSpec.class, GoTypeDeclaration.class})) instanceof GoTypeSpec) {
            return (GoTypeSpec)parent;
        }
        if (parent instanceof GoTypeDeclaration) {
            List<GoTypeSpec> specs = ((GoTypeDeclaration)parent).getTypeSpecList();
            return specs.size() == 1 ? specs.get(0) : null;
        }
        return null;
    }

    private static void generate(@NotNull Editor editor, @NotNull GoTypeSpec typeSpec, @NotNull List<GoMemberChooserNode> selectedFieldNodes) {
        if (editor == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(10);
        }
        if (typeSpec == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(11);
        }
        if (selectedFieldNodes == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(12);
        }
        if (!typeSpec.isValid()) {
            return;
        }
        GoTypeDeclaration typeDeclaration = (GoTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)typeSpec, GoTypeDeclaration.class);
        if (typeDeclaration == null || !typeDeclaration.isValid()) {
            return;
        }
        SmartList fields = new SmartList();
        for (GoMemberChooserNode node : selectedFieldNodes) {
            PsiElement element = node.getPsiElement();
            if (!element.isValid()) {
                return;
            }
            GoNamedElement namedElement = (GoNamedElement)ObjectUtils.tryCast((Object)element, GoNamedElement.class);
            if (!GoPsiImplUtil.isFieldDefinition(namedElement) || namedElement.isBlank()) continue;
            String name = namedElement.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return;
            }
            GoType type = namedElement.getGoType(null);
            if (type == null) {
                return;
            }
            fields.add(new FieldInfo(name, type.getText()));
        }
        String typeName = typeSpec.getName();
        if (typeName == null) {
            return;
        }
        GoTemplate template = new GoTemplate(typeSpec.getContainingFile());
        template.addTextSegment("func ");
        String constructorName = typeSpec.isPublic() ? "New" + typeName : "new" + StringUtil.capitalize((String)typeName);
        template.addVariable(constructorName, true);
        GoGenerateConstructorIntention.setupFunctionParameters(template, (List<FieldInfo>)fields);
        template.addTextSegment(" *" + typeName);
        template.addTextSegment(" {\n\t");
        template.addTextSegment("\t\treturn &" + typeName);
        GoGenerateConstructorIntention.setupStructLiteralArguments(template, (List<FieldInfo>)fields);
        template.addEndVariable();
        template.addTextSegment("\n}");
        template.startTemplate(editor, typeDeclaration.getTextRange().getEndOffset(), GoBundle.message((String)"go.intention.generate.constructor.name", (Object[])new Object[0]), null);
    }

    private static void setupFunctionParameters(@NotNull GoTemplate template, @NotNull List<FieldInfo> fields) {
        if (template == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(13);
        }
        if (fields == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(14);
        }
        template.addTextSegment("(");
        for (int i = 0; i < fields.size(); ++i) {
            FieldInfo field = fields.get(i);
            template.addPrimaryVariable(GoGenerateConstructorIntention.parameterVariableName(i), (Expression)new ConstantNode(GoGenerateConstructorIntention.mapFieldName(field)));
            template.addTextSegment(" " + field.getType());
            if (i == fields.size() - 1) continue;
            template.addTextSegment(", ");
        }
        template.addTextSegment(")");
    }

    private static String mapFieldName(@NotNull FieldInfo field) {
        if (field == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(15);
        }
        String fieldName = field.getName();
        String decapitalizedFieldName = StringUtil.decapitalize((String)fieldName);
        if (ContainerUtil.find((Object[])GoParserDefinition.Lazy.KEYWORDS.getTypes(), type -> decapitalizedFieldName.equals(type.toString())) != null) {
            return fieldName;
        }
        return decapitalizedFieldName;
    }

    private static void setupStructLiteralArguments(@NotNull GoTemplate template, @NotNull List<FieldInfo> fields) {
        if (template == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(16);
        }
        if (fields == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(17);
        }
        template.addTextSegment("{");
        for (int i = 0; i < fields.size(); ++i) {
            FieldInfo field = fields.get(i);
            template.addTextSegment(field.getName() + ": ");
            template.addSecondaryVariable(GoGenerateConstructorIntention.parameterVariableName(i));
            if (i == fields.size() - 1) continue;
            template.addTextSegment(", ");
        }
        template.addTextSegment("}");
    }

    @NotNull
    @NonNls
    private static String parameterVariableName(int index) {
        String string = "PARAM" + index;
        if (string == null) {
            GoGenerateConstructorIntention.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/generate/constructor/GoGenerateConstructorIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFieldNodes";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/generate/constructor/GoGenerateConstructorIntention";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parameterVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTypeSpec";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupFunctionParameters";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mapFieldName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupStructLiteralArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    private static final class FieldInfo {
        private final String name;
        private final String type;

        private FieldInfo(@NotNull String name, @NotNull String type) {
            if (name == null) {
                FieldInfo.$$$reportNull$$$0(0);
            }
            if (type == null) {
                FieldInfo.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.type = type;
        }

        @NotNull
        private String getName() {
            String string = this.name;
            if (string == null) {
                FieldInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private String getType() {
            String string = this.type;
            if (string == null) {
                FieldInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/intentions/generate/constructor/GoGenerateConstructorIntention$FieldInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/intentions/generate/constructor/GoGenerateConstructorIntention$FieldInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

