/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.fmtstring;

import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoDecodedStringLiteralRangeConverter;
import com.goide.inspections.fmtstring.GoFmtStringUtil;
import com.goide.inspections.fmtstring.parser.GoFmtStringParser;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringBadPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringEscapedPercent;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringText;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringToken;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.intentions.fmtstring.GoAddFmtStringArgumentPopup;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.Value;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoAddFmtStringArgumentIntention
extends GoBaseIntentionAction {
    static final Key<GoCodeFragment> TEST_CODE_FRAGMENT = Key.create((String)"GoAddFmtStringArgumentIntention.TEST_CODE_FRAGMENT");
    private static final Logger LOG = Logger.getInstance(GoAddFmtStringArgumentIntention.class);

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(2);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class));
        if (file == null) {
            return false;
        }
        GoStringLiteral literal = (GoStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, GoStringLiteral.class);
        if (literal == null || !GoAddFmtStringArgumentIntention.containsOffset(literal, editor.getCaretModel().getOffset())) {
            return false;
        }
        GoFmtStringUtil.FmtFunctionInfo fmtFunctionInfo = GoFmtStringUtil.findFormattingFunction(literal);
        if (fmtFunctionInfo == null || fmtFunctionInfo.isScanFunction()) {
            return false;
        }
        GoFmtStringUtil.FmtCallArguments fmtCallArguments = fmtFunctionInfo.getFmtStringAndRestArguments();
        return fmtCallArguments != null && fmtCallArguments.getFmtString() == literal;
    }

    @Override
    protected boolean isAvailableInCodeFragment() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(4);
        }
        if (file == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(5);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(6);
        }
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        GoFile file;
        if (project == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(9);
        }
        if ((file = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class))) == null) {
            return;
        }
        GoStringLiteral literal = (GoStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, GoStringLiteral.class);
        if (literal == null || !GoAddFmtStringArgumentIntention.containsOffset(literal, editor.getCaretModel().getOffset())) {
            return;
        }
        GoFmtStringUtil.FmtFunctionInfo fmtFunctionInfo = GoFmtStringUtil.findFormattingFunction(literal);
        if (fmtFunctionInfo == null || fmtFunctionInfo.isScanFunction()) {
            return;
        }
        GoFmtStringUtil.FmtCallArguments fmtCallArguments = fmtFunctionInfo.getFmtStringAndRestArguments();
        if (fmtCallArguments == null || fmtCallArguments.getFmtString() != literal) {
            return;
        }
        if (fmtFunctionInfo.getCallExpression().getArgumentList().isVariadic()) {
            GoAddFmtStringArgumentIntention.showErrorHint(project, editor, GoBundle.message((String)"go.intention.fmt.string.argument.variadic.arg.error.message", (Object[])new Object[0]));
            return;
        }
        List<GoFmtStringToken> tokens = GoFmtStringUtil.parse(literal);
        if (ContainerUtil.or(tokens, t1 -> t1 instanceof GoFmtStringBadPlaceholder)) {
            GoAddFmtStringArgumentIntention.showErrorHint(project, editor, GoBundle.message((String)"go.intention.fmt.string.argument.syntax.error.message", (Object[])new Object[0]));
            return;
        }
        if (ContainerUtil.or(tokens, t -> t instanceof GoFmtStringEscapedPercent && !"%%".equals(t.getText()))) {
            GoAddFmtStringArgumentIntention.showErrorHint(project, editor, GoBundle.message((String)"go.intention.fmt.string.argument.percent.with.args.error.message", (Object[])new Object[0]));
            return;
        }
        if (GoFmtStringUtil.hasExplicitIndices(GoFmtStringUtil.filterPlaceholders(tokens))) {
            GoAddFmtStringArgumentIntention.showErrorHint(project, editor, GoBundle.message((String)"go.intention.fmt.string.argument.explicit.indices.error.message", (Object[])new Object[0]));
            return;
        }
        int caretOffsetInRawLiteral = editor.getCaretModel().getOffset() - literal.getTextOffset();
        if (caretOffsetInRawLiteral < 0) {
            return;
        }
        int newPlaceholderIndex = GoAddFmtStringArgumentIntention.getNewPlaceholderIndex(literal, tokens, caretOffsetInRawLiteral);
        if (newPlaceholderIndex < 0) {
            GoAddFmtStringArgumentIntention.showErrorHint(project, editor, GoBundle.message((String)"go.intention.fmt.string.argument.bad.position.error.message", (Object[])new Object[0]));
            return;
        }
        PsiElement anchor = GoAddFmtStringArgumentIntention.findElementBeforeNewArgument(fmtCallArguments.getRestArguments(), literal, caretOffsetInRawLiteral, newPlaceholderIndex);
        if (anchor == null) {
            GoAddFmtStringArgumentIntention.showErrorHint(project, editor, GoBundle.message((String)"go.intention.fmt.string.argument.too.few.arguments.error.message", (Object[])new Object[0]));
            return;
        }
        GoCodeFragment codeFragment = GoCodeFragment.createExpression(element.getProject(), "", true, element, true);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            GoCodeFragment testCodeFragment = (GoCodeFragment)((Object)ObjectUtils.notNull((Object)((Object)((GoCodeFragment)((Object)TestModeFlags.get(TEST_CODE_FRAGMENT)))), (Object)((Object)codeFragment)));
            this.addFmtStringArgument(project, editor, testCodeFragment, file, fmtFunctionInfo.getCallExpression(), literal, caretOffsetInRawLiteral, anchor);
            return;
        }
        GoAddFmtStringArgumentPopup.show(editor, project, codeFragment, () -> this.addFmtStringArgument(project, editor, codeFragment, file, fmtFunctionInfo.getCallExpression(), literal, caretOffsetInRawLiteral, anchor));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.add.fmt.string.argument.name", (Object[])new Object[0]);
        if (string == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean containsOffset(@NotNull GoStringLiteral element, int offset) {
        if (element == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(12);
        }
        return ElementManipulators.getValueTextRange((PsiElement)element).shiftRight(element.getTextOffset()).containsOffset(offset);
    }

    private static int getNewPlaceholderIndex(@NotNull GoStringLiteral literal, @NotNull List<GoFmtStringToken> tokens, int offsetInLiteral) {
        if (literal == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(13);
        }
        if (tokens == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(14);
        }
        GoDecodedStringLiteralRangeConverter converter = new GoDecodedStringLiteralRangeConverter(literal);
        SmartList placeholdersRanges = new SmartList();
        for (GoFmtStringToken token : tokens) {
            TextRange range2 = converter.computeRange(token.getStart(), token.getEnd());
            if (range2 == null) {
                LOG.error("failed to compute non text token range");
                return -1;
            }
            if (!(token instanceof GoFmtStringText) && range2.getStartOffset() < offsetInLiteral && offsetInLiteral < range2.getEndOffset()) {
                return -1;
            }
            if (!(token instanceof GoFmtStringPlaceholder)) continue;
            placeholdersRanges.add(range2);
        }
        return ContainerUtil.lastIndexOf((List)placeholdersRanges, range -> range.getEndOffset() <= offsetInLiteral) + 1;
    }

    @Nullable
    private static PsiElement findElementBeforeNewArgument(@NotNull List<GoExpression> argsAfterFmtString, @NotNull GoStringLiteral literal, int caretOffsetInRawLiteral, int newPlaceholderIndex) {
        GoStringLiteral literalWithDummyPlaceholder;
        Value value;
        String fmtStringWithDummyPlaceholder;
        if (argsAfterFmtString == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(15);
        }
        if (literal == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(16);
        }
        String string = fmtStringWithDummyPlaceholder = (value = (literalWithDummyPlaceholder = GoAddFmtStringArgumentIntention.insertPlaceholder(literal, "%v", caretOffsetInRawLiteral)).getValue()) != null ? value.getString() : null;
        if (fmtStringWithDummyPlaceholder == null) {
            throw new IllegalStateException("failed to get updated fmt string value");
        }
        int newPlaceholderArgumentIndex = GoAddFmtStringArgumentIntention.getArgumentIndexForPlaceholderVerb(fmtStringWithDummyPlaceholder, newPlaceholderIndex);
        return newPlaceholderArgumentIndex == 0 ? literal : (PsiElement)ContainerUtil.getOrElse(argsAfterFmtString, (int)(newPlaceholderArgumentIndex - 1), null);
    }

    @NotNull
    private static GoStringLiteral insertPlaceholder(@NotNull GoStringLiteral literal, @NonNls @NotNull String placeholderText, int caretOffsetInRawLiteral) {
        String rawLiteralText;
        if (literal == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(17);
        }
        if (placeholderText == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(18);
        }
        if ((rawLiteralText = literal.getText()).length() <= caretOffsetInRawLiteral) {
            throw new IllegalArgumentException("caret offset in raw literal is incorrect");
        }
        String rawLiteralTextPlaceholder = new StringBuilder(rawLiteralText).insert(caretOffsetInRawLiteral, placeholderText).toString();
        GoStringLiteral goStringLiteral = GoElementFactory.createStringLiteral(literal.getProject(), rawLiteralTextPlaceholder);
        if (goStringLiteral == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(19);
        }
        return goStringLiteral;
    }

    private static int getArgumentIndexForPlaceholderVerb(@NotNull String fmtString, int placeholderIndex) {
        List<GoFmtStringToken> tokens;
        List<GoFmtStringPlaceholder> placeholders;
        if (fmtString == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(20);
        }
        if (placeholderIndex >= (placeholders = GoFmtStringUtil.filterPlaceholders(tokens = GoFmtStringParser.parse(fmtString))).size()) {
            throw new IllegalArgumentException("Placeholder index is incorrect. Fmt string: " + fmtString + ", index: " + placeholderIndex);
        }
        return GoFmtStringUtil.operandsIndices(placeholders).get(placeholderIndex).getVerbIndex();
    }

    private void addFmtStringArgument(@NotNull Project project, @NotNull Editor editor, @NotNull GoCodeFragment codeFragment, @NotNull GoFile file, @NotNull GoCallExpr callExpression, @NotNull GoStringLiteral literal, int caretOffsetInRawLiteral, @NotNull PsiElement elementBeforeNewArgument) {
        if (project == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(22);
        }
        if (codeFragment == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(23);
        }
        if (file == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(24);
        }
        if (callExpression == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(25);
        }
        if (literal == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(26);
        }
        if (elementBeforeNewArgument == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(27);
        }
        if (!(file.isValid() && callExpression.isValid() && literal.isValid() && elementBeforeNewArgument.isValid())) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> {
            GoExpression expression = codeFragment.getExpression();
            if (expression == null) {
                return;
            }
            PsiElement comma = callExpression.getArgumentList().addAfter(GoElementFactory.createComma(project), elementBeforeNewArgument);
            callExpression.getArgumentList().addAfter(expression, comma);
            GoFormatterUtil.reformat(callExpression.getArgumentList());
            String newPlaceholderText = GoAddFmtStringArgumentIntention.getPlaceholderText(expression.getGoType(null), expression);
            int finalCaretPosition = literal.getTextOffset() + caretOffsetInRawLiteral + newPlaceholderText.length();
            GoStringLiteral newLiteral = GoAddFmtStringArgumentIntention.insertPlaceholder(literal, newPlaceholderText, caretOffsetInRawLiteral);
            literal.replace(newLiteral);
            editor.getCaretModel().moveToOffset(finalCaretPosition);
            for (GoImportSpec importSpec : codeFragment.getImports()) {
                file.addImport(importSpec.getPath(), importSpec.getAlias());
            }
        }, (PsiFile[])new PsiFile[]{file});
    }

    @NotNull
    @NonNls
    private static String getPlaceholderText(@Nullable GoType type, @Nullable PsiElement context) {
        if (type == null) {
            return "%v";
        }
        if (type instanceof GoLightType.LightUntypedType || GoPsiImplUtil.builtin(type.resolve(context))) {
            if (GoTypeUtil.isString(type, context)) {
                return "%s";
            }
            if (GoTypeUtil.isIntegerType(type, context)) {
                return "%d";
            }
            if (GoTypeUtil.isBoolean(type, context)) {
                return "%t";
            }
            if (GoTypeUtil.isFloatType(type, context)) {
                return "%g";
            }
            return "%v";
        }
        return type instanceof GoPointerType || type instanceof GoChannelType ? "%p" : "%v";
    }

    private static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String message) {
        if (project == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(28);
        }
        if (editor == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(29);
        }
        if (message == null) {
            GoAddFmtStringArgumentIntention.$$$reportNull$$$0(30);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)GoBundle.message((String)"go.intention.fmt.string.title.error.message", (Object[])new Object[0]), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 11, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/fmtstring/GoAddFmtStringArgumentIntention";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argsAfterFmtString";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholderText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fmtString";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementBeforeNewArgument";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/fmtstring/GoAddFmtStringArgumentIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "insertPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 19: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsOffset";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNewPlaceholderIndex";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findElementBeforeNewArgument";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertPlaceholder";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentIndexForPlaceholderVerb";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addFmtStringArgument";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 11, 19 -> new IllegalStateException(string);
        };
    }
}

