/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions.declarations;

import com.goide.GoTypes;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoIotaUtil;
import com.goide.refactor.util.GoCommentsHolder;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.IntPredicate;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRefactorDeclarationsUtil {
    @NotNull
    static GoCommentsHolder<PsiElement> createDeclaration(@NotNull Project project, @NotNull List<GoCommentsHolder<PsiElement>> specs, @NotNull DeclarationInfo declarationInfo) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(0);
        }
        if (specs == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(1);
        }
        if (declarationInfo == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(2);
        }
        return GoRefactorDeclarationsUtil.createDeclaration(project, specs, declarationInfo, false);
    }

    @NotNull
    static GoCommentsHolder<PsiElement> createDeclaration(@NotNull Project project, @NotNull List<GoCommentsHolder<PsiElement>> specs, @NotNull DeclarationInfo declarationInfo, boolean wrapSingleSpecInParens) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(3);
        }
        if (specs == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(4);
        }
        if (declarationInfo == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(5);
        }
        if (specs.isEmpty()) {
            throw new IllegalArgumentException("Cannot create declaration from empty group of specs");
        }
        if (specs.size() == 1 && !wrapSingleSpecInParens) {
            GoCommentsHolder<PsiElement> spec = specs.get(0);
            PsiElement newDeclaration = GoRefactorDeclarationsUtil.createDeclaration(project, declarationInfo.type, spec.getElement().getText(), false, declarationInfo.isTopLevel);
            GoCommentsHolder<PsiElement> goCommentsHolder = GoCommentsHolder.withComments(spec.getUpperComments(), newDeclaration, spec.getAfterComments());
            if (goCommentsHolder == null) {
                GoRefactorDeclarationsUtil.$$$reportNull$$$0(6);
            }
            return goCommentsHolder;
        }
        PsiElement newDeclaration = GoRefactorDeclarationsUtil.createDeclaration(project, declarationInfo.type, GoRefactorDeclarationsUtil.join(specs), true, declarationInfo.isTopLevel);
        GoCommentsHolder<PsiElement> goCommentsHolder = GoCommentsHolder.elementOnly(newDeclaration);
        if (goCommentsHolder == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(7);
        }
        return goCommentsHolder;
    }

    @NotNull
    private static PsiElement createDeclaration(@NotNull Project project, @NotNull IElementType type, @NotNull String specsText, boolean withParens, boolean isTopLevel) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(8);
        }
        if (type == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(9);
        }
        if (specsText == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(10);
        }
        String typeText = type == GoTypes.CONST ? "const" : (type == GoTypes.VAR ? "var" : "type");
        String text = withParens ? String.format("%s (\n%s\n)", typeText, specsText) : typeText + " " + specsText;
        GoStatement statement = GoElementFactory.createStatement(project, text);
        GoStatement goStatement = isTopLevel ? (PsiElement)Objects.requireNonNull((GoTopLevelDeclaration)PsiTreeUtil.findChildOfType((PsiElement)statement, GoTopLevelDeclaration.class)) : statement;
        if (goStatement == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(11);
        }
        return goStatement;
    }

    @NotNull
    private static String join(@NotNull List<GoCommentsHolder<PsiElement>> elements) {
        if (elements == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(12);
        }
        StringBuilder sb = new StringBuilder();
        elements.forEach(element -> {
            element.getUpperComments().forEach(c -> sb.append(c.getText()).append('\n'));
            sb.append(element.getElement().getText());
            element.getAfterComments().forEach(c -> sb.append(c.getText()).append(' '));
            sb.append('\n');
        });
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        String string = sb.toString();
        if (string == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    static DeclarationInfo findDeclaration(@NotNull PsiElement context) {
        PsiElement parent;
        if (context == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(14);
        }
        if (!((parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{GoTypeDeclaration.class, GoVarOrConstDeclaration.class, GoStatement.class, GoFunctionLit.class})) instanceof GoTypeDeclaration) && !(parent instanceof GoVarOrConstDeclaration)) {
            return null;
        }
        PsiElement grand = parent.getParent();
        PsiElement declaration = grand instanceof GoStatement ? grand : parent;
        return GoRefactorDeclarationsUtil.declarationInfo(declaration);
    }

    static boolean isWhiteSpaceOrCommentOrSemicolon(@NotNull PsiElement element) {
        if (element == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(15);
        }
        return element instanceof PsiWhiteSpace || element instanceof PsiComment || element.getNode().getElementType() == GoTypes.SEMICOLON;
    }

    @Nullable
    static PsiElement findDeclarationIfStatement(@NotNull PsiElement element) {
        if (element == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(16);
        }
        return element instanceof GoStatement ? PsiTreeUtil.findChildOfType((PsiElement)element, GoTopLevelDeclaration.class) : element;
    }

    static void mergeDeclarations(@NotNull Project project, Editor editor, @NotNull Collection<PsiElement> declarations) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(17);
        }
        if (declarations == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(18);
        }
        GoRefactorDeclarationsUtil.mergeDeclarations(project, editor, declarations, false);
    }

    static void mergeDeclarations(@NotNull Project project, Editor editor, @NotNull Collection<PsiElement> declarations, boolean preview) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(19);
        }
        if (declarations == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(20);
        }
        List declarationInfos = ContainerUtil.map(declarations, GoRefactorDeclarationsUtil::declarationInfo);
        List allButFirst = ContainerUtil.subList((List)declarationInfos, (int)1);
        if (!preview && ContainerUtil.or((Iterable)allButFirst, declaration -> GoRefactorDeclarationsUtil.constDeclarationHasSpecWithIotaInitializers(declaration, 0)) && GoRefactorDeclarationsUtil.userCancelsMerge(project)) {
            return;
        }
        IntentionPreviewUtils.write(() -> GoRefactorDeclarationsUtil.doMerge(project, editor, declarationInfos));
    }

    private static void doMerge(@NotNull Project project, @NotNull Editor editor, @NotNull List<DeclarationInfo> declarationInfos) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(22);
        }
        if (declarationInfos == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(23);
        }
        SmartList upperComments = new SmartList();
        SmartList mergedSpecs = new SmartList();
        for (DeclarationInfo declarationInfo : declarationInfos) {
            if (declarationInfo.wrappedInParens) {
                upperComments.addAll(GoDocumentationProvider.getUpperComments(declarationInfo.originalElement));
                declarationInfo.specs.forEach(arg_0 -> GoRefactorDeclarationsUtil.lambda$doMerge$5((List)mergedSpecs, arg_0));
                continue;
            }
            PsiElement singleSpec = (PsiElement)ContainerUtil.getFirstItem(declarationInfo.specs);
            if (singleSpec == null) continue;
            mergedSpecs.add(GoCommentsHolder.create(singleSpec, declarationInfo.originalElement));
        }
        DeclarationInfo firstDeclaration = Objects.requireNonNull((DeclarationInfo)ContainerUtil.getFirstItem(declarationInfos));
        DeclarationInfo lastDeclaration = Objects.requireNonNull((DeclarationInfo)ContainerUtil.getLastItem(declarationInfos));
        GoCommentsHolder<PsiElement> newDeclaration = GoCommentsHolder.withUpperComments((List<PsiComment>)upperComments, GoRefactorDeclarationsUtil.createDeclaration(project, (List<GoCommentsHolder<PsiElement>>)mergedSpecs, firstDeclaration).getElement());
        GoRefactorDeclarationsUtil.replace(editor, firstDeclaration.originalElement, lastDeclaration.originalElement, newDeclaration);
    }

    private static void replace(@NotNull Editor editor, @NotNull PsiElement firstChild, @NotNull PsiElement lastChild, @NotNull GoCommentsHolder<PsiElement> newChild) {
        if (editor == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(24);
        }
        if (firstChild == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(25);
        }
        if (lastChild == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(26);
        }
        if (newChild == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(27);
        }
        GoRefactoringUtil.withVerticalScrollingSaved(editor, () -> {
            PsiElement first = (PsiElement)ContainerUtil.getFirstItem(GoDocumentationProvider.getUpperComments(firstChild), (Object)firstChild);
            PsiElement last = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ContainerUtil.getLastItem(GoDocumentationProvider.getAfterComments(lastChild))), (Object)lastChild);
            List<PsiElement> added = newChild.addBefore(first);
            first.getParent().deleteChildRange(first, last);
            if (!added.isEmpty()) {
                GoFormatterUtil.reformat(added.get(0).getContainingFile(), added);
                editor.getCaretModel().moveToOffset(added.get(0).getTextOffset());
            }
        });
    }

    static boolean cancelSplitDueToIotaInitializers(@NotNull DeclarationInfo declarationInfo, int indexOfTheFirstSpecToCheck, @NotNull Project project) {
        if (declarationInfo == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(28);
        }
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(29);
        }
        return GoRefactorDeclarationsUtil.constDeclarationHasSpecWithIotaInitializers(declarationInfo, indexOfTheFirstSpecToCheck) && GoRefactorDeclarationsUtil.userCancelsSplit(project);
    }

    private static boolean constDeclarationHasSpecWithIotaInitializers(@NotNull DeclarationInfo declarationInfo, int indexOfTheFirstSpecToCheck) {
        if (declarationInfo == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(30);
        }
        return declarationInfo.type == GoTypes.CONST && GoRefactorDeclarationsUtil.haveIotaInitializers(declarationInfo.specs, indexOfTheFirstSpecToCheck);
    }

    private static boolean haveIotaInitializers(@NotNull List<? extends PsiElement> constSpecElements, int checkFromIndex) {
        if (constSpecElements == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(31);
        }
        List targetElements = ContainerUtil.subList(constSpecElements, (int)checkFromIndex);
        List<GoConstSpec> constSpecs = GoRefactorDeclarationsUtil.asConstSpecs(targetElements);
        return ContainerUtil.or(constSpecs, spec -> GoRefactorDeclarationsUtil.containsIotaInitializers(spec.getExpressionList()));
    }

    @NotNull
    private static List<GoConstSpec> asConstSpecs(@NotNull List<? extends PsiElement> constSpecElements) {
        List constSpecs;
        if (constSpecElements == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(32);
        }
        if ((constSpecs = ContainerUtil.mapNotNull(constSpecElements, s -> (GoConstSpec)ObjectUtils.tryCast((Object)s, GoConstSpec.class))).size() != constSpecElements.size()) {
            throw new IllegalArgumentException("Expecting PSI elements that hold GoConstSpec");
        }
        List list = constSpecs;
        if (list == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(33);
        }
        return list;
    }

    static boolean containsIotaInitializers(@NotNull List<GoExpression> initializers) {
        if (initializers == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(34);
        }
        return ContainerUtil.or(initializers, GoIotaUtil::containsIota);
    }

    static boolean userCancelsSplit(@NotNull Project project) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(35);
        }
        return GoRefactorDeclarationsUtil.userCancelsAction(project, GoBundle.message((String)"go.refactoring.split.declarations.action.text", (Object[])new Object[0]), GoBundle.message((String)"go.refactoring.split.declarations.with.iota.warning", (Object[])new Object[0]));
    }

    static boolean userCancelsMerge(@NotNull Project project) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(36);
        }
        return GoRefactorDeclarationsUtil.userCancelsAction(project, GoBundle.message((String)"go.refactoring.merge.declarations.action.text", (Object[])new Object[0]), GoBundle.message((String)"go.refactoring.merge.declarations.with.iota.warning", (Object[])new Object[0]));
    }

    private static boolean userCancelsAction(@NotNull Project project, @Nls @NotNull String actionName, @Nls @NotNull String question) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(37);
        }
        if (actionName == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(38);
        }
        if (question == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(39);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new CommonRefactoringUtil.RefactoringErrorHintException(actionName);
        }
        return Messages.showYesNoDialog((Project)project, (String)question, (String)actionName, (String)RefactoringBundle.message((String)"continue.button"), (String)RefactoringBundle.message((String)"cancel.button"), (Icon)Messages.getWarningIcon()) != 0;
    }

    @NotNull
    static List<GoCommentsHolder<PsiElement>> split(@NotNull DeclarationInfo declarationInfo, @NotNull IntPredicate isSplitPoint) {
        if (declarationInfo == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(40);
        }
        if (isSplitPoint == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(41);
        }
        SmartList newDeclarations = new SmartList();
        SmartList currentGroup = new SmartList();
        Project project = declarationInfo.originalElement.getProject();
        for (int i = 0; i < declarationInfo.specs.size(); ++i) {
            currentGroup.add(GoCommentsHolder.create(declarationInfo.specs.get(i)));
            if (!isSplitPoint.test(i)) continue;
            newDeclarations.add(GoRefactorDeclarationsUtil.createDeclaration(project, (List<GoCommentsHolder<PsiElement>>)currentGroup, declarationInfo));
            currentGroup.clear();
        }
        if (!currentGroup.isEmpty()) {
            newDeclarations.add(GoRefactorDeclarationsUtil.createDeclaration(project, (List<GoCommentsHolder<PsiElement>>)currentGroup, declarationInfo));
        }
        SmartList smartList = newDeclarations;
        if (smartList == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(42);
        }
        return smartList;
    }

    static void replace(@NotNull Editor editor, @NotNull PsiElement oldElement, @NotNull List<GoCommentsHolder<PsiElement>> newElements, int elementIndexToMoveCaretTo) {
        if (editor == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(43);
        }
        if (oldElement == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(44);
        }
        if (newElements == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(45);
        }
        GoRefactoringUtil.withVerticalScrollingSaved(editor, () -> {
            PsiFile file = oldElement.getContainingFile();
            List<List<PsiElement>> addedGroups = GoRefactorDeclarationsUtil.replace(oldElement, newElements);
            GoFormatterUtil.reformat(file, ContainerUtil.concat(addedGroups));
            PsiElement caretTarget = (PsiElement)ContainerUtil.getFirstItem((List)((List)ContainerUtil.getOrElse(addedGroups, (int)elementIndexToMoveCaretTo, null)));
            if (caretTarget != null) {
                editor.getCaretModel().moveToOffset(caretTarget.getTextOffset());
            }
        });
    }

    @NotNull
    private static List<List<PsiElement>> replace(@NotNull PsiElement oldElement, @NotNull List<GoCommentsHolder<PsiElement>> newElements) {
        if (oldElement == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(46);
        }
        if (newElements == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(47);
        }
        Project project = oldElement.getProject();
        PsiElement parent = oldElement.getParent();
        SmartList added = new SmartList();
        for (int i = 0; i < newElements.size(); ++i) {
            added.add(newElements.get(i).addBefore(oldElement));
            if (i == newElements.size() - 1) continue;
            parent.addBefore(GoElementFactory.createNewLine(project), oldElement);
        }
        oldElement.delete();
        SmartList smartList = added;
        if (smartList == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(48);
        }
        return smartList;
    }

    @NotNull
    private static DeclarationInfo declarationInfo(@NotNull PsiElement declaration) {
        boolean isTopLevel;
        PsiElement unwrapped;
        GoConstDeclaration constDeclaration;
        if (declaration == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(49);
        }
        if ((constDeclaration = (GoConstDeclaration)ObjectUtils.tryCast((Object)(unwrapped = (isTopLevel = !(declaration instanceof GoStatement)) ? declaration : PsiTreeUtil.findChildOfType((PsiElement)declaration, GoTopLevelDeclaration.class)), GoConstDeclaration.class)) != null) {
            return new DeclarationInfo(declaration, GoTypes.CONST, constDeclaration.getLparen() != null, constDeclaration.getConstSpecList(), isTopLevel);
        }
        GoVarDeclaration varDeclaration = (GoVarDeclaration)ObjectUtils.tryCast((Object)unwrapped, GoVarDeclaration.class);
        if (varDeclaration != null) {
            return new DeclarationInfo(declaration, GoTypes.VAR, varDeclaration.getLparen() != null, varDeclaration.getVarSpecList(), isTopLevel);
        }
        GoTypeDeclaration typeDeclaration = (GoTypeDeclaration)ObjectUtils.tryCast((Object)unwrapped, GoTypeDeclaration.class);
        if (typeDeclaration != null) {
            return new DeclarationInfo(declaration, GoTypes.TYPE_, typeDeclaration.getLparen() != null, typeDeclaration.getTypeSpecList(), isTopLevel);
        }
        throw new IllegalArgumentException(String.format("Declaration expected, found: %s (%s)", declaration.getText(), declaration.getClass().getName()));
    }

    @Nullable
    static VarOrConstSpecInfo findVarOrConst(@Nullable PsiElement context) {
        VarOrConstSpecInfo.Type type;
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{GoVarOrConstSpec.class, GoStatement.class, GoFunctionLit.class});
        GoVarOrConstSpec spec = (GoVarOrConstSpec)ObjectUtils.tryCast((Object)parent, GoVarOrConstSpec.class);
        if (spec == null) {
            return null;
        }
        if (spec instanceof GoShortVarDeclaration) {
            PsiElement grand = spec.getParent();
            return grand instanceof GoStatement ? new VarOrConstSpecInfo(grand, VarOrConstSpecInfo.Type.SHORT_VAR, spec) : null;
        }
        GoVarOrConstDeclaration declaration = (GoVarOrConstDeclaration)ObjectUtils.tryCast((Object)spec.getParent(), GoVarOrConstDeclaration.class);
        if (declaration == null) {
            return null;
        }
        VarOrConstSpecInfo.Type type2 = type = spec instanceof GoVarSpec ? VarOrConstSpecInfo.Type.VAR : VarOrConstSpecInfo.Type.CONST;
        if (declaration.getLparen() != null) {
            return new VarOrConstSpecInfo(spec, type, spec);
        }
        PsiElement grandGrand = declaration.getParent();
        return new VarOrConstSpecInfo((PsiElement)(grandGrand instanceof GoStatement ? grandGrand : declaration), type, spec);
    }

    @Nullable
    static VarOrConstSpecInfo findVarOrConstWithSimilarInfo(@NotNull PsiElement topLevelElement, @NotNull VarOrConstSpecInfo specInfo) {
        if (topLevelElement == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(50);
        }
        if (specInfo == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(51);
        }
        if (specInfo.type == VarOrConstSpecInfo.Type.SHORT_VAR) {
            GoSimpleStatement statement = (GoSimpleStatement)ObjectUtils.tryCast((Object)topLevelElement, GoSimpleStatement.class);
            GoShortVarDeclaration declaration = statement != null ? statement.getShortVarDeclaration() : null;
            return declaration != null ? new VarOrConstSpecInfo(statement, VarOrConstSpecInfo.Type.SHORT_VAR, declaration) : null;
        }
        if (specInfo.isFromParenthesizedDeclaration() && topLevelElement instanceof GoVarOrConstSpec) {
            return new VarOrConstSpecInfo(topLevelElement, specInfo.type, (GoVarOrConstSpec)topLevelElement);
        }
        if (specInfo.isFromLocalDeclaration() && topLevelElement instanceof GoStatement || specInfo.isFromTopLevelDeclaration() && topLevelElement instanceof GoTopLevelDeclaration) {
            GoVarOrConstDeclaration declaration;
            GoVarOrConstSpec spec = (GoVarOrConstSpec)PsiTreeUtil.findChildOfType((PsiElement)topLevelElement, GoVarOrConstSpec.class);
            GoVarOrConstDeclaration goVarOrConstDeclaration = declaration = spec != null ? (GoVarOrConstDeclaration)ObjectUtils.tryCast((Object)spec.getParent(), GoVarOrConstDeclaration.class) : null;
            if (declaration == null || declaration.getLparen() != null || declaration.getSpecList().size() > 1) {
                return null;
            }
            return specInfo.spec.getClass().isInstance(spec) ? new VarOrConstSpecInfo(topLevelElement, specInfo.type, spec) : null;
        }
        return null;
    }

    @NotNull
    static PsiElement createDeclaration(@NotNull Project project, @NotNull List<? extends GoVarOrConstDefinition> definitions, @NotNull List<GoExpression> initializers, @NotNull VarOrConstSpecInfo specInfo) {
        if (project == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(52);
        }
        if (definitions == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(53);
        }
        if (initializers == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(54);
        }
        if (specInfo == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(55);
        }
        String leftSide = StringUtil.join(definitions, PsiElement::getText, (String)", ");
        String rightSide = StringUtil.join(initializers, PsiElement::getText, (String)", ");
        if (specInfo.type == VarOrConstSpecInfo.Type.SHORT_VAR) {
            GoStatement goStatement = GoElementFactory.createShortVarDeclarationStatement(project, leftSide, rightSide);
            if (goStatement == null) {
                GoRefactorDeclarationsUtil.$$$reportNull$$$0(56);
            }
            return goStatement;
        }
        String keyword = specInfo.type == VarOrConstSpecInfo.Type.VAR ? "var" : "const";
        GoType declarationType = specInfo.spec.getType();
        String declarationTypeText = declarationType != null ? declarationType.getText() : "";
        String declarationText = rightSide.isEmpty() ? String.format("%s %s %s", keyword, leftSide, declarationTypeText) : String.format("%s %s %s = %s", keyword, leftSide, declarationTypeText, rightSide);
        GoStatement statement = GoElementFactory.createStatement(project, declarationText);
        if (specInfo.isFromParenthesizedDeclaration()) {
            PsiElement psiElement = Objects.requireNonNull((GoVarOrConstSpec)PsiTreeUtil.findChildOfType((PsiElement)statement, GoVarOrConstSpec.class));
            if (psiElement == null) {
                GoRefactorDeclarationsUtil.$$$reportNull$$$0(57);
            }
            return psiElement;
        }
        if (specInfo.isFromTopLevelDeclaration()) {
            PsiElement psiElement = Objects.requireNonNull((GoTopLevelDeclaration)PsiTreeUtil.findChildOfType((PsiElement)statement, GoTopLevelDeclaration.class));
            if (psiElement == null) {
                GoRefactorDeclarationsUtil.$$$reportNull$$$0(58);
            }
            return psiElement;
        }
        GoStatement goStatement = statement;
        if (goStatement == null) {
            GoRefactorDeclarationsUtil.$$$reportNull$$$0(59);
        }
        return goStatement;
    }

    private static /* synthetic */ void lambda$doMerge$5(List mergedSpecs, PsiElement spec) {
        mergedSpecs.add(GoCommentsHolder.create(spec));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 11, 13, 33, 42, 48, 56, 57, 58, 59 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specs";
                break;
            }
            case 2: 
            case 5: 
            case 28: 
            case 30: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationInfo";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 33: 
            case 42: 
            case 48: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/declarations/GoRefactorDeclarationsUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specsText";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 22: 
            case 24: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationInfos";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastChild";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constSpecElements";
                break;
            }
            case 34: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializers";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "question";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSplitPoint";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelElement";
                break;
            }
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specInfo";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/declarations/GoRefactorDeclarationsUtil";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeclaration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "asConstSpecs";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDeclaration";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 33: 
            case 42: 
            case 48: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaration";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isWhiteSpaceOrCommentOrSemicolon";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarationIfStatement";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mergeDeclarations";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doMerge";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "cancelSplitDueToIotaInitializers";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "constDeclarationHasSpecWithIotaInitializers";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "haveIotaInitializers";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "asConstSpecs";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "containsIotaInitializers";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "userCancelsSplit";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "userCancelsMerge";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "userCancelsAction";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "declarationInfo";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findVarOrConstWithSimilarInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 11, 13, 33, 42, 48, 56, 57, 58, 59 -> new IllegalStateException(string);
        };
    }

    static final class DeclarationInfo {
        final PsiElement originalElement;
        final IElementType type;
        final boolean wrappedInParens;
        final List<? extends PsiElement> specs;
        final boolean isTopLevel;

        private DeclarationInfo(@NotNull PsiElement originalElement, @NotNull IElementType type, boolean wrappedInParens, @NotNull List<? extends PsiElement> specs, boolean isTopLevel) {
            if (originalElement == null) {
                DeclarationInfo.$$$reportNull$$$0(0);
            }
            if (type == null) {
                DeclarationInfo.$$$reportNull$$$0(1);
            }
            if (specs == null) {
                DeclarationInfo.$$$reportNull$$$0(2);
            }
            this.originalElement = originalElement;
            this.type = type;
            this.wrappedInParens = wrappedInParens;
            this.specs = specs;
            this.isTopLevel = isTopLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "specs";
                    break;
                }
            }
            objectArray[1] = "com/goide/intentions/declarations/GoRefactorDeclarationsUtil$DeclarationInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class VarOrConstSpecInfo {
        final PsiElement topLevelElement;
        final Type type;
        final GoVarOrConstSpec<?> spec;

        private VarOrConstSpecInfo(@NotNull PsiElement topLevelElement, @NotNull Type type, @NotNull GoVarOrConstSpec<?> spec) {
            if (topLevelElement == null) {
                VarOrConstSpecInfo.$$$reportNull$$$0(0);
            }
            if (type == null) {
                VarOrConstSpecInfo.$$$reportNull$$$0(1);
            }
            if (spec == null) {
                VarOrConstSpecInfo.$$$reportNull$$$0(2);
            }
            this.topLevelElement = topLevelElement;
            this.type = type;
            this.spec = spec;
        }

        @NotNull
        List<? extends GoVarOrConstDefinition> getDefinitionList() {
            if (this.spec instanceof GoVarSpec) {
                List<GoVarDefinition> list = ((GoVarSpec)this.spec).getDefinitionList();
                if (list == null) {
                    VarOrConstSpecInfo.$$$reportNull$$$0(3);
                }
                return list;
            }
            if (this.spec instanceof GoConstSpec) {
                List<GoConstDefinition> list = ((GoConstSpec)this.spec).getDefinitionList();
                if (list == null) {
                    VarOrConstSpecInfo.$$$reportNull$$$0(4);
                }
                return list;
            }
            throw new IllegalArgumentException("Unexpected subclass of GoVarOrConstSpec");
        }

        boolean isFromParenthesizedDeclaration() {
            return this.topLevelElement instanceof GoVarOrConstSpec;
        }

        boolean isFromTopLevelDeclaration() {
            return this.topLevelElement instanceof GoTopLevelDeclaration;
        }

        boolean isFromLocalDeclaration() {
            return this.topLevelElement instanceof GoStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topLevelElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spec";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/intentions/declarations/GoRefactorDeclarationsUtil$VarOrConstSpecInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/intentions/declarations/GoRefactorDeclarationsUtil$VarOrConstSpecInfo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefinitionList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }

        static enum Type {
            VAR,
            CONST,
            SHORT_VAR;

        }
    }
}

