/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.execution.testing.creator.GoStringBuilder;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonNullLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoJsonTypeGenerator {
    private static final Pattern RFC3339 = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(\\.\\d+)?(Z|[+-]\\d\\d:\\d\\d)");
    private final GoFile myFile;
    private String myTimeQualifier;

    public GoJsonTypeGenerator() {
        this.myFile = null;
    }

    public GoJsonTypeGenerator(@NotNull PsiElement context) {
        if (context == null) {
            GoJsonTypeGenerator.$$$reportNull$$$0(0);
        }
        this.myFile = (GoFile)((Object)ObjectUtils.tryCast((Object)context.getContainingFile(), GoFile.class));
    }

    private String getTimePackageQualifier() {
        if (this.myFile == null) {
            return "time";
        }
        if (this.myTimeQualifier != null) {
            return this.myTimeQualifier;
        }
        GoImportSpec timeImportSpec = this.myFile.getImportedPackagesMap().get("time");
        if (timeImportSpec != null && !timeImportSpec.isForSideEffects()) {
            String alias = timeImportSpec.getAlias();
            this.myTimeQualifier = alias != null ? alias : "time";
            return this.myTimeQualifier;
        }
        return "time";
    }

    @NotNull
    public String generate(@NotNull JsonValue val) {
        if (val == null) {
            GoJsonTypeGenerator.$$$reportNull$$$0(1);
        }
        GoStringBuilder text = new GoStringBuilder();
        text.append("package main\n\n");
        text.append("type T ");
        JsonNode rootNode = new JsonNode();
        GoJsonTypeGenerator.buildJsonOutline(rootNode, val);
        JsonNode topLevelNode = rootNode.getChild();
        if (topLevelNode != null && topLevelNode.myType == JsonNodeType.ARRAY) {
            JsonNode sliceElement = topLevelNode.getChild();
            topLevelNode = sliceElement != null ? sliceElement : topLevelNode;
        }
        this.generate(text, topLevelNode);
        String string = text.toString();
        if (string == null) {
            GoJsonTypeGenerator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void buildJsonOutline(@NotNull JsonNode node, @NotNull JsonValue val) {
        block5: {
            block4: {
                if (node == null) {
                    GoJsonTypeGenerator.$$$reportNull$$$0(3);
                }
                if (val == null) {
                    GoJsonTypeGenerator.$$$reportNull$$$0(4);
                }
                node = node.addValue(val);
                if (!(val instanceof JsonArray)) break block4;
                for (JsonValue arrayElement : ((JsonArray)val).getValueList()) {
                    GoJsonTypeGenerator.buildJsonOutline(node, arrayElement);
                }
                break block5;
            }
            if (!(val instanceof JsonObject)) break block5;
            for (JsonProperty property : ((JsonObject)val).getPropertyList()) {
                String propName = property.getName();
                JsonValue propVal = property.getValue();
                if (propVal == null) continue;
                GoJsonTypeGenerator.buildJsonOutline(node.addField(propName), propVal);
            }
        }
    }

    private void generate(@NotNull GoStringBuilder text, @Nullable JsonNode node) {
        JsonNodeType type;
        if (text == null) {
            GoJsonTypeGenerator.$$$reportNull$$$0(5);
        }
        JsonNodeType jsonNodeType = type = node != null ? node.myType : JsonNodeType.ANY;
        if (type == JsonNodeType.ARRAY) {
            text.append("[]");
            this.generate(text, node.getChild());
        } else if (type == JsonNodeType.OBJECT) {
            text.append("struct ");
            text.block("", () -> {
                int fieldNum = 1;
                HashSet<String> fieldNames = new HashSet<String>();
                for (Map.Entry<String, JsonNode> entry : node.getFields().entrySet()) {
                    String jsonPropName = entry.getKey();
                    JsonNode fieldNode = entry.getValue();
                    JsonNode fieldValueNode = fieldNode.getChild();
                    boolean omitted = fieldNode.wasOmitted() && fieldValueNode != null && fieldValueNode.myType != JsonNodeType.NULL;
                    String structFieldName = GoJsonTypeGenerator.getStructFieldName(fieldNames, jsonPropName, fieldNum);
                    text.indent(structFieldName).append(" ");
                    if (fieldValueNode != null && !fieldValueNode.isRefType() && fieldValueNode.myNullable) {
                        text.append("*");
                    }
                    this.generate(text, fieldValueNode);
                    text.append(" `json:\"" + jsonPropName + (omitted ? ",omitempty" : "") + "\"`\n");
                    ++fieldNum;
                }
            }, false);
        } else if (type == JsonNodeType.STRING) {
            text.append("string");
        } else if (type == JsonNodeType.BOOL) {
            text.append("bool");
        } else if (type == JsonNodeType.INT) {
            text.append("int");
        } else if (type == JsonNodeType.LONG) {
            text.append("int64");
        } else if (type == JsonNodeType.FLOAT) {
            text.append("float64");
        } else if (type == JsonNodeType.TIME) {
            String timeQualifier = this.getTimePackageQualifier();
            text.append((String)(StringUtil.isEmpty((String)timeQualifier) ? "Time" : timeQualifier + ".Time"));
        } else if (type == JsonNodeType.ANY || type == JsonNodeType.NULL) {
            text.append("interface{}");
        }
    }

    @NotNull
    private static String getStructFieldName(@NotNull Set<String> occupiedNames, @NotNull String jsonName, int fieldNum) {
        if (occupiedNames == null) {
            GoJsonTypeGenerator.$$$reportNull$$$0(6);
        }
        if (jsonName == null) {
            GoJsonTypeGenerator.$$$reportNull$$$0(7);
        }
        if (jsonName.isEmpty()) {
            return GoJsonTypeGenerator.getUniqueName(occupiedNames, "Field", fieldNum);
        }
        StringBuilder result = new StringBuilder();
        boolean upper = true;
        for (int i = 0; i < jsonName.length(); ++i) {
            char c = jsonName.charAt(i);
            if (Character.isAlphabetic(c)) {
                if (upper) {
                    result.append(Character.toUpperCase(c));
                    upper = false;
                    continue;
                }
                result.append(c);
                continue;
            }
            if (Character.isDigit(c) && result.length() > 0) {
                result.append(c);
                upper = true;
                continue;
            }
            upper = true;
        }
        if (result.length() == 0) {
            return GoJsonTypeGenerator.getUniqueName(occupiedNames, "Field", fieldNum);
        }
        String generatedName = result.toString();
        if (occupiedNames.add(generatedName)) {
            String string = generatedName;
            if (string == null) {
                GoJsonTypeGenerator.$$$reportNull$$$0(8);
            }
            return string;
        }
        return GoJsonTypeGenerator.getUniqueName(occupiedNames, generatedName, 1);
    }

    @NotNull
    private static String getUniqueName(@NotNull Set<String> names, @NotNull String prefix, int num) {
        if (names == null) {
            GoJsonTypeGenerator.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            GoJsonTypeGenerator.$$$reportNull$$$0(10);
        }
        String result = prefix + num;
        while (!names.add(result)) {
            result = prefix + ++num;
        }
        String string = result;
        if (string == null) {
            GoJsonTypeGenerator.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoJsonTypeGenerator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occupiedNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoJsonTypeGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructFieldName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildJsonOutline";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStructFieldName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 11 -> new IllegalStateException(string);
        };
    }

    private static class JsonNode {
        private final JsonNode myParent;
        private JsonNodeType myType;
        private boolean myNullable;
        private JsonNode myChild;
        private final Map<String, JsonNode> myFields;
        private int myCount;

        private JsonNode() {
            this.myFields = new LinkedHashMap<String, JsonNode>();
            this.myCount = 0;
            this.myParent = null;
            this.myType = JsonNodeType.ANY;
        }

        private JsonNode(@NotNull JsonNode parent, @NotNull JsonNodeType type) {
            if (parent == null) {
                JsonNode.$$$reportNull$$$0(0);
            }
            if (type == null) {
                JsonNode.$$$reportNull$$$0(1);
            }
            this.myFields = new LinkedHashMap<String, JsonNode>();
            this.myCount = 0;
            this.myParent = parent;
            this.myType = type;
        }

        JsonNode addValue(@NotNull JsonValue val) {
            if (val == null) {
                JsonNode.$$$reportNull$$$0(2);
            }
            JsonNodeType childType = JsonNodeType.ANY;
            if (val instanceof JsonArray) {
                childType = JsonNodeType.ARRAY;
            } else if (val instanceof JsonObject) {
                childType = JsonNodeType.OBJECT;
            } else if (val instanceof JsonBooleanLiteral) {
                childType = JsonNodeType.BOOL;
            } else if (val instanceof JsonNumberLiteral) {
                childType = JsonNode.getNumericType((JsonNumberLiteral)val);
            } else if (val instanceof JsonStringLiteral) {
                String v = ((JsonStringLiteral)val).getValue();
                childType = RFC3339.matcher(v).matches() ? JsonNodeType.TIME : JsonNodeType.STRING;
            } else if (val instanceof JsonNullLiteral) {
                childType = JsonNodeType.NULL;
            }
            if (this.myChild == null) {
                this.myChild = new JsonNode(this, childType);
            } else {
                JsonNodeType unifiedType = this.unify(this.myChild.myType, childType);
                if (unifiedType != JsonNodeType.NULL && (childType == JsonNodeType.NULL || this.myChild.myType == JsonNodeType.NULL)) {
                    this.myChild.myNullable = true;
                }
                this.myChild.myType = unifiedType;
            }
            if (childType != JsonNodeType.NULL) {
                ++this.myChild.myCount;
            }
            return this.myChild;
        }

        boolean isRefType() {
            return this.myType == JsonNodeType.ANY || this.myType == JsonNodeType.NULL || this.myType == JsonNodeType.ARRAY;
        }

        JsonNodeType unify(JsonNodeType t1, JsonNodeType t2) {
            if (t1 == t2) {
                return t1;
            }
            List<JsonNodeType> types = Arrays.asList(t1, t2);
            if (types.contains((Object)JsonNodeType.INT) && types.contains((Object)JsonNodeType.LONG)) {
                return JsonNodeType.LONG;
            }
            if (types.contains((Object)JsonNodeType.INT) && types.contains((Object)JsonNodeType.FLOAT)) {
                return JsonNodeType.FLOAT;
            }
            if (types.contains((Object)JsonNodeType.LONG) && types.contains((Object)JsonNodeType.FLOAT)) {
                return JsonNodeType.FLOAT;
            }
            if (types.contains((Object)JsonNodeType.TIME) && types.contains((Object)JsonNodeType.STRING)) {
                return JsonNodeType.STRING;
            }
            if (t1 == JsonNodeType.NULL) {
                return t2;
            }
            if (t2 == JsonNodeType.NULL) {
                return t1;
            }
            return JsonNodeType.ANY;
        }

        private static JsonNodeType getNumericType(JsonNumberLiteral literal) {
            String numText = literal.getText();
            try {
                Integer.parseInt(numText);
                return JsonNodeType.INT;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Long.parseLong(numText);
                    return JsonNodeType.LONG;
                }
                catch (NumberFormatException numberFormatException2) {
                    return JsonNodeType.FLOAT;
                }
            }
        }

        JsonNode addField(@NotNull String name) {
            if (name == null) {
                JsonNode.$$$reportNull$$$0(3);
            }
            JsonNode result = this.myFields.computeIfAbsent(name, __ -> new JsonNode(this, JsonNodeType.FIELD));
            ++result.myCount;
            return result;
        }

        private boolean wasOmitted() {
            return this.myParent != null && this.myCount < this.myParent.getCount();
        }

        private int getCount() {
            return this.myCount;
        }

        @NotNull
        Map<String, JsonNode> getFields() {
            Map<String, JsonNode> map = this.myFields;
            if (map == null) {
                JsonNode.$$$reportNull$$$0(4);
            }
            return map;
        }

        @Nullable
        private JsonNode getChild() {
            return this.myChild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/intentions/GoJsonTypeGenerator$JsonNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/intentions/GoJsonTypeGenerator$JsonNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFields";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addField";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static enum JsonNodeType {
        ARRAY,
        OBJECT,
        FIELD,
        BOOL,
        STRING,
        TIME,
        INT,
        LONG,
        FLOAT,
        NULL,
        ANY;

    }
}

