/*
 * Decompiled with CFR 0.152.
 */
package com.goide.intentions;

import com.goide.i18n.GoBundle;
import com.goide.intentions.GoJsonTypeGenerator;
import com.goide.psi.GoFile;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoGenerateTypeFromJsonDialog
extends DialogWrapper {
    private final Project myProject;
    private final PsiElement myContext;
    private final JPanel myPanel;
    private final EditorEx myEditor;
    private volatile GoTypeSpec myGeneratedType;

    public GoGenerateTypeFromJsonDialog(@NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            GoGenerateTypeFromJsonDialog.$$$reportNull$$$0(0);
        }
        super(project, false, DialogWrapper.IdeModalityType.IDE);
        this.myProject = project;
        this.myContext = context;
        String jsonText = GoGenerateTypeFromJsonDialog.getJsonText(project);
        PsiFile jsonFile = PsiFileFactory.getInstance((Project)project).createFileFromText("data.json", (Language)JsonLanguage.INSTANCE, (CharSequence)jsonText);
        Document document = Objects.requireNonNull(PsiDocumentManager.getInstance((Project)project).getDocument(jsonFile));
        this.myEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, project);
        this.myEditor.getCaretModel().moveToOffset(0);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        document.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                GoGenerateTypeFromJsonDialog.this.setErrorText(null);
                GoGenerateTypeFromJsonDialog.this.setOKActionEnabled(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/intentions/GoGenerateTypeFromJsonDialog$1", "documentChanged"));
            }
        });
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        this.myPanel.add((Component)new JLabel(GoBundle.message((String)"go.generate.type.from.json.dialog.json.label", (Object[])new Object[0])), "North");
        this.myPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.myEditor.getComponent().setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        this.setTitle(GoBundle.message((String)"go.generate.type.from.json.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    protected void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        super.dispose();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.putValue("Name", GoBundle.message((String)"go.generate.type.from.json.dialog.ok.label", (Object[])new Object[0]));
    }

    protected void doOKAction() {
        JsonFile jsonFile = (JsonFile)Objects.requireNonNull(PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)this.myEditor.getDocument()));
        JsonValue topLevelValue = Objects.requireNonNull((JsonValue)ContainerUtil.getOnlyItem((Collection)jsonFile.getAllTopLevelValues()));
        GoJsonTypeGenerator generator = new GoJsonTypeGenerator(this.myContext);
        String goCode = generator.generate(topLevelValue);
        GoFile goFile = GoElementFactory.createFileFromText(this.myProject, goCode);
        this.myGeneratedType = (GoTypeSpec)ContainerUtil.getFirstItem(goFile.getTypes());
        this.close(0);
    }

    protected boolean continuousValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        JsonFile jsonFile = (JsonFile)ObjectUtils.tryCast((Object)PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)this.myEditor.getDocument()), JsonFile.class);
        if (jsonFile == null || PsiTreeUtil.findChildOfType((PsiElement)jsonFile, PsiErrorElement.class) != null) {
            return new ValidationInfo(GoBundle.message((String)"go.generate.type.from.json.error.invalid.json", (Object[])new Object[0]));
        }
        JsonValue topLevelValue = (JsonValue)ContainerUtil.getOnlyItem((Collection)jsonFile.getAllTopLevelValues());
        if (topLevelValue == null) {
            return new ValidationInfo(GoBundle.message((String)"go.generate.type.from.json.error.no.top.value", (Object[])new Object[0]));
        }
        GoJsonTypeGenerator generator = new GoJsonTypeGenerator(this.myContext);
        String goCode = generator.generate(topLevelValue);
        GoFile goFile = GoElementFactory.createFileFromText(this.myProject, goCode);
        this.myGeneratedType = Objects.requireNonNull((GoTypeSpec)ContainerUtil.getFirstItem(goFile.getTypes()));
        String validationError = this.validateGeneratedType(this.myGeneratedType);
        if (validationError != null) {
            return new ValidationInfo(validationError);
        }
        return null;
    }

    @Nullable
    public GoTypeSpec getGeneratedType() {
        return this.myGeneratedType;
    }

    @Nullable
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected String validateGeneratedType(@NotNull GoTypeSpec type) {
        if (type == null) {
            GoGenerateTypeFromJsonDialog.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    private static String getJsonText(@NotNull Project project) {
        block6: {
            String clipboard;
            if (project == null) {
                GoGenerateTypeFromJsonDialog.$$$reportNull$$$0(2);
            }
            if (StringUtil.isEmpty((String)(clipboard = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)))) {
                return "";
            }
            if (clipboard.startsWith("[") && clipboard.endsWith("]") || clipboard.startsWith("{") && clipboard.endsWith("}")) {
                String string;
                try {
                    PsiFile clipboardFile = PsiFileFactory.getInstance((Project)project).createFileFromText("clipboard.json", (Language)JsonLanguage.INSTANCE, (CharSequence)clipboard);
                    if (clipboardFile == null || PsiTreeUtil.findChildOfType((PsiElement)clipboardFile, PsiErrorElement.class) != null) break block6;
                    string = clipboard;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string == null) {
                    GoGenerateTypeFromJsonDialog.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/intentions/GoGenerateTypeFromJsonDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/intentions/GoGenerateTypeFromJsonDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validateGeneratedType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJsonText";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

