/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.controlflow.GoControlFlowBuilder;
import com.goide.controlflow.GoControlFlowProvider;
import com.goide.controlflow.GoControlFlowUtil;
import com.goide.controlflow.instructions.GoBranchInstructionBase;
import com.goide.controlflow.instructions.GoExpressionStatementInstruction;
import com.goide.controlflow.instructions.GoForLoopEndInstruction;
import com.goide.controlflow.instructions.GoPsiInstruction;
import com.goide.dataflow.GoDataFlowUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoAssignedVariable;
import com.goide.inspections.core.GoCallableDescriptorSet;
import com.goide.inspections.core.GoFunctionDescriptor;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoStatement;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoVarSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoNavigateToQuickFix;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoVetLostCancelInspection
extends GoInspectionBase {
    private static final GoCallableDescriptorSet CANCEL_FUNCTIONS_CONSTRUCTORS = new GoCallableDescriptorSet(Set.of(GoFunctionDescriptor.of("context.WithCancel"), GoFunctionDescriptor.of("context.WithTimeout"), GoFunctionDescriptor.of("context.WithDeadline")));

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoVetLostCancelInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoVetLostCancelInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr call) {
                GoAssignedVariable cancelVariable;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!CANCEL_FUNCTIONS_CONSTRUCTORS.contains(call, true)) {
                    return;
                }
                PsiElement varSpecOrAssignment = PsiTreeUtil.getParentOfType((PsiElement)call, (Class[])new Class[]{GoVarSpec.class, GoAssignmentStatement.class});
                if (varSpecOrAssignment == null) {
                    return;
                }
                if (varSpecOrAssignment instanceof GoVarSpec) {
                    cancelVariable = GoAssignedVariable.from((GoVarSpec)varSpecOrAssignment, 1);
                } else {
                    assert (varSpecOrAssignment instanceof GoAssignmentStatement);
                    cancelVariable = GoAssignedVariable.from((GoAssignmentStatement)varSpecOrAssignment, 1);
                }
                if (cancelVariable == null) {
                    return;
                }
                if (cancelVariable.getAssignedElement().textMatches((CharSequence)"_")) {
                    holder.registerProblem(cancelVariable.getAssignedElement(), GoVetLostCancelInspection.message("go.inspection.discarded.context.cancel.function"), new LocalQuickFix[0]);
                    return;
                }
                if (cancelVariable.getDefinition() == null || cancelVariable instanceof GoAssignedVariable.FromAssignment && !GoDataFlowUtil.isInSameFunctionBlock(((GoAssignedVariable.FromAssignment)cancelVariable).getAssignedElement(), cancelVariable.getDefinition())) {
                    return;
                }
                GoSignatureOwner enclosingFunction = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)call, (Class[])new Class[]{GoFunctionOrMethodDeclaration.class, GoFunctionLit.class});
                if (enclosingFunction == null || enclosingFunction instanceof GoFunctionDeclaration && GoPsiUtil.isMainFunction((GoFunctionDeclaration)enclosingFunction)) {
                    return;
                }
                ControlFlow controlFlow = GoControlFlowProvider.INSTANCE.getControlFlow(enclosingFunction);
                if (controlFlow == null) {
                    return;
                }
                Instruction startInstruction = GoControlFlowUtil.correspondingInstruction(varSpecOrAssignment, enclosingFunction, controlFlow);
                if (startInstruction == null) {
                    return;
                }
                boolean variableIsNamedResultParameter = cancelVariable.getDefinition() instanceof GoParamDefinition && GoVetLostCancelInspection.isNamedResultParameter((GoParamDefinition)cancelVariable.getDefinition());
                ControlFlowUtil.iterate((int)startInstruction.num(), (Instruction[])controlFlow.getInstructions(), instruction -> {
                    if (instruction == startInstruction) {
                        return ControlFlowUtil.Operation.NEXT;
                    }
                    if (GoVetLostCancelInspection.usesVariable(instruction, cancelVariable.getDefinition(), variableIsNamedResultParameter)) {
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                    if (GoVetLostCancelInspection.isExecutionEnd(instruction) && !GoVetLostCancelInspection.isTerminatingCallInstruction(instruction)) {
                        this.reportProblem((Instruction)instruction, cancelVariable);
                        return ControlFlowUtil.Operation.BREAK;
                    }
                    return ControlFlowUtil.Operation.NEXT;
                }, (boolean)false);
            }

            private void reportProblem(@NotNull Instruction end, @NotNull GoAssignedVariable cancelVariable) {
                PsiElement reportedElement;
                if (end == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (cancelVariable == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((reportedElement = this.reportEndInstruction(end, cancelVariable)) != null) {
                    GoNavigateToQuickFix fix = new GoNavigateToQuickFix(reportedElement, GoBundle.message((String)"go.inspection.problematic.execution.path.end", (Object[])new Object[0]));
                    holder.registerProblem(cancelVariable.getAssignedElement(), GoVetLostCancelInspection.message("go.inspection.function.returns.without.calling.context.cancel.function"), fix);
                } else {
                    holder.registerProblem(cancelVariable.getAssignedElement(), GoVetLostCancelInspection.message("go.inspection.function.returns.without.calling.context.cancel.function"), new LocalQuickFix[0]);
                }
            }

            @Nullable
            private PsiElement reportEndInstruction(@NotNull Instruction end, @NotNull GoAssignedVariable cancelVariable) {
                PsiElement conditionElement;
                if (end == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (cancelVariable == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (end instanceof GoPsiInstruction) {
                    Object element = ((GoPsiInstruction)end).getPsi();
                    this.reportPsiElement((PsiElement)element, cancelVariable);
                    return element;
                }
                if (end instanceof GoForLoopEndInstruction) {
                    PsiElement forKeyword = ((GoForLoopEndInstruction)end).getLoopStartInstruction().getForStatement().getFor();
                    this.reportIfForSwitchStatement(forKeyword, cancelVariable);
                    return forKeyword;
                }
                if (end instanceof GoBranchInstructionBase && (conditionElement = ((GoBranchInstructionBase)end).getCondition()) != null) {
                    PsiElement keyword = GoVetLostCancelInspection.getKeywordOfIfForSwitchStatement(GoExpressionUtil.getParentIfForSwitchStatement(conditionElement));
                    if (keyword != null) {
                        this.reportIfForSwitchStatement(keyword, cancelVariable);
                        return keyword;
                    }
                    this.reportPsiElement(conditionElement, cancelVariable);
                    return conditionElement;
                }
                return null;
            }

            private void reportPsiElement(@NotNull PsiElement element, @NotNull GoAssignedVariable cancelVariable) {
                if (element == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (cancelVariable == null) {
                    1.$$$reportNull$$$0(6);
                }
                String assignedElementText = cancelVariable.getAssignedElement().getText();
                holder.registerProblem(element, GoVetLostCancelInspection.message("go.inspection.execution.ends.without.context.cancel.function.after.instruction", new Object[]{assignedElementText}), 1.createNavigateFix(cancelVariable, assignedElementText));
            }

            private void reportIfForSwitchStatement(@NotNull PsiElement statementKeyword, @NotNull GoAssignedVariable cancelVariable) {
                if (statementKeyword == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (cancelVariable == null) {
                    1.$$$reportNull$$$0(8);
                }
                String assignedElementText = cancelVariable.getAssignedElement().getText();
                holder.registerProblem(statementKeyword, GoVetLostCancelInspection.message("go.inspection.execution.ends.without.context.cancel.function.after.statement", new Object[]{statementKeyword.getText(), assignedElementText}), 1.createNavigateFix(cancelVariable, assignedElementText));
            }

            @NotNull
            private static GoNavigateToQuickFix createNavigateFix(@NotNull GoAssignedVariable cancelVariable, @NotNull @Nls String assignedElementText) {
                if (cancelVariable == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (assignedElementText == null) {
                    1.$$$reportNull$$$0(10);
                }
                return new GoNavigateToQuickFix(cancelVariable.getAssignedElement(), "'" + assignedElementText + "' " + GoBundle.message((String)"go.terms.function", (Object[])new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "end";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cancelVariable";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statementKeyword";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignedElementText";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/vet/GoVetLostCancelInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpr";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportProblem";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportEndInstruction";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportPsiElement";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportIfForSwitchStatement";
                        break;
                    }
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createNavigateFix";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isNamedResultParameter(@NotNull GoParamDefinition parameter) {
        if (parameter == null) {
            GoVetLostCancelInspection.$$$reportNull$$$0(2);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)parameter, GoResult.class, (boolean)false, (Class[])new Class[]{GoSignature.class}) != null;
    }

    private static boolean usesVariable(@NotNull Instruction instruction, @NotNull GoNamedElement variableDefinition, boolean variableIsNamedResultParameter) {
        if (instruction == null) {
            GoVetLostCancelInspection.$$$reportNull$$$0(3);
        }
        if (variableDefinition == null) {
            GoVetLostCancelInspection.$$$reportNull$$$0(4);
        }
        return Optional.of(instruction).map(i -> (GoPsiInstruction)((Object)((Object)ObjectUtils.tryCast((Object)i, GoPsiInstruction.class)))).map(i -> i.getPsi()).map(rootElement -> (PsiElement)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot(rootElement)).traverse().find(element -> element instanceof GoReferenceExpression && ((GoReferenceExpression)element).resolve() == variableDefinition || element instanceof GoReturnStatement && ((GoReturnStatement)element).getExpressionList().isEmpty() && variableIsNamedResultParameter)).isPresent();
    }

    private static boolean isExecutionEnd(@NotNull Instruction instruction) {
        Collection successors;
        if (instruction == null) {
            GoVetLostCancelInspection.$$$reportNull$$$0(5);
        }
        return (successors = instruction.allSucc()).size() == 1 && ((Instruction)ContainerUtil.getFirstItem((Collection)successors)).allSucc().isEmpty();
    }

    private static boolean isTerminatingCallInstruction(@NotNull Instruction instruction) {
        if (instruction == null) {
            GoVetLostCancelInspection.$$$reportNull$$$0(6);
        }
        return Optional.of(instruction).map(i -> (GoExpressionStatementInstruction)((Object)((Object)ObjectUtils.tryCast((Object)i, GoExpressionStatementInstruction.class)))).map(i -> (GoExpression)i.getPsi()).filter(GoControlFlowBuilder::isTerminatingCall).isPresent();
    }

    @Nullable
    private static PsiElement getKeywordOfIfForSwitchStatement(@Nullable GoStatement statement) {
        if (statement instanceof GoIfStatement) {
            return ((GoIfStatement)statement).getIf();
        }
        if (statement instanceof GoForStatement) {
            return ((GoForStatement)statement).getFor();
        }
        if (statement instanceof GoExprSwitchStatement) {
            return ((GoExprSwitchStatement)statement).getSwitchStart().getSwitch();
        }
        if (statement instanceof GoTypeSwitchStatement) {
            return ((GoTypeSwitchStatement)statement).getSwitchStart().getSwitch();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDefinition";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/vet/GoVetLostCancelInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNamedResultParameter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "usesVariable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isExecutionEnd";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTerminatingCallInstruction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

