/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoExpression;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoTypeCaseClause;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoDeleteImpossibleAssertedInterfaceInClauseQuickFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoVetImpossibleInterfaceToInterfaceAssertionInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoVetImpossibleInterfaceToInterfaceAssertionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoVetImpossibleInterfaceToInterfaceAssertionInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitTypeAssertionExpr(@NotNull GoTypeAssertionExpr typeAssertion) {
                GoType assertedUnderlyingType;
                if (typeAssertion == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTypeAssertionExpr(typeAssertion);
                if (typeAssertion.getType_() != null) {
                    return;
                }
                GoType underlyingTypeToAssert = typeAssertion.getExpression().getGoUnderlyingType(null);
                if (!(underlyingTypeToAssert instanceof GoInterfaceType)) {
                    return;
                }
                GoType assertedType = typeAssertion.getType();
                GoType goType = assertedUnderlyingType = assertedType != null ? assertedType.getUnderlyingType(assertedType) : null;
                if (!(assertedUnderlyingType instanceof GoInterfaceType)) {
                    return;
                }
                GoInspectionMessage message = this.findImpossibleInterfaceToInterfaceConversion((GoInterfaceType)underlyingTypeToAssert, assertedType, (GoInterfaceType)assertedUnderlyingType);
                if (message == null) {
                    return;
                }
                holder.registerProblem((PsiElement)assertedType, message, new LocalQuickFix[0]);
            }

            @Override
            public void visitTypeSwitchStatement(@NotNull GoTypeSwitchStatement typeSwitch) {
                if (typeSwitch == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitTypeSwitchStatement(typeSwitch);
                GoExpression typeSwitchGuardExpression = typeSwitch.getTypeSwitchGuard().getExpression();
                if (!(typeSwitchGuardExpression instanceof GoTypeAssertionExpr)) {
                    return;
                }
                GoType underlyingTypeToAssert = ((GoTypeAssertionExpr)typeSwitchGuardExpression).getExpression().getGoUnderlyingType(null);
                if (!(underlyingTypeToAssert instanceof GoInterfaceType)) {
                    return;
                }
                List<GoTypeCaseClause> clauses = typeSwitch.getTypeCaseClauseList();
                for (GoTypeCaseClause caseClause : clauses) {
                    this.checkClause(caseClause, (GoInterfaceType)underlyingTypeToAssert);
                }
            }

            private void checkClause(@NotNull GoTypeCaseClause caseClause, @NotNull GoInterfaceType underlyingTypeToAssert) {
                GoType caseClauseTypes;
                if (caseClause == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (underlyingTypeToAssert == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((caseClauseTypes = caseClause.getType()) == null) {
                    return;
                }
                List<GoType> assertedTypes = GoTypeUtil.getListOfTypesFromTypeList(caseClauseTypes);
                int numberOfAssertedTypes = assertedTypes.size();
                for (GoType assertedType : assertedTypes) {
                    this.checkAssertedTypeInClause(underlyingTypeToAssert, assertedType, caseClause, numberOfAssertedTypes);
                }
            }

            private void checkAssertedTypeInClause(@NotNull GoInterfaceType underlyingTypeToAssert, @NotNull GoType assertedType, @NotNull GoTypeCaseClause caseClause, int numberOfAssertedTypes) {
                GoType assertedUnderlyingType;
                if (underlyingTypeToAssert == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (assertedType == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (caseClause == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (!((assertedUnderlyingType = assertedType.getUnderlyingType(assertedType)) instanceof GoInterfaceType)) {
                    return;
                }
                GoInspectionMessage message = this.findImpossibleInterfaceToInterfaceConversion(underlyingTypeToAssert, assertedType, (GoInterfaceType)assertedUnderlyingType);
                if (message == null) {
                    return;
                }
                GoDeleteImpossibleAssertedInterfaceInClauseQuickFix fix = new GoDeleteImpossibleAssertedInterfaceInClauseQuickFix(caseClause, assertedType, numberOfAssertedTypes);
                holder.registerProblem((PsiElement)assertedType, message, new LocalQuickFix[]{fix});
            }

            @Nullable
            private GoInspectionMessage findImpossibleInterfaceToInterfaceConversion(@NotNull GoInterfaceType interfaceToAssert, @NotNull GoType assertedInterface, @NotNull GoInterfaceType assertedUnderlyingInterface) {
                Collection intersectedMethodNames;
                List<GoMethodSpec> interfaceToAssertMethods;
                int interfaceToAssertMethodNumber;
                if (interfaceToAssert == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (assertedInterface == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (assertedUnderlyingInterface == null) {
                    1.$$$reportNull$$$0(9);
                }
                if ((interfaceToAssertMethodNumber = (interfaceToAssertMethods = interfaceToAssert.getAllMethods()).size()) == 0) {
                    return null;
                }
                List<GoMethodSpec> assertedInterfaceMethods = assertedUnderlyingInterface.getAllMethods();
                int assertedInterfaceMethodNumber = assertedInterfaceMethods.size();
                if (assertedInterfaceMethodNumber == 0) {
                    return null;
                }
                Function<GoMethodSpec, Pair> getNameAndElementFromMethod = method -> Pair.pair((Object)StringUtil.notNullize((String)method.getName()), (Object)method);
                Map interfaceToAssertMethodByName = ContainerUtil.map2Map(interfaceToAssertMethods, getNameAndElementFromMethod::apply);
                Map assertedInterfaceMethodByName = ContainerUtil.map2Map(assertedInterfaceMethods, getNameAndElementFromMethod::apply);
                Set<String> ambiguousMethodNames = 1.getAmbiguousMethodNames(interfaceToAssertMethodByName, assertedInterfaceMethodByName, intersectedMethodNames = ContainerUtil.intersection(assertedInterfaceMethodByName.keySet(), interfaceToAssertMethodByName.keySet()));
                return ambiguousMethodNames.size() != 0 ? 1.buildMessage(interfaceToAssert, assertedInterface, ambiguousMethodNames) : null;
            }

            @NotNull
            private static GoInspectionMessage buildMessage(@NotNull GoInterfaceType interfaceToAssert, @NotNull GoType assertedInterface, @NotNull Set<String> ambiguousMethodNames) {
                if (interfaceToAssert == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (assertedInterface == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (ambiguousMethodNames == null) {
                    1.$$$reportNull$$$0(12);
                }
                String messageTemplate = "go.inspection.problem.impossible.interface.assertion";
                String interfaceToAssertName = GoVetImpossibleInterfaceToInterfaceAssertionInspection.code(interfaceToAssert.getPresentationText());
                String assertedInterfaceName = GoVetImpossibleInterfaceToInterfaceAssertionInspection.code(assertedInterface.getPresentationText());
                String ambiguousMethods = StringUtil.join((Collection)ContainerUtil.map(ambiguousMethodNames, name -> GoVetImpossibleInterfaceToInterfaceAssertionInspection.code(name)), (String)", ");
                GoInspectionMessage goInspectionMessage = GoVetImpossibleInterfaceToInterfaceAssertionInspection.message(messageTemplate, new Object[]{interfaceToAssertName, assertedInterfaceName, ambiguousMethods});
                if (goInspectionMessage == null) {
                    1.$$$reportNull$$$0(13);
                }
                return goInspectionMessage;
            }

            @NotNull
            private static Set<String> getAmbiguousMethodNames(@NotNull Map<String, GoMethodSpec> interfaceToAssertMethodByName, @NotNull Map<String, GoMethodSpec> assertedInterfaceMethodByName, @NotNull Collection<String> intersectedMethodNames) {
                if (interfaceToAssertMethodByName == null) {
                    1.$$$reportNull$$$0(14);
                }
                if (assertedInterfaceMethodByName == null) {
                    1.$$$reportNull$$$0(15);
                }
                if (intersectedMethodNames == null) {
                    1.$$$reportNull$$$0(16);
                }
                HashSet<String> ambiguousMethodNames = new HashSet<String>();
                for (String intersectedMethodName : intersectedMethodNames) {
                    GoMethodSpec assertedInterfaceMethod;
                    GoMethodSpec expressionInterfaceMethod = interfaceToAssertMethodByName.get(intersectedMethodName);
                    if (GoTypeUtil.areSignaturesIdentical(expressionInterfaceMethod, assertedInterfaceMethod = assertedInterfaceMethodByName.get(intersectedMethodName), true)) continue;
                    ambiguousMethodNames.add(intersectedMethodName);
                }
                HashSet<String> hashSet = ambiguousMethodNames;
                if (hashSet == null) {
                    1.$$$reportNull$$$0(17);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 13, 17 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeAssertion";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeSwitch";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caseClause";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "underlyingTypeToAssert";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assertedType";
                        break;
                    }
                    case 7: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interfaceToAssert";
                        break;
                    }
                    case 8: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assertedInterface";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assertedUnderlyingInterface";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ambiguousMethodNames";
                        break;
                    }
                    case 13: 
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/inspections/vet/GoVetImpossibleInterfaceToInterfaceAssertionInspection$1";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interfaceToAssertMethodByName";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assertedInterfaceMethodByName";
                        break;
                    }
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "intersectedMethodNames";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/inspections/vet/GoVetImpossibleInterfaceToInterfaceAssertionInspection$1";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildMessage";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAmbiguousMethodNames";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitTypeAssertionExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitTypeSwitchStatement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "checkClause";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "checkAssertedTypeInClause";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "findImpossibleInterfaceToInterfaceConversion";
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "buildMessage";
                        break;
                    }
                    case 13: 
                    case 17: {
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: {
                        objectArray = objectArray;
                        objectArray[2] = "getAmbiguousMethodNames";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 13, 17 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/vet/GoVetImpossibleInterfaceToInterfaceAssertionInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

