/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.highlighting.legacyErrorInspections.GoTestSignaturesInspection;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.quickfix.GoRenameQuickFix;
import com.goide.stubs.index.GoAllPrivateNamesIndex;
import com.goide.stubs.index.GoAllPublicNamesIndex;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTestNameInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoTestNameInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoTestNameInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitGoFile(@NotNull GoFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitGoFile(file);
                if (!GoTestFinder.isTestFile((PsiFile)file)) {
                    return;
                }
                Lazy<Map<GoPackage, GlobalSearchScope>> packagesForSymbolLookup = GoTestNameInspection.getPackagesForSymbolLookup(file);
                String testingPackageQualifier = GoTestSignaturesInspection.getTestingPackageQualifier(file);
                for (GoFunctionDeclaration goFunctionDeclaration : file.getFunctions()) {
                    String name = goFunctionDeclaration.getName();
                    if (StringUtil.isEmpty((String)name)) continue;
                    if (name.startsWith(GoTestFunctionType.TEST.getPrefix())) {
                        GoTestNameInspection.checkTest(holder, goFunctionDeclaration, GoTestFunctionType.TEST, testingPackageQualifier);
                        continue;
                    }
                    if (name.startsWith(GoTestFunctionType.BENCHMARK.getPrefix())) {
                        GoTestNameInspection.checkTest(holder, goFunctionDeclaration, GoTestFunctionType.BENCHMARK, testingPackageQualifier);
                        continue;
                    }
                    if (!name.startsWith(GoTestFunctionType.EXAMPLE.getPrefix())) continue;
                    GoTestNameInspection.checkExample(packagesForSymbolLookup, holder, goFunctionDeclaration);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/goide/inspections/vet/GoTestNameInspection$1", "visitGoFile"));
            }
        };
    }

    private static void checkTest(@NotNull GoProblemsHolder problemsHolder, @NotNull GoFunctionDeclaration function, @NotNull GoTestFunctionType testFunctionType, @Nullable String testingPackageQualifier) {
        if (problemsHolder == null) {
            GoTestNameInspection.$$$reportNull$$$0(2);
        }
        if (function == null) {
            GoTestNameInspection.$$$reportNull$$$0(3);
        }
        if (testFunctionType == null) {
            GoTestNameInspection.$$$reportNull$$$0(4);
        }
        if (!GoTestSignaturesInspection.isValidTestOrBenchmarkSignature(function, testFunctionType, testingPackageQualifier)) {
            return;
        }
        String name = Objects.requireNonNull(function.getName());
        assert (name.length() >= testFunctionType.getPrefix().length());
        String suffix = name.substring(testFunctionType.getPrefix().length());
        if (!GoTestNameInspection.isTestSuffix(suffix)) {
            String suggestedName = testFunctionType.getPrefix() + StringUtil.capitalize((String)suffix);
            String key = testFunctionType == GoTestFunctionType.BENCHMARK ? "go.inspection.problem.malformed.benchmark.name" : "go.inspection.problem.malformed.test.name";
            problemsHolder.registerProblem(function.getIdentifier(), GoTestNameInspection.message(key), GoTestNameInspection.getRenameFixes(function, suggestedName));
        }
    }

    private static void checkExample(@NotNull Lazy<Map<GoPackage, GlobalSearchScope>> packagesForSymbolLookup, @NotNull GoProblemsHolder problemsHolder, @NotNull GoFunctionDeclaration function) {
        GoSignature signature;
        if (packagesForSymbolLookup == null) {
            GoTestNameInspection.$$$reportNull$$$0(5);
        }
        if (problemsHolder == null) {
            GoTestNameInspection.$$$reportNull$$$0(6);
        }
        if (function == null) {
            GoTestNameInspection.$$$reportNull$$$0(7);
        }
        if ((signature = function.getSignature()) == null || !GoTestSignaturesInspection.isValidExampleSignature(signature)) {
            return;
        }
        String name = Objects.requireNonNull(function.getName());
        assert (name.length() >= GoTestFunctionType.EXAMPLE.getPrefix().length());
        String exampleName = name.substring(GoTestFunctionType.EXAMPLE.getPrefix().length());
        if (StringUtil.isEmpty((String)exampleName)) {
            return;
        }
        List<String> parts = GoTestNameInspection.splitExampleName(exampleName);
        assert (parts.size() > 0);
        String part0 = parts.get(0);
        if (part0.isEmpty()) {
            String residual = StringUtil.trimStart((String)exampleName, (String)"_");
            if (!GoTestNameInspection.isExampleSuffix(residual)) {
                String suggestedName = GoTestFunctionType.EXAMPLE.getPrefix() + "_" + StringUtil.decapitalize((String)residual);
                problemsHolder.registerProblem(function.getIdentifier(), GoTestNameInspection.message("go.inspection.problem.malformed.example.suffix", residual), GoTestNameInspection.getRenameFixes(function, suggestedName));
            }
            return;
        }
        if (!GoTestNameInspection.findTopLevelDeclaration(packagesForSymbolLookup, part0)) {
            problemsHolder.registerProblem(function.getIdentifier(), GoTestNameInspection.message("go.inspection.problem.example.for.unknown.identifier", part0), new LocalQuickFix[]{new GoRenameQuickFix(function)});
            return;
        }
        if (parts.size() < 2) {
            return;
        }
        String part1 = parts.get(1);
        if (!GoTestNameInspection.isExampleSuffix(part1) && !GoTestNameInspection.findFieldOrMethod(packagesForSymbolLookup, part0, part1)) {
            problemsHolder.registerProblem(function.getIdentifier(), GoTestNameInspection.message("go.inspection.problem.example.for.unknown.field.or.method", part0, part1), new LocalQuickFix[]{new GoRenameQuickFix(function)});
            return;
        }
        if (parts.size() == 3 && !GoTestNameInspection.isExampleSuffix(parts.get(2))) {
            String part2 = parts.get(2);
            String suggestedName = GoTestFunctionType.EXAMPLE.getPrefix() + part0 + "_" + part1 + "_" + StringUtil.decapitalize((String)part2);
            problemsHolder.registerProblem(function.getIdentifier(), GoTestNameInspection.message("go.inspection.problem.malformed.example.suffix", part2), GoTestNameInspection.getRenameFixes(function, suggestedName));
        }
    }

    @NotNull
    private static List<String> splitExampleName(@NotNull String s) {
        if (s == null) {
            GoTestNameInspection.$$$reportNull$$$0(8);
        }
        String separator = "_";
        int maxCount = 3;
        List parts = StringUtil.split((String)s, (String)separator, (boolean)true, (boolean)false);
        if (parts.size() <= maxCount) {
            List list = parts;
            if (list == null) {
                GoTestNameInspection.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> result = parts.subList(0, maxCount);
        result.add(StringUtil.join(parts.subList(maxCount, parts.size()), (String)separator));
        List<String> list = result;
        if (list == null) {
            GoTestNameInspection.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static boolean findTopLevelDeclaration(@NotNull Lazy<Map<GoPackage, GlobalSearchScope>> lazyPackageScopes, @NotNull String name) {
        if (lazyPackageScopes == null) {
            GoTestNameInspection.$$$reportNull$$$0(11);
        }
        if (name == null) {
            GoTestNameInspection.$$$reportNull$$$0(12);
        }
        Map packageScopes = (Map)lazyPackageScopes.getValue();
        return ContainerUtil.exists(packageScopes.keySet(), pkg -> GoTestNameInspection.findSymbol(pkg, packageScopes, name, it -> !GoTestNameInspection.isMethodOrField(it)));
    }

    private static boolean findFieldOrMethod(@NotNull Lazy<Map<GoPackage, GlobalSearchScope>> lazyPackageScopes, @NotNull String type, @NotNull String fieldOrMethod) {
        if (lazyPackageScopes == null) {
            GoTestNameInspection.$$$reportNull$$$0(13);
        }
        if (type == null) {
            GoTestNameInspection.$$$reportNull$$$0(14);
        }
        if (fieldOrMethod == null) {
            GoTestNameInspection.$$$reportNull$$$0(15);
        }
        StubIndexKey<String, GoNamedElement> index = StringUtil.isCapitalized((String)type) ? GoAllPublicNamesIndex.ALL_PUBLIC_NAMES : GoAllPrivateNamesIndex.ALL_PRIVATE_NAMES;
        Map packageScopeCache = (Map)lazyPackageScopes.getValue();
        for (GoPackage pkg : packageScopeCache.keySet()) {
            GlobalSearchScope scope = packageScopeCache.computeIfAbsent(pkg, it -> it.getScope());
            String typeFqn = pkg.getName() + "." + type;
            Collection elements = StubIndex.getElements(index, (Object)typeFqn, (Project)pkg.getProject(), (GlobalSearchScope)scope, GoNamedElement.class);
            for (GoNamedElement element : elements) {
                GoTypeSpec typeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)element, GoTypeSpec.class);
                if (GoPsiImplUtil.findFieldOrMethod(typeSpec, it -> fieldOrMethod.equals(it.getName())) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean findSymbol(@NotNull GoPackage pkg, @NotNull Map<GoPackage, GlobalSearchScope> packageScopeCache, @NotNull String name, @NotNull Predicate<GoNamedElement> predicate) {
        if (pkg == null) {
            GoTestNameInspection.$$$reportNull$$$0(16);
        }
        if (packageScopeCache == null) {
            GoTestNameInspection.$$$reportNull$$$0(17);
        }
        if (name == null) {
            GoTestNameInspection.$$$reportNull$$$0(18);
        }
        if (predicate == null) {
            GoTestNameInspection.$$$reportNull$$$0(19);
        }
        StubIndexKey<String, GoNamedElement> index = StringUtil.isCapitalized((String)name) ? GoAllPublicNamesIndex.ALL_PUBLIC_NAMES : GoAllPrivateNamesIndex.ALL_PRIVATE_NAMES;
        GlobalSearchScope scope = packageScopeCache.computeIfAbsent(pkg, it -> it.getScope());
        Collection elements = StubIndex.getElements(index, (Object)(pkg.getName() + "." + name), (Project)pkg.getProject(), (GlobalSearchScope)scope, GoNamedElement.class);
        for (GoNamedElement element : elements) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMethodOrField(GoNamedElement element) {
        return element instanceof GoMethodDeclaration || element instanceof GoMethodSpec || GoPsiImplUtil.isFieldDefinition(element);
    }

    @NotNull
    private static Lazy<Map<GoPackage, GlobalSearchScope>> getPackagesForSymbolLookup(@NotNull GoFile file) {
        if (file == null) {
            GoTestNameInspection.$$$reportNull$$$0(20);
        }
        GoPackage pkg = GoPackage.of(file);
        Lazy lazy = LazyKt.lazy(() -> {
            if (pkg == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<GoPackage, Object> result = new LinkedHashMap<GoPackage, Object>();
            result.put(pkg, null);
            pkg.processBuildableFiles(null, GoUtil.module((PsiElement)file), (Processor<? super PsiFile>)((Processor)f -> {
                GoFile goFile = (GoFile)((Object)((Object)((Object)ObjectUtils.tryCast((Object)f, GoFile.class))));
                if (goFile != null) {
                    for (GoImportSpec importSpec : goFile.getImports()) {
                        for (GoPackage importedPackage : importSpec.resolve(ResolveState.initial())) {
                            result.putIfAbsent(importedPackage, null);
                        }
                    }
                }
                return true;
            }));
            return result;
        });
        if (lazy == null) {
            GoTestNameInspection.$$$reportNull$$$0(21);
        }
        return lazy;
    }

    private static LocalQuickFix @NotNull [] getRenameFixes(@NotNull GoFunctionDeclaration function, @NotNull String suggestedName) {
        LocalQuickFix[] localQuickFixArray;
        if (function == null) {
            GoTestNameInspection.$$$reportNull$$$0(22);
        }
        if (suggestedName == null) {
            GoTestNameInspection.$$$reportNull$$$0(23);
        }
        if (suggestedName.equals(function.getName())) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = new GoRenameQuickFix(function);
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[2];
            localQuickFixArray3[0] = new GoRenameQuickFix(function);
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[1] = new RenameElementFix((PsiNamedElement)function, suggestedName);
        }
        if (localQuickFixArray == null) {
            GoTestNameInspection.$$$reportNull$$$0(24);
        }
        return localQuickFixArray;
    }

    private static boolean isExampleSuffix(@NotNull String s) {
        if (s == null) {
            GoTestNameInspection.$$$reportNull$$$0(25);
        }
        return !s.isEmpty() && Character.isLowerCase(s.charAt(0));
    }

    private static boolean isTestSuffix(@NotNull String s) {
        if (s == null) {
            GoTestNameInspection.$$$reportNull$$$0(26);
        }
        return s.isEmpty() || !Character.isLowerCase(s.charAt(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 21, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 3: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFunctionType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagesForSymbolLookup";
                break;
            }
            case 8: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: 
            case 10: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/vet/GoTestNameInspection";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyPackageScopes";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOrMethod";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageScopeCache";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/vet/GoTestNameInspection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "splitExampleName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesForSymbolLookup";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenameFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkTest";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkExample";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "splitExampleName";
                break;
            }
            case 9: 
            case 10: 
            case 21: 
            case 24: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelDeclaration";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFieldOrMethod";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSymbol";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesForSymbolLookup";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRenameFixes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isExampleSuffix";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isTestSuffix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 21, 24 -> new IllegalStateException(string);
        };
    }
}

