/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.unresolved;

import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoRenameToBlankQuickFix;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J1\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/goide/inspections/unresolved/GoUnusedTypeParameterInspection;", "Lcom/goide/inspections/core/GoInspectionBase;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/goide/inspections/core/GoProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "registerProblem", "", "element", "Lcom/intellij/psi/PsiElement;", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/goide/inspections/core/GoProblemsHolder;Lcom/intellij/psi/PsiElement;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "parametersCanBeRemoved", "", "function", "Lcom/goide/psi/GoFunctionOrMethodDeclaration;", "tooCostlyToSearch", "isUsedInFunctionType", "intellij.go.impl"})
public final class GoUnusedTypeParameterInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new GoVisitor(this, holder){
            final /* synthetic */ GoUnusedTypeParameterInspection this$0;
            final /* synthetic */ GoProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFunctionDeclaration(GoFunctionDeclaration function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                GoCompositeElement goCompositeElement = function.getSignature();
                if (goCompositeElement == null || (goCompositeElement = goCompositeElement.getTypeParameters()) == null) {
                    return;
                }
                GoCompositeElement parameters = goCompositeElement;
                List<GoTypeParamDefinition> potentiallyUnusedParameters = this.findPotentiallyUnusedParameters((GoTypeParameters)parameters);
                if (potentiallyUnusedParameters.isEmpty()) {
                    return;
                }
                if (!this.this$0.parametersCanBeRemoved(this.$holder, function)) {
                    Iterable $this$forEach$iv = potentiallyUnusedParameters;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        GoTypeParamDefinition parameter = (GoTypeParamDefinition)element$iv;
                        boolean bl = false;
                        this.registerProblemWithRename(parameter);
                    }
                } else {
                    Iterable $this$forEach$iv = potentiallyUnusedParameters;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        GoTypeParamDefinition parameter = (GoTypeParamDefinition)element$iv;
                        boolean bl = false;
                        this.registerProblemWithDelete(parameter);
                    }
                }
            }

            private final List<GoTypeParamDefinition> findPotentiallyUnusedParameters(GoTypeParameters parameters) {
                List potentiallyUnusedParameters = new ArrayList<E>();
                for (GoTypeParameterDeclaration parameterDeclaration : parameters.getTypeParameterDeclarationList()) {
                    for (GoTypeParamDefinition parameter : parameterDeclaration.getTypeParamDefinitionList()) {
                        Query<PsiReference> search;
                        ProgressManager.checkCanceled();
                        if (parameter.isBlank()) continue;
                        Intrinsics.checkNotNullExpressionValue(GoReferencesSearch.search((PsiElement)parameter, parameter.getUseScope(), true), (String)"search(...)");
                        if (search.findFirst() != null) continue;
                        Intrinsics.checkNotNull((Object)parameter);
                        potentiallyUnusedParameters.add(parameter);
                    }
                }
                return potentiallyUnusedParameters;
            }

            private final void registerProblemWithRename(GoTypeParamDefinition parameter) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new GoRenameToBlankQuickFix(parameter)};
                GoUnusedTypeParameterInspection.access$registerProblem(this.this$0, this.$holder, parameter, localQuickFixArray);
            }

            private final void registerProblemWithDelete(GoTypeParamDefinition parameter) {
                PsiElement psiElement = parameter.getParent();
                GoTypeParameterDeclaration declaration = psiElement instanceof GoTypeParameterDeclaration ? (GoTypeParameterDeclaration)psiElement : null;
                PsiElement element = declaration != null && declaration.getTypeParamDefinitionList().size() == 1 ? (PsiElement)declaration : (PsiElement)parameter;
                GoUnusedTypeParameterInspection.access$registerProblem(this.this$0, this.$holder, element, new LocalQuickFix[0]);
            }
        };
    }

    private final void registerProblem(GoProblemsHolder holder, PsiElement element, LocalQuickFix ... fixes) {
        Object[] objectArray = new Object[]{GoInspectionBase.REF};
        holder.registerProblem(element, GoInspectionBase.message("go.inspection.unused.type.parameter.message", objectArray), Arrays.copyOf(fixes, fixes.length));
    }

    public final boolean parametersCanBeRemoved(@NotNull GoProblemsHolder holder, @NotNull GoFunctionOrMethodDeclaration function) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return !this.tooCostlyToSearch(holder, function) && !this.isUsedInFunctionType(function);
    }

    private final boolean tooCostlyToSearch(GoProblemsHolder holder, GoFunctionOrMethodDeclaration function) {
        return holder.isOnTheFly() && function.isPublic() && !GoInspectionUtil.isCheapEnoughToSearch(function);
    }

    private final boolean isUsedInFunctionType(GoFunctionOrMethodDeclaration function) {
        Predicate<PsiElement> referenceElementPredicate = GoUnusedTypeParameterInspection::isUsedInFunctionType$lambda$0;
        Iterator iterator = GoReferencesSearch.search((PsiElement)function, function.getUseScope(), referenceElementPredicate).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            GoReferenceExpression expression;
            PsiReference reference = (PsiReference)iterator2.next();
            ProgressManager.checkCanceled();
            PsiElement psiElement = reference.getElement();
            GoReferenceExpression goReferenceExpression = psiElement instanceof GoReferenceExpression ? (GoReferenceExpression)psiElement : null;
            if (goReferenceExpression == null || !((expression = goReferenceExpression).getGoType(null) instanceof GoFunctionType)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isUsedInFunctionType$lambda$0(PsiElement it) {
        return it instanceof GoReferenceExpression && !GoRefactoringUtil.isCall(it);
    }

    public static final /* synthetic */ void access$registerProblem(GoUnusedTypeParameterInspection $this, GoProblemsHolder holder, PsiElement element, LocalQuickFix ... fixes) {
        $this.registerProblem(holder, element, fixes);
    }
}

