/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.time;

import com.goide.inspections.time.GoTimeFile;
import com.goide.inspections.time.GoTimeParameterInfoHandler;
import com.goide.inspections.time.GoTimeToken;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.macro.EnumMacro;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTimeCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Key<Integer> ITEM_WEIGHT = Key.create((String)"GO_TIME_ITEM_WEIGHT");
    private static final GoTimeCompletionItem[] ISO_ALIASES = new GoTimeCompletionItem[]{new GoTimeCompletionItem("YY", GoTimeToken.ZERO_YEAR), new GoTimeCompletionItem("YYYY", GoTimeToken.LONG_YEAR), new GoTimeCompletionItem("MM", GoTimeToken.ZERO_MONTH), new GoTimeCompletionItem("DD", GoTimeToken.ZERO_DAY), new GoTimeCompletionItem("hh", GoTimeToken.HOUR), new GoTimeCompletionItem("mm", GoTimeToken.ZERO_MINUTE), new GoTimeCompletionItem("ss", GoTimeToken.ZERO_SECOND)};
    private static final GoTimeCompletionCategory[] CATEGORIES = new GoTimeCompletionCategory[]{new GoTimeCompletionCategory("year", GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ZERO_YEAR, "2-digit"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.LONG_YEAR, "4-digit")), new GoTimeCompletionCategory("month", GoTimeCompletionContributor.createCategoryItem(GoTimeToken.MONTH, "short name"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.LONG_MONTH, "full name"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.NUM_MONTH, "month of year"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ZERO_MONTH, "month of year, zero-padded")), new GoTimeCompletionCategory("day", GoTimeCompletionContributor.createCategoryItem(GoTimeToken.LONG_WEEK_DAY, "full name"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.WEEK_DAY, "short name"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.DAY, "day of month"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ZERO_DAY, "day of month, zero-padded"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.UNDER_DAY, "day of month, space-padded"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ZERO_YEAR_DAY, "day of year, zero-padded"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.UNDER_YEAR, "day of year, space-padded")), new GoTimeCompletionCategory("hour", GoTimeCompletionContributor.createCategoryItem(GoTimeToken.HOUR12, "12-hour"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ZERO_HOUR12, "12-hour, zero-padded"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.HOUR, "24-hour, zero-padded"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.PM_SMALL, "am/pm"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.PM_BIG, "AM/PM")), new GoTimeCompletionCategory("minute", GoTimeCompletionContributor.createCategoryItem(GoTimeToken.MINUTE, "minute of hour"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ZERO_MINUTE, "minute of hour, zero padded")), new GoTimeCompletionCategory("second", GoTimeCompletionContributor.createCategoryItem(GoTimeToken.SECOND, "second of minute"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ZERO_SECOND, "second of minute, zero-padded"), GoTimeCompletionContributor.createCategoryItem("millisecond", ".000", ".000"), GoTimeCompletionContributor.createCategoryItem("millisecond, no trailing zeros", ".999", ".999"), GoTimeCompletionContributor.createCategoryItem("fraction of second", ".0+", ".0"), GoTimeCompletionContributor.createCategoryItem("fraction of second, no trailing zeros", ".9+", ".9")), new GoTimeCompletionCategory("zone", GoTimeCompletionContributor.createCategoryItem(GoTimeToken.TZ, "name"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.NUM_SHORT_TZ, "\u00b1hh"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ISO_8601_SHORT_TZ, "\u00b1hh, Z for UTC"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.NUM_TZ, "\u00b1hhmm"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ISO_8601_TZ, "\u00b1hhmm, Z for UTC"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.NUM_SECONDS_TZ, "\u00b1hhmmss"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ISO_8601_SECONDS_TZ, "\u00b1hhmmss, Z for UTC"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.NUM_COLON_TZ, "\u00b1hh:mm"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ISO_8601_COLON_TZ, "\u00b1hh:mm, Z for UTC"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.NUM_COLON_SECONDS_TZ, "\u00b1hh:mm:ss"), GoTimeCompletionContributor.createCategoryItem(GoTimeToken.ISO_8601_COLON_SECONDS_TZ, "\u00b1hh:mm:ss, Z for UTC"))};

    public GoTimeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside(GoTimeFile.class), new GoTimeCompletionProvider());
    }

    @NotNull
    private static String getPrefix(@NotNull CompletionParameters parameters, @NotNull GoTimeFile file) {
        int completionOffset;
        if (parameters == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(1);
        }
        String text = file.getText();
        int prefixStart = completionOffset = parameters.getOffset();
        int i = completionOffset;
        while (i >= 0 && Character.isAlphabetic(text.charAt(i))) {
            prefixStart = i--;
        }
        String prefix = text.substring(prefixStart, completionOffset);
        String string = prefix = StringUtil.trimStart((String)prefix, (String)"T");
        if (string == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static GoTimeCompletionItem createCategoryItem(@NotNull GoTimeToken token, @NotNull String lookupString) {
        if (token == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(3);
        }
        if (lookupString == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(4);
        }
        return GoTimeCompletionContributor.createCategoryItem(token, lookupString, Objects.requireNonNull(token.getExpectedText()));
    }

    private static GoTimeCompletionItem createCategoryItem(@NotNull GoTimeToken token, @NotNull String lookupString, @NotNull String insertText) {
        if (token == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(5);
        }
        if (lookupString == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(6);
        }
        if (insertText == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(7);
        }
        return GoTimeCompletionContributor.createCategoryItem(lookupString, Objects.requireNonNull(token.getExpectedText()), insertText);
    }

    private static GoTimeCompletionItem createCategoryItem(@NotNull String lookupString, @NotNull String description, @NotNull String insertText) {
        if (lookupString == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(8);
        }
        if (description == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(9);
        }
        if (insertText == null) {
            GoTimeCompletionContributor.$$$reportNull$$$0(10);
        }
        return new GoTimeCompletionItem(lookupString, description, insertText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/time/GoTimeCompletionContributor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/time/GoTimeCompletionContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCategoryItem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class GoTimeCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private GoTimeCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            LookupElement element;
            PsiElement position;
            GoTimeFile file;
            if (parameters == null) {
                GoTimeCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                GoTimeCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                GoTimeCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((file = (GoTimeFile)((Object)ObjectUtils.tryCast((Object)(position = parameters.getPosition()).getContainingFile(), GoTimeFile.class))) == null) {
                return;
            }
            String prefix = GoTimeCompletionContributor.getPrefix(parameters, file);
            result = result.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix, false));
            result = result.withRelevanceSorter(CompletionSorter.emptySorter().weigh((LookupElementWeigher)new GoTimeWeigher()));
            int weight = 0;
            ArrayList<LookupElementDecorator> elements = new ArrayList<LookupElementDecorator>();
            for (GoTimeCompletionItem item : ISO_ALIASES) {
                element = LookupElementBuilder.create((String)item.myLookupString).withTypeText(item.myDescription).withInsertHandler((InsertHandler)new TokenInsertHandler(item.myInsertText)).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                element.putUserData(ITEM_WEIGHT, (Object)weight++);
                elements.add(new LookupElementDecorator<LookupElement>(element){

                    public boolean isWorthShowingInAutoPopup() {
                        return true;
                    }
                });
            }
            for (GoTimeCompletionCategory category : CATEGORIES) {
                element = LookupElementBuilder.create((String)category.myName).withTailText("...", true).withInsertHandler((InsertHandler)new GoTimeCategoryInsertHandler(category)).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                element.putUserData(ITEM_WEIGHT, (Object)weight++);
                elements.add(new LookupElementDecorator<LookupElement>(element){

                    public boolean isWorthShowingInAutoPopup() {
                        return true;
                    }
                });
            }
            result.addAllElements(elements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/time/GoTimeCompletionContributor$GoTimeCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GoTimeCompletionItem {
        private final String myLookupString;
        private final String myDescription;
        private final String myInsertText;
        private final List<String> myAdditionalLookupStrings;

        private GoTimeCompletionItem(@NotNull String lookupString, @NotNull GoTimeToken token) {
            if (lookupString == null) {
                GoTimeCompletionItem.$$$reportNull$$$0(0);
            }
            if (token == null) {
                GoTimeCompletionItem.$$$reportNull$$$0(1);
            }
            this(lookupString, GoTimeParameterInfoHandler.DESCRIPTIONS.get((Object)token), Objects.requireNonNull(token.getExpectedText()));
        }

        private GoTimeCompletionItem(@NotNull String lookupString, @NotNull String description, @NotNull String insertText) {
            if (lookupString == null) {
                GoTimeCompletionItem.$$$reportNull$$$0(2);
            }
            if (description == null) {
                GoTimeCompletionItem.$$$reportNull$$$0(3);
            }
            if (insertText == null) {
                GoTimeCompletionItem.$$$reportNull$$$0(4);
            }
            this.myLookupString = lookupString;
            this.myDescription = description;
            this.myInsertText = insertText;
            this.myAdditionalLookupStrings = StringUtil.getWordsIn((String)lookupString);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lookupString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "token";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "insertText";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/time/GoTimeCompletionContributor$GoTimeCompletionItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GoTimeCompletionCategory {
        private final String myName;
        private final GoTimeCompletionItem[] myItems;

        private GoTimeCompletionCategory(@NotNull String name, GoTimeCompletionItem ... items) {
            if (name == null) {
                GoTimeCompletionCategory.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myItems = items;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/goide/inspections/time/GoTimeCompletionContributor$GoTimeCompletionCategory", "<init>"));
        }
    }

    private static class GoTimeWeigher
    extends LookupElementWeigher {
        GoTimeWeigher() {
            super("GoTimeWeigher");
        }

        @Nullable
        public Comparable weigh(@NotNull LookupElement element) {
            if (element == null) {
                GoTimeWeigher.$$$reportNull$$$0(0);
            }
            return (Comparable)element.getUserData(ITEM_WEIGHT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/inspections/time/GoTimeCompletionContributor$GoTimeWeigher", "weigh"));
        }
    }

    private static class GoTimeCategoryInsertHandler
    implements InsertHandler<LookupElement> {
        private final GoTimeCompletionCategory myCategory;

        GoTimeCategoryInsertHandler(@NotNull GoTimeCompletionCategory category) {
            if (category == null) {
                GoTimeCategoryInsertHandler.$$$reportNull$$$0(0);
            }
            this.myCategory = category;
        }

        public void handleInsert(@NotNull InsertionContext ctx, @NotNull LookupElement item) {
            if (ctx == null) {
                GoTimeCategoryInsertHandler.$$$reportNull$$$0(1);
            }
            if (item == null) {
                GoTimeCategoryInsertHandler.$$$reportNull$$$0(2);
            }
            int start = ctx.getStartOffset();
            int end = ctx.getTailOffset();
            ctx.getDocument().deleteString(start, end);
            TemplateImpl template = new TemplateImpl("", "");
            MacroCallNode categoryItem = new MacroCallNode((Macro)new EnumMacro(){

                public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
                    if (params == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ArrayList<LookupElement> elements = new ArrayList<LookupElement>();
                    for (GoTimeCompletionItem item : myCategory.myItems) {
                        LookupElement element = LookupElementBuilder.create((String)item.myLookupString).withTypeText(item.myDescription).withLookupStrings(item.myAdditionalLookupStrings).withInsertHandler((InsertHandler)new TokenInsertHandler(item.myInsertText)).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                        elements.add(element);
                    }
                    return elements.toArray(LookupElement.EMPTY_ARRAY);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/goide/inspections/time/GoTimeCompletionContributor$GoTimeCategoryInsertHandler$1", "calculateLookupItems"));
                }
            });
            template.addVariable("V", (Expression)categoryItem, true);
            TemplateManager.getInstance((Project)ctx.getProject()).startTemplate(ctx.getEditor(), (Template)template);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/time/GoTimeCompletionContributor$GoTimeCategoryInsertHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TokenInsertHandler
    implements InsertHandler<LookupElement> {
        private final String myTokenText;

        TokenInsertHandler(@NotNull String tokenText) {
            if (tokenText == null) {
                TokenInsertHandler.$$$reportNull$$$0(0);
            }
            this.myTokenText = tokenText;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                TokenInsertHandler.$$$reportNull$$$0(1);
            }
            if (item == null) {
                TokenInsertHandler.$$$reportNull$$$0(2);
            }
            int start = context.getStartOffset();
            int end = context.getTailOffset();
            Document document = context.getEditor().getDocument();
            if (this.myTokenText.startsWith(".") && start > 0 && document.getCharsSequence().charAt(start - 1) == '.') {
                --start;
            }
            document.replaceString(start, end, (CharSequence)this.myTokenText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/goide/inspections/time/GoTimeCompletionContributor$TokenInsertHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

