/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.goide.i18n.GoBundle;
import com.goide.inspections.tag.GoTagEntry;
import com.goide.inspections.tag.GoTagFile;
import com.goide.inspections.tag.GoTagUtil;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTag;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class GoTagUpdateValueIntention
extends GoBaseIntentionAction
implements Iconable,
PriorityAction {
    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.update.value.in.tags", (Object[])new Object[0]);
        if (string == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Tag;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.TOP;
        if (priority == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(2);
        }
        return priority;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(5);
        }
        if (!GoTagUtil.RAW_STRING_IN_STRUCT_TAG.accepts((Object)element)) {
            return false;
        }
        return GoTagUtil.getTagEntry(element, editor.getCaretModel().getOffset()) != null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(8);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(9);
        }
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        GoTagEntry currentEntry;
        if (project == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(11);
        }
        if (element == null) {
            GoTagUpdateValueIntention.$$$reportNull$$$0(12);
        }
        if ((currentEntry = GoTagUtil.getTagEntry(element, editor.getCaretModel().getOffset())) == null) {
            return;
        }
        String currentKey = currentEntry.getKey().getText();
        editor.getCaretModel().removeSecondaryCarets();
        Caret primaryCaret = editor.getCaretModel().getPrimaryCaret();
        GoTag currentTag = (GoTag)PsiTreeUtil.getParentOfType((PsiElement)element, GoTag.class);
        GoStructType struct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)element, GoStructType.class);
        block0: for (GoFieldDeclaration field : SyntaxTraverser.psiTraverser((PsiElement)struct).postOrderDfsTraversal().filter(GoFieldDeclaration.class)) {
            GoTag tag = field.getTag();
            if (tag == currentTag) {
                primaryCaret.moveToOffset(element.getTextRange().getStartOffset() + currentEntry.getValue().getTextRange().getEndOffset());
                continue;
            }
            GoStringLiteral tagLiteral = tag != null ? tag.getStringLiteral() : null;
            GoTagFile file = GoTagUtil.parseTagLiteral(tagLiteral);
            if (file == null) continue;
            for (GoTagEntry entry : file.getEntries()) {
                if (!currentKey.equals(entry.getKey().getText())) continue;
                int valueEndOffset = tagLiteral.getTextRange().getStartOffset() + entry.getValue().getTextRange().getEndOffset();
                editor.getCaretModel().addCaret(editor.offsetToVisualPosition(valueEndOffset), false);
                continue block0;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/tag/GoTagUpdateValueIntention";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/tag/GoTagUpdateValueIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

