/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.goide.GoTypes;
import com.goide.inspections.tag.GoTagToken;
import com.goide.lexer.GoLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTagLexer
extends LexerBase {
    private final GoLexer myGoLexer;
    private CharSequence myBuffer;
    private int myOffset;
    private int myEndOffset;
    private int myState;
    private int myTokenStart;
    private int myTokenEnd;
    private IElementType myToken;
    private final PendingToken[] myPendingTokens = new PendingToken[2];
    private int myNextPendingTokenIndex = this.myPendingTokens.length;

    public GoTagLexer() {
        this.myGoLexer = new GoLexer();
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            GoTagLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myState = initialState;
        this.myNextPendingTokenIndex = this.myPendingTokens.length;
        this.advance();
    }

    public void advance() {
        if (this.myOffset >= this.myEndOffset) {
            this.myToken = null;
            return;
        }
        if (this.myNextPendingTokenIndex < this.myPendingTokens.length) {
            PendingToken token = this.myPendingTokens[this.myNextPendingTokenIndex];
            this.myTokenStart = token.myStart;
            this.myTokenEnd = token.myEnd;
            this.myToken = token.myToken;
            this.myOffset = this.myTokenEnd;
            ++this.myNextPendingTokenIndex;
            return;
        }
        int c = this.charAt(this.myOffset);
        if (c == 32) {
            this.consumeSpace();
            return;
        }
        int keyEnd = this.findKeyEndOffset(this.myOffset);
        if (keyEnd > this.myOffset && this.charAt(keyEnd) == 58 && this.charAt(keyEnd + 1) == 34) {
            int keyStart = this.myOffset;
            int stringStart = keyEnd + 1;
            this.myGoLexer.start(this.myBuffer, stringStart, this.myEndOffset);
            IElementType type = this.myGoLexer.getTokenType();
            int stringEnd = this.myGoLexer.getTokenEnd();
            if (type == GoTypes.STRING && stringEnd > stringStart && this.charAt(stringEnd - 1) == 34) {
                this.myTokenStart = keyStart;
                this.myTokenEnd = keyEnd;
                this.myToken = GoTagToken.KEY;
                this.myOffset = this.myTokenEnd;
                this.myPendingTokens[0] = new PendingToken(keyEnd, stringStart, GoTagToken.COLON);
                this.myPendingTokens[1] = new PendingToken(stringStart, stringEnd, GoTagToken.VALUE);
                this.myNextPendingTokenIndex = 0;
                return;
            }
        }
        this.myTokenStart = this.myOffset;
        this.myTokenEnd = this.myEndOffset;
        this.myToken = GoTagToken.TEXT;
        this.myOffset = this.myEndOffset;
    }

    private int findKeyEndOffset(int start) {
        int i;
        for (i = start; i < this.myEndOffset && GoTagLexer.isValidKeyCharacter(this.myBuffer.charAt(i)); ++i) {
        }
        return i;
    }

    private static boolean isValidKeyCharacter(char c) {
        return c > ' ' && c != ':' && c != '\"' && c != '\u007f';
    }

    private void consumeSpace() {
        int i;
        for (i = this.myOffset + 1; i < this.myEndOffset && this.myBuffer.charAt(i) == ' '; ++i) {
        }
        this.myTokenStart = this.myOffset;
        this.myTokenEnd = i;
        this.myToken = GoTagToken.SPACE;
        this.myOffset = this.myTokenEnd;
    }

    public int getState() {
        return this.myState;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myToken;
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            GoTagLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    private int charAt(int offset) {
        return offset < this.myEndOffset ? (int)this.myBuffer.charAt(offset) : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/tag/GoTagLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/tag/GoTagLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class PendingToken {
        private final int myStart;
        private final int myEnd;
        private final GoTagToken myToken;

        private PendingToken(int startOffset, int endOffset, GoTagToken token) {
            this.myStart = startOffset;
            this.myEnd = endOffset;
            this.myToken = token;
        }
    }
}

