/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.godebug;

import com.goide.inspections.GoBaseLexer;
import com.goide.inspections.godebug.GoDebugToken;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0005H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/goide/inspections/godebug/GoDebugLexer;", "Lcom/goide/inspections/GoBaseLexer;", "<init>", "()V", "advance", "", "consumeWhitespace", "consumeEq", "consumeChar", "consumeValue", "consumeKey", "isValidKeyValueChar", "", "ch", "", "isValidKeyChar", "c", "consumeBadCharacter", "Companion", "intellij.go.impl"})
public final class GoDebugLexer
extends GoBaseLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int STATE_BEFORE_AFTER = 0;
    public static final int STATE_KEY = 1;
    public static final int STATE_EQ = 2;
    public static final int STATE_VALUE = 3;

    public void advance() {
        if (this.myOffset >= this.myEndOffset) {
            this.myToken = null;
            return;
        }
        char c = this.getMyBuffer().charAt(this.myOffset);
        if (CharsKt.isWhitespace((char)c)) {
            this.consumeWhitespace();
        } else if (c == '=') {
            this.consumeEq();
        } else if (this.isValidKeyValueChar(c)) {
            this.consumeChar();
        } else {
            this.consumeBadCharacter();
        }
    }

    private final void consumeWhitespace() {
        if (this.myState == 3) {
            this.myState = 0;
        }
        if (this.myState == 0) {
            int i;
            for (i = this.myOffset + 1; i < this.myEndOffset && CharsKt.isWhitespace((char)this.getMyBuffer().charAt(i)); ++i) {
            }
            IElementType iElementType = TokenType.WHITE_SPACE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"WHITE_SPACE");
            this.consumeToken(this.myOffset, i, iElementType);
        } else {
            this.consumeBadCharacter();
        }
    }

    private final void consumeEq() {
        switch (this.myState) {
            case 1: {
                this.myState = 2;
                this.consumeToken(this.myOffset, this.myOffset + 1, GoDebugToken.Eq.INSTANCE);
                break;
            }
            case 2: {
                this.consumeValue();
                break;
            }
            default: {
                this.consumeBadCharacter();
            }
        }
    }

    private final void consumeChar() {
        switch (this.myState) {
            case 0: {
                this.consumeKey();
                break;
            }
            case 2: {
                this.consumeValue();
                break;
            }
            default: {
                this.consumeBadCharacter();
            }
        }
    }

    private final void consumeValue() {
        int i;
        this.myState = 3;
        for (i = this.myOffset + 1; i < this.myEndOffset && this.isValidKeyValueChar(this.getMyBuffer().charAt(i)); ++i) {
        }
        this.consumeToken(this.myOffset, i, GoDebugToken.Value.INSTANCE);
    }

    private final void consumeKey() {
        int i;
        this.myState = 1;
        for (i = this.myOffset + 1; i < this.myEndOffset && this.isValidKeyChar(this.getMyBuffer().charAt(i)); ++i) {
        }
        this.consumeToken(this.myOffset, i, GoDebugToken.Key.INSTANCE);
    }

    private final boolean isValidKeyValueChar(char ch) {
        return ch != ',' && !CharsKt.isWhitespace((char)ch);
    }

    private final boolean isValidKeyChar(char c) {
        return this.isValidKeyValueChar(c) && c != '=';
    }

    private final void consumeBadCharacter() {
        IElementType iElementType = TokenType.BAD_CHARACTER;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"BAD_CHARACTER");
        this.consumeToken(this.myOffset, this.myOffset + 1, iElementType);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/goide/inspections/godebug/GoDebugLexer$Companion;", "", "<init>", "()V", "STATE_BEFORE_AFTER", "", "STATE_KEY", "STATE_EQ", "STATE_VALUE", "intellij.go.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

