/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.core;

import com.goide.inspections.GoExcludedFunctionsAndMethodsSettings;
import com.goide.inspections.GoMethodDescriptors;
import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.impl.imports.GoImportPathUtil;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoMethodDescriptor
implements GoCallableDescriptor {
    private final String myImportPath;
    private final String myReceiver;
    private final String myName;

    public GoMethodDescriptor(@NotNull String importPath, @NotNull String receiver, @NotNull String name) {
        if (importPath == null) {
            GoMethodDescriptor.$$$reportNull$$$0(0);
        }
        if (receiver == null) {
            GoMethodDescriptor.$$$reportNull$$$0(1);
        }
        if (name == null) {
            GoMethodDescriptor.$$$reportNull$$$0(2);
        }
        this.myImportPath = importPath;
        this.myReceiver = receiver;
        this.myName = name;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GoMethodDescriptor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getImportPath() {
        String string = this.myImportPath;
        if (string == null) {
            GoMethodDescriptor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getReceiver() {
        String string = this.myReceiver;
        if (string == null) {
            GoMethodDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoMethodDescriptor that = (GoMethodDescriptor)o;
        return Objects.equals(this.myImportPath, that.myImportPath) && Objects.equals(this.myReceiver, that.myReceiver) && Objects.equals(this.myName, that.myName);
    }

    public String toString() {
        return "(" + this.myImportPath + "." + this.myReceiver + ")." + this.myName;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.myImportPath, this.myReceiver, this.myName);
    }

    @NotNull
    public static GoMethodDescriptor of(@NotNull String descriptorText) {
        Trinity<String, String, String> parts;
        if (descriptorText == null) {
            GoMethodDescriptor.$$$reportNull$$$0(6);
        }
        if ((parts = GoMethodDescriptors.asParts(descriptorText)) == null) {
            throw new IllegalArgumentException("Invalid method descriptor format");
        }
        return new GoMethodDescriptor((String)parts.first, (String)parts.second, (String)parts.third);
    }

    @Nullable
    public static GoMethodDescriptor of(@NotNull GoMethodDeclaration declaration, @NotNull PsiElement context, boolean ignoreVersion) {
        Trinity<String, String, String> parts;
        if (declaration == null) {
            GoMethodDescriptor.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GoMethodDescriptor.$$$reportNull$$$0(8);
        }
        if ((parts = GoExcludedFunctionsAndMethodsSettings.getMethodFqnParts(declaration, context, null)) == null) {
            return null;
        }
        String importPath = ignoreVersion ? GoImportPathUtil.removeVersion((String)parts.first) : (String)parts.first;
        return new GoMethodDescriptor(importPath, (String)parts.second, (String)parts.third);
    }

    @Nullable
    public static GoMethodDescriptor of(@NotNull GoMethodSpec methodSpec, @NotNull PsiElement context, boolean ignoreVersion) {
        Trinity<String, String, String> parts;
        if (methodSpec == null) {
            GoMethodDescriptor.$$$reportNull$$$0(9);
        }
        if (context == null) {
            GoMethodDescriptor.$$$reportNull$$$0(10);
        }
        if ((parts = GoExcludedFunctionsAndMethodsSettings.getMethodFqnParts(methodSpec, context, null)) == null) {
            return null;
        }
        String importPath = ignoreVersion ? GoImportPathUtil.removeVersion((String)parts.first) : (String)parts.first;
        return new GoMethodDescriptor(importPath, (String)parts.second, (String)parts.third);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/core/GoMethodDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/core/GoMethodDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

