/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.buildTag;

import com.goide.inspections.buildTag.GoBuildAndElement;
import com.goide.inspections.buildTag.GoBuildElement;
import com.goide.inspections.buildTag.GoBuildElementType;
import com.goide.inspections.buildTag.GoBuildLanguage;
import com.goide.inspections.buildTag.GoBuildLexer;
import com.goide.inspections.buildTag.GoBuildNotElement;
import com.goide.inspections.buildTag.GoBuildOrElement;
import com.goide.inspections.buildTag.GoBuildParElement;
import com.goide.inspections.buildTag.GoBuildParser;
import com.goide.inspections.buildTag.GoBuildTagElement;
import com.goide.inspections.buildTag.GoBuildTagEnvironment;
import com.goide.inspections.buildTag.GoBuildToken;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildAndElement;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildElement;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildLanguage;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildNotElement;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildOrElement;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildTagElement;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.util.GoBuildMatcher;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoBuildTagUtil {
    @NotNull
    public static List<String> getPlusBuildConstraintsForGoBuildDirective(@Nullable GoBuildElement e) {
        List<String> list = e != null ? GoBuildTagUtil.getPlusBuildConstraints(e) : Collections.emptyList();
        if (list == null) {
            GoBuildTagUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public static GoBuildElement parseGoBuildElement(@NotNull PsiElement goBuildDirective) {
        if (goBuildDirective == null) {
            GoBuildTagUtil.$$$reportNull$$$0(1);
        }
        if (!GoPsiUtil.isGoBuildDirective(goBuildDirective)) {
            return null;
        }
        String text = StringUtil.trim((String)goBuildDirective.getText().substring("//go:build".length()));
        return GoBuildTagUtil.parseGoBuildElement(goBuildDirective.getProject(), text);
    }

    @NotNull
    public static FlyweightCapableTreeStructure<LighterASTNode> parseGoBuildElement(@NotNull String text) {
        if (text == null) {
            GoBuildTagUtil.$$$reportNull$$$0(2);
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)GoBuildLanguage.INSTANCE);
        PsiBuilder b = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)new GoBuildLexer(), (CharSequence)text);
        new GoBuildParser().parseLight((IElementType)parserDefinition.getFileNodeType(), b);
        FlyweightCapableTreeStructure flyweightCapableTreeStructure = b.getLightTree();
        if (flyweightCapableTreeStructure == null) {
            GoBuildTagUtil.$$$reportNull$$$0(3);
        }
        return flyweightCapableTreeStructure;
    }

    @Nullable
    public static GoBuildElement parseGoBuildElement(@NotNull Project project, @NotNull String text) {
        PsiFile file;
        if (project == null) {
            GoBuildTagUtil.$$$reportNull$$$0(4);
        }
        if (text == null) {
            GoBuildTagUtil.$$$reportNull$$$0(5);
        }
        if (PsiTreeUtil.findChildOfType((PsiElement)(file = PsiFileFactory.getInstance((Project)project).createFileFromText("go.build.tag", (Language)GoBuildLanguage.INSTANCE, (CharSequence)text)), PsiErrorElement.class) != null) {
            return null;
        }
        List elements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)file, PsiElement.class);
        return (GoBuildElement)((Object)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem((Collection)elements), GoBuildElement.class));
    }

    @Nullable
    public static GoPlusBuildElement parsePlusBuildElement(@NotNull PsiElement plusBuildComment) {
        if (plusBuildComment == null) {
            GoBuildTagUtil.$$$reportNull$$$0(6);
        }
        if (!GoPsiUtil.isBuildTagComment(plusBuildComment)) {
            return null;
        }
        String text = StringUtil.trimLeading((String)StringUtil.trimStart((String)plusBuildComment.getText(), (String)"//"));
        String expression = StringUtil.trim((String)text.substring("+build".length()));
        return GoBuildTagUtil.parsePlusBuildElement(plusBuildComment.getProject(), expression);
    }

    @Nullable
    public static GoPlusBuildElement parsePlusBuildElement(@NotNull Project project, @NotNull String text) {
        PsiFile file;
        if (project == null) {
            GoBuildTagUtil.$$$reportNull$$$0(7);
        }
        if (text == null) {
            GoBuildTagUtil.$$$reportNull$$$0(8);
        }
        if (PsiTreeUtil.findChildOfType((PsiElement)(file = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)GoPlusBuildLanguage.INSTANCE, (CharSequence)text)), PsiErrorElement.class) != null) {
            return null;
        }
        List elements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)file, PsiElement.class);
        return (GoPlusBuildElement)((Object)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem((Collection)elements), GoPlusBuildElement.class));
    }

    @NotNull
    public static Set<Set<String>> getPowerSet(@NotNull Set<String> set) {
        if (set == null) {
            GoBuildTagUtil.$$$reportNull$$$0(9);
        }
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        if (set.isEmpty()) {
            result.add(new HashSet());
        } else {
            for (String element : set) {
                HashSet<String> rest = new HashSet<String>(set);
                rest.remove(element);
                Set<Set<String>> subSetPs = GoBuildTagUtil.getPowerSet(rest);
                result.addAll(subSetPs);
                for (Set<String> it : subSetPs) {
                    result.add(ContainerUtil.union(it, Collections.singleton(element)));
                }
            }
        }
        HashSet<Set<String>> hashSet = result;
        if (hashSet == null) {
            GoBuildTagUtil.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    public static GoBuildMatcher.MatchingResult eval(@NotNull GoBuildElement e, @NotNull GoBuildTagEnvironment env) {
        if (e == null) {
            GoBuildTagUtil.$$$reportNull$$$0(11);
        }
        if (env == null) {
            GoBuildTagUtil.$$$reportNull$$$0(12);
        }
        if (e instanceof GoBuildTagElement) {
            return env.inferMatchingResult(e.getText());
        }
        if (e instanceof GoBuildParElement) {
            GoBuildElement nested = Objects.requireNonNull((GoBuildElement)((Object)ContainerUtil.getOnlyItem((Collection)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)e, GoBuildElement.class))));
            return GoBuildTagUtil.eval(nested, env);
        }
        if (e instanceof GoBuildNotElement) {
            GoBuildElement negated = Objects.requireNonNull((GoBuildElement)((Object)ContainerUtil.getOnlyItem((Collection)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)e, GoBuildElement.class))));
            return GoBuildTagUtil.eval(negated, env).invert();
        }
        if (e instanceof GoBuildAndElement) {
            return GoBuildMatcher.MatchingResult.and(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)e, GoBuildElement.class), child -> GoBuildTagUtil.eval(child, env));
        }
        if (e instanceof GoBuildOrElement) {
            return GoBuildMatcher.MatchingResult.or(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)e, GoBuildElement.class), child -> GoBuildTagUtil.eval(child, env));
        }
        throw new RuntimeException("Unknown element type " + e.getNode().getElementType());
    }

    @NotNull
    public static List<LighterASTNode> getChildren(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode node, @NotNull Predicate<IElementType> tokenPredicate) {
        if (tree == null) {
            GoBuildTagUtil.$$$reportNull$$$0(13);
        }
        if (node == null) {
            GoBuildTagUtil.$$$reportNull$$$0(14);
        }
        if (tokenPredicate == null) {
            GoBuildTagUtil.$$$reportNull$$$0(15);
        }
        Ref childrenRef = new Ref();
        tree.getChildren((Object)node, childrenRef);
        List list = ContainerUtil.filter((Object[])((LighterASTNode[])childrenRef.get()), it -> {
            if (it == null) {
                return false;
            }
            IElementType tokenType = it.getTokenType();
            return tokenType != TokenType.WHITE_SPACE && tokenPredicate.test(it.getTokenType());
        });
        if (list == null) {
            GoBuildTagUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static GoBuildMatcher.MatchingResult eval(@NotNull String text, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode node, @NotNull GoBuildTagEnvironment env) {
        IElementType tokenType;
        if (text == null) {
            GoBuildTagUtil.$$$reportNull$$$0(17);
        }
        if (tree == null) {
            GoBuildTagUtil.$$$reportNull$$$0(18);
        }
        if (node == null) {
            GoBuildTagUtil.$$$reportNull$$$0(19);
        }
        if (env == null) {
            GoBuildTagUtil.$$$reportNull$$$0(20);
        }
        if ((tokenType = node.getTokenType()) == GoBuildElementType.TAG) {
            GoBuildMatcher.MatchingResult matchingResult = env.inferMatchingResult(text.substring(node.getStartOffset(), node.getEndOffset()));
            if (matchingResult == null) {
                GoBuildTagUtil.$$$reportNull$$$0(21);
            }
            return matchingResult;
        }
        if (tokenType == GoBuildElementType.PAR) {
            List<LighterASTNode> children = GoBuildTagUtil.getChildren(tree, node, type -> type != GoBuildToken.LPAREN && type != GoBuildToken.RPAREN);
            if (children.size() == 1) {
                return GoBuildTagUtil.eval(text, tree, children.get(0), env);
            }
            GoBuildMatcher.MatchingResult matchingResult = GoBuildMatcher.MatchingResult.mismatch(GoBuildMatcher.MatchingReason.SYNTAX);
            if (matchingResult == null) {
                GoBuildTagUtil.$$$reportNull$$$0(22);
            }
            return matchingResult;
        }
        if (tokenType == GoBuildElementType.NOT) {
            List<LighterASTNode> children = GoBuildTagUtil.getChildren(tree, node, type -> true);
            if (children.size() == 2) {
                GoBuildMatcher.MatchingResult matchingResult = GoBuildTagUtil.eval(text, tree, children.get(1), env).invert();
                if (matchingResult == null) {
                    GoBuildTagUtil.$$$reportNull$$$0(23);
                }
                return matchingResult;
            }
            GoBuildMatcher.MatchingResult matchingResult = GoBuildMatcher.MatchingResult.mismatch(GoBuildMatcher.MatchingReason.SYNTAX);
            if (matchingResult == null) {
                GoBuildTagUtil.$$$reportNull$$$0(24);
            }
            return matchingResult;
        }
        if (tokenType == GoBuildElementType.AND) {
            List<LighterASTNode> children = GoBuildTagUtil.getChildren(tree, node, type -> type != GoBuildToken.AND);
            GoBuildMatcher.MatchingResult matchingResult = GoBuildMatcher.MatchingResult.and(children, child -> GoBuildTagUtil.eval(text, tree, child, env));
            if (matchingResult == null) {
                GoBuildTagUtil.$$$reportNull$$$0(25);
            }
            return matchingResult;
        }
        if (tokenType == GoBuildElementType.OR) {
            List<LighterASTNode> children = GoBuildTagUtil.getChildren(tree, node, type -> type != GoBuildToken.OR);
            GoBuildMatcher.MatchingResult matchingResult = GoBuildMatcher.MatchingResult.or(children, child -> GoBuildTagUtil.eval(text, tree, child, env));
            if (matchingResult == null) {
                GoBuildTagUtil.$$$reportNull$$$0(26);
            }
            return matchingResult;
        }
        GoBuildMatcher.MatchingResult matchingResult = GoBuildMatcher.MatchingResult.mismatch(GoBuildMatcher.MatchingReason.SYNTAX);
        if (matchingResult == null) {
            GoBuildTagUtil.$$$reportNull$$$0(27);
        }
        return matchingResult;
    }

    public static GoBuildMatcher.MatchingResult eval(@NotNull List<GoPlusBuildElement> constraints, @NotNull GoBuildTagEnvironment env) {
        if (constraints == null) {
            GoBuildTagUtil.$$$reportNull$$$0(28);
        }
        if (env == null) {
            GoBuildTagUtil.$$$reportNull$$$0(29);
        }
        return GoBuildMatcher.MatchingResult.and(constraints, constraint -> GoBuildTagUtil.eval(constraint, env));
    }

    private static GoBuildMatcher.MatchingResult eval(@NotNull GoPlusBuildElement e, @NotNull GoBuildTagEnvironment env) {
        if (e == null) {
            GoBuildTagUtil.$$$reportNull$$$0(30);
        }
        if (env == null) {
            GoBuildTagUtil.$$$reportNull$$$0(31);
        }
        if (e instanceof GoPlusBuildTagElement) {
            GoPlusBuildTagElement tagElement = (GoPlusBuildTagElement)e;
            return env.inferMatchingResult(tagElement.getTagText());
        }
        if (e instanceof GoPlusBuildNotElement) {
            GoPlusBuildElement negated = Objects.requireNonNull((GoPlusBuildElement)((Object)ContainerUtil.getOnlyItem((Collection)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)e, GoPlusBuildElement.class))));
            return GoBuildTagUtil.eval(negated, env).invert();
        }
        if (e instanceof GoPlusBuildAndElement) {
            return GoBuildMatcher.MatchingResult.and(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)e, GoPlusBuildElement.class), child -> GoBuildTagUtil.eval(child, env));
        }
        if (e instanceof GoPlusBuildOrElement) {
            return GoBuildMatcher.MatchingResult.or(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)e, GoPlusBuildElement.class), child -> GoBuildTagUtil.eval(child, env));
        }
        throw new RuntimeException("Unknown element type " + e.getNode().getElementType());
    }

    @NotNull
    public static Set<String> getTags(@NotNull GoBuildElement element) {
        if (element == null) {
            GoBuildTagUtil.$$$reportNull$$$0(32);
        }
        Set set = SyntaxTraverser.psiTraverser((PsiElement)element).filter(GoBuildTagElement.class).map(it -> it.getText()).toSet();
        if (set == null) {
            GoBuildTagUtil.$$$reportNull$$$0(33);
        }
        return set;
    }

    @NotNull
    public static Set<String> getTags(@NotNull List<GoPlusBuildElement> elements) {
        if (elements == null) {
            GoBuildTagUtil.$$$reportNull$$$0(34);
        }
        HashSet<String> result = new HashSet<String>();
        for (GoPlusBuildElement element : elements) {
            result.addAll(SyntaxTraverser.psiTraverser((PsiElement)element).filter(GoPlusBuildTagElement.class).map(it -> it.getTagText()).toList());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            GoBuildTagUtil.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    public static boolean hasEmptyTags(@NotNull GoPlusBuildElement root) {
        if (root == null) {
            GoBuildTagUtil.$$$reportNull$$$0(36);
        }
        return ContainerUtil.exists((Iterable)PsiTreeUtil.findChildrenOfType((PsiElement)root, GoPlusBuildTagElement.class), tag -> tag.getText().isEmpty());
    }

    @NotNull
    private static List<String> getPlusBuildConstraints(@NotNull GoBuildElement element) {
        Expr expr;
        if (element == null) {
            GoBuildTagUtil.$$$reportNull$$$0(37);
        }
        if ((expr = GoBuildTagUtil.convertToExpr((PsiElement)element)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GoBuildTagUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        expr = GoBuildTagUtil.pushNot(expr, false);
        List<PlusBuildOrExpr> split = new ArrayList<PlusBuildOrExpr>();
        for (Expr or2 : GoBuildTagUtil.splitAnd(new ArrayList<Expr>(), expr)) {
            PlusBuildOrExpr orGroup = new PlusBuildOrExpr();
            for (Expr and : GoBuildTagUtil.splitOr(new ArrayList<Expr>(), or2)) {
                PlusBuildAndExpr andGroup = new PlusBuildAndExpr();
                for (Expr leaf : GoBuildTagUtil.splitAnd(new ArrayList<Expr>(), and)) {
                    if (leaf instanceof Leaf) {
                        andGroup.addLeaf((Leaf)leaf);
                        continue;
                    }
                    List<String> list = Collections.emptyList();
                    if (list == null) {
                        GoBuildTagUtil.$$$reportNull$$$0(39);
                    }
                    return list;
                }
                orGroup.addAnd(andGroup);
            }
            split.add(orGroup);
        }
        int maxOrSize = (Integer)Collections.max(ContainerUtil.map(split, or -> or.size()));
        if (split.size() > 1 && maxOrSize == 1) {
            PlusBuildAndExpr combinedAnd = new PlusBuildAndExpr();
            for (PlusBuildOrExpr orExpr : split) {
                for (PlusBuildAndExpr and : orExpr.myAnds) {
                    combinedAnd.myLeaves.addAll(and.myLeaves);
                }
            }
            PlusBuildOrExpr combined = new PlusBuildOrExpr();
            combined.addAnd(combinedAnd);
            split = Collections.singletonList(combined);
        }
        List list = ContainerUtil.map(split, it -> it.toString());
        if (list == null) {
            GoBuildTagUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    @Nullable
    private static Expr convertToExpr(@Nullable PsiElement e) {
        if (e instanceof GoBuildTagElement) {
            return new TagExpr(e.getText());
        }
        if (e instanceof GoBuildParElement) {
            GoBuildElement inner = (GoBuildElement)((Object)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(Arrays.asList(e.getChildren())), GoBuildElement.class));
            return inner != null ? GoBuildTagUtil.convertToExpr((PsiElement)inner) : null;
        }
        if (e instanceof GoBuildNotElement) {
            GoBuildElement negated = (GoBuildElement)((Object)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(Arrays.asList(e.getChildren())), GoBuildElement.class));
            Expr child = GoBuildTagUtil.convertToExpr((PsiElement)negated);
            return child != null ? new NotExpr(child) : null;
        }
        if (e instanceof GoBuildAndElement) {
            List<Expr> children = GoBuildTagUtil.convertToExpressions(e);
            return children != null ? new AndExpr(children) : null;
        }
        if (e instanceof GoBuildOrElement) {
            List<Expr> children = GoBuildTagUtil.convertToExpressions(e);
            return children != null ? new OrExpr(children) : null;
        }
        return null;
    }

    @Nullable
    private static List<Expr> convertToExpressions(@NotNull PsiElement e) {
        if (e == null) {
            GoBuildTagUtil.$$$reportNull$$$0(41);
        }
        ArrayList<Expr> children = new ArrayList<Expr>();
        for (PsiElement childElement : e.getChildren()) {
            Expr child = GoBuildTagUtil.convertToExpr(childElement);
            if (child == null) {
                return null;
            }
            children.add(child);
        }
        return children;
    }

    @NotNull
    private static List<Expr> splitAnd(@NotNull List<Expr> list, @NotNull Expr expr) {
        if (list == null) {
            GoBuildTagUtil.$$$reportNull$$$0(42);
        }
        if (expr == null) {
            GoBuildTagUtil.$$$reportNull$$$0(43);
        }
        if (expr instanceof AndExpr) {
            for (Expr child : ((AndExpr)expr).myChildren) {
                GoBuildTagUtil.splitAnd(list, child);
            }
        } else {
            list.add(expr);
        }
        List<Expr> list2 = list;
        if (list2 == null) {
            GoBuildTagUtil.$$$reportNull$$$0(44);
        }
        return list2;
    }

    @NotNull
    private static List<Expr> splitOr(@NotNull List<Expr> list, @NotNull Expr expr) {
        if (list == null) {
            GoBuildTagUtil.$$$reportNull$$$0(45);
        }
        if (expr == null) {
            GoBuildTagUtil.$$$reportNull$$$0(46);
        }
        if (expr instanceof OrExpr) {
            for (Expr child : ((OrExpr)expr).myChildren) {
                GoBuildTagUtil.splitOr(list, child);
            }
        } else {
            list.add(expr);
        }
        List<Expr> list2 = list;
        if (list2 == null) {
            GoBuildTagUtil.$$$reportNull$$$0(47);
        }
        return list2;
    }

    @NotNull
    private static Expr pushNot(@NotNull Expr expr, boolean not) {
        if (expr == null) {
            GoBuildTagUtil.$$$reportNull$$$0(48);
        }
        if (expr instanceof TagExpr) {
            Expr expr2 = not ? new NotExpr(expr) : expr;
            if (expr2 == null) {
                GoBuildTagUtil.$$$reportNull$$$0(49);
            }
            return expr2;
        }
        if (expr instanceof NotExpr) {
            return GoBuildTagUtil.pushNot(((NotExpr)expr).myChild, !not);
        }
        if (expr instanceof AndExpr) {
            List children = ContainerUtil.map(((AndExpr)expr).myChildren, it -> GoBuildTagUtil.pushNot(it, not));
            return not ? new OrExpr(children) : new AndExpr(children);
        }
        if (expr instanceof OrExpr) {
            List children = ContainerUtil.map(((OrExpr)expr).myChildren, it -> GoBuildTagUtil.pushNot(it, not));
            return not ? new AndExpr(children) : new OrExpr(children);
        }
        throw new RuntimeException("Unknown expr type " + expr.getClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 17, 18, 19, 20, 28, 29, 30, 31, 32, 34, 36, 37, 41, 42, 43, 45, 46, 48 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/buildTag/GoBuildTagUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goBuildDirective";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plusBuildComment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 11: 
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: 
            case 20: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenPredicate";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 43: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlusBuildConstraintsForGoBuildDirective";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/buildTag/GoBuildTagUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGoBuildElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPowerSet";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "eval";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlusBuildConstraints";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "splitAnd";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "splitOr";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "pushNot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseGoBuildElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parsePlusBuildElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPowerSet";
                break;
            }
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "eval";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTags";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasEmptyTags";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPlusBuildConstraints";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "convertToExpressions";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "splitAnd";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "splitOr";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "pushNot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 17, 18, 19, 20, 28, 29, 30, 31, 32, 34, 36, 37, 41, 42, 43, 45, 46, 48 -> new IllegalArgumentException(string);
        };
    }

    private static abstract class Expr {
        private Expr() {
        }
    }

    private static class PlusBuildOrExpr {
        private final List<PlusBuildAndExpr> myAnds = new ArrayList<PlusBuildAndExpr>();

        private PlusBuildOrExpr() {
        }

        void addAnd(@NotNull PlusBuildAndExpr and) {
            if (and == null) {
                PlusBuildOrExpr.$$$reportNull$$$0(0);
            }
            this.myAnds.add(and);
        }

        public String toString() {
            return this.myAnds.stream().map(it -> it.toString()).collect(Collectors.joining(" "));
        }

        int size() {
            return this.myAnds.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "and", "com/goide/inspections/buildTag/GoBuildTagUtil$PlusBuildOrExpr", "addAnd"));
        }
    }

    private static class PlusBuildAndExpr {
        private final List<Leaf> myLeaves = new ArrayList<Leaf>();

        private PlusBuildAndExpr() {
        }

        void addLeaf(@NotNull Leaf leaf) {
            if (leaf == null) {
                PlusBuildAndExpr.$$$reportNull$$$0(0);
            }
            this.myLeaves.add(leaf);
        }

        public String toString() {
            return this.myLeaves.stream().map(it -> it.toString()).collect(Collectors.joining(","));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaf", "com/goide/inspections/buildTag/GoBuildTagUtil$PlusBuildAndExpr", "addLeaf"));
        }
    }

    private static abstract class Leaf
    extends Expr {
        private Leaf() {
        }
    }

    private static class TagExpr
    extends Leaf {
        private final String myName;

        private TagExpr(@NotNull String name) {
            if (name == null) {
                TagExpr.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/goide/inspections/buildTag/GoBuildTagUtil$TagExpr", "<init>"));
        }
    }

    private static class NotExpr
    extends Leaf {
        private final Expr myChild;

        private NotExpr(@NotNull Expr child) {
            if (child == null) {
                NotExpr.$$$reportNull$$$0(0);
            }
            this.myChild = child;
        }

        public String toString() {
            return "!" + this.myChild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/goide/inspections/buildTag/GoBuildTagUtil$NotExpr", "<init>"));
        }
    }

    private static class AndExpr
    extends Expr {
        private final List<Expr> myChildren;

        private AndExpr(@NotNull List<Expr> children) {
            if (children == null) {
                AndExpr.$$$reportNull$$$0(0);
            }
            this.myChildren = children;
        }

        public String toString() {
            return this.myChildren.stream().map(it -> it.toString()).collect(Collectors.joining(" && "));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/goide/inspections/buildTag/GoBuildTagUtil$AndExpr", "<init>"));
        }
    }

    private static class OrExpr
    extends Expr {
        private final List<Expr> myChildren;

        private OrExpr(@NotNull List<Expr> children) {
            if (children == null) {
                OrExpr.$$$reportNull$$$0(0);
            }
            this.myChildren = children;
        }

        public String toString() {
            return this.myChildren.stream().map(it -> it.toString()).collect(Collectors.joining(" || "));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/goide/inspections/buildTag/GoBuildTagUtil$OrExpr", "<init>"));
        }
    }
}

