/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoFunctionDescriptors;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoGoStatement;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoAddLocalVarForExpressionQuickFix;
import com.goide.quickfix.GoIgnoreExplicitlyQuickFix;
import com.goide.quickfix.GoIgnoreUnusedCallResultQuickFix;
import com.goide.util.GoStdlibUtil;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class GoUnusedCallResultInspection
extends GoInspectionBase {
    private static final Set<String> DEFAULT_FUNCTIONS = Set.of("errors.New", "fmt.Errorf", "fmt.Sprintf", "fmt.Sprint", "sort.Reverse");
    private static final List<String> DEFAULT_METHODS = List.of("Error", "String");
    private final GoFunctionDescriptors myFunctions = new GoFunctionDescriptors(DEFAULT_FUNCTIONS);
    private final List<String> myMethods = new ArrayList<String>(DEFAULT_METHODS);

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCallExpr(o);
                if (GoUnusedCallResultInspection.isCallWithUnusedResult(o)) {
                    GoInspectionMessage description = GoUnusedCallResultInspection.message("go.inspection.problem.unused.result", new Object[]{REF});
                    if (GoUnusedCallResultInspection.this.shouldReportWarning(o)) {
                        holder.registerProblem((PsiElement)o, description, GoUnusedCallResultInspection.fixes(o));
                    } else if (holder.isOnTheFly() && !GoUnusedCallResultInspection.isInsideDeferOrGoStatement(o)) {
                        holder.registerProblem((PsiElement)o, description, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new GoAddLocalVarForExpressionQuickFix(o)});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoUnusedCallResultInspection$1", "visitCallExpr"));
            }
        };
    }

    private boolean shouldReportWarning(@NotNull GoCallExpr callExpr) {
        GoReferenceExpression ref;
        if (callExpr == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(2);
        }
        if ((ref = GoPsiUtil.getCallReference(callExpr)) == null) {
            return false;
        }
        PsiElement resolve = ref.resolve();
        GoFunctionDeclaration functionDeclaration = (GoFunctionDeclaration)ObjectUtils.tryCast((Object)resolve, GoFunctionDeclaration.class);
        if (functionDeclaration != null) {
            return this.myFunctions.contains(GoUtil.getImportPath(functionDeclaration, callExpr), functionDeclaration.getName());
        }
        GoMethodDeclaration methodDeclaration = (GoMethodDeclaration)ObjectUtils.tryCast((Object)resolve, GoMethodDeclaration.class);
        if (GoStdlibUtil.isNoArgStringReturningMethod(methodDeclaration, callExpr)) {
            return this.myMethods.contains(methodDeclaration.getName());
        }
        return false;
    }

    public static boolean isCallWithUnusedResult(@NotNull GoCallExpr callExpr) {
        PsiElement parent;
        if (callExpr == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(3);
        }
        if ((parent = callExpr.getParent()) instanceof GoGoStatement || parent instanceof GoDeferStatement) {
            return GoUnusedCallResultInspection.isNonVoidResult(callExpr);
        }
        if (parent instanceof GoLeftHandExprList) {
            GoStatement statement = (GoStatement)ObjectUtils.tryCast((Object)parent.getParent(), GoStatement.class);
            return statement != null && !(statement instanceof GoAssignmentStatement) && (statement.getParent() instanceof GoStatementsHolder || statement instanceof GoSimpleStatement && GoPsiUtil.isSimpleStatementFromIfForSwitch((GoSimpleStatement)statement)) && GoUnusedCallResultInspection.isNonVoidResult(callExpr);
        }
        return false;
    }

    private static boolean isNonVoidResult(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(4);
        }
        return !(callExpr.getGoType(null) instanceof GoLightType.LightVoidType);
    }

    private static LocalQuickFix @NotNull [] fixes(@NotNull GoCallExpr callExpression) {
        if (callExpression == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(5);
        }
        if (GoUnusedCallResultInspection.isInsideDeferOrGoStatement(callExpression)) {
            LocalQuickFix[] localQuickFixArray = GoUnusedCallResultInspection.fixes(new LocalQuickFix[]{new GoIgnoreUnusedCallResultQuickFix(callExpression)});
            if (localQuickFixArray == null) {
                GoUnusedCallResultInspection.$$$reportNull$$$0(6);
            }
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = GoUnusedCallResultInspection.fixes(new LocalQuickFix[]{new GoIgnoreExplicitlyQuickFix(callExpression), new GoIgnoreUnusedCallResultQuickFix(callExpression), new GoAddLocalVarForExpressionQuickFix(callExpression)});
        if (localQuickFixArray == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(7);
        }
        return localQuickFixArray;
    }

    public static boolean isInsideDeferOrGoStatement(@NotNull GoCallExpr callExpression) {
        PsiElement parent;
        if (callExpression == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(8);
        }
        return (parent = callExpression.getParent()) instanceof GoGoStatement || parent instanceof GoDeferStatement;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(9);
        }
        GoFunctionDescriptors.readList(node, this.myFunctions);
        GoUnusedCallResultInspection.readList(node, this.myMethods);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(10);
        }
        this.myFunctions.writeList(node);
        GoUnusedCallResultInspection.writeList(node, this.myMethods, new GoUnusedCallResultInspection().myMethods);
    }

    private static void readList(@NotNull Element node, @NotNull List<String> dst) {
        Element items;
        if (node == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(11);
        }
        if (dst == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(12);
        }
        if ((items = node.getChild("methods")) == null) {
            return;
        }
        dst.clear();
        for (Element item : items.getChildren("method")) {
            String name = item.getAttributeValue("name");
            if (name == null) continue;
            dst.add(name);
        }
    }

    private static void writeList(@NotNull Element node, @NotNull List<String> list, @NotNull List<String> defaultList) {
        if (node == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(13);
        }
        if (list == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(14);
        }
        if (defaultList == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(15);
        }
        if (!list.equals(defaultList)) {
            Element itemsElement = new Element("methods");
            for (String item : list) {
                Element element = new Element("method");
                element.setAttribute("name", item);
                itemsElement.addContent(element);
            }
            node.addContent(itemsElement);
        }
    }

    public void exclude(@NotNull GoCallExpr usage, @NotNull GoFunctionOrMethodDeclaration declaration) {
        if (usage == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(16);
        }
        if (declaration == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(17);
        }
        if (declaration instanceof GoFunctionDeclaration) {
            this.myFunctions.remove(GoUtil.getImportPath(declaration, usage), declaration.getName());
        } else if (declaration instanceof GoMethodDeclaration) {
            this.myMethods.remove(declaration.getName());
        }
    }

    @TestOnly
    public void addFunctionNames(String ... names) {
        for (String name : names) {
            this.myFunctions.add(name);
        }
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{this.myFunctions.getTable(GoBundle.message((String)"go.inspection.options.panel.reported.functions", (Object[])new Object[0])).prefix("myFunctions"), OptPane.stringList((String)"myMethods", (String)GoBundle.message((String)"go.inspection.options.panel.string.methods", (Object[])new Object[0]))});
        if (optPane == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(18);
        }
        return optPane;
    }

    @TestOnly
    public void resetStateOnDispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            GoUnusedCallResultInspection.$$$reportNull$$$0(19);
        }
        Disposer.register((Disposable)disposable, () -> {
            this.myMethods.clear();
            this.myMethods.addAll(DEFAULT_METHODS);
            this.myFunctions.clear();
            this.myFunctions.addAll(DEFAULT_FUNCTIONS);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 6: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoUnusedCallResultInspection";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultList";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoUnusedCallResultInspection";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fixes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldReportWarning";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCallWithUnusedResult";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNonVoidResult";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fixes";
                break;
            }
            case 6: 
            case 7: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInsideDeferOrGoStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readList";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeList";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resetStateOnDispose";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 18 -> new IllegalStateException(string);
        };
    }
}

