/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.GoStdlibUtil;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GoStringsReplaceCountInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoStringsReplaceCountInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoStringsReplaceCountInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr callExpr) {
                if (callExpr == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCallExpr(callExpr);
                if (GoStdlibUtil.isStdLibCall(callExpr, "strings", "Replace")) {
                    this.checkCountArgument(callExpr);
                }
            }

            private void checkCountArgument(@NotNull GoCallExpr callExpr) {
                Number numValue;
                List<GoExpression> args;
                GoExpression lastArg;
                if (callExpr == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((lastArg = (GoExpression)ContainerUtil.getLastItem(args = callExpr.getArgumentList().getExpressionList())) == null || !GoTypeUtil.isNumericType(lastArg.getGoType(null), lastArg)) {
                    return;
                }
                Value value = lastArg.getValue();
                Number number = numValue = value == null ? (Number)null : (Number)value.getNumber();
                if (!Comparing.equal((Object)0L, (Object)numValue)) {
                    return;
                }
                holder.registerProblem((PsiElement)lastArg, GoStringsReplaceCountInspection.message("go.inspection.problem.bad.count.argument.of.strings.replace", new Object[]{GoStringsReplaceCountInspection.code("strings.Replace"), REF}), new LocalQuickFix[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "callExpr";
                objectArray2[1] = "com/goide/inspections/GoStringsReplaceCountInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkCountArgument";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoStringsReplaceCountInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

