/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.execution.testing.GoTestFinder;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.intentions.expressions.structLiteral.GoFillFieldsIntentionBase;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoRenameQuickFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class GoSnakeCaseUsageInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoSnakeCaseUsageInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoSnakeCaseUsageInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitNamedElement(@NotNull GoNamedElement o) {
                String fixedName;
                GoInspectionMessage problemDescription;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitNamedElement(o);
                if (GoFillFieldsIntentionBase.isProtobufGeneratedField(o)) {
                    return;
                }
                PsiElement nameIdentifier = o.getNameIdentifier();
                String name = o.getName();
                if (nameIdentifier == null || name == null || o.isBlank() || !StringUtil.containsChar((String)name, (char)'_') || GoSnakeCaseUsageInspection.getSnakeParts(name).count() <= 1L || GoSnakeCaseUsageInspection.isTestOrBenchmarkOrExample(o)) {
                    return;
                }
                if (o instanceof GoImportSpec) {
                    problemDescription = GoSnakeCaseUsageInspection.message("go.inspection.problem.eliminate.snake.case");
                    fixedName = GoSnakeCaseUsageInspection.joinSnakeParts(name);
                } else {
                    problemDescription = GoSnakeCaseUsageInspection.message("go.inspection.problem.use.camelcase.instead.of.snake.case");
                    fixedName = GoSnakeCaseUsageInspection.convertToCamelCase(name);
                }
                holder.registerProblem(nameIdentifier, problemDescription, new LocalQuickFix[]{new GoRenameQuickFix(o), new RenameElementFix((PsiNamedElement)o, fixedName)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoSnakeCaseUsageInspection$1", "visitNamedElement"));
            }
        };
    }

    private static boolean isTestOrBenchmarkOrExample(@NotNull GoNamedElement o) {
        if (o == null) {
            GoSnakeCaseUsageInspection.$$$reportNull$$$0(2);
        }
        return o instanceof GoFunctionOrMethodDeclaration && GoTestFinder.isTestFile((PsiFile)o.getContainingFile()) && (GoTestFinder.isTestOrExampleFunction((GoFunctionOrMethodDeclaration)o) || GoTestFinder.isBenchmarkFunction((GoFunctionOrMethodDeclaration)o));
    }

    @NotNull
    private static String joinSnakeParts(@NotNull String name) {
        if (name == null) {
            GoSnakeCaseUsageInspection.$$$reportNull$$$0(3);
        }
        String string = GoSnakeCaseUsageInspection.getSnakeParts(name).map(namePart -> namePart.toLowerCase(Locale.ROOT)).collect(Collectors.joining());
        if (string == null) {
            GoSnakeCaseUsageInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String convertToCamelCase(@NotNull String name) {
        if (name == null) {
            GoSnakeCaseUsageInspection.$$$reportNull$$$0(5);
        }
        String camelCaseName = GoSnakeCaseUsageInspection.getSnakeParts(name).map(namePart -> StringUtil.capitalize((String)namePart.toLowerCase(Locale.ROOT))).collect(Collectors.joining());
        return Character.isUpperCase(name.charAt(0)) ? camelCaseName : GoSnakeCaseUsageInspection.decapitalize(camelCaseName);
    }

    @NotNull
    private static Stream<String> getSnakeParts(@NotNull String name) {
        if (name == null) {
            GoSnakeCaseUsageInspection.$$$reportNull$$$0(6);
        }
        Stream<String> stream = StringUtil.split((String)name, (String)"_", (boolean)true, (boolean)true).stream();
        if (stream == null) {
            GoSnakeCaseUsageInspection.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @NotNull
    private static String decapitalize(@NotNull String s) {
        if (s == null) {
            GoSnakeCaseUsageInspection.$$$reportNull$$$0(8);
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoSnakeCaseUsageInspection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoSnakeCaseUsageInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "joinSnakeParts";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnakeParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTestOrBenchmarkOrExample";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "joinSnakeParts";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertToCamelCase";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSnakeParts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

