/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.execution.testing.GoTestFinder;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoRenameQuickFix;
import com.goide.quickfix.GoRenameToQuickFix;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class GoNameStartsWithPackageNameInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoNameStartsWithPackageNameInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoNameStartsWithPackageNameInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitTopLevelDeclaration(@NotNull GoTopLevelDeclaration o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTopLevelDeclaration(o);
                PsiElement parent = o.getParent();
                if (!(parent instanceof GoFile) || GoTestFinder.isTestFile((PsiFile)((GoFile)parent))) {
                    return;
                }
                String packageName = ((GoFile)parent).getPackageName();
                if (!1.acceptPackageName(packageName)) {
                    return;
                }
                if (o instanceof GoTypeDeclaration) {
                    for (GoTypeSpec typeSpec : ((GoTypeDeclaration)o).getTypeSpecList()) {
                        this.checkElement(packageName, typeSpec);
                    }
                }
                if (o instanceof GoVarOrConstDeclaration) {
                    for (GoTypeSpec spec : ((GoVarOrConstDeclaration)o).getSpecList()) {
                        if (!(spec instanceof GoVarOrConstSpec)) continue;
                        for (Object definition : ((GoVarOrConstSpec)((Object)spec)).getDefinitionList()) {
                            if (!(definition instanceof GoNamedElement)) continue;
                            this.checkElement(packageName, (GoNamedElement)definition);
                        }
                    }
                }
            }

            @Override
            public void visitFunctionDeclaration(@NotNull GoFunctionDeclaration o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitFunctionDeclaration(o);
                GoFile psiFile = o.getContainingFile();
                if (GoTestFinder.isTestFile((PsiFile)psiFile)) {
                    return;
                }
                String packageName = psiFile.getPackageName();
                if (1.acceptPackageName(packageName)) {
                    this.checkElement(packageName, o);
                }
            }

            private void checkElement(@NotNull String packageName, @NotNull GoNamedElement o) {
                if (packageName == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!o.isPublic() || o.isBlank()) {
                    return;
                }
                String name = o.getName();
                PsiElement identifier = o.getIdentifier();
                if (name != null && identifier != null && name.length() != packageName.length() && GoUtil.checkPrefix(name, packageName, true)) {
                    int prefixLength = StringUtil.commonPrefixLength((CharSequence)name, (CharSequence)packageName, (boolean)true);
                    assert (prefixLength > 0);
                    String nameWithoutPrefix = name.substring(prefixLength);
                    holder.registerProblem(identifier, GoNameStartsWithPackageNameInspection.message("go.inspection.problem.name.starts.with.package.name"), new LocalQuickFix[]{new GoRenameToQuickFix(o, nameWithoutPrefix), new GoRenameQuickFix(o)});
                }
            }

            private static boolean acceptPackageName(String packageName) {
                return packageName != null && !"main".equals(packageName) && packageName.length() > 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "packageName";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoNameStartsWithPackageNameInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTopLevelDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionDeclaration";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoNameStartsWithPackageNameInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

