/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoTypes;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBuiltinArgumentList;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoMissingTrailingCommaInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoMissingTrailingCommaInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoMissingTrailingCommaInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            public void visitErrorElement(@NotNull PsiErrorElement o) {
                Pair<PsiElement, GoInspectionMessage> elementAndMessage;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((elementAndMessage = GoMissingTrailingCommaInspection.getElementAndMessage(o)) != null) {
                    PsiElement element = (PsiElement)elementAndMessage.first;
                    TextRange range = GoMissingTrailingCommaInspection.getRangeOfTheLastSymbol(element);
                    holder.registerProblem(element, range, (GoInspectionMessage)elementAndMessage.second, new MyAddCommaFix());
                }
            }

            @Override
            public void visitTypeArguments(@NotNull GoTypeArguments o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                GoMissingTrailingCommaInspection.checkTrailingComma(holder, o.getRbrack(), GoMissingTrailingCommaInspection.message("go.inspection.problem.need.trailing.comma.in.type.arguments.list"));
            }

            @Override
            public void visitTypeParameters(@NotNull GoTypeParameters o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                GoMissingTrailingCommaInspection.checkTrailingComma(holder, o.getRbrack(), GoMissingTrailingCommaInspection.message("go.inspection.problem.need.trailing.comma.in.type.parameters.list"));
            }

            @Override
            public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr o) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                GoInspectionMessage errorMessage = GoPsiUtil.isCallOrConversionWithTypeInstantiation(o) ? GoMissingTrailingCommaInspection.message("go.inspection.problem.need.trailing.comma.in.type.arguments.list") : GoMissingTrailingCommaInspection.message("go.inspection.problem.need.trailing.comma.in.index.expression");
                GoMissingTrailingCommaInspection.checkTrailingComma(holder, o.getRbrack(), errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/goide/inspections/GoMissingTrailingCommaInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitErrorElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeArguments";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeParameters";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIndexOrSliceExpr";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static TextRange getRangeOfTheLastSymbol(PsiElement element) {
        int length = element.getTextLength();
        TextRange textRange = length > 1 ? TextRange.create((int)(length - 1), (int)length) : TextRange.create((int)0, (int)length);
        if (textRange == null) {
            GoMissingTrailingCommaInspection.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Nullable
    private static Pair<PsiElement, GoInspectionMessage> getElementAndMessage(@NotNull PsiErrorElement error) {
        if (error == null) {
            GoMissingTrailingCommaInspection.$$$reportNull$$$0(3);
        }
        if (!GoFormatterUtil.isLastElementOnLine((PsiElement)error)) {
            return null;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)error);
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)error);
        if (next == null || prev == null) {
            return null;
        }
        PsiElement parent = error.getParent();
        IElementType nextType = next.getNode().getElementType();
        if (parent instanceof GoLiteralValue && prev instanceof GoElement && (next instanceof GoElement || nextType == GoTypes.RBRACE)) {
            return Pair.create((Object)prev, (Object)GoMissingTrailingCommaInspection.message("go.inspection.problem.need.trailing.comma.in.composite.literal"));
        }
        if (parent instanceof GoParameters && prev instanceof GoParameterDeclaration && nextType == GoTypes.RPAREN) {
            return Pair.create((Object)prev, (Object)GoMissingTrailingCommaInspection.message("go.inspection.problem.need.trailing.comma.in.parameter.list"));
        }
        if (parent instanceof GoArgumentList && nextType == GoTypes.RPAREN && (prev instanceof GoExpression || parent instanceof GoBuiltinArgumentList && prev instanceof GoType)) {
            return Pair.create((Object)prev, (Object)GoMissingTrailingCommaInspection.message("go.inspection.problem.need.trailing.comma.in.argument.list"));
        }
        return null;
    }

    private static void checkTrailingComma(@NotNull GoProblemsHolder holder, @Nullable PsiElement rightBracket, @NotNull GoInspectionMessage errorMessage) {
        PsiElement elementBefore;
        if (holder == null) {
            GoMissingTrailingCommaInspection.$$$reportNull$$$0(4);
        }
        if (errorMessage == null) {
            GoMissingTrailingCommaInspection.$$$reportNull$$$0(5);
        }
        if ((elementBefore = (PsiElement)Optional.ofNullable(rightBracket).map(PsiTreeUtil::skipWhitespacesAndCommentsBackward).map(PsiElement::getLastChild).orElse(null)) != null && elementBefore.getNode().getElementType() != GoTypes.COMMA && GoPsiUtil.hasNewLineAfter(elementBefore)) {
            TextRange range = GoMissingTrailingCommaInspection.getRangeOfTheLastSymbol(elementBefore);
            holder.registerProblem(elementBefore, range, errorMessage, new LocalQuickFix[]{new MyAddCommaAfterAnchorFix(elementBefore)});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoMissingTrailingCommaInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoMissingTrailingCommaInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeOfTheLastSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementAndMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkTrailingComma";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class MyAddCommaAfterAnchorFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        MyAddCommaAfterAnchorFix(@Nullable PsiElement anchor) {
            super(anchor);
        }

        @NotNull
        public String getText() {
            String string = GoBundle.message((String)"go.fix.add.comma.name", (Object[])new Object[0]);
            if (string == null) {
                MyAddCommaAfterAnchorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.add.comma.name", (Object[])new Object[0]);
            if (string == null) {
                MyAddCommaAfterAnchorFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Document document;
            if (project == null) {
                MyAddCommaAfterAnchorFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                MyAddCommaAfterAnchorFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                MyAddCommaAfterAnchorFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                MyAddCommaAfterAnchorFix.$$$reportNull$$$0(5);
            }
            Document document2 = document = editor != null ? editor.getDocument() : null;
            if (document != null) {
                document.insertString(startElement.getTextRange().getEndOffset(), (CharSequence)",");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoMissingTrailingCommaInspection$MyAddCommaAfterAnchorFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoMissingTrailingCommaInspection$MyAddCommaAfterAnchorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyAddCommaFix
    implements LocalQuickFix {
        private MyAddCommaFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.add.comma.name", (Object[])new Object[0]);
            if (string == null) {
                MyAddCommaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement e;
            if (project == null) {
                MyAddCommaFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyAddCommaFix.$$$reportNull$$$0(2);
            }
            if (!(e = descriptor.getPsiElement()).isValid()) {
                return;
            }
            PsiErrorElement error = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)e, PsiErrorElement.class);
            if (error == null) {
                return;
            }
            error.replace(GoElementFactory.createComma(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoMissingTrailingCommaInspection$MyAddCommaFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoMissingTrailingCommaInspection$MyAddCommaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

