/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCallLikeExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParameters;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoResolveResult;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.generics.GoSubstitution;
import com.goide.sdk.GoSdkUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoInspectionUtil {
    public static final int UNKNOWN_COUNT = -1;
    private static final String CODE_OPEN_TAG = "<code>";
    private static final String CODE_CLOSED_TAG = "</code>";

    public static int getExpressionResultCount(@Nullable GoExpression expression) {
        GoType type;
        GoType goType = type = expression != null ? expression.getGoType(null) : null;
        if (type == null || GoTypeUtil.isCType(type, expression)) {
            return -1;
        }
        if (type instanceof GoLightType.LightVoidType) {
            return 0;
        }
        return type instanceof GoTypeList ? ((GoTypeList)type).getTypeList().size() : 1;
    }

    public static boolean isPrimaryDefinition(@Nullable GoNamedElement namedElement) {
        return GoInspectionUtil.getPrimaryDefinition(namedElement) == namedElement;
    }

    @Contract(value="null -> null")
    @Nullable
    public static GoNamedElement getPrimaryDefinition(@Nullable GoNamedElement namedElement) {
        PsiReference ref = namedElement != null ? namedElement.getReference() : null;
        PsiElement resolve = ref != null ? ref.resolve() : null;
        return resolve == null ? namedElement : (GoNamedElement)ObjectUtils.tryCast((Object)resolve, GoNamedElement.class);
    }

    public static boolean isUnused(@NotNull GoFunctionDeclaration o) {
        if (o == null) {
            GoInspectionUtil.$$$reportNull$$$0(0);
        }
        return GoReferencesSearch.search(o, o.getUseScope()).forEach(usage -> PsiTreeUtil.isAncestor((PsiElement)o, (PsiElement)usage.getElement(), (boolean)true));
    }

    @Contract(value="null -> false")
    public static boolean isCheapEnoughToSearch(@Nullable GoNamedElement o) {
        String name;
        String string = name = o == null ? null : o.getName();
        if (name == null) {
            return false;
        }
        SearchScope useScope = PsiSearchHelper.getInstance((Project)o.getProject()).getUseScope((PsiElement)o);
        if (!(useScope instanceof GlobalSearchScope)) {
            return true;
        }
        Project project = o.getProject();
        PsiSearchHelper.SearchCostResult cheapEnough = PsiSearchHelper.getInstance((Project)project).isCheapEnoughToSearch(name, (GlobalSearchScope)useScope, (PsiFile)o.getContainingFile());
        return cheapEnough != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    @Nullable
    public static GoStructType findStructTypeForLiteralValue(@Nullable GoLiteralValue value) {
        return (GoStructType)ObjectUtils.tryCast((Object)GoInspectionUtil.getLiteralValueUnderlyingType(value), GoStructType.class);
    }

    @Nullable
    @Contract(value="null -> null")
    public static GoType getLiteralValueUnderlyingType(@Nullable GoLiteralValue value) {
        GoType type = value != null ? GoPsiImplUtil.getUnwrappedTypeOfLiteralValue(value) : null;
        return type != null ? type.getUnderlyingType(value) : null;
    }

    @Nullable
    public static Pair<GoLiteralValue, GoType> findValueAndStructType(@Nullable PsiElement elementAt) {
        GoLiteralValue value = (GoLiteralValue)PsiTreeUtil.getParentOfType((PsiElement)elementAt, GoLiteralValue.class);
        GoType type = GoInspectionUtil.getLiteralValueUnderlyingType(value);
        return type instanceof GoStructType ? Pair.create((Object)value, (Object)type) : null;
    }

    public static boolean canDeleteDefinition(@NotNull GoVarOrConstDefinition definition) {
        PsiElement parent;
        if (definition == null) {
            GoInspectionUtil.$$$reportNull$$$0(1);
        }
        if ((parent = definition.getParent()) instanceof GoTypeSwitchGuard) {
            return ((GoTypeSwitchGuard)parent).getVarAssign() != null;
        }
        if (parent instanceof GoRangeClause) {
            return ContainerUtil.getLastItem(((GoRangeClause)parent).getVarDefinitionList()) == definition;
        }
        if (parent instanceof GoVarOrConstSpec) {
            GoExpression expr = definition.findExpression();
            return expr != null && GoInspectionUtil.getExpressionResultCount(expr) == 1;
        }
        return false;
    }

    @NotNull
    public static Attachment createAttachment(@NotNull PsiElement element) {
        PsiFile file;
        VirtualFile virtualFile;
        if (element == null) {
            GoInspectionUtil.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile2 = virtualFile = (file = element.getContainingFile()) == null ? null : file.getVirtualFile();
        if (virtualFile != null) {
            Attachment attachment = CoreAttachmentFactory.createAttachment((VirtualFile)virtualFile);
            if (attachment == null) {
                GoInspectionUtil.$$$reportNull$$$0(3);
            }
            return attachment;
        }
        return new Attachment(file != null ? file.getName() : "file name is <null>", (String)(file != null ? file.getText() : "psi element text is '" + element.getText() + "'"));
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isInSdkPackage(@Nullable PsiElement element, @NotNull String importPath, @Nullable PsiElement context) {
        if (importPath == null) {
            GoInspectionUtil.$$$reportNull$$$0(4);
        }
        GoFile file = element != null ? (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class)) : null;
        String actualImportPath = file != null ? file.getImportPath(GoVendoringUtil.isVendoringEnabled(context)) : null;
        return importPath.equals(actualImportPath) && GoSdkUtil.isInSdk((PsiFileSystemItem)file);
    }

    public static boolean hasNoNewVariables(@NotNull List<? extends GoNamedElement> list) {
        if (list == null) {
            GoInspectionUtil.$$$reportNull$$$0(5);
        }
        return !list.isEmpty() && ContainerUtil.and(list, e -> e.isBlank() || !GoInspectionUtil.isPrimaryDefinition(e));
    }

    @NotNull
    public static String getPresentableText(@NotNull GoExpression expression) {
        GoType type;
        if (expression == null) {
            GoInspectionUtil.$$$reportNull$$$0(6);
        }
        if (expression instanceof GoFunctionLit) {
            GoSignature signature = ((GoFunctionLit)expression).getSignature();
            String signatureText = signature != null ? signature.getText() : "";
            String string = String.format("func%s {...}", signatureText);
            if (string == null) {
                GoInspectionUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (expression instanceof GoCompositeLit && (type = ((GoCompositeLit)expression).getType()) != null) {
            GoLiteralValue value = ((GoCompositeLit)expression).getLiteralValue();
            String valueText = value != null && value.getElementList().isEmpty() ? "{}" : "{...}";
            String string = type.getPresentationText() + valueText;
            if (string == null) {
                GoInspectionUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = expression.getText();
        if (string == null) {
            GoInspectionUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String xmlCode(@NotNull String text) {
        if (text == null) {
            GoInspectionUtil.$$$reportNull$$$0(10);
        }
        String string = (String)ProblemDescriptorUtil.XML_CODE_MARKER.first + text + (String)ProblemDescriptorUtil.XML_CODE_MARKER.second;
        if (string == null) {
            GoInspectionUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeAllExceptCodeTags(@NotNull String message) {
        if (message == null) {
            GoInspectionUtil.$$$reportNull$$$0(12);
        }
        if (!message.contains(CODE_OPEN_TAG)) {
            return GoInspectionUtil.xmlCode(XmlStringUtil.escapeString((String)message));
        }
        List partialSplit = StringUtil.split((String)message, (String)CODE_OPEN_TAG, (boolean)false);
        SmartList split = new SmartList();
        for (String str : partialSplit) {
            split.addAll(StringUtil.split((String)str, (String)CODE_CLOSED_TAG, (boolean)false));
        }
        StringBuilder result = new StringBuilder();
        for (String str : split) {
            String withoutTags;
            if (str.endsWith(CODE_OPEN_TAG)) {
                withoutTags = StringUtil.trimEnd((String)str, (String)CODE_OPEN_TAG);
                result.append(XmlStringUtil.escapeString((String)withoutTags));
                result.append(CODE_OPEN_TAG);
                continue;
            }
            if (str.endsWith(CODE_CLOSED_TAG)) {
                withoutTags = StringUtil.trimEnd((String)str, (String)CODE_CLOSED_TAG);
                result.append(XmlStringUtil.escapeString((String)withoutTags));
                result.append(CODE_CLOSED_TAG);
                continue;
            }
            result.append(XmlStringUtil.escapeString((String)str));
        }
        return GoInspectionUtil.xmlCode(result.toString());
    }

    @Nullable
    public static TextRange getProblemRangeInElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GoInspectionUtil.$$$reportNull$$$0(13);
        }
        return Optional.ofNullable(GoInspectionUtil.narrowProblemElement(psiElement)).map(child -> child.getTextRange().shiftLeft(psiElement.getTextRange().getStartOffset())).orElse(null);
    }

    @Nullable
    private static PsiElement narrowProblemElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GoInspectionUtil.$$$reportNull$$$0(14);
        }
        if (psiElement instanceof GoFunctionLit) {
            return ((GoFunctionLit)psiElement).getFunc();
        }
        if (psiElement instanceof GoCallExpr) {
            GoExpression calledExpression = ((GoCallExpr)psiElement).getExpression();
            GoExpression unwrapped = calledExpression.unwrapParentheses();
            if (unwrapped instanceof GoFunctionLit) {
                return ((GoFunctionLit)unwrapped).getFunc();
            }
            if (unwrapped instanceof GoReferenceExpression) {
                return ((GoReferenceExpression)unwrapped).getIdentifier();
            }
            return calledExpression;
        }
        if (psiElement instanceof GoBuiltinCallExpr) {
            return ((GoBuiltinCallExpr)psiElement).getExpression();
        }
        if (psiElement instanceof GoConversionExpr) {
            return ((GoConversionExpr)psiElement).getType();
        }
        if (psiElement instanceof GoCompositeLit) {
            GoCompositeLit literal = (GoCompositeLit)psiElement;
            return Optional.ofNullable(literal.getType()).orElseGet(() -> literal.getTypeReferenceExpression());
        }
        if (psiElement instanceof GoNamedElement && !(psiElement instanceof GoImportSpec)) {
            return ((GoNamedElement)psiElement).getIdentifier();
        }
        return null;
    }

    public static boolean canAccessField(@NotNull GoNamedElement field, boolean isStructFromCurrentPackage) {
        if (field == null) {
            GoInspectionUtil.$$$reportNull$$$0(15);
        }
        return !field.isBlank() && (isStructFromCurrentPackage || field.isPublic());
    }

    @Nullable
    public static GoNamedSignatureOwner resolveCall(@NotNull GoCallLikeExpr call) {
        Pair<GoNamedSignatureOwner, GoSubstitution> resolve;
        if (call == null) {
            GoInspectionUtil.$$$reportNull$$$0(16);
        }
        return (resolve = GoInspectionUtil.resolveCallWithSubstitution(call)) != null ? (GoNamedSignatureOwner)resolve.first : null;
    }

    @Nullable
    public static Pair<GoNamedSignatureOwner, GoSubstitution> resolveCallWithSubstitution(@NotNull GoCallLikeExpr call) {
        GoReferenceExpression callRef;
        if (call == null) {
            GoInspectionUtil.$$$reportNull$$$0(17);
        }
        GoResolveResult resolveResult = (callRef = GoPsiUtil.getCallReference(call)) != null ? callRef.getGoResolveResult(null) : null;
        PsiElement resolveElement = resolveResult != null ? resolveResult.getElement() : null;
        GoNamedSignatureOwner declaration = (GoNamedSignatureOwner)ObjectUtils.tryCast((Object)resolveElement, GoNamedSignatureOwner.class);
        return declaration != null ? Pair.create((Object)declaration, (Object)resolveResult.getTypeSubstitution()) : null;
    }

    @Nullable
    public static GoCallExpr findCallFromArgument(@NotNull PsiElement argument) {
        GoArgumentList argumentList;
        if (argument == null) {
            GoInspectionUtil.$$$reportNull$$$0(18);
        }
        return (argumentList = (GoArgumentList)ObjectUtils.tryCast((Object)(argument = GoPsiUtil.skipParens(argument)).getParent(), GoArgumentList.class)) != null ? (GoCallExpr)ObjectUtils.tryCast((Object)argumentList.getParent(), GoCallExpr.class) : null;
    }

    public static boolean areAllArgumentsSpecified(@NotNull GoCallExpr callExpr, @NotNull GoSignature signature, boolean strict) {
        int argumentCount;
        if (callExpr == null) {
            GoInspectionUtil.$$$reportNull$$$0(19);
        }
        if (signature == null) {
            GoInspectionUtil.$$$reportNull$$$0(20);
        }
        if ((argumentCount = callExpr.getArgumentList().getArgumentCount()) == -1) {
            return !strict;
        }
        GoParameters parameters = signature.getParameters();
        int parameterCount = parameters.getParameterCount();
        return parameters.isVariadic() && parameterCount - 1 <= argumentCount || argumentCount == parameterCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoInspectionUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoInspectionUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachment";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "xmlCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnused";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteDefinition";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAttachment";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInSdkPackage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasNoNewVariables";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "xmlCode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "escapeAllExceptCodeTags";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProblemRangeInElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "narrowProblemElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canAccessField";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveCall";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallWithSubstitution";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findCallFromArgument";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "areAllArgumentsSpecified";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

