/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptTable;
import com.intellij.codeInspection.options.OptTableColumn;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoFunctionDescriptors
implements OptionContainer {
    private final List<String> myImportPaths;
    private final List<String> myFunctionNames;
    private final Set<String> myDefault;

    public GoFunctionDescriptors(@NotNull Set<String> defaultFunctions) {
        if (defaultFunctions == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(0);
        }
        this.myImportPaths = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFunctionNames = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDefault = new HashSet<String>(defaultFunctions);
        this.addAll(defaultFunctions);
    }

    void addAll(@NotNull Set<String> functions) {
        if (functions == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(1);
        }
        functions.forEach(this::add);
    }

    void add(@NotNull String importPathAndName) {
        int lastDot;
        if (importPathAndName == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(2);
        }
        if ((lastDot = importPathAndName.lastIndexOf(".")) == -1 || lastDot == 0 || lastDot == importPathAndName.length() - 1) {
            throw new IllegalArgumentException("Wrong function name: " + importPathAndName);
        }
        this.add(importPathAndName.substring(0, lastDot), importPathAndName.substring(lastDot + 1));
    }

    public void add(@NotNull String importPath, @NotNull String functionName) {
        if (importPath == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(3);
        }
        if (functionName == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(4);
        }
        this.myImportPaths.add(importPath);
        this.myFunctionNames.add(functionName);
    }

    boolean contains(@Nullable String importPath, @Nullable String functionName) {
        return importPath != null && functionName != null && ContainerUtil.find((Iterable)ContainerUtil.zip(this.myImportPaths, this.myFunctionNames), pair -> importPath.equals(pair.first) && functionName.equals(pair.second)) != null;
    }

    void remove(@Nullable String importPath, @Nullable String functionName) {
        if (StringUtil.isEmpty((String)importPath) || StringUtil.isEmpty((String)functionName)) {
            return;
        }
        Iterator pairs = ContainerUtil.zip(this.myImportPaths, this.myFunctionNames).iterator();
        while (pairs.hasNext()) {
            Pair pair = (Pair)pairs.next();
            if (!importPath.equals(pair.first) || !functionName.equals(pair.second)) continue;
            pairs.remove();
        }
    }

    @NotNull
    List<String> getImportPaths() {
        List<String> list = this.myImportPaths;
        if (list == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    List<String> getFunctionNames() {
        List<String> list = this.myFunctionNames;
        if (list == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(6);
        }
        return list;
    }

    void clear() {
        this.myImportPaths.clear();
        this.myFunctionNames.clear();
    }

    private boolean isDefault() {
        HashSet functions = new HashSet(this.myImportPaths.size());
        ContainerUtil.zip(this.myImportPaths, this.myFunctionNames).forEach(pair -> functions.add((String)pair.first + "." + (String)pair.second));
        return functions.equals(this.myDefault);
    }

    static void readList(@NotNull Element node, @NotNull GoFunctionDescriptors dst) {
        Element items;
        if (node == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(7);
        }
        if (dst == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(8);
        }
        if ((items = node.getChild("functions")) == null) {
            return;
        }
        dst.clear();
        for (Element item : items.getChildren("function")) {
            String importPath = item.getAttributeValue("importPath");
            String name = item.getAttributeValue("name");
            if (importPath == null || name == null) continue;
            dst.add(importPath, name);
        }
    }

    void writeList(@NotNull Element node) {
        if (node == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(9);
        }
        if (!this.isDefault()) {
            Element itemsElement = new Element("functions");
            assert (this.myFunctionNames.size() == this.myImportPaths.size());
            HashSet<CallSite> unique = new HashSet<CallSite>();
            for (int i = 0; i < this.myImportPaths.size(); ++i) {
                String functionName;
                String importPath = this.myImportPaths.get(i);
                if (!unique.add((CallSite)((Object)(importPath + "." + (functionName = this.myFunctionNames.get(i)))))) continue;
                Element element = new Element("function");
                element.setAttribute("importPath", importPath);
                element.setAttribute("name", functionName);
                itemsElement.addContent(element);
            }
            node.addContent(itemsElement);
        }
    }

    OptTable getTable(@NotNull @Nls String label) {
        if (label == null) {
            GoFunctionDescriptors.$$$reportNull$$$0(10);
        }
        return OptPane.table((String)label, (OptTableColumn[])new OptTableColumn[]{OptPane.column((String)"myImportPaths", (String)GoBundle.message((String)"go.inspection.options.panel.import.path", (Object[])new Object[0])), OptPane.column((String)"myFunctionNames", (String)GoBundle.message((String)"go.inspection.options.panel.function.name", (Object[])new Object[0]))});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFunctions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathAndName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoFunctionDescriptors";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoFunctionDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

