/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoFileType;
import com.goide.GoPluginDisposable;
import com.goide.i18n.GoBundle;
import com.goide.project.GoBuildTargetSettings;
import com.goide.project.GoModuleSettings;
import com.goide.psi.GoFile;
import com.goide.util.GoBuildMatcher;
import com.goide.util.GoTargetSystem;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoFileIgnoredByBuildToolNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    private static final String DO_NOT_SHOW_NOTIFICATION_ABOUT_IGNORE_BY_BUILD_TOOL = "DO_NOT_SHOW_NOTIFICATION_ABOUT_IGNORE_BY_BUILD_TOOL";
    private final MergingUpdateQueue myCheckingQueue;
    private final Set<VirtualFile> myFilesToCheck;
    private final Map<VirtualFile, IgnoreReason> myIgnoredFiles;

    GoFileIgnoredByBuildToolNotificationProvider(final @NotNull Project project) {
        if (project == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(0);
        }
        this.myFilesToCheck = Collections.synchronizedSet(new HashSet());
        this.myIgnoredFiles = Collections.synchronizedMap(new HashMap());
        Disposable goPluginDisposable = GoPluginDisposable.getInstance(project);
        this.myCheckingQueue = new MergingUpdateQueue("Checking if files are ignored by build tool", 500, true, null, goPluginDisposable, null, Alarm.ThreadToUse.POOLED_THREAD);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                VirtualFile file = FileDocumentManager.getInstance().getFile(e.getDocument());
                if (file == null || !ArrayUtil.contains((Object)file, (Object[])FileEditorManager.getInstance((Project)project).getSelectedFiles())) {
                    return;
                }
                GoFileIgnoredByBuildToolNotificationProvider.this.myFilesToCheck.add(file);
                GoFileIgnoredByBuildToolNotificationProvider.this.scheduleCheckFiles(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/goide/inspections/GoFileIgnoredByBuildToolNotificationProvider$1", "documentChanged"));
            }
        }, goPluginDisposable);
        MessageBusConnection connection = project.getMessageBus().connect(goPluginDisposable);
        VirtualFileManager.getInstance().addAsyncFileListener(events -> {
            if (project.isDisposed()) {
                return null;
            }
            boolean scheduleUpdate = false;
            for (VFileEvent event : events) {
                ProgressManager.checkCanceled();
                VirtualFile file = event.getFile();
                if (file == null || !ArrayUtil.contains((Object)file, (Object[])FileEditorManager.getInstance((Project)project).getSelectedFiles())) continue;
                scheduleUpdate |= this.myFilesToCheck.add(file);
            }
            return scheduleUpdate ? new AsyncFileListener.ChangeApplier(){

                public void afterVfsChange() {
                    if (!project.isDisposed()) {
                        GoFileIgnoredByBuildToolNotificationProvider.this.scheduleCheckFiles(project);
                    }
                }
            } : null;
        }, goPluginDisposable);
        connection.subscribe(FileDocumentManagerListener.TOPIC, (Object)new FileDocumentManagerListener(){

            public void fileContentReloaded(@NotNull VirtualFile file, @NotNull Document document) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (project.isDisposed() || !ArrayUtil.contains((Object)file, (Object[])FileEditorManager.getInstance((Project)project).getSelectedFiles())) {
                    return;
                }
                GoFileIgnoredByBuildToolNotificationProvider.this.myFilesToCheck.add(file);
                GoFileIgnoredByBuildToolNotificationProvider.this.scheduleCheckFiles(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/goide/inspections/GoFileIgnoredByBuildToolNotificationProvider$3";
                objectArray[2] = "fileContentReloaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(GoModuleSettings.BUILD_TARGET_TOPIC, (module, __) -> {
            if (project.isDisposed()) {
                return;
            }
            this.myFilesToCheck.addAll(this.myIgnoredFiles.keySet());
            this.myFilesToCheck.addAll(Arrays.asList(FileEditorManager.getInstance((Project)project).getOpenFiles()));
            this.scheduleCheckFiles(project);
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (project.isDisposed()) {
                    return;
                }
                GoFileIgnoredByBuildToolNotificationProvider.this.myFilesToCheck.add(file);
                GoFileIgnoredByBuildToolNotificationProvider.this.scheduleCheckFiles(project);
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (file == null) {
                    4.$$$reportNull$$$0(3);
                }
                GoFileIgnoredByBuildToolNotificationProvider.this.myFilesToCheck.remove(file);
                GoFileIgnoredByBuildToolNotificationProvider.this.myIgnoredFiles.remove(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoFileIgnoredByBuildToolNotificationProvider$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myFilesToCheck.addAll(Arrays.asList(FileEditorManager.getInstance((Project)project).getOpenFiles()));
        this.scheduleCheckFiles(project);
    }

    private void scheduleCheckFiles(final @NotNull Project project) {
        if (project == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(1);
        }
        this.myCheckingQueue.queue(new Update("Check if files are ignored by build tool"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                VirtualFile[] files;
                Set<VirtualFile> set = GoFileIgnoredByBuildToolNotificationProvider.this.myFilesToCheck;
                synchronized (set) {
                    files = GoFileIgnoredByBuildToolNotificationProvider.this.myFilesToCheck.toArray(VirtualFile.EMPTY_ARRAY);
                    GoFileIgnoredByBuildToolNotificationProvider.this.myFilesToCheck.clear();
                }
                HashMap<VirtualFile, IgnoreReason> ignored = new HashMap<VirtualFile, IgnoreReason>();
                HashSet notIgnored = new HashSet();
                HashSet<VirtualFile> changed = new HashSet<VirtualFile>();
                ReadAction.run(() -> GoFileIgnoredByBuildToolNotificationProvider.calcIgnoredFiles(project, files, ignored, notIgnored));
                Map<VirtualFile, IgnoreReason> map = GoFileIgnoredByBuildToolNotificationProvider.this.myIgnoredFiles;
                synchronized (map) {
                    for (VirtualFile file : notIgnored) {
                        if (GoFileIgnoredByBuildToolNotificationProvider.this.myIgnoredFiles.remove(file) == null) continue;
                        changed.add(file);
                    }
                    ignored.forEach((f, v) -> {
                        if (GoFileIgnoredByBuildToolNotificationProvider.this.myIgnoredFiles.put((VirtualFile)f, (IgnoreReason)v) != v) {
                            changed.add((VirtualFile)f);
                        }
                    });
                }
                if (project.isDisposed()) {
                    return;
                }
                EditorNotifications notifications = EditorNotifications.getInstance((Project)project);
                for (VirtualFile file : changed) {
                    notifications.updateNotifications(file);
                }
            }
        });
    }

    private static void calcIgnoredFiles(@NotNull Project project, VirtualFile @NotNull [] files, @NotNull Map<VirtualFile, IgnoreReason> ignored, @NotNull Set<VirtualFile> notIgnored) {
        if (project == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(2);
        }
        if (ignored == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(3);
        }
        if (notIgnored == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(4);
        }
        if (files == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(5);
        }
        FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
        for (VirtualFile file : files) {
            if (!file.isValid() || !fileTypeRegistry.isFileOfType(file, (FileType)GoFileType.INSTANCE)) {
                notIgnored.add(file);
                continue;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof GoFile) || InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psiFile) != null) {
                notIgnored.add(file);
                continue;
            }
            Module module = GoUtil.module((PsiElement)psiFile);
            String fileName = file.getName();
            if (GoUtil.fileToIgnore(fileName) && !PropertiesComponent.getInstance().getBoolean(DO_NOT_SHOW_NOTIFICATION_ABOUT_IGNORE_BY_BUILD_TOOL, false)) {
                GoBuildMatcher.MatchingReason reason = null;
                if (fileName.startsWith("_")) {
                    reason = GoBuildMatcher.MatchingReason.FILE_NAME_STARTS_WITH_UNDERSCORE;
                } else if (fileName.startsWith(".")) {
                    reason = GoBuildMatcher.MatchingReason.FILE_NAME_STARTS_WITH_DOT;
                }
                ignored.put(file, new IgnoreReason(GoBuildMatcher.MatchingResult.mismatch(reason).withCause(GoBuildMatcher.MatchingCause.FILE_NAME), (PsiElement)psiFile));
                continue;
            }
            if (module == null) {
                notIgnored.add(file);
                continue;
            }
            GoBuildMatcher buildMatcher = new GoBuildMatcher(GoTargetSystem.forModule(module));
            GoBuildMatcher.MatchingResult result = buildMatcher.inferMatchingResultForFile(psiFile);
            if (!result.matches) {
                Object cause = null;
                GoFile goFile = (GoFile)psiFile;
                if (result.cause == GoBuildMatcher.MatchingCause.PLUS_BUILD_DIRECTIVE) {
                    cause = (PsiElement)ContainerUtil.getFirstItem(goFile.getBuildFlagElements());
                } else if (result.cause == GoBuildMatcher.MatchingCause.GO_BUILD_DIRECTIVE) {
                    cause = goFile.getGoBuildDirectiveElement();
                } else if (result.cause == GoBuildMatcher.MatchingCause.CGO_IMPORT) {
                    cause = (PsiElement)ContainerUtil.find(goFile.getImports(), importSpec -> importSpec.isCImport());
                } else if (result.cause == GoBuildMatcher.MatchingCause.FILE_NAME) {
                    cause = goFile;
                }
                ignored.put(file, new IgnoreReason(result, (PsiElement)cause));
                continue;
            }
            notIgnored.add(file);
        }
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(6);
        }
        if (file == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        IgnoreReason ignoreReason = this.myIgnoredFiles.get(file);
        if (ignoreReason == null) {
            return null;
        }
        Module module = GoUtil.module((PsiElement)PsiManager.getInstance((Project)project).findFile(file));
        if (module == null) {
            return null;
        }
        return fileEditor -> GoFileIgnoredByBuildToolNotificationProvider.createMismatchedTargetPanel(project, module, file, fileEditor, ignoreReason);
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createMismatchedTargetPanel(@NotNull Project project, @NotNull Module module, @NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull IgnoreReason ignoreReason) {
        if (project == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(8);
        }
        if (module == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(9);
        }
        if (file == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(10);
        }
        if (fileEditor == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(11);
        }
        if (ignoreReason == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.assertEventDispatchThread();
        EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        GoBuildMatcher.MatchingReason reason = ignoreReason.mismatchResult.reason;
        panel.setText(GoBuildMatcher.MatchingReason.mismatchMessage(reason, file.getName()));
        if (reason == GoBuildMatcher.MatchingReason.CGO) {
            GoFileIgnoredByBuildToolNotificationProvider.addInvertCgoSupportAction(panel, module);
        }
        GoBuildMatcher.MatchingCause cause = ignoreReason.mismatchResult.cause;
        PsiElement causeElement = ignoreReason.cause;
        if (cause != null && causeElement != null) {
            if (cause == GoBuildMatcher.MatchingCause.FILE_NAME) {
                panel.createActionLabel(cause.fixMessage(), () -> {
                    if (FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{causeElement})) {
                        PsiElementRenameHandler.invoke((PsiElement)causeElement, (Project)project, (PsiElement)causeElement, null);
                    }
                });
            } else if (causeElement instanceof Navigatable) {
                panel.createActionLabel(cause.fixMessage(), () -> ((Navigatable)causeElement).navigate(true));
            }
        }
        panel.createActionLabel(GoBundle.message((String)"go.notification.go.edit.project.settings.action.text", (Object[])new Object[0]), () -> GoModuleSettings.showModulesConfigurable(module));
        EditorNotificationPanel editorNotificationPanel = panel;
        if (editorNotificationPanel == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(13);
        }
        return editorNotificationPanel;
    }

    private static void addInvertCgoSupportAction(EditorNotificationPanel panel, @NotNull Module module) {
        if (module == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(14);
        }
        GoModuleSettings moduleSettings = GoModuleSettings.getInstance(module);
        ThreeState currentState = moduleSettings.getBuildTargetSettings().cgo;
        if (currentState == ThreeState.UNSURE) {
            return;
        }
        boolean newState = !currentState.toBoolean();
        String message = currentState == ThreeState.YES ? GoBundle.message((String)"go.notification.disable.cgo.support.action.text", (Object[])new Object[0]) : GoBundle.message((String)"go.notification.enable.cgo.support.action.text", (Object[])new Object[0]);
        panel.createActionLabel(message, () -> GoFileIgnoredByBuildToolNotificationProvider.modifyBuildTargetSettings(moduleSettings, settings -> {
            settings.cgo = ThreeState.fromBoolean((boolean)newState);
        }));
    }

    private static void modifyBuildTargetSettings(@NotNull GoModuleSettings moduleSettings, @NotNull Consumer<GoBuildTargetSettings> modifier) {
        GoBuildTargetSettings newBuildTargetSettings;
        if (moduleSettings == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(15);
        }
        if (modifier == null) {
            GoFileIgnoredByBuildToolNotificationProvider.$$$reportNull$$$0(16);
        }
        if ((newBuildTargetSettings = (GoBuildTargetSettings)((Object)XmlSerializerUtil.createCopy((Object)((Object)moduleSettings.getBuildTargetSettings())))) != null) {
            modifier.accept(newBuildTargetSettings);
            moduleSettings.setBuildTargetSettings(newBuildTargetSettings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notIgnored";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreReason";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoFileIgnoredByBuildToolNotificationProvider";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSettings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoFileIgnoredByBuildToolNotificationProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createMismatchedTargetPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCheckFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcIgnoredFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createMismatchedTargetPanel";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addInvertCgoSupportAction";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "modifyBuildTargetSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    private static class IgnoreReason {
        @NotNull
        private final GoBuildMatcher.MatchingResult mismatchResult;
        @Nullable
        private final PsiElement cause;

        private IgnoreReason(@NotNull GoBuildMatcher.MatchingResult mismatchResult, @Nullable PsiElement cause) {
            if (mismatchResult == null) {
                IgnoreReason.$$$reportNull$$$0(0);
            }
            this.mismatchResult = mismatchResult;
            this.cause = cause;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mismatchResult", "com/goide/inspections/GoFileIgnoredByBuildToolNotificationProvider$IgnoreReason", "<init>"));
        }
    }
}

