/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoFunctionDescriptors;
import com.goide.inspections.GoMethodDescriptors;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GoExcludedFunctionsAndMethodsSettings
implements OptionContainer {
    private final GoFunctionDescriptors myExcludedFunctions;
    private final GoMethodDescriptors myExcludedMethods;
    private final GoMethodDescriptors defaultExcludedMethods;

    public GoExcludedFunctionsAndMethodsSettings(Set<String> defaultExcludedFunctions, GoMethodDescriptors defaultExcludedMethods) {
        this.myExcludedFunctions = new GoFunctionDescriptors(defaultExcludedFunctions);
        this.myExcludedMethods = new GoMethodDescriptors(defaultExcludedMethods);
        this.defaultExcludedMethods = defaultExcludedMethods;
    }

    public boolean isExcluded(@NotNull GoCallExpr callExpression, @NotNull GoNamedSignatureOwner signatureOwner) {
        GoFunctionDeclaration funcDeclaration;
        if (callExpression == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(0);
        }
        if (signatureOwner == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(1);
        }
        if ((funcDeclaration = (GoFunctionDeclaration)ObjectUtils.tryCast((Object)signatureOwner, GoFunctionDeclaration.class)) != null) {
            String importPath = GoUtil.getImportPath(funcDeclaration, callExpression);
            return this.myExcludedFunctions.contains(importPath, funcDeclaration.getName());
        }
        return this.isExcluded(GoExcludedFunctionsAndMethodsSettings.getMethodFqnParts(signatureOwner, callExpression, callExpression)) || this.isExcluded(GoExcludedFunctionsAndMethodsSettings.getMethodFqnParts(signatureOwner, callExpression, null));
    }

    private boolean isExcluded(@Nullable Trinity<String, String, String> methodFqnParts) {
        return methodFqnParts != null && this.myExcludedMethods.contains((String)methodFqnParts.first, (String)methodFqnParts.second, (String)methodFqnParts.third);
    }

    public void exclude(@NotNull GoCallExpr callExpression, @NotNull GoNamedSignatureOwner signatureOwner) {
        GoMethodSpec methodSpec;
        GoMethodDeclaration methodDeclaration;
        GoFunctionDeclaration funcDeclaration;
        if (callExpression == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(2);
        }
        if (signatureOwner == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(3);
        }
        if ((funcDeclaration = (GoFunctionDeclaration)ObjectUtils.tryCast((Object)signatureOwner, GoFunctionDeclaration.class)) != null) {
            String importPath = GoUtil.getImportPath(funcDeclaration, callExpression);
            String functionName = funcDeclaration.getName();
            if (importPath == null || functionName == null) {
                return;
            }
            this.myExcludedFunctions.add(importPath, functionName);
        }
        if ((methodDeclaration = (GoMethodDeclaration)ObjectUtils.tryCast((Object)signatureOwner, GoMethodDeclaration.class)) != null) {
            Trinity<String, String, String> parts = GoExcludedFunctionsAndMethodsSettings.getMethodFqnParts(methodDeclaration, callExpression, callExpression);
            if (parts == null) {
                return;
            }
            this.myExcludedMethods.add((String)parts.first, (String)parts.second, (String)parts.third);
        }
        if ((methodSpec = (GoMethodSpec)ObjectUtils.tryCast((Object)signatureOwner, GoMethodSpec.class)) != null) {
            Trinity<String, String, String> parts = GoExcludedFunctionsAndMethodsSettings.getMethodFqnParts(methodSpec, callExpression, callExpression);
            if (parts == null) {
                return;
            }
            this.myExcludedMethods.add((String)parts.first, (String)parts.second, (String)parts.third);
        }
    }

    @TestOnly
    public void excludeMethods(String ... methods) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            StreamEx.of((Object[])methods).forEach(m -> GoExcludedFunctionsAndMethodsSettings.add(this.myExcludedMethods, m));
        }
    }

    @TestOnly
    public void excludeFunctions(String ... functions) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            StreamEx.of((Object[])functions).forEach(this.myExcludedFunctions::add);
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(4);
        }
        GoFunctionDescriptors.readList(node, this.myExcludedFunctions);
        GoMethodDescriptors.readList(node, this.myExcludedMethods);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(5);
        }
        this.myExcludedFunctions.writeList(node);
        this.myExcludedMethods.writeList(node, this.defaultExcludedMethods);
    }

    @NotNull
    public OptPane getOptionsPane(String prefix) {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{this.myExcludedFunctions.getTable(GoBundle.message((String)"go.inspection.options.panel.exclude", (Object[])new Object[0])).prefix("myExcludedFunctions"), this.myExcludedMethods.getTable().prefix("myExcludedMethods")}).prefix(prefix);
        if (optPane == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(6);
        }
        return optPane;
    }

    @Nullable
    public static Trinity<String, String, String> getMethodFqnParts(@NotNull GoNamedSignatureOwner namedSignatureOwner, @NotNull PsiElement context, @Nullable GoCallExpr callExpression) {
        GoMethodDeclaration methodDeclaration;
        GoTypeSpec typeSpec;
        if (namedSignatureOwner == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(8);
        }
        GoTypeSpec goTypeSpec = typeSpec = callExpression == null ? GoExcludedFunctionsAndMethodsSettings.getTypeSpec(namedSignatureOwner) : GoExcludedFunctionsAndMethodsSettings.findReceiverTypeDeclaration(callExpression);
        if (typeSpec == null) {
            return null;
        }
        String typeName = typeSpec.getName();
        if (typeName == null) {
            return null;
        }
        String typeText = namedSignatureOwner instanceof GoMethodDeclaration ? ((methodDeclaration = (GoMethodDeclaration)namedSignatureOwner).getReceiverType() instanceof GoPointerType ? "*" + typeName : typeName) : typeName;
        String importPath = GoUtil.getImportPath(typeSpec, context);
        String methodName = namedSignatureOwner.getName();
        if (importPath == null || methodName == null) {
            return null;
        }
        return Trinity.create((Object)importPath, (Object)typeText, (Object)methodName);
    }

    @Nullable
    private static GoTypeSpec getTypeSpec(@NotNull GoNamedSignatureOwner namedSignatureOwner) {
        if (namedSignatureOwner == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(9);
        }
        if (namedSignatureOwner instanceof GoMethodDeclaration) {
            GoMethodDeclaration methodDeclaration = (GoMethodDeclaration)namedSignatureOwner;
            return GoExcludedFunctionsAndMethodsSettings.getReceiverTypeSpec(methodDeclaration.getReceiverType());
        }
        if (namedSignatureOwner instanceof GoMethodSpec) {
            GoMethodSpec methodSpec = (GoMethodSpec)namedSignatureOwner;
            return (GoTypeSpec)PsiTreeUtil.getParentOfType((PsiElement)methodSpec, GoTypeSpec.class);
        }
        return null;
    }

    @Nullable
    private static GoTypeSpec findReceiverTypeDeclaration(@NotNull GoCallExpr callExpression) {
        GoReferenceExpression ref;
        if (callExpression == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(10);
        }
        GoExpression qualifier = (ref = GoPsiUtil.getCallReference(callExpression)) != null ? ref.getExpressionQualifier() : null;
        GoType type = qualifier != null ? qualifier.getGoType(null) : null;
        return GoExcludedFunctionsAndMethodsSettings.getReceiverTypeSpec(type);
    }

    @Nullable
    private static GoTypeSpec getReceiverTypeSpec(@Nullable GoType type) {
        GoType unwrappedType = GoTypeUtil.unwrapPointerAndParTypes(type);
        GoTypeReferenceExpression typeRef = unwrappedType != null ? unwrappedType.getTypeReferenceExpression() : null;
        return typeRef != null ? (GoTypeSpec)ObjectUtils.tryCast((Object)typeRef.resolve(), GoTypeSpec.class) : null;
    }

    static void add(@NotNull GoMethodDescriptors specialMethods, @NotNull String methodDescriptor) {
        Trinity<String, String, String> parts;
        if (specialMethods == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(11);
        }
        if (methodDescriptor == null) {
            GoExcludedFunctionsAndMethodsSettings.$$$reportNull$$$0(12);
        }
        if ((parts = GoMethodDescriptors.asParts(methodDescriptor)) == null) {
            throw new IllegalArgumentException("Bad method descriptor: " + methodDescriptor);
        }
        specialMethods.add((String)parts.first, (String)parts.second, (String)parts.third);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureOwner";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoExcludedFunctionsAndMethodsSettings";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedSignatureOwner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialMethods";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoExcludedFunctionsAndMethodsSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMethodFqnParts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSpec";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findReceiverTypeDeclaration";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

