/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoErrorHandlingUtil;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStatement;
import com.goide.psi.GoSwitchStart;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.refactor.template.GoLookupExpression;
import com.goide.refactor.template.GoTemplate;
import com.goide.util.GoStdlibUtil;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/goide/inspections/GoDirectComparisonOfErrorsInspection;", "Lcom/goide/inspections/core/GoInspectionBase;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/goide/inspections/core/GoProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isSafeToCompareWithErrors", "", "conditionalExpr", "Lcom/goide/psi/GoConditionalExpr;", "isSwitchOnErrors", "switchStatement", "Lcom/goide/psi/GoExprSwitchStatement;", "hasClauseExpressionsWithErrorType", "expr", "Lcom/goide/psi/GoExpression;", "definedIsMethodOnErrorType", "method", "Lcom/goide/psi/GoMethodDeclaration;", "GoUseErrorIsQuickFix", "GoUseErrorIsInEqualityConditionQuickFix", "GoUseErrorIsInSwitchStatementQuickFix", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoDirectComparisonOfErrorsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDirectComparisonOfErrorsInspection.kt\ncom/goide/inspections/GoDirectComparisonOfErrorsInspection\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,551:1\n66#2,2:552\n*S KotlinDebug\n*F\n+ 1 GoDirectComparisonOfErrorsInspection.kt\ncom/goide/inspections/GoDirectComparisonOfErrorsInspection\n*L\n130#1:552,2\n*E\n"})
public final class GoDirectComparisonOfErrorsInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new GoVisitor(this, holder){
            final /* synthetic */ GoDirectComparisonOfErrorsInspection this$0;
            final /* synthetic */ GoProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitConditionalExpr(GoConditionalExpr conditonalExpr) {
                Intrinsics.checkNotNullParameter((Object)conditonalExpr, (String)"conditonalExpr");
                if (!GoErrorHandlingUtil.INSTANCE.goSdkSupportsErrorsIsAndAs(conditonalExpr)) {
                    return;
                }
                if (GoErrorHandlingUtil.isEqualityComparisonWithErrors(conditonalExpr) && !GoDirectComparisonOfErrorsInspection.access$isSafeToCompareWithErrors(this.this$0, conditonalExpr)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{this.this$0.new GoUseErrorIsInEqualityConditionQuickFix(conditonalExpr)};
                    this.$holder.registerProblem((PsiElement)conditonalExpr, GoDirectComparisonOfErrorsInspection.access$message$s1115493773("go.inspection.problem.comparison.with.errors.using.equality.fails.on.wrapped.errors"), localQuickFixArray);
                }
            }

            public void visitExprSwitchStatement(GoExprSwitchStatement switchStatement) {
                Intrinsics.checkNotNullParameter((Object)switchStatement, (String)"switchStatement");
                if (!GoErrorHandlingUtil.INSTANCE.goSdkSupportsErrorsIsAndAs(switchStatement)) {
                    return;
                }
                if (GoDirectComparisonOfErrorsInspection.access$isSwitchOnErrors(this.this$0, switchStatement)) {
                    GoExpression goExpression = switchStatement.getCondition();
                    Intrinsics.checkNotNull((Object)goExpression);
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{this.this$0.new GoUseErrorIsInSwitchStatementQuickFix(switchStatement)};
                    this.$holder.registerProblem((PsiElement)goExpression, GoDirectComparisonOfErrorsInspection.access$message$s1115493773("go.inspection.problem.switch.on.error.fails.on.wrapped.errors"), localQuickFixArray);
                }
            }
        };
    }

    private final boolean isSafeToCompareWithErrors(GoConditionalExpr conditionalExpr) {
        GoExpression goExpression = conditionalExpr.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)goExpression, (String)"getLeft(...)");
        GoExpression left = goExpression;
        GoExpression goExpression2 = conditionalExpr.getRight();
        if (goExpression2 == null) {
            return false;
        }
        GoExpression right = goExpression2;
        return this.isSafeToCompareWithErrors(left) || this.isSafeToCompareWithErrors(right);
    }

    private final boolean isSwitchOnErrors(GoExprSwitchStatement switchStatement) {
        if (switchStatement.getExprCaseClauseList().isEmpty()) {
            return false;
        }
        GoExpression goExpression = switchStatement.getCondition();
        if (goExpression == null) {
            return false;
        }
        GoExpression cond = goExpression;
        if (this.isSafeToCompareWithErrors(cond)) {
            return false;
        }
        if (!GoErrorHandlingUtil.isErrorType(cond)) {
            return false;
        }
        return this.hasClauseExpressionsWithErrorType(switchStatement);
    }

    private final boolean hasClauseExpressionsWithErrorType(GoExprSwitchStatement switchStatement) {
        for (GoExprCaseClause exprCaseClause : switchStatement.getExprCaseClauseList()) {
            if (exprCaseClause.getDefault() != null) continue;
            for (GoExpression expr : exprCaseClause.getExpressionList()) {
                if (!GoErrorHandlingUtil.isErrorType(expr) && !GoExpressionUtil.isNil(expr)) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)expr);
                if (this.isSafeToCompareWithErrors(expr)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSafeToCompareWithErrors(GoExpression expr) {
        if (GoExpressionUtil.isNil(expr)) return true;
        if (GoStdlibUtil.isStdLibNamedElement(expr, "io", "EOF", expr)) return true;
        PsiElement $this$parentOfType_u24default$iv = expr;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        if (!this.definedIsMethodOnErrorType((GoMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GoMethodDeclaration.class, (boolean)true))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean definedIsMethodOnErrorType(GoMethodDeclaration method) {
        if (method == null) {
            return false;
        }
        GoSignature goSignature = method.getSignature();
        if (goSignature == null) {
            return false;
        }
        GoSignature signature = goSignature;
        List<GoParamDefinition> list = signature.getParameters().getDefinitionList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDefinitionList(...)");
        GoParamDefinition goParamDefinition = (GoParamDefinition)CollectionsKt.singleOrNull(list);
        if (goParamDefinition == null) {
            return false;
        }
        GoParamDefinition singleParameter = goParamDefinition;
        if (!Intrinsics.areEqual((Object)method.getName(), (Object)"Is")) return false;
        if (!GoTypeUtil.isBoolean(signature.getResultType(), method)) return false;
        GoReceiver goReceiver = method.getReceiver();
        if (!GoErrorHandlingUtil.implementsErrorInterface(goReceiver != null ? goReceiver.getType() : null, method)) return false;
        if (!GoErrorHandlingUtil.INSTANCE.isBuiltInErrorType(singleParameter.getGoType(null), method)) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isSafeToCompareWithErrors(GoDirectComparisonOfErrorsInspection $this, GoConditionalExpr conditionalExpr) {
        return $this.isSafeToCompareWithErrors(conditionalExpr);
    }

    public static final /* synthetic */ GoInspectionMessage access$message$s1115493773(String key) {
        return GoInspectionBase.message(key);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002\u00a8\u0006#"}, d2={"Lcom/goide/inspections/GoDirectComparisonOfErrorsInspection$GoUseErrorIsInEqualityConditionQuickFix;", "Lcom/goide/inspections/GoDirectComparisonOfErrorsInspection$GoUseErrorIsQuickFix;", "elem", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/goide/inspections/GoDirectComparisonOfErrorsInspection;Lcom/intellij/psi/PsiElement;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "invokeTemplate", "template", "Lcom/goide/refactor/template/GoTemplate;", "cond", "Lcom/goide/psi/GoConditionalExpr;", "getArgumentsForErrorsIs", "Lkotlin/Pair;", "left", "Lcom/goide/psi/GoExpression;", "right", "distanceToDefinition", "", "expr", "(Lcom/goide/psi/GoExpression;Lcom/goide/psi/GoConditionalExpr;)Ljava/lang/Integer;", "isDefinedInTheSameFunctionScope", "", "isReferenceToVar", "intellij.go.impl"})
    private final class GoUseErrorIsInEqualityConditionQuickFix
    extends GoUseErrorIsQuickFix {
        public GoUseErrorIsInEqualityConditionQuickFix(PsiElement elem) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            super(elem);
        }

        @NotNull
        public String getText() {
            String string = GoBundle.message((String)"go.fix.replace.equality.check.with.errors.is", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (editor == null) {
                return;
            }
            if (!(startElement instanceof GoConditionalExpr)) {
                return;
            }
            if (!GoErrorHandlingUtil.isEqualityComparisonWithErrors((GoExpression)startElement)) {
                return;
            }
            GoErrorHandlingUtil.INSTANCE.withTemplate(editor, (GoFile)file, PsiTreeUtilKt.getStartOffset((PsiElement)startElement), ((GoConditionalExpr)startElement).getTextRange(), (Function1<? super GoTemplate, Unit>)((Function1)arg_0 -> GoUseErrorIsInEqualityConditionQuickFix.invoke$lambda$0(this, startElement, arg_0)));
        }

        private final void invokeTemplate(GoTemplate template, GoConditionalExpr cond) {
            GoExpression goExpression = cond.getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)goExpression, (String)"getLeft(...)");
            GoExpression left = goExpression;
            GoExpression goExpression2 = cond.getRight();
            Intrinsics.checkNotNull((Object)goExpression2);
            GoExpression right = goExpression2;
            if (GoErrorHandlingUtil.INSTANCE.isNotEqualOperator(cond)) {
                template.addTextSegment("!");
            }
            Pair<String, String> arguments = this.getArgumentsForErrorsIs(left, right, cond);
            GoErrorHandlingUtil.INSTANCE.addFunctionCall(template, "errors.Is", (Function1<? super GoTemplate, Unit>)((Function1)arg_0 -> GoUseErrorIsInEqualityConditionQuickFix.invokeTemplate$lambda$1(arguments, arg_0)), (Function1<? super GoTemplate, Unit>)((Function1)arg_0 -> GoUseErrorIsInEqualityConditionQuickFix.invokeTemplate$lambda$2(arguments, arg_0)));
        }

        private final Pair<String, String> getArgumentsForErrorsIs(GoExpression left, GoExpression right, GoConditionalExpr cond) {
            Pair pair;
            String leftText = left.getText();
            String rightText = right.getText();
            boolean isLeftDefinedInSameFunctionScope = this.isDefinedInTheSameFunctionScope(left, cond);
            boolean isRightDefinedInSameFunctionScope = this.isDefinedInTheSameFunctionScope(right, cond);
            if (isLeftDefinedInSameFunctionScope && isRightDefinedInSameFunctionScope) {
                Integer leftDistance = this.distanceToDefinition(left, cond);
                Integer rightDistance = this.distanceToDefinition(right, cond);
                pair = leftDistance == null || rightDistance == null ? new Pair((Object)leftText, (Object)rightText) : (leftDistance < rightDistance ? new Pair((Object)leftText, (Object)rightText) : (rightDistance < leftDistance ? new Pair((Object)rightText, (Object)leftText) : new Pair((Object)leftText, (Object)rightText)));
            } else {
                pair = isLeftDefinedInSameFunctionScope ? new Pair((Object)leftText, (Object)rightText) : (isRightDefinedInSameFunctionScope ? new Pair((Object)rightText, (Object)leftText) : (this.isReferenceToVar(left) ? new Pair((Object)rightText, (Object)leftText) : (this.isReferenceToVar(right) ? new Pair((Object)leftText, (Object)rightText) : new Pair((Object)leftText, (Object)rightText))));
            }
            return pair;
        }

        private final Integer distanceToDefinition(GoExpression expr, GoConditionalExpr cond) {
            if (expr instanceof GoReferenceExpression) {
                Integer startOffset;
                Integer n;
                PsiElement parent;
                PsiElement resolved;
                PsiElement psiElement = resolved = ((GoReferenceExpression)expr).getReference().resolve();
                Object object = parent = psiElement != null ? psiElement.getParent() : null;
                if (parent instanceof GoVarSpec) {
                    n = PsiTreeUtilKt.getStartOffset((PsiElement)parent);
                } else if (parent instanceof GoParameterDeclaration) {
                    PsiElement psiElement2 = ((GoParameterDeclaration)parent).getParent();
                    n = psiElement2 != null ? Integer.valueOf(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement2)) : null;
                } else {
                    PsiElement psiElement3 = resolved;
                    n = psiElement3 != null ? Integer.valueOf(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement3)) : null;
                }
                Integer n2 = startOffset = n;
                return n2 != null ? Integer.valueOf(Math.abs(n2 - PsiTreeUtilKt.getStartOffset((PsiElement)cond))) : null;
            }
            return null;
        }

        private final boolean isDefinedInTheSameFunctionScope(GoExpression expr, GoConditionalExpr cond) {
            if (expr instanceof GoReferenceExpression) {
                PsiElement resolved;
                KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(GoFunctionOrMethodDeclaration.class), Reflection.getOrCreateKotlinClass(GoFunctionLit.class)};
                KClass[] parents = kClassArray;
                PsiElement psiElement = resolved = ((GoReferenceExpression)expr).getReference().resolve();
                GoCompositeElement exprParent = psiElement != null ? (GoCompositeElement)PsiTreeUtilKt.parentOfTypes$default((PsiElement)psiElement, (KClass[])Arrays.copyOf(parents, parents.length), (boolean)false, (int)2, null) : null;
                GoCompositeElement condParent = (GoCompositeElement)PsiTreeUtilKt.parentOfTypes$default((PsiElement)cond, (KClass[])Arrays.copyOf(parents, parents.length), (boolean)false, (int)2, null);
                return Intrinsics.areEqual((Object)exprParent, (Object)condParent);
            }
            return false;
        }

        private final boolean isReferenceToVar(GoExpression expr) {
            GoReferenceExpression goReferenceExpression = expr instanceof GoReferenceExpression ? (GoReferenceExpression)expr : null;
            PsiElement resolved = goReferenceExpression != null ? goReferenceExpression.resolve() : null;
            return resolved instanceof GoVarDefinition;
        }

        private static final Unit invoke$lambda$0(GoUseErrorIsInEqualityConditionQuickFix this$0, PsiElement $startElement, GoTemplate template) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            this$0.invokeTemplate(template, (GoConditionalExpr)$startElement);
            return Unit.INSTANCE;
        }

        private static final Unit invokeTemplate$lambda$1(Pair $arguments, GoTemplate $this$addFunctionCall) {
            Intrinsics.checkNotNullParameter((Object)$this$addFunctionCall, (String)"$this$addFunctionCall");
            Object[] objectArray = new String[]{$arguments.getFirst(), $arguments.getSecond()};
            GoLookupExpression firstArgument = new GoLookupExpression(SetsKt.linkedSetOf((Object[])objectArray), LookupFocusDegree.FOCUSED);
            $this$addFunctionCall.addPrimaryVariable("FIRST", firstArgument);
            return Unit.INSTANCE;
        }

        private static final Unit invokeTemplate$lambda$2(Pair $arguments, GoTemplate $this$addFunctionCall) {
            Intrinsics.checkNotNullParameter((Object)$this$addFunctionCall, (String)"$this$addFunctionCall");
            MacroBase macro2 = new MacroBase((Pair<String, String>)$arguments){
                final /* synthetic */ Pair<String, String> $arguments;
                {
                    this.$arguments = $arguments;
                    super("secondArgumentForErrorIsCall", "secondArgumentForErrorIsCall");
                }

                protected Result calculateResult(Expression[] params, ExpressionContext context, boolean quick) {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    ExpressionContext expressionContext = context;
                    return Intrinsics.areEqual((Object)(expressionContext != null && (expressionContext = expressionContext.getVariableValue("FIRST")) != null ? expressionContext.getText() : null), (Object)this.$arguments.getFirst()) ? (Result)new TextResult((String)this.$arguments.getSecond()) : (Result)new TextResult((String)this.$arguments.getFirst());
                }
            };
            $this$addFunctionCall.addVariable("SECOND", (Expression)new MacroCallNode((Macro)macro2), false);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\t*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0018\u001a\u00020\t*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/goide/inspections/GoDirectComparisonOfErrorsInspection$GoUseErrorIsInSwitchStatementQuickFix;", "Lcom/goide/inspections/GoDirectComparisonOfErrorsInspection$GoUseErrorIsQuickFix;", "elem", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/goide/inspections/GoDirectComparisonOfErrorsInspection;Lcom/intellij/psi/PsiElement;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "shouldIntroduceNewVariable", "", "switchStatement", "Lcom/goide/psi/GoExprSwitchStatement;", "addSwitchStatement", "Lcom/goide/refactor/template/GoTemplate;", "addCondition", "expr", "Lcom/goide/psi/GoExpression;", "switchConditionExpr", "shouldIntroduceNewVariableForCallExpr", "intellij.go.impl"})
    @SourceDebugExtension(value={"SMAP\nGoDirectComparisonOfErrorsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDirectComparisonOfErrorsInspection.kt\ncom/goide/inspections/GoDirectComparisonOfErrorsInspection$GoUseErrorIsInSwitchStatementQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,551:1\n774#2:552\n865#2,2:553\n1#3:555\n*S KotlinDebug\n*F\n+ 1 GoDirectComparisonOfErrorsInspection.kt\ncom/goide/inspections/GoDirectComparisonOfErrorsInspection$GoUseErrorIsInSwitchStatementQuickFix\n*L\n284#1:552\n284#1:553,2\n*E\n"})
    private final class GoUseErrorIsInSwitchStatementQuickFix
    extends GoUseErrorIsQuickFix {
        public GoUseErrorIsInSwitchStatementQuickFix(PsiElement elem) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            super(elem);
        }

        @NotNull
        public String getText() {
            String string = GoBundle.message((String)"go.fix.replace.switch.on.errors.with.errors.is", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (editor == null) {
                return;
            }
            if (!(startElement instanceof GoExprSwitchStatement)) {
                return;
            }
            if (!GoDirectComparisonOfErrorsInspection.this.isSwitchOnErrors((GoExprSwitchStatement)startElement)) {
                return;
            }
            GoErrorHandlingUtil.INSTANCE.withTemplate(editor, (GoFile)file, PsiTreeUtilKt.getStartOffset((PsiElement)startElement), ((GoExprSwitchStatement)startElement).getTextRange(), (Function1<? super GoTemplate, Unit>)((Function1)arg_0 -> GoUseErrorIsInSwitchStatementQuickFix.invoke$lambda$0(this, startElement, arg_0)));
        }

        /*
         * WARNING - void declaration
         */
        private final boolean shouldIntroduceNewVariable(GoExprSwitchStatement switchStatement) {
            if (switchStatement.getCondition() instanceof GoCallExpr) {
                void $this$filterTo$iv$iv;
                List<GoExprCaseClause> list = switchStatement.getExprCaseClauseList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getExprCaseClauseList(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GoExprCaseClause it = (GoExprCaseClause)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getDefault() == null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                int n = 0;
                for (Object e : iterable2) {
                    void it;
                    GoExprCaseClause $i$f$filterTo2 = (GoExprCaseClause)e;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = it.getExpressionList().size();
                    n = n2 + n3;
                }
                int countClauseExpressions = n;
                return countClauseExpressions > 1;
            }
            return false;
        }

        private final void addSwitchStatement(GoTemplate $this$addSwitchStatement, GoExprSwitchStatement switchStatement) {
            boolean shouldIntroduceNewVariableForCallExpr = this.shouldIntroduceNewVariable(switchStatement);
            GoStatement switchInitStatement = switchStatement.getInitStatement();
            GoExpression goExpression = switchStatement.getCondition();
            Intrinsics.checkNotNull((Object)goExpression);
            GoExpression switchConditionExpr = goExpression;
            if (shouldIntroduceNewVariableForCallExpr) {
                GoErrorHandlingUtil.INSTANCE.declareVarForSwitchExpr($this$addSwitchStatement, switchInitStatement, switchConditionExpr);
            }
            $this$addSwitchStatement.addTextSegment("switch");
            GoSwitchStart goSwitchStart = switchStatement.getSwitchStart();
            Intrinsics.checkNotNullExpressionValue((Object)goSwitchStart, (String)"getSwitchStart(...)");
            GoStatement goStatement = switchStatement.getStatement();
            Intrinsics.checkNotNull((Object)goStatement);
            GoErrorHandlingUtil.INSTANCE.addWhitespaceAndCommentsAfterSwitch($this$addSwitchStatement, goSwitchStart, switchInitStatement, goStatement);
            GoErrorHandlingUtil.INSTANCE.addSwitchInitStatement($this$addSwitchStatement, switchInitStatement, switchConditionExpr, shouldIntroduceNewVariableForCallExpr);
            GoErrorHandlingUtil.INSTANCE.addWhitespaceAndCommentAfterInitStatement($this$addSwitchStatement, switchInitStatement, switchStatement.getSemicolon(), switchConditionExpr);
            $this$addSwitchStatement.addTextSegment("{");
            if (switchStatement.getLbrace() != null) {
                PsiElement psiElement = switchStatement.getLbrace();
                Intrinsics.checkNotNull((Object)psiElement);
                List<GoExprCaseClause> list = switchStatement.getExprCaseClauseList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getExprCaseClauseList(...)");
                Object object = CollectionsKt.first(list);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                $this$addSwitchStatement.addTextSegment(GoErrorHandlingUtil.INSTANCE.getText(GoErrorHandlingUtil.INSTANCE.elementsInBetween(psiElement, (PsiElement)object)));
            }
            for (GoExprCaseClause caseClause : switchStatement.getExprCaseClauseList()) {
                PsiElement colon = caseClause.getColon();
                if (caseClause.getDefault() != null) {
                    Intrinsics.checkNotNull((Object)caseClause);
                    PsiElement psiElement = caseClause;
                    PsiElement psiElement2 = caseClause.getDefault();
                    Intrinsics.checkNotNull((Object)psiElement2);
                    $this$addSwitchStatement.addTextSegment(GoErrorHandlingUtil.INSTANCE.getText(GoErrorHandlingUtil.INSTANCE.elementsToChild(psiElement, psiElement2)));
                    $this$addSwitchStatement.addTextSegment("default");
                    PsiElement psiElement3 = caseClause.getDefault();
                    Intrinsics.checkNotNull((Object)psiElement3);
                    GoErrorHandlingUtil.INSTANCE.addCaseClauseBody($this$addSwitchStatement, colon, psiElement3);
                    continue;
                }
                if (caseClause.getCase() != null) {
                    PsiElement psiElement;
                    Intrinsics.checkNotNull((Object)caseClause.getCase());
                    Intrinsics.checkNotNull((Object)caseClause);
                    $this$addSwitchStatement.addTextSegment(GoErrorHandlingUtil.INSTANCE.getText(GoErrorHandlingUtil.INSTANCE.elementsToChild(caseClause, psiElement)));
                    $this$addSwitchStatement.addTextSegment("case");
                    List<GoExpression> list = caseClause.getExpressionList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressionList(...)");
                    if (!((Collection)list).isEmpty()) {
                        List<GoExpression> list2 = caseClause.getExpressionList();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExpressionList(...)");
                        Object object = CollectionsKt.first(list2);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                        $this$addSwitchStatement.addTextSegment(GoErrorHandlingUtil.INSTANCE.getText(GoErrorHandlingUtil.INSTANCE.elementsInBetween(psiElement, (PsiElement)object)));
                    }
                    GoErrorHandlingUtil.addList$default(GoErrorHandlingUtil.INSTANCE, $this$addSwitchStatement, caseClause.getExpressionList(), (arg_0, arg_1) -> GoUseErrorIsInSwitchStatementQuickFix.addSwitchStatement$lambda$3(this, switchConditionExpr, shouldIntroduceNewVariableForCallExpr, arg_0, arg_1), false, null, 12, null);
                    List<GoExpression> list3 = caseClause.getExpressionList();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"getExpressionList(...)");
                    GoExpression goExpression2 = (GoExpression)CollectionsKt.firstOrNull(list3);
                    GoErrorHandlingUtil.INSTANCE.addCaseClauseBody($this$addSwitchStatement, colon, goExpression2 != null ? (PsiElement)goExpression2 : psiElement);
                    continue;
                }
                $this$addSwitchStatement.getTemplate().addTextSegment(caseClause.getText());
            }
            $this$addSwitchStatement.addTextSegment("}");
        }

        private final void addCondition(GoTemplate $this$addCondition, GoExpression expr, GoExpression switchConditionExpr, boolean shouldIntroduceNewVariableForCallExpr) {
            String firstArg = switchConditionExpr.getText();
            String secondArg = expr.getText();
            if (GoDirectComparisonOfErrorsInspection.this.isSafeToCompareWithErrors(expr)) {
                Intrinsics.checkNotNull((Object)firstArg);
                GoErrorHandlingUtil.INSTANCE.addFirstArgument($this$addCondition, firstArg, shouldIntroduceNewVariableForCallExpr);
                $this$addCondition.addTextSegment("==");
                $this$addCondition.addTextSegment(secondArg);
            } else {
                GoErrorHandlingUtil.INSTANCE.addFunctionCall($this$addCondition, "errors.Is", (Function1<? super GoTemplate, Unit>)((Function1)arg_0 -> GoUseErrorIsInSwitchStatementQuickFix.addCondition$lambda$4(firstArg, shouldIntroduceNewVariableForCallExpr, arg_0)), (Function1<? super GoTemplate, Unit>)((Function1)arg_0 -> GoUseErrorIsInSwitchStatementQuickFix.addCondition$lambda$5(secondArg, arg_0)));
            }
        }

        private static final Unit invoke$lambda$0(GoUseErrorIsInSwitchStatementQuickFix this$0, PsiElement $startElement, GoTemplate template) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            this$0.addSwitchStatement(template, (GoExprSwitchStatement)$startElement);
            return Unit.INSTANCE;
        }

        private static final Unit addSwitchStatement$lambda$3(GoUseErrorIsInSwitchStatementQuickFix this$0, GoExpression $switchConditionExpr, boolean $shouldIntroduceNewVariableForCallExpr, GoTemplate $this$addList, GoExpression expr) {
            Intrinsics.checkNotNullParameter((Object)$this$addList, (String)"$this$addList");
            Intrinsics.checkNotNull((Object)expr);
            this$0.addCondition($this$addList, expr, $switchConditionExpr, $shouldIntroduceNewVariableForCallExpr);
            return Unit.INSTANCE;
        }

        private static final Unit addCondition$lambda$4(String $firstArg, boolean $shouldIntroduceNewVariableForCallExpr, GoTemplate $this$addFunctionCall) {
            Intrinsics.checkNotNullParameter((Object)$this$addFunctionCall, (String)"$this$addFunctionCall");
            Intrinsics.checkNotNull((Object)$firstArg);
            GoErrorHandlingUtil.INSTANCE.addFirstArgument($this$addFunctionCall, $firstArg, $shouldIntroduceNewVariableForCallExpr);
            return Unit.INSTANCE;
        }

        private static final Unit addCondition$lambda$5(String $secondArg, GoTemplate $this$addFunctionCall) {
            Intrinsics.checkNotNullParameter((Object)$this$addFunctionCall, (String)"$this$addFunctionCall");
            $this$addFunctionCall.addTextSegment($secondArg);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/goide/inspections/GoDirectComparisonOfErrorsInspection$GoUseErrorIsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "elem", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "availableInBatchMode", "", "intellij.go.impl"})
    private static abstract class GoUseErrorIsQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        public GoUseErrorIsQuickFix(@NotNull PsiElement elem) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            super(elem);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        public boolean availableInBatchMode() {
            return false;
        }
    }
}

