/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoParserDefinition;
import com.goide.formatter.GoLineCommentBlock;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class GoCommentLeadingSpaceInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoCommentLeadingSpaceInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoCommentLeadingSpaceInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            public void visitComment(@NotNull PsiComment o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitComment(o);
                if (o.getTokenType() != GoParserDefinition.Lazy.LINE_COMMENT) {
                    return;
                }
                GoCodeStyleSettings settings = (GoCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)o.getContainingFile(), GoCodeStyleSettings.class);
                if (!settings.ADD_LEADING_SPACE_TO_COMMENTS) {
                    return;
                }
                String commentText = StringUtil.trimStart((String)o.getText(), (String)"//");
                if (commentText.isEmpty() || Character.isWhitespace(commentText.charAt(0)) || !GoLineCommentBlock.canBeFormatted(commentText, settings)) {
                    return;
                }
                holder.registerProblem((PsiElement)o, GoCommentLeadingSpaceInspection.message("go.inspection.problem.comment.should.start.with.whitespace"), new GoAddCommentLeadingSpaceQuickFix());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoCommentLeadingSpaceInspection$1", "visitComment"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoCommentLeadingSpaceInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoAddCommentLeadingSpaceQuickFix
    implements LocalQuickFix {
        private GoAddCommentLeadingSpaceQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.add.whitespace.name", (Object[])new Object[0]);
            if (string == null) {
                GoAddCommentLeadingSpaceQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                GoAddCommentLeadingSpaceQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoAddCommentLeadingSpaceQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null || !element.isValid() || !(element instanceof PsiComment)) {
                return;
            }
            String newText = StringUtil.trimStart((String)element.getText(), (String)"//");
            PsiComment newComment = GoElementFactory.createLineCommentFromText(project, newText);
            element.replace((PsiElement)newComment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoCommentLeadingSpaceInspection$GoAddCommentLeadingSpaceQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoCommentLeadingSpaceInspection$GoAddCommentLeadingSpaceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

