/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAndExpr;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoOrExpr;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.expectedTypes.GoConditionExpectedType;
import com.goide.quickfix.GoAlwaysFalseForConditionQuickFix;
import com.goide.quickfix.GoAlwaysFalseIfQuickFix;
import com.goide.quickfix.GoAlwaysTrueForConditionQuickFix;
import com.goide.quickfix.GoAlwaysTrueIfQuickFix;
import com.goide.quickfix.GoRemoveRedundantBoolLiteralQuickFix;
import com.goide.quickfix.GoSimplifyBoolExprQuickFix;
import com.goide.quickfix.GoSimplifyExpressionToBooleanLiteralQuickFix;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoBoolExpressionsInspection
extends GoInspectionBase {
    private static final Key<Set<GoExpression>> REPORTED_EXPRESSIONS = Key.create((String)"GoBoolExpressionsInspection.REPORTED_EXPRESSIONS");

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitConditionalExpr(@NotNull GoConditionalExpr o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitConditionalExpr(o);
                PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
                if (GoBoolExpressionsInspection.isNonStrictComparisonWithMaxOrMinValue(o, context)) {
                    this.reportAlwaysTrueOrFalseExpression(o, true, context);
                    return;
                }
                if (GoBoolExpressionsInspection.isComparisonOfFuncAndNil(o)) {
                    this.reportAlwaysTrueOrFalseExpression(o, o.getNotEq() != null, context);
                }
            }

            @Override
            public void visitExpression(@NotNull GoExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitExpression(o);
                if (PsiTreeUtil.instanceOf((Object)o.getParent(), (Class[])new Class[]{GoUnaryExpr.class, GoParenthesesExpr.class}) || !GoTypeUtil.isBoolean(o.getGoType(null), o)) {
                    return;
                }
                Optional.of(o).map(GoExpression::getValue).map(Value::getBool).ifPresent(boolValue -> this.processBoolExprWithKnownValue(o, (boolean)boolValue, GoReferenceBase.getSubstitutionContextOrSelf(o)));
            }

            @Override
            public void visitAndExpr(@NotNull GoAndExpr o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.visitBinaryExpression(o, true);
            }

            @Override
            public void visitOrExpr(@NotNull GoOrExpr o) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.visitBinaryExpression(o, false);
            }

            private void processBoolExprWithKnownValue(@NotNull GoExpression o, boolean isTrue, @NotNull PsiElement context) {
                boolean isRedundantPartOfBinaryExpression;
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(5);
                }
                PsiElement parent = o.getParent();
                boolean bl = isRedundantPartOfBinaryExpression = isTrue ? parent instanceof GoAndExpr : parent instanceof GoOrExpr;
                if (isRedundantPartOfBinaryExpression && GoExpressionUtil.isBooleanLiteral(GoPsiImplUtil.unwrapParentheses(o))) {
                    this.reportRedundantLiteralInBinaryExpression(o, (GoBinaryExpr)parent);
                    return;
                }
                this.reportAlwaysTrueOrFalseExpression(o, isTrue, context);
            }

            private void reportRedundantLiteralInBinaryExpression(@NotNull GoExpression literalExpression, @NotNull GoBinaryExpr parent) {
                if (literalExpression == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (parent == null) {
                    1.$$$reportNull$$$0(7);
                }
                PsiElement operator = parent.getOperator();
                if (this.isAlreadyReported(parent) || operator == null || parent.getRight() == null) {
                    return;
                }
                GoExpression otherExpression = parent.getLeft() == literalExpression ? parent.getRight() : parent.getLeft();
                String otherExpressionText = otherExpression.getText();
                if (StringUtil.isNotEmpty((String)otherExpressionText)) {
                    this.addToReported(parent);
                    GoInspectionMessage message = GoBoolExpressionsInspection.message("go.inspection.problem.expression.can.be.simplified.to.other", new Object[]{REF, GoBoolExpressionsInspection.code(otherExpressionText)});
                    holder.registerProblem((PsiElement)parent, message, new LocalQuickFix[]{new GoRemoveRedundantBoolLiteralQuickFix(literalExpression, otherExpressionText)});
                }
            }

            private void reportAlwaysTrueOrFalseExpression(@NotNull GoExpression o, boolean boolConst, @NotNull PsiElement context) {
                boolean isCondition;
                if (o == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (this.isAlreadyReported(o = 1.getTopmostAlwaysTrueOrFalseExpression(o, boolConst))) {
                    return;
                }
                boolean bl = isCondition = ContainerUtil.findInstance(GoTypeUtil.getExpectedTypes(o, context).asList(), GoConditionExpectedType.class) != null;
                if (!1.isPureBoolean(o.getGoType(null), o) && !isCondition || GoPsiImplUtil.unwrapParentheses(o) instanceof GoReferenceExpression && GoExpressionUtil.isConstant(o)) {
                    return;
                }
                this.addToReported(o);
                GoInspectionMessage message = 1.getMessage(isCondition, boolConst);
                if (!GoExpressionUtil.hasSideEffects(o)) {
                    holder.registerProblem((PsiElement)o, message, GoBoolExpressionsInspection.fixesForKnownValue(o, boolConst));
                } else {
                    holder.registerProblem((PsiElement)o, message, new LocalQuickFix[0]);
                }
            }

            @NotNull
            private static GoExpression getTopmostAlwaysTrueOrFalseExpression(@NotNull GoExpression o, boolean isTrue) {
                if (o == null) {
                    1.$$$reportNull$$$0(10);
                }
                GoExpression goExpression = (GoExpression)GoPsiUtil.skipParens(GoPsiUtil.skipParents(o, isTrue ? GoOrExpr.class : GoAndExpr.class));
                if (goExpression == null) {
                    1.$$$reportNull$$$0(11);
                }
                return goExpression;
            }

            private static boolean isPureBoolean(@Nullable GoType type, @NotNull PsiElement context) {
                PsiElement resolve;
                if (context == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (type instanceof GoSpecType) {
                    return false;
                }
                PsiElement psiElement = resolve = type != null ? type.resolve(context) : null;
                if (resolve instanceof GoTypeSpec && !GoPsiImplUtil.builtin(resolve)) {
                    return false;
                }
                return GoTypeUtil.isBoolean(type, context);
            }

            @NotNull
            private static GoInspectionMessage getMessage(boolean condition, boolean boolConst) {
                GoInspectionMessage goInspectionMessage = condition ? GoBoolExpressionsInspection.message("go.inspection.problem.condition.is.always.true.or.false", new Object[]{REF, GoBoolExpressionsInspection.code(String.valueOf(boolConst))}) : GoBoolExpressionsInspection.message("go.inspection.problem.expression.is.always.true.or.false", new Object[]{REF, GoBoolExpressionsInspection.code(String.valueOf(boolConst))});
                if (goInspectionMessage == null) {
                    1.$$$reportNull$$$0(13);
                }
                return goInspectionMessage;
            }

            private void visitBinaryExpression(@NotNull GoBinaryExpr o, boolean and) {
                if (o == null) {
                    1.$$$reportNull$$$0(14);
                }
                if (this.isAlreadyReported(o) || !1.isTopmostOperationOfType(o, and)) {
                    return;
                }
                List<ExpressionGroup> groups = GoBoolExpressionsInspection.split(GoBoolExpressionsInspection.collect(o, and));
                PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
                for (ExpressionGroup group : groups) {
                    if (group.hasSideEffects) continue;
                    List<GoExpression> elements = group.expressions;
                    for (int i = 0; i < elements.size(); ++i) {
                        GoExpression l = elements.get(i);
                        if (GoExpressionUtil.getBoolConst(l) != null) {
                            return;
                        }
                        for (int j = i + 1; j < elements.size(); ++j) {
                            ProgressManager.checkCanceled();
                            GoExpression r = elements.get(j);
                            if (!GoBoolExpressionsInspection.isEqualsWithNot(l, r, context) && !GoBoolExpressionsInspection.isEqualsWithNot(r, l, context) && !GoExpressionUtil.identical(l, r, context) && !GoBoolExpressionsInspection.isProblemWithEqAndConsts(l, r, and, context)) continue;
                            this.addToReported(o);
                            holder.registerProblem((PsiElement)o, GoBoolExpressionsInspection.message("go.inspection.problem.expression.can.be.simplified"), new LocalQuickFix[]{new GoSimplifyBoolExprQuickFix(o)});
                            return;
                        }
                    }
                }
            }

            private static boolean isTopmostOperationOfType(@Nullable GoBinaryExpr o, boolean isAndType) {
                PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)o, (Class[])new Class[]{GoParenthesesExpr.class});
                return !(parent instanceof GoBinaryExpr) || !GoBoolExpressionsInspection.isSameOp((GoExpression)parent, isAndType);
            }

            private boolean isAlreadyReported(@NotNull GoExpression expression) {
                Set expressions;
                if (expression == null) {
                    1.$$$reportNull$$$0(15);
                }
                return (expressions = (Set)REPORTED_EXPRESSIONS.get((UserDataHolder)session)) != null && expressions.contains(expression);
            }

            private void addToReported(@NotNull GoExpression expression) {
                HashSet<GoExpression> expressions;
                if (expression == null) {
                    1.$$$reportNull$$$0(16);
                }
                if ((expressions = (HashSet<GoExpression>)REPORTED_EXPRESSIONS.get((UserDataHolder)session)) == null) {
                    expressions = new HashSet<GoExpression>();
                    REPORTED_EXPRESSIONS.set((UserDataHolder)session, expressions);
                }
                expressions.add(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 11, 13 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 5: 
                    case 9: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literalExpression";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 11: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/inspections/GoBoolExpressionsInspection$1";
                        break;
                    }
                    case 15: 
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/inspections/GoBoolExpressionsInspection$1";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTopmostAlwaysTrueOrFalseExpression";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitConditionalExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitAndExpr";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "visitOrExpr";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "processBoolExprWithKnownValue";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "reportRedundantLiteralInBinaryExpression";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "reportAlwaysTrueOrFalseExpression";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "getTopmostAlwaysTrueOrFalseExpression";
                        break;
                    }
                    case 11: 
                    case 13: {
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "isPureBoolean";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "visitBinaryExpression";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "isAlreadyReported";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray;
                        objectArray[2] = "addToReported";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 11, 13 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static List<ExpressionGroup> split(@NotNull List<GoExpression> expressions) {
        if (expressions == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(2);
        }
        SmartList groups = new SmartList();
        SmartList current = new SmartList();
        boolean currentGroupHasSideEffects = false;
        for (GoExpression expression : expressions) {
            if (GoExpressionUtil.hasSideEffects(expression) == currentGroupHasSideEffects) {
                current.add(expression);
                continue;
            }
            if (!current.isEmpty()) {
                groups.add(new ExpressionGroup((List<GoExpression>)current, currentGroupHasSideEffects));
                current = new SmartList();
            }
            current.add(expression);
            currentGroupHasSideEffects = !currentGroupHasSideEffects;
        }
        if (!current.isEmpty()) {
            groups.add(new ExpressionGroup((List<GoExpression>)current, currentGroupHasSideEffects));
        }
        SmartList smartList = groups;
        if (smartList == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private static boolean isProblemWithEqAndConsts(@NotNull GoExpression l, @NotNull GoExpression r, boolean and, @Nullable PsiElement context) {
        ThreeState valuesEquals;
        if (l == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(4);
        }
        if (r == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(5);
        }
        if ((valuesEquals = GoBoolExpressionsInspection.areSameExpressions(l, r, context)) == ThreeState.UNSURE) {
            return false;
        }
        return valuesEquals.toBoolean() || !GoExpressionUtil.identicalOperators(l, r) || and == (((GoConditionalExpr)l).getEq() != null);
    }

    @NotNull
    public static ThreeState areSameExpressions(@NotNull GoExpression l, @NotNull GoExpression r, @Nullable PsiElement context) {
        GoConditionalExpr left;
        block9: {
            block8: {
                if (l == null) {
                    GoBoolExpressionsInspection.$$$reportNull$$$0(6);
                }
                if (r == null) {
                    GoBoolExpressionsInspection.$$$reportNull$$$0(7);
                }
                if (!(l instanceof GoConditionalExpr)) break block8;
                left = (GoConditionalExpr)l;
                if (r instanceof GoConditionalExpr) break block9;
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GoBoolExpressionsInspection.$$$reportNull$$$0(8);
            }
            return threeState;
        }
        GoConditionalExpr right = (GoConditionalExpr)r;
        if (left.getEq() == null && left.getNotEq() == null || right.getEq() == null && right.getNotEq() == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                GoBoolExpressionsInspection.$$$reportNull$$$0(9);
            }
            return threeState;
        }
        return GoBoolExpressionsInspection.areTwoIdenticalChildrenAndChildrenWithEqualValues(left, right, context);
    }

    @NotNull
    private static ThreeState areTwoIdenticalChildrenAndChildrenWithEqualValues(@NotNull GoConditionalExpr l, @NotNull GoConditionalExpr r, @Nullable PsiElement context) {
        GoExpression r2;
        if (l == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(10);
        }
        if (r == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(11);
        }
        GoExpression l1 = l.getLeft();
        GoExpression l2 = l.getRight();
        GoExpression r1 = r.getLeft();
        ThreeState valuesEquals = GoBoolExpressionsInspection.areTwoIdenticalAndTwoWithEqualValues(l1, r1, l2, r2 = r.getRight(), context);
        if (valuesEquals != ThreeState.UNSURE) {
            ThreeState threeState = valuesEquals;
            if (threeState == null) {
                GoBoolExpressionsInspection.$$$reportNull$$$0(12);
            }
            return threeState;
        }
        valuesEquals = GoBoolExpressionsInspection.areTwoIdenticalAndTwoWithEqualValues(l1, r2, l2, r1, context);
        if (valuesEquals != ThreeState.UNSURE) {
            ThreeState threeState = valuesEquals;
            if (threeState == null) {
                GoBoolExpressionsInspection.$$$reportNull$$$0(13);
            }
            return threeState;
        }
        valuesEquals = GoBoolExpressionsInspection.areTwoIdenticalAndTwoWithEqualValues(l2, r1, l1, r2, context);
        if (valuesEquals != ThreeState.UNSURE) {
            ThreeState threeState = valuesEquals;
            if (threeState == null) {
                GoBoolExpressionsInspection.$$$reportNull$$$0(14);
            }
            return threeState;
        }
        ThreeState threeState = valuesEquals = GoBoolExpressionsInspection.areTwoIdenticalAndTwoWithEqualValues(l2, r2, l1, r1, context);
        if (threeState == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(15);
        }
        return threeState;
    }

    private static ThreeState areTwoIdenticalAndTwoWithEqualValues(@Nullable GoExpression f1, @Nullable GoExpression f2, @Nullable GoExpression s1, @Nullable GoExpression s2, @Nullable PsiElement context) {
        Value value2;
        Value value1 = s1 != null ? s1.getValue() : null;
        Value value = value2 = s2 != null ? s2.getValue() : null;
        if (value1 == null || value2 == null || !GoExpressionUtil.identical(f1, f2, context)) {
            return ThreeState.UNSURE;
        }
        return ThreeState.fromBoolean((boolean)value1.equals(value2));
    }

    public static boolean isEqualsWithNot(@Nullable GoExpression not, @Nullable GoExpression expr, @Nullable PsiElement context) {
        return not instanceof GoUnaryExpr && ((GoUnaryExpr)not).getNot() != null && GoExpressionUtil.identical(((GoUnaryExpr)not).getExpression(), expr, context);
    }

    @NotNull
    public static List<GoExpression> collect(@NotNull GoBinaryExpr o, boolean and) {
        if (o == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(16);
        }
        List<GoExpression> list = o.getExpressionList().stream().map(e -> GoBoolExpressionsInspection.processExpr(e, and)).flatMap(Collection::stream).collect(Collectors.toList());
        if (list == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private static List<GoExpression> processExpr(@Nullable GoExpression e, boolean and) {
        if (e == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GoBoolExpressionsInspection.$$$reportNull$$$0(18);
            }
            return list;
        }
        if (GoBoolExpressionsInspection.isSameOp(e, and)) {
            return GoBoolExpressionsInspection.collect((GoBinaryExpr)e, and);
        }
        if (e instanceof GoParenthesesExpr) {
            return GoBoolExpressionsInspection.processExpr(((GoParenthesesExpr)e).getExpression(), and);
        }
        List<GoExpression> list = Collections.singletonList(e);
        if (list == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static boolean isSameOp(GoExpression expr, boolean and) {
        return and ? expr instanceof GoAndExpr : expr instanceof GoOrExpr;
    }

    private static boolean isNonStrictComparisonWithMaxOrMinValue(@NotNull GoConditionalExpr conditionalExpr, @NotNull PsiElement context) {
        if (conditionalExpr == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(20);
        }
        if (context == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(21);
        }
        if (conditionalExpr.getLessOrEqual() == null && conditionalExpr.getGreaterOrEqual() == null) {
            return false;
        }
        ComparisonInfo info = GoBoolExpressionsInspection.extractComparisonInfo(conditionalExpr, true, context);
        ComparisonInfo comparisonInfo = info = info == null ? GoBoolExpressionsInspection.extractComparisonInfo(conditionalExpr, false, context) : info;
        if (info == null) {
            return false;
        }
        Pair<Long, Long> limits = GoTypeUtil.getIntegerTypeLimits(info.comparedExprType, context);
        return limits != null && info.comparisonOp.test((Long)limits.first, info.bound) && info.comparisonOp.test((Long)limits.second, info.bound);
    }

    @Nullable
    private static ComparisonInfo extractComparisonInfo(@NotNull GoConditionalExpr conditionalExpr, boolean leftToRight, @NotNull PsiElement context) {
        Long boundValue;
        if (conditionalExpr == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(22);
        }
        if (context == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(23);
        }
        GoExpression boundExpr = leftToRight ? conditionalExpr.getRight() : conditionalExpr.getLeft();
        Value bound = boundExpr != null && boundExpr.isConstant() ? boundExpr.getValue() : null;
        Long l = boundValue = bound != null ? bound.getInteger() : null;
        if (boundValue == null) {
            return null;
        }
        BiPredicate<Long, Long> comparisonOp = null;
        if (conditionalExpr.getGreaterOrEqual() != null) {
            comparisonOp = leftToRight ? (x, y) -> x >= y : (x, y) -> x <= y;
        } else if (conditionalExpr.getLessOrEqual() != null) {
            BiPredicate<Long, Long> biPredicate = comparisonOp = leftToRight ? (x, y) -> x <= y : (x, y) -> x >= y;
        }
        if (comparisonOp == null) {
            return null;
        }
        GoExpression expr = leftToRight ? conditionalExpr.getLeft() : conditionalExpr.getRight();
        GoType underlyingType = expr != null ? expr.getGoUnderlyingType(GoPsiImplUtil.createContextOnElement(context)) : null;
        boolean isIntegerType = underlyingType != null && GoTypeUtil.isIntegerType(underlyingType, context);
        return isIntegerType ? new ComparisonInfo(underlyingType, comparisonOp, boundValue) : null;
    }

    private static boolean isComparisonOfFuncAndNil(@NotNull GoConditionalExpr conditionalExpr) {
        if (conditionalExpr == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(24);
        }
        if (conditionalExpr.getEq() == null && conditionalExpr.getNotEq() == null) {
            return false;
        }
        GoExpression notNilExpression = null;
        if (GoExpressionUtil.isNil(conditionalExpr.getLeft())) {
            notNilExpression = conditionalExpr.getRight();
        } else if (GoExpressionUtil.isNil(conditionalExpr.getRight())) {
            notNilExpression = conditionalExpr.getLeft();
        }
        return notNilExpression instanceof GoReferenceExpression && ((GoReferenceExpression)notNilExpression).resolve() instanceof GoFunctionOrMethodDeclaration;
    }

    private static LocalQuickFix[] fixesForKnownValue(@NotNull GoExpression expr, boolean value) {
        if (expr == null) {
            GoBoolExpressionsInspection.$$$reportNull$$$0(25);
        }
        SmartList fixes = new SmartList();
        if (GoPsiUtil.isForCondition(expr)) {
            fixes.add(value ? new GoAlwaysTrueForConditionQuickFix(expr) : new GoAlwaysFalseForConditionQuickFix(expr));
        } else {
            fixes.add(new GoSimplifyExpressionToBooleanLiteralQuickFix(expr, String.valueOf(value)));
            if (GoPsiUtil.isIfCondition(expr)) {
                fixes.add(value ? new GoAlwaysTrueIfQuickFix(expr) : new GoAlwaysFalseIfQuickFix(expr));
            }
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9, 12, 13, 14, 15, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoBoolExpressionsInspection";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExpr";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoBoolExpressionsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "areSameExpressions";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "areTwoIdenticalChildrenAndChildrenWithEqualValues";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "processExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProblemWithEqAndConsts";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areSameExpressions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areTwoIdenticalChildrenAndChildrenWithEqualValues";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isNonStrictComparisonWithMaxOrMinValue";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractComparisonInfo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isComparisonOfFuncAndNil";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fixesForKnownValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9, 12, 13, 14, 15, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    public static final class ExpressionGroup {
        @NotNull
        public final List<GoExpression> expressions;
        public final boolean hasSideEffects;

        private ExpressionGroup(@NotNull List<GoExpression> expressions, boolean hasSideEffects) {
            if (expressions == null) {
                ExpressionGroup.$$$reportNull$$$0(0);
            }
            this.expressions = expressions;
            this.hasSideEffects = hasSideEffects;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/goide/inspections/GoBoolExpressionsInspection$ExpressionGroup", "<init>"));
        }
    }

    private static final class ComparisonInfo {
        @NotNull
        public final GoType comparedExprType;
        @NotNull
        public final BiPredicate<Long, Long> comparisonOp;
        public final long bound;

        private ComparisonInfo(@NotNull GoType comparedExprType, @NotNull BiPredicate<Long, Long> comparisonOp, long bound) {
            if (comparedExprType == null) {
                ComparisonInfo.$$$reportNull$$$0(0);
            }
            if (comparisonOp == null) {
                ComparisonInfo.$$$reportNull$$$0(1);
            }
            this.comparedExprType = comparedExprType;
            this.comparisonOp = comparisonOp;
            this.bound = bound;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "comparedExprType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "comparisonOp";
                    break;
                }
            }
            objectArray[1] = "com/goide/inspections/GoBoolExpressionsInspection$ComparisonInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

