/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoSwitchMissingCasesForIotaConstsInspectionKt;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoFile;
import com.goide.psi.GoSwitchStatement;
import com.goide.refactor.template.GoTemplate;
import com.goide.refactor.template.GoTemplateExtentionsKt;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0002J\b\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/goide/inspections/GoAddMissingSwitchIotaEnumCasesQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "switchStatement", "Lcom/goide/psi/GoSwitchStatement;", "missingConstsCount", "", "<init>", "(Lcom/goide/psi/GoSwitchStatement;I)V", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "getFamilyName", "getText", "intellij.go.impl"})
final class GoAddMissingSwitchIotaEnumCasesQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String text;

    public GoAddMissingSwitchIotaEnumCasesQuickFix(@NotNull GoSwitchStatement switchStatement, int missingConstsCount) {
        Intrinsics.checkNotNullParameter((Object)switchStatement, (String)"switchStatement");
        super((PsiElement)switchStatement);
        Object[] objectArray = new Object[]{missingConstsCount};
        String string = GoBundle.message((String)"go.inspection.switch.missing.iota.const.cases.create.cases.fix", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.text = string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (!(file instanceof GoFile)) {
            return;
        }
        if (editor == null) {
            return;
        }
        GoExprSwitchStatement goExprSwitchStatement = startElement instanceof GoExprSwitchStatement ? (GoExprSwitchStatement)startElement : null;
        if (goExprSwitchStatement == null) {
            return;
        }
        GoExprSwitchStatement switchStatement = goExprSwitchStatement;
        GoFile goFile = (GoFile)file;
        List<GoExprCaseClause> list = switchStatement.getExprCaseClauseList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprCaseClauseList(...)");
        List missingConsts = GoSwitchMissingCasesForIotaConstsInspectionKt.access$findMissingConsts(goFile, list);
        if (missingConsts.isEmpty()) {
            return;
        }
        GoTemplate template = new GoTemplate((GoFile)file);
        template.addTextSegment("\n");
        GoTemplateExtentionsKt.setupConstCaseClauses(template, missingConsts);
        GoSwitchMissingCasesForIotaConstsInspectionKt.access$startMissingCasesTemplate(template, editor, this.getText(), switchStatement);
    }

    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.inspection.switch.missing.cases.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        return this.text;
    }
}

