/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoSwitchMissingCasesForIotaConstsInspectionKt;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoFile;
import com.goide.psi.GoSwitchStatement;
import com.goide.refactor.template.GoTemplate;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J3\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/goide/inspections/GoAddDefaultCaseQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "switchStatement", "Lcom/goide/psi/GoSwitchStatement;", "<init>", "(Lcom/goide/psi/GoSwitchStatement;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "getFamilyName", "", "getText", "intellij.go.impl"})
final class GoAddDefaultCaseQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public GoAddDefaultCaseQuickFix(@NotNull GoSwitchStatement switchStatement) {
        Intrinsics.checkNotNullParameter((Object)switchStatement, (String)"switchStatement");
        super((PsiElement)switchStatement);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (!(file instanceof GoFile)) {
            return;
        }
        if (editor == null) {
            return;
        }
        GoExprSwitchStatement goExprSwitchStatement = startElement instanceof GoExprSwitchStatement ? (GoExprSwitchStatement)startElement : null;
        if (goExprSwitchStatement == null) {
            return;
        }
        GoExprSwitchStatement switchStatement = goExprSwitchStatement;
        GoFile goFile = (GoFile)file;
        List<GoExprCaseClause> list = switchStatement.getExprCaseClauseList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprCaseClauseList(...)");
        if (GoSwitchMissingCasesForIotaConstsInspectionKt.access$findMissingConsts(goFile, list).isEmpty()) {
            return;
        }
        GoTemplate template = new GoTemplate((GoFile)file);
        template.addTextSegment("\ndefault:\n");
        template.addSelectionStartVariable();
        template.addTextSegment("panic(\"unhandled default case\")");
        template.addSelectionEndVariable();
        GoSwitchMissingCasesForIotaConstsInspectionKt.access$startMissingCasesTemplate(template, editor, this.getText(), switchStatement);
    }

    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.inspection.switch.missing.cases.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        String string = GoBundle.message((String)"go.inspection.switch.missing.iota.const.cases.insert.default.fix", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

