/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoVarProcessor;
import com.goide.quickfix.GoDeleteVarDefinitionQuickFix;
import com.goide.quickfix.GoRenameToBlankQuickFix;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class GoUnusedVariableInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoUnusedVariableInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoUnusedVariableInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitVarDefinition(@NotNull GoVarDefinition o) {
        if (o == null) {
            GoUnusedVariableInspection.$$$reportNull$$$0(1);
        }
        if (GoUnusedVariableInspection.shouldCheck(o, false) && GoUnusedVariableInspection.isUnused(o, this.myHolder.isOnTheFly())) {
            this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.unused.variable.message", GoInspectionProblemUtil.REF), GoUnusedVariableInspection.getUnusedVariableFixes(o));
        }
    }

    public static boolean shouldCheck(@NotNull GoVarDefinition o, boolean allowGlobal) {
        boolean isGlobal;
        if (o == null) {
            GoUnusedVariableInspection.$$$reportNull$$$0(2);
        }
        if (o.isBlank()) {
            return false;
        }
        GoCompositeElement varSpec = (GoCompositeElement)PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{GoVarSpec.class, GoTypeSwitchGuard.class});
        GoVarDeclaration declaration = (GoVarDeclaration)PsiTreeUtil.getParentOfType((PsiElement)o, GoVarDeclaration.class, (boolean)true, (Class[])new Class[]{GoFunctionLit.class});
        if (varSpec == null && declaration == null) {
            return false;
        }
        boolean bl = isGlobal = declaration != null && declaration.getParent() instanceof GoFile;
        if (allowGlobal != isGlobal) {
            return false;
        }
        return GoInspectionUtil.isPrimaryDefinition(o);
    }

    public static boolean isUnused(@NotNull GoVarDefinition o, boolean onTheFly) {
        if (o == null) {
            GoUnusedVariableInspection.$$$reportNull$$$0(3);
        }
        if (onTheFly && !GoInspectionUtil.isCheapEnoughToSearch(o)) {
            return false;
        }
        boolean foundReference = !GoReferencesSearch.search(o, o.getUseScope()).forEach(reference -> {
            PsiElement grandParent;
            ProgressManager.checkCanceled();
            PsiElement element = reference.getElement();
            PsiElement parent = element.getParent();
            if (parent instanceof GoLeftHandExprList && (grandParent = parent.getParent()) instanceof GoAssignmentStatement && ((GoAssignmentStatement)grandParent).getAssignOp().getAssign() != null) {
                GoSdk sdk = GoSdkService.getInstance(o.getProject()).getSdk(GoUtil.module(o));
                if (sdk.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_18)) {
                    return true;
                }
                GoFunctionLit fn = (GoFunctionLit)PsiTreeUtil.getParentOfType((PsiElement)element, GoFunctionLit.class);
                if (fn == null || !PsiTreeUtil.isAncestor((PsiElement)GoVarProcessor.getScope(o), (PsiElement)fn, (boolean)true)) {
                    return true;
                }
            }
            if (parent instanceof GoShortVarDeclaration) {
                int op = ((GoShortVarDeclaration)parent).getVarAssign().getStartOffsetInParent();
                return element.getStartOffsetInParent() < op;
            }
            if (parent instanceof GoRangeClause) {
                PsiElement assign = ((GoRangeClause)parent).getAssign();
                return assign != null && element.getStartOffsetInParent() < assign.getStartOffsetInParent();
            }
            return false;
        });
        return !foundReference;
    }

    public static LocalQuickFix @NotNull [] getUnusedVariableFixes(@NotNull GoVarDefinition o) {
        if (o == null) {
            GoUnusedVariableInspection.$$$reportNull$$$0(4);
        }
        LocalQuickFix[] localQuickFixArray = GoInspectionUtil.canDeleteDefinition(o) ? GoInspectionProblemUtil.fixes(new LocalQuickFix[]{new GoRenameToBlankQuickFix(o), new GoDeleteVarDefinitionQuickFix(o.getName())}) : GoInspectionProblemUtil.fixes(new LocalQuickFix[]{new GoRenameToBlankQuickFix(o)});
        if (localQuickFixArray == null) {
            GoUnusedVariableInspection.$$$reportNull$$$0(5);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoUnusedVariableInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoUnusedVariableInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedVariableFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitVarDefinition";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheck";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnused";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedVariableFixes";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

