/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.highlighting.legacyErrorInspections.GoInvalidExpressionConversionInspection;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.expectedTypes.GoCoreStringExpectedType;
import com.goide.psi.impl.expectedTypes.GoExpectedType;
import com.goide.psi.impl.expectedTypes.GoExpectedTypeImpl;
import com.goide.psi.impl.expectedTypes.GoStringLikeExpectedType;
import com.goide.psi.impl.generics.GoTypeSet;
import com.goide.psi.impl.typesCompatibility.GoAmbiguousMethods;
import com.goide.psi.impl.typesCompatibility.GoCannotUsePointerReceiverMethod;
import com.goide.psi.impl.typesCompatibility.GoDoesNotImplementInterface;
import com.goide.psi.impl.typesCompatibility.GoInterfaceWithNonExportedMethodInDifferentPackage;
import com.goide.psi.impl.typesCompatibility.GoMethodsMissing;
import com.goide.psi.impl.typesCompatibility.GoNonStrictComparabilityUnsupported;
import com.goide.psi.impl.typesCompatibility.GoNotComplexType;
import com.goide.psi.impl.typesCompatibility.GoNotInTypeSet;
import com.goide.psi.impl.typesCompatibility.GoNotRepresentable;
import com.goide.psi.impl.typesCompatibility.GoNotSendChannelType;
import com.goide.psi.impl.typesCompatibility.GoRangeExpressionWithoutCoreType;
import com.goide.psi.impl.typesCompatibility.GoSignatureDiffers;
import com.goide.psi.impl.typesCompatibility.GoTypeCheckResult;
import com.goide.psi.impl.typesCompatibility.GoTypeParametersNotSupported;
import com.goide.psi.presentation.GoPsiPresentationBuilder;
import com.goide.psi.presentation.GoPsiPresentationFunction;
import com.goide.quickfix.GoChangeParametersQuickFix;
import com.goide.quickfix.GoChangeResultParametersInAssignmentQuickFix;
import com.goide.quickfix.GoChangeResultParametersInCallQuickFix;
import com.goide.quickfix.GoChangeResultParametersInReturnQuickFix;
import com.goide.quickfix.GoChangeResultParametersInVarSpecQuickFix;
import com.goide.quickfix.GoChangeResultParametersQuickFix;
import com.goide.quickfix.GoChangeSignatureFromFunctionTypeQuickFix;
import com.goide.quickfix.GoConvertToExpectedTypeQuickFix;
import com.goide.quickfix.GoImplementMissingMethodsQuickfix;
import com.goide.quickfix.GoIntToStringConversionCallQuickFix;
import com.goide.quickfix.GoReplaceExpressionQuickFix;
import com.goide.quickfix.GoShowSdkConfigurableFix;
import com.goide.quickfix.GoUnpackSliceQuickFix;
import com.goide.sdk.GoSdkVersion;
import com.goide.vgo.mod.quickfix.VgoAddOrUpdateGoVersionFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTypeCheckingUtil {
    @NonNls
    @NotNull
    static String getPresentationText(@NotNull GoExpression expression) {
        if (expression == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(0);
        }
        return GoTypeCheckingUtil.getPresentationText(expression, false);
    }

    @NonNls
    @NotNull
    static String getPresentationText(@NotNull GoExpression expression, boolean typeNeedsFullPath) {
        if (expression == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(1);
        }
        GoType type = !GoExpressionUtil.isNil(expression) ? expression.getGoType(null) : null;
        String string = type == null ? GoInspectionProblemUtil.code(expression) : GoBundle.message((String)"go.inspection.problem.expression.with.type", (Object[])new Object[]{GoInspectionProblemUtil.code(expression), GoTypeCheckingUtil.getPresentationText(type, typeNeedsFullPath)});
        if (string == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    static String getPresentationText(@NotNull GoType type, boolean addFullPath) {
        if (type == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(3);
        }
        if (type instanceof GoLightType.LightUntypedType || !addFullPath) {
            String string = type.getPresentationText();
            if (string == null) {
                GoTypeCheckingUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = GoPsiPresentationBuilder.create().withoutResolve().withoutStructureAndInterfaceContent().withPresentationFunction(NamedTypeWithoutQualifierPresentationFunction.WITH_FULL_PATH).build(type);
        if (string == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    static GoInspectionMessage commonErrorDescription(@NotNull GoExpression expr, @NotNull GoType expectedType, @Nullable GoTypeCheckResult problem) {
        if (expr == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(6);
        }
        if (expectedType == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(7);
        }
        return GoTypeCheckingUtil.commonErrorDescription(expr, expr.getGoType(null), expectedType, problem);
    }

    @NotNull
    static GoInspectionMessage commonErrorDescription(@NotNull GoExpression expr, @Nullable GoType exprType, @NotNull GoType expectedType, @Nullable GoTypeCheckResult problem) {
        if (expr == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(8);
        }
        if (expectedType == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(9);
        }
        if (problem instanceof GoNotRepresentable) {
            GoExpression unwrapped = expr.unwrapParentheses();
            GoInspectionMessage goInspectionMessage = unwrapped instanceof GoLiteral || unwrapped instanceof GoStringLiteral || GoExpressionUtil.isBooleanLiteral(unwrapped) ? GoInspectionProblemUtil.message("go.cannot.be.represented.by.type", GoTypeCheckingUtil.getPresentationText(expr), GoTypeCheckingUtil.getPresentationText(expectedType, false)) : GoInspectionProblemUtil.message("go.value.cannot.be.represented.by.type", GoTypeCheckingUtil.getPresentationText(expr), GoTypeCheckingUtil.getPresentationText(expectedType, false));
            if (goInspectionMessage == null) {
                GoTypeCheckingUtil.$$$reportNull$$$0(10);
            }
            return goInspectionMessage;
        }
        boolean needFullPath = GoTypeCheckingUtil.haveSamePresentation(exprType, expectedType);
        GoInspectionMessage goInspectionMessage = GoInspectionProblemUtil.message("go.inspection.problem.incompatible.types", GoTypeCheckingUtil.getPresentationText(expr, needFullPath), GoTypeCheckingUtil.getPresentationText(expectedType, needFullPath));
        if (goInspectionMessage == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(11);
        }
        return goInspectionMessage;
    }

    @NotNull
    static GoInspectionMessage commonErrorDescription(@NotNull GoType actualType, @NotNull GoType expectedType) {
        if (actualType == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(12);
        }
        if (expectedType == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(13);
        }
        boolean needFullPath = GoTypeCheckingUtil.haveSamePresentation(actualType, expectedType);
        GoInspectionMessage goInspectionMessage = GoInspectionProblemUtil.message("go.inspection.problem.incompatible.types", GoTypeCheckingUtil.getPresentationText(actualType, needFullPath), GoTypeCheckingUtil.getPresentationText(expectedType, needFullPath));
        if (goInspectionMessage == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(14);
        }
        return goInspectionMessage;
    }

    static boolean haveSamePresentation(@Nullable GoType actual, @Nullable GoType expected) {
        if (actual == null || expected == null) {
            return false;
        }
        String actualType = GoPsiPresentationBuilder.create().withoutResolve().withoutStructureAndInterfaceContent().withPresentationFunction(NamedTypeWithoutQualifierPresentationFunction.WITHOUT_FULL_PATH).build(actual);
        String expectedType = GoPsiPresentationBuilder.create().withoutResolve().withoutStructureAndInterfaceContent().withPresentationFunction(NamedTypeWithoutQualifierPresentationFunction.WITHOUT_FULL_PATH).build(expected);
        return actualType.equals(expectedType);
    }

    public static void registerProblem(@NotNull GoProblemsHolder holder, @NotNull GoExpression expression, @NotNull GoInspectionMessage message, @NotNull GoType expectedType, @NotNull GoTypeCheckResult problem) {
        if (holder == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(15);
        }
        if (expression == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(16);
        }
        if (message == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(17);
        }
        if (expectedType == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(18);
        }
        if (problem == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(19);
        }
        GoTypeCheckingUtil.registerProblem(holder, expression, expression, message, expectedType, problem);
    }

    public static void registerProblem(@NotNull GoProblemsHolder holder, @NotNull PsiElement targetElement, @Nullable GoExpression expression, @NotNull GoInspectionMessage message, @NotNull GoType expectedType, @NotNull GoTypeCheckResult problem) {
        if (holder == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(20);
        }
        if (targetElement == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(21);
        }
        if (message == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(22);
        }
        if (expectedType == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(23);
        }
        if (problem == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(24);
        }
        if (problem.getExpectedType() == null) {
            problem.setExpectedType(new GoExpectedTypeImpl(expectedType));
        }
        List<GoTypeCheckResult> problems = Collections.singletonList(problem);
        GoInspectionMessage fullMessage = GoTypeCheckingUtil.getMessageWithAdditionalInfo(message, problems);
        List<LocalQuickFix> fixes = expression != null ? GoTypeCheckingUtil.additionalFixes(expression, problems, true, GoReferenceBase.getSubstitutionContextOrSelf(expression)) : GoTypeCheckingUtil.additionalFixes(targetElement, problems, GoReferenceBase.getSubstitutionContextOrSelf(targetElement));
        holder.registerProblem(targetElement, fullMessage, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    @NotNull
    static GoInspectionMessage getMessageWithAdditionalInfo(@NotNull GoInspectionMessage message, @NotNull List<? extends GoTypeCheckResult> problems) {
        GoInspectionMessage additionalInfo;
        if (message == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(25);
        }
        if (problems == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(26);
        }
        GoInspectionMessage goInspectionMessage = (additionalInfo = GoTypeCheckingUtil.additionalInfo(problems)) != null ? new MessageWithAdditionalInfo(message, additionalInfo) : message;
        if (goInspectionMessage == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(27);
        }
        return goInspectionMessage;
    }

    @Nullable
    private static GoInspectionMessage additionalInfo(@NotNull List<? extends GoTypeCheckResult> problems) {
        if (problems == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(28);
        }
        if (problems.size() > 1) {
            return null;
        }
        GoTypeCheckResult firstProblem = (GoTypeCheckResult)ContainerUtil.getFirstItem(problems);
        if (firstProblem instanceof GoTypeParametersNotSupported) {
            return GoInspectionProblemUtil.message("go.inspection.problem.type.parameters.are.not.supported");
        }
        if (firstProblem instanceof GoNotSendChannelType) {
            return GoInspectionProblemUtil.message("go.inspection.problem.invalid.argument.must.be.send.channel.type");
        }
        if (firstProblem instanceof GoNotComplexType) {
            return GoInspectionProblemUtil.message("go.inspection.problem.invalid.argument.must.be.complex.type");
        }
        if (firstProblem instanceof GoNonStrictComparabilityUnsupported) {
            return GoInspectionProblemUtil.message("go.inspection.problem.non.strict.comparability.not.supported");
        }
        if (firstProblem instanceof GoRangeExpressionWithoutCoreType) {
            return GoInspectionProblemUtil.message("go.inspection.problem.no.core.type.in.range.expression");
        }
        GoDoesNotImplementInterface problem = (GoDoesNotImplementInterface)ObjectUtils.tryCast((Object)firstProblem, GoDoesNotImplementInterface.class);
        if (problem == null) {
            return null;
        }
        GoType interfaceType = problem.getInterfaceType();
        if (interfaceType == null) {
            return null;
        }
        GoMethodsMissing methodsMissing = (GoMethodsMissing)ObjectUtils.tryCast((Object)problem, GoMethodsMissing.class);
        if (methodsMissing != null) {
            List<GoMethodSpec> methods = methodsMissing.getMethods();
            String methodsText = GoTypeCheckingUtil.joinShortened(methods, GoTypeCheckingUtil::getPresentationText, "<br/>", 3);
            return GoInspectionProblemUtil.message("go.inspection.problem.incompatible.types.some.methods.are.missing", GoTypeCheckingUtil.getPresentation(interfaceType), GoTypeCheckingUtil.getBoldColor(), GoInspectionUtil.xmlCode(methodsText));
        }
        GoAmbiguousMethods ambiguousMethods = (GoAmbiguousMethods)ObjectUtils.tryCast((Object)problem, GoAmbiguousMethods.class);
        if (ambiguousMethods != null) {
            String methods = ((StreamEx)StreamEx.of(ambiguousMethods.getMethods()).map(GoTypeCheckingUtil::getPresentationText).sorted()).map(name -> GoInspectionProblemUtil.code(GoInspectionUtil.xmlCode(name))).joining((CharSequence)", ");
            return GoInspectionProblemUtil.message("go.inspection.problem.incompatible.types.ambiguous.methods", GoTypeCheckingUtil.getPresentation(interfaceType), GoTypeCheckingUtil.getBoldColor(), methods);
        }
        GoCannotUsePointerReceiverMethod cannotUsePointerMethod = (GoCannotUsePointerReceiverMethod)ObjectUtils.tryCast((Object)problem, GoCannotUsePointerReceiverMethod.class);
        if (cannotUsePointerMethod != null) {
            GoMethodDeclaration pointerMethod = cannotUsePointerMethod.getMethod();
            String methodName = (String)ObjectUtils.notNull((Object)pointerMethod.getName(), (Object)"?");
            return GoInspectionProblemUtil.message("go.inspection.problem.incompatible.method.has.pointer.receiver", GoTypeCheckingUtil.getPresentation(interfaceType), GoTypeCheckingUtil.getBoldColor(), GoInspectionProblemUtil.code(GoInspectionUtil.xmlCode(methodName)));
        }
        GoSignatureDiffers signatureDiffers = (GoSignatureDiffers)ObjectUtils.tryCast((Object)problem, GoSignatureDiffers.class);
        if (signatureDiffers != null) {
            return GoInspectionProblemUtil.message("go.inspection.problem.incompatible.need.method.have.method", GoTypeCheckingUtil.getPresentation(interfaceType), GoTypeCheckingUtil.getBoldColor(), GoInspectionUtil.xmlCode(GoTypeCheckingUtil.getPresentationText(signatureDiffers.getInterfaceMethod())), GoInspectionUtil.xmlCode(GoTypeCheckingUtil.getPresentationText(signatureDiffers.getImplementedMethod())));
        }
        if (problem instanceof GoInterfaceWithNonExportedMethodInDifferentPackage) {
            return GoInspectionProblemUtil.message("go.inspection.problem.incompatible.unexported.method", GoTypeCheckingUtil.getPresentation(interfaceType), GoTypeCheckingUtil.getBoldColor());
        }
        GoNotInTypeSet notInTypeSet = (GoNotInTypeSet)ObjectUtils.tryCast((Object)problem, GoNotInTypeSet.class);
        if (notInTypeSet != null) {
            GoTypeSet typeSet = notInTypeSet.getTypeSet();
            if (typeSet instanceof GoTypeSet.Empty) {
                return GoInspectionProblemUtil.message("go.inspection.problem.incompatible.empty.type.set", GoTypeCheckingUtil.getPresentation(interfaceType), GoTypeCheckingUtil.getBoldColor());
            }
            if (typeSet instanceof GoTypeSet.Comparable) {
                return GoInspectionProblemUtil.message("go.inspection.problem.incompatible.not.comparable", GoTypeCheckingUtil.getPresentation(interfaceType), GoTypeCheckingUtil.getBoldColor());
            }
            if (typeSet instanceof GoTypeSet.Terms) {
                return GoInspectionProblemUtil.message("go.inspection.problem.incompatible.not.in.type.set", GoTypeCheckingUtil.getPresentation(interfaceType), GoTypeCheckingUtil.getBoldColor(), GoTypeCheckingUtil.joinShortened(((GoTypeSet.Terms)typeSet).getTerms(), term -> GoInspectionProblemUtil.code(GoInspectionUtil.xmlCode(term.toString())), ", ", 5));
            }
        }
        return null;
    }

    @NotNull
    private static String getPresentation(GoType interfaceType) {
        String string = GoInspectionProblemUtil.code(GoInspectionUtil.xmlCode(GoTypeCheckingUtil.getPresentationText(interfaceType)));
        if (string == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    private static String getPresentationText(@NotNull GoType type) {
        if (type == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(30);
        }
        String string = GoPsiPresentationBuilder.create().withoutResolve().withoutStructureAndInterfaceContent().html().build(type);
        if (string == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    private static String getPresentationText(@NotNull GoNamedSignatureOwner signatureOwner) {
        if (signatureOwner == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(32);
        }
        String string = GoPsiPresentationBuilder.create().withoutResolve().withoutStructureAndInterfaceContent().html().build(signatureOwner, false);
        if (string == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static String getBoldColor() {
        String string = UIUtil.isUnderDarcula() ? "ffC800" : GuiUtils.colorToHex((Color)JBColor.foreground());
        if (string == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public static <T> String joinShortened(@NotNull List<T> list, @NotNull Function<? super T, String> f, @NotNull String separator, int limit) {
        if (list == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(35);
        }
        if (f == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(36);
        }
        if (separator == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(37);
        }
        List<T> subList = list.size() > limit ? list.subList(0, limit) : list;
        String joined = StringUtil.join(subList, f::apply, (String)separator);
        Object object = list.size() != subList.size() ? joined + separator + "\u2026" : joined;
        if (object == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(38);
        }
        return object;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    static @NotNull List<@NotNull LocalQuickFix> additionalFixes(@NotNull GoExpression expression, @NotNull List<? extends GoTypeCheckResult> problems, boolean suggestConversion, @NotNull PsiElement context) {
        GoTypeCheckResult problem;
        GoVarSpec varSpec;
        GoAssignmentStatement assignment;
        GoReturnStatement returnStatement;
        if (expression == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(39);
        }
        if (problems == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(40);
        }
        if (context == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(41);
        }
        @NotNull SmartList fixes = new SmartList();
        GoTypeCheckingUtil.addDoesNotImplementInterfaceFixes(expression, problems, (List<? super LocalQuickFix>)fixes, context);
        if (suggestConversion) {
            GoTypeCheckingUtil.addConversionFixes(expression, problems, (List<? super LocalQuickFix>)fixes, context);
        }
        GoTypeCheckingUtil.addNonStrictComparabilityUnsupportedFix(problems, (List<? super LocalQuickFix>)fixes);
        GoCallExpr call = (GoCallExpr)PsiTreeUtil.getParentOfType((PsiElement)expression, GoCallExpr.class);
        if (call != null) {
            new GoChangeParametersQuickFix(call).addIfAvailable((List)fixes);
            new GoChangeResultParametersInCallQuickFix(call).addIfAvailable((List)fixes);
            new GoUnpackSliceQuickFix(call).addIfAvailable((List<? super LocalQuickFix>)fixes);
        }
        if ((returnStatement = (GoReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, GoReturnStatement.class)) != null) {
            new GoChangeResultParametersQuickFix(returnStatement).addIfAvailable((List)fixes);
            new GoChangeResultParametersInReturnQuickFix(returnStatement).addIfAvailable((List)fixes);
        }
        if ((assignment = (GoAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, GoAssignmentStatement.class)) != null) {
            new GoChangeResultParametersInAssignmentQuickFix(assignment).addIfAvailable((List)fixes);
        }
        if ((varSpec = (GoVarSpec)PsiTreeUtil.getParentOfType((PsiElement)expression, GoVarSpec.class)) != null) {
            new GoChangeResultParametersInVarSpecQuickFix(varSpec).addIfAvailable((List)fixes);
        }
        if ((problem = (GoTypeCheckResult)ContainerUtil.getOnlyItem(problems)) != null) {
            GoExpectedType expectedType = problem.getExpectedType();
            GoType type = expectedType != null ? expectedType.getType() : null;
            PsiElement resolve = (PsiElement)ObjectUtils.doIfNotNull((Object)type, t -> t.resolve(context));
            GoSpecType specType = (GoSpecType)ObjectUtils.doIfCast((Object)resolve, GoTypeSpec.class, GoTypeSpec::getSpecType);
            GoSignature signature = (GoSignature)ObjectUtils.doIfCast((Object)(type = (GoType)ObjectUtils.doIfNotNull((Object)specType, GoSpecType::getType)), GoFunctionType.class, GoFunctionType::getSignature);
            if (signature != null) {
                new GoChangeSignatureFromFunctionTypeQuickFix((PsiElement)expression, signature).addIfAvailable((List)fixes);
            }
        }
        SmartList smartList = fixes;
        if (smartList == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(42);
        }
        return smartList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    static @NotNull List<@NotNull LocalQuickFix> additionalFixes(@NotNull PsiElement targetElement, @NotNull List<? extends GoTypeCheckResult> problems, @NotNull PsiElement context) {
        if (targetElement == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(43);
        }
        if (problems == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(44);
        }
        if (context == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(45);
        }
        @NotNull SmartList fixes = new SmartList();
        GoTypeCheckingUtil.addDoesNotImplementInterfaceFixes(targetElement, problems, (List<? super LocalQuickFix>)fixes, context);
        GoTypeCheckingUtil.addNonStrictComparabilityUnsupportedFix(problems, (List<? super LocalQuickFix>)fixes);
        SmartList smartList = fixes;
        if (smartList == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(46);
        }
        return smartList;
    }

    private static void addDoesNotImplementInterfaceFixes(@NotNull PsiElement targetElement, @NotNull List<? extends GoTypeCheckResult> problems, @NotNull @NotNull List<? super @NotNull LocalQuickFix> result, @NotNull PsiElement context) {
        GoExpression expression;
        if (targetElement == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(47);
        }
        if (problems == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(48);
        }
        if (result == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(49);
        }
        if (context == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(50);
        }
        if (problems.size() > 1) {
            return;
        }
        GoDoesNotImplementInterface problem = (GoDoesNotImplementInterface)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem(problems), GoDoesNotImplementInterface.class);
        if (problem == null) {
            return;
        }
        if (problem instanceof GoMethodsMissing) {
            GoType interfaceType = problem.getInterfaceType();
            GoType type = problem.getType();
            if (interfaceType == null || type == null) {
                return;
            }
            GoTypeSpec targetType = GoTypeUtil.findTypeSpec(type, context, true);
            if (GoPsiUtil.isTopLevelDeclaration(targetType)) {
                result.add((LocalQuickFix)new GoImplementMissingMethodsQuickfix(interfaceType, targetType));
            }
        } else if (problem instanceof GoCannotUsePointerReceiverMethod && targetElement instanceof GoExpression && GoExpressionUtil.canTakeAddressOf(expression = (GoExpression)targetElement, context)) {
            result.add(GoReplaceExpressionQuickFix.prependAmpersandQuickFix(expression));
        }
    }

    private static void addConversionFixes(@NotNull GoExpression expression, @NotNull List<? extends GoTypeCheckResult> problems, @NotNull @NotNull List<? super @NotNull LocalQuickFix> result, @NotNull PsiElement context) {
        if (expression == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(51);
        }
        if (problems == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(52);
        }
        if (result == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(53);
        }
        if (context == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(54);
        }
        GoType expressionType = expression.getGoType(null);
        for (GoTypeCheckResult goTypeCheckResult : problems) {
            GoType stringType;
            GoType type;
            GoExpectedType expectedType = goTypeCheckResult.getExpectedType();
            if (expressionType == null || expectedType == null || expectedType.isVariadic() || goTypeCheckResult instanceof GoDoesNotImplementInterface || (type = expectedType.getType()) != null && GoInvalidExpressionConversionInspection.getInvalidConversionTypeError(type, context) != null) continue;
            if (type != null && GoInvalidExpressionConversionInspection.isValidConversion(expression, expressionType, type, true, context) == ThreeState.YES) {
                if (GoTypeCheckingUtil.isIntegerToStringConversion(type, expressionType)) {
                    result.add(new GoIntToStringConversionCallQuickFix((GoFile)expression.getContainingFile(), type, "", expressionType, expressionType, expression.getText()));
                } else {
                    result.add(new GoConvertToExpectedTypeQuickFix(type, expressionType));
                }
            }
            if (!(expectedType instanceof GoStringLikeExpectedType) && !(expectedType instanceof GoCoreStringExpectedType) || (stringType = GoPsiImplUtil.getBuiltinType("string", context)) == null || GoInvalidExpressionConversionInspection.isValidConversion(expression, expressionType, stringType, true, context) != ThreeState.YES) continue;
            result.add(new GoConvertToExpectedTypeQuickFix(stringType, expressionType));
        }
    }

    private static void addNonStrictComparabilityUnsupportedFix(@NotNull List<? extends GoTypeCheckResult> problems, @NotNull @NotNull List<? super @NotNull LocalQuickFix> result) {
        if (problems == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(55);
        }
        if (result == null) {
            GoTypeCheckingUtil.$$$reportNull$$$0(56);
        }
        for (GoTypeCheckResult goTypeCheckResult : problems) {
            if (!(goTypeCheckResult instanceof GoNonStrictComparabilityUnsupported)) continue;
            GoNonStrictComparabilityUnsupported unsupported = (GoNonStrictComparabilityUnsupported)goTypeCheckResult;
            result.add((LocalQuickFix)(unsupported.getNeedVersionUpdate() ? new VgoAddOrUpdateGoVersionFix(GoSdkVersion.GO_1_20) : new GoShowSdkConfigurableFix()));
            break;
        }
    }

    private static boolean isIntegerToStringConversion(@Nullable GoType type, @Nullable GoType expressionType) {
        return GoTypeUtil.isString(type, null) && GoTypeUtil.isIntegerType(expressionType, null) && !GoTypeUtil.isRuneType(expressionType, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 10, 11, 14, 27, 29, 31, 33, 34, 38, 42, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 38: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoTypeCheckingUtil";
                break;
            }
            case 3: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 21: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 26: 
            case 28: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureOwner";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 41: 
            case 45: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 49: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoTypeCheckingUtil";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "commonErrorDescription";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageWithAdditionalInfo";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoldColor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "joinShortened";
                break;
            }
            case 42: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "additionalFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationText";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 38: 
            case 42: 
            case 46: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "commonErrorDescription";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMessageWithAdditionalInfo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "additionalInfo";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "joinShortened";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "additionalFixes";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addDoesNotImplementInterfaceFixes";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addConversionFixes";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addNonStrictComparabilityUnsupportedFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 10, 11, 14, 27, 29, 31, 33, 34, 38, 42, 46 -> new IllegalStateException(string);
        };
    }

    private static final class NamedTypeWithoutQualifierPresentationFunction
    implements GoPsiPresentationFunction {
        public static final NamedTypeWithoutQualifierPresentationFunction WITHOUT_FULL_PATH = new NamedTypeWithoutQualifierPresentationFunction(false);
        public static final NamedTypeWithoutQualifierPresentationFunction WITH_FULL_PATH = new NamedTypeWithoutQualifierPresentationFunction(true);
        private final boolean myWithFullPath;

        private NamedTypeWithoutQualifierPresentationFunction(boolean withFullPath) {
            this.myWithFullPath = withFullPath;
        }

        @Override
        @NotNull
        public String apply(PsiElement e) {
            String name;
            if (!(e instanceof GoType)) {
                String string = e.getText();
                if (string == null) {
                    NamedTypeWithoutQualifierPresentationFunction.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (!GoTypeUtil.isNamedType((GoType)e)) {
                String string = ((GoType)e).getPresentationText();
                if (string == null) {
                    NamedTypeWithoutQualifierPresentationFunction.$$$reportNull$$$0(1);
                }
                return string;
            }
            String text = ((GoType)e).getPresentationText();
            String string = name = text.contains(".") ? StringUtil.substringAfterLast((String)text, (String)".") : text;
            if (name == null) {
                String string2 = text;
                if (string2 == null) {
                    NamedTypeWithoutQualifierPresentationFunction.$$$reportNull$$$0(2);
                }
                return string2;
            }
            if (!this.myWithFullPath) {
                String string3 = name;
                if (string3 == null) {
                    NamedTypeWithoutQualifierPresentationFunction.$$$reportNull$$$0(3);
                }
                return string3;
            }
            String path = NamedTypeWithoutQualifierPresentationFunction.calcPath((GoType)e);
            Object object = StringUtil.isNotEmpty((String)path) ? "\"" + path + "\"." + name : name;
            if (object == null) {
                NamedTypeWithoutQualifierPresentationFunction.$$$reportNull$$$0(4);
            }
            return object;
        }

        @Nullable
        private static String calcPath(@Nullable GoType type) {
            PsiFile file;
            if (type == null) {
                return null;
            }
            GoTypeReferenceExpression reference = GoPsiImplUtil.findTypeReference(type);
            GoType resolve = type instanceof GoSpecType ? type : (reference != null ? reference.resolve() : null);
            PsiFile psiFile = file = resolve == null ? null : resolve.getContainingFile();
            return GoPsiImplUtil.builtin((PsiElement)file) ? null : (file instanceof GoFile ? ((GoFile)file).getImportPath(false) : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/highlighting/legacyErrorInspections/GoTypeCheckingUtil$NamedTypeWithoutQualifierPresentationFunction", "apply"));
        }
    }

    private static class MessageWithAdditionalInfo
    implements GoInspectionMessage {
        private final GoInspectionMessage myMessage;
        private final GoInspectionMessage myAdditionalInfo;

        MessageWithAdditionalInfo(@NotNull GoInspectionMessage message, @NotNull GoInspectionMessage additionalInfo) {
            if (message == null) {
                MessageWithAdditionalInfo.$$$reportNull$$$0(0);
            }
            if (additionalInfo == null) {
                MessageWithAdditionalInfo.$$$reportNull$$$0(1);
            }
            this.myMessage = message;
            this.myAdditionalInfo = additionalInfo;
        }

        @Override
        public String toString() {
            HtmlBuilder builder = new HtmlBuilder();
            builder.appendRaw(GoInspectionUtil.escapeAllExceptCodeTags(this.myMessage.toString()));
            builder.br();
            builder.appendRaw(this.myAdditionalInfo.toString());
            return builder.wrapWith("html").toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "additionalInfo";
                    break;
                }
            }
            objectArray[1] = "com/goide/highlighting/legacyErrorInspections/GoTypeCheckingUtil$MessageWithAdditionalInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

