/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.execution.testing.GoTestFinder;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.project.GoModuleSettings;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.imports.GoImportPathReference;
import com.goide.psi.impl.imports.GoImportResolver;
import com.goide.quickfix.GoDeleteImportQuickFix;
import com.goide.quickfix.GoEnableGoExperimentQuickFix;
import com.goide.quickfix.GoRenameDirectoryQuickFix;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.goide.vgo.mod.psi.impl.VgoImportModuleNameReference;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoInvalidPackageImportInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoInvalidPackageImportInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitGoFile(@NotNull GoFile file) {
        if (file == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(1);
        }
        Module module = GoUtil.module((PsiElement)file);
        boolean supportsVendoring = GoVendoringUtil.isVendoringEnabled(module);
        GoSdk sdk = GoSdkService.getInstance(file.getProject()).getSdk(module);
        VirtualFile sdkHome = GoSdkUtil.getSdkSources(file.getProject(), module);
        boolean supportsInternalPackages = sdk.supportsInternalPackages();
        boolean supportsInternalPackagesInSdk = sdkHome != null && sdk.supportsSdkInternalPackages();
        boolean supportsCanonicalPaths = GoInvalidPackageImportInspection.supportsCanonicalPaths(file.getProject(), module);
        boolean supportsAtSignInImportPath = sdk.supportsAtSignInImportPath();
        block0: for (GoImportSpec importSpec : file.getImports()) {
            boolean validateInternal;
            if (!GoInvalidPackageImportInspection.validateCImport(importSpec, this.myHolder) || !GoInvalidPackageImportInspection.validateMainImport(importSpec, this.myHolder)) continue;
            Collection<GoPackage> packages = importSpec.resolve(ResolveState.initial());
            if (packages.isEmpty()) {
                GoInvalidPackageImportInspection.reportUnresolvedImport(importSpec, this.myHolder);
                continue;
            }
            if (!GoInvalidPackageImportInspection.validateImportedDirectory(file, this.myHolder, module, importSpec, packages) || !GoInvalidPackageImportInspection.validateCanonicalPath(supportsCanonicalPaths, supportsVendoring, importSpec, packages, module, this.myHolder)) continue;
            VirtualFile contextFile = file.getVirtualFile();
            Set resolvedDirectories = packages.stream().flatMap(p -> p.getDirectories().stream()).collect(Collectors.toSet());
            boolean resolvedToSdk = sdkHome != null && ContainerUtil.exists(resolvedDirectories, dir -> VfsUtilCore.isAncestor((VirtualFile)sdkHome, (VirtualFile)dir, (boolean)false));
            boolean bl = validateInternal = supportsInternalPackages || supportsInternalPackagesInSdk && resolvedToSdk;
            if (!supportsVendoring && !validateInternal && !resolvedToSdk) continue;
            LinkedHashSet<VirtualFile> sourceRoots = GoSdkUtil.getSourcesPathsToLookup(file.getProject(), module);
            block1: for (PsiReference reference : importSpec.getReferences()) {
                if (!(reference instanceof GoImportPathReference)) continue;
                String canonicalText = reference.getCanonicalText();
                if (validateInternal && "internal".equals(canonicalText)) {
                    boolean isUnreachable;
                    boolean bl2 = isUnreachable = reference instanceof VgoImportModuleNameReference ? GoSdkUtil.isUnreachableInternalGoModulePackage(file, importSpec) : ContainerUtil.exists(resolvedDirectories, dir -> GoSdkUtil.isUnreachableInternalPackage(dir, contextFile, sourceRoots));
                    if (!isUnreachable) continue;
                    this.myHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.use.of.internal.package.is.not.allowed"), new GoDeleteImportQuickFix());
                    continue block0;
                }
                if (supportsVendoring && "vendor".equals(canonicalText)) {
                    if (ContainerUtil.exists(resolvedDirectories, dir -> GoSdkUtil.isUnreachableVendoredPackage(dir, contextFile, sourceRoots))) {
                        this.myHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.use.of.vendored.package.is.not.allowed"), new GoDeleteImportQuickFix());
                        continue block0;
                    }
                    for (GoPackage aPackage : packages) {
                        String vendoredImportPath = aPackage.getImportPath(true);
                        if (vendoredImportPath == null) continue;
                        this.myHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.must.be.imported.as", GoInspectionProblemUtil.code(vendoredImportPath)), new GoReplaceImportPath(vendoredImportPath), new GoDeleteImportQuickFix());
                        continue block1;
                    }
                    continue;
                }
                if (supportsAtSignInImportPath || !StringUtil.containsChar((String)canonicalText, (char)'@')) continue;
                PsiFileSystemItem resolve = (PsiFileSystemItem)ObjectUtils.tryCast((Object)reference.resolve(), PsiFileSystemItem.class);
                LocalQuickFix[] fix = resolve != null && resolve.isValid() ? GoInspectionProblemUtil.fixes(new LocalQuickFix[]{new GoRenameDirectoryQuickFix(resolve)}) : null;
                this.myHolder.registerProblem((PsiElement)importSpec, reference.getRangeInElement(), GoInspectionProblemUtil.message("go.inspection.problem.at.is.not.allowed.in.import.paths"), fix);
                continue block0;
            }
        }
    }

    private static boolean supportsCanonicalPaths(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(2);
        }
        for (GoImportResolver resolver : GoImportResolver.EP_NAME.getExtensionList()) {
            ThreeState supports = resolver.supportsCanonicalImportPath(project, module);
            if (supports == ThreeState.UNSURE) continue;
            return supports.toBoolean();
        }
        return false;
    }

    private static void reportUnresolvedImport(@NotNull GoImportSpec importSpec, @NotNull GoProblemsHolder problemsHolder) {
        if (importSpec == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(3);
        }
        if (problemsHolder == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(4);
        }
        for (PsiReference reference : importSpec.getReferences()) {
            if (!(reference instanceof GoImportPathReference) || !((GoImportPathReference)reference).isAbsolutePathReference()) continue;
            problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.cannot.import.absolute.path"), new GoDeleteImportQuickFix());
            break;
        }
    }

    private static boolean validateImportedDirectory(@NotNull GoFile file, @NotNull GoProblemsHolder problemsHolder, @Nullable Module module, @NotNull GoImportSpec importSpec, @NotNull Collection<GoPackage> packages) {
        String originalPath;
        String cleanImport;
        if (file == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(5);
        }
        if (problemsHolder == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(6);
        }
        if (importSpec == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(7);
        }
        if (packages == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(8);
        }
        if (ContainerUtil.exists(packages, GoPackage::isBuiltin)) {
            problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.cannot.import.builtin.package"), new GoDeleteImportQuickFix());
        }
        if (!(cleanImport = GoInvalidPackageImportInspection.cleanImport(originalPath = importSpec.getPath())).equals(originalPath)) {
            problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.non.canonical.import.path", originalPath, cleanImport), new GoReplaceImportPath(cleanImport), new GoDeleteImportQuickFix());
        }
        String paths = StreamEx.of(packages).flatCollection(GoPackage::getDirectories).map(VirtualFile::getPath).joining((CharSequence)";");
        if (StreamEx.of(packages).flatMap(GoPackage::getPsiDirectories).flatCollection(d -> GoPackageUtil.getAllPackagesInDirectory(d, module, true)).findAny().isEmpty()) {
            if (GoInvalidPackageImportInspection.isSdkIterPackage(module, cleanImport, packages)) {
                problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.non.enabled.rangefunc.exclude.iter.package.files"), new GoEnableGoExperimentQuickFix("GOEXPERIMENT"));
            } else {
                problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.build.constraints.exclude.all.go.files", GoInspectionProblemUtil.code(paths)), new GoShowBuildSettingsQuickFix(), new GoDeleteImportQuickFix());
            }
            return false;
        }
        Set packageNames = ContainerUtil.map2Set(packages, GoPackage::getName);
        if (!GoTestFinder.isTestFile((PsiFile)file) && packageNames.size() == 1 && packageNames.contains("main")) {
            problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.path.is.a.program.not.an.importable.package", GoInspectionProblemUtil.code(originalPath)), new GoDeleteImportQuickFix());
            return false;
        }
        if (packageNames.size() > 1) {
            GoInspectionMessage message = GoInspectionProblemUtil.message("go.inspection.problem.found.several.packages", StringUtil.join((Collection)packageNames, (String)", "), GoInspectionProblemUtil.code(paths));
            problemsHolder.registerProblem((PsiElement)importSpec, message, new GoDeleteImportQuickFix());
            return false;
        }
        for (GoPackage resolvedPackage : packages) {
            if (resolvedPackage.processBuildableFiles((PsiFile)file, module, (Processor<? super PsiFile>)((Processor)GoTestFinder::isTestFile))) continue;
            return true;
        }
        problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.no.non.test.go.files", GoInspectionProblemUtil.code(paths)), new GoDeleteImportQuickFix());
        return false;
    }

    private static boolean isSdkIterPackage(@Nullable Module module, @NotNull String cleanImportPath, @NotNull Collection<GoPackage> packages) {
        if (cleanImportPath == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(9);
        }
        if (packages == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(10);
        }
        if (module == null || !cleanImportPath.equals("iter")) {
            return false;
        }
        for (GoPackage pkg : packages) {
            for (VirtualFile directory : pkg.getDirectories()) {
                if (!GoSdkUtil.isInSdk(pkg.getProject(), module, directory)) continue;
                return true;
            }
        }
        return false;
    }

    private static String cleanImport(@NotNull String originalPath) {
        if (originalPath == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(11);
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)originalPath);
        return originalPath.startsWith("./") && !"..".equals(canonicalPath) && !canonicalPath.startsWith("../") ? "./" + canonicalPath : canonicalPath;
    }

    private static boolean validateMainImport(@NotNull GoImportSpec importSpec, @NotNull GoProblemsHolder problemsHolder) {
        if (importSpec == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(12);
        }
        if (problemsHolder == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(13);
        }
        if ("main".equals(importSpec.getPath())) {
            problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.cannot.import", GoInspectionProblemUtil.code("main")), new GoDeleteImportQuickFix());
            return false;
        }
        return true;
    }

    private static boolean validateCImport(@NotNull GoImportSpec importSpec, @NotNull GoProblemsHolder problemsHolder) {
        if (importSpec == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(14);
        }
        if (problemsHolder == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(15);
        }
        if (importSpec.isCImport()) {
            if (importSpec.getDot() != null || importSpec.getIdentifier() != null) {
                problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.cannot.rename.import.c"), new GoDeleteImportSpecAlias(), new GoDeleteImportQuickFix());
            }
            return false;
        }
        return true;
    }

    private static boolean validateCanonicalPath(boolean supportsCanonicalPaths, boolean supportsVendoring, @NotNull GoImportSpec importSpec, @NotNull Collection<GoPackage> resolvedPackages, @Nullable Module module, @NotNull GoProblemsHolder problemsHolder) {
        if (importSpec == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(16);
        }
        if (resolvedPackages == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(17);
        }
        if (problemsHolder == null) {
            GoInvalidPackageImportInspection.$$$reportNull$$$0(18);
        }
        if (!supportsCanonicalPaths) {
            return true;
        }
        for (GoPackage resolvedPackage : resolvedPackages) {
            String canonicalImport = resolvedPackage.getCanonicalImport(module);
            if (canonicalImport == null) continue;
            if (canonicalImport.isEmpty()) {
                problemsHolder.registerProblem((PsiElement)importSpec, GoInspectionProblemUtil.message("go.inspection.problem.path.imports.package.with.invalid.import.comment", GoInspectionProblemUtil.code(importSpec.getPath())), new GoDeleteImportQuickFix());
                return false;
            }
            if (canonicalImport.equals(importSpec.getPath())) continue;
            if (supportsVendoring) {
                VirtualFile referenceFile = importSpec.getContainingFile().getOriginalFile().getVirtualFile();
                LinkedHashSet<VirtualFile> pathsToLookup = GoSdkUtil.getSourcesPathsToLookup(importSpec.getProject(), module);
                for (VirtualFile directory : resolvedPackage.getDirectories()) {
                    if (!GoVendoringUtil.isVendoredPackage(directory, referenceFile, pathsToLookup, true)) continue;
                    return true;
                }
            }
            GoInspectionMessage message = GoInspectionProblemUtil.message("go.inspection.problem.path.imports.package.that.expects.canonical.import", GoInspectionProblemUtil.code(importSpec.getPath()), canonicalImport);
            problemsHolder.registerProblem((PsiElement)importSpec, message, new GoReplaceImportPath(canonicalImport), new GoDeleteImportQuickFix());
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanImportPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedPackages";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidPackageImportInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGoFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsCanonicalPaths";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportUnresolvedImport";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "validateImportedDirectory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isSdkIterPackage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanImport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "validateMainImport";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "validateCImport";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "validateCanonicalPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GoReplaceImportPath
    implements HighPriorityAction,
    LocalQuickFix {
        @NotNull
        private final String myNewImportPath;

        protected GoReplaceImportPath(@NotNull String newImportPath) {
            if (newImportPath == null) {
                GoReplaceImportPath.$$$reportNull$$$0(0);
            }
            this.myNewImportPath = newImportPath;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = GoBundle.message((String)"go.fix.replace.with.text", (Object[])new Object[]{this.myNewImportPath});
            if (string == null) {
                GoReplaceImportPath.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.replace.with.name", (Object[])new Object[0]);
            if (string == null) {
                GoReplaceImportPath.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            GoImportSpec element;
            if (project == null) {
                GoReplaceImportPath.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                GoReplaceImportPath.$$$reportNull$$$0(4);
            }
            if ((element = (GoImportSpec)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), GoImportSpec.class)) != null && element.isValid()) {
                ElementManipulators.handleContentChange((PsiElement)element.getStringLiteral(), (String)this.myNewImportPath);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newImportPath";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoInvalidPackageImportInspection$GoReplaceImportPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidPackageImportInspection$GoReplaceImportPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class GoShowBuildSettingsQuickFix
    implements LocalQuickFix,
    HighPriorityAction {
        private GoShowBuildSettingsQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.notification.go.edit.project.settings.action.text", (Object[])new Object[0]);
            if (string == null) {
                GoShowBuildSettingsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                GoShowBuildSettingsQuickFix.$$$reportNull$$$0(1);
            }
            if (previewDescriptor == null) {
                GoShowBuildSettingsQuickFix.$$$reportNull$$$0(2);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                GoShowBuildSettingsQuickFix.$$$reportNull$$$0(3);
            }
            return intentionPreviewInfo;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Module module;
            if (project == null) {
                GoShowBuildSettingsQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                GoShowBuildSettingsQuickFix.$$$reportNull$$$0(5);
            }
            if ((module = GoUtil.module(descriptor.getStartElement())) != null) {
                ApplicationManager.getApplication().invokeLater(() -> GoModuleSettings.showModulesConfigurable(module));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoInvalidPackageImportInspection$GoShowBuildSettingsQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidPackageImportInspection$GoShowBuildSettingsQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class GoDeleteImportSpecAlias
    implements LocalQuickFix {
        private GoDeleteImportSpecAlias() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.delete.name", (Object[])new Object[]{GoBundle.message((String)"go.terms.import.alias", (Object[])new Object[0])});
            if (string == null) {
                GoDeleteImportSpecAlias.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            GoImportSpec element;
            if (project == null) {
                GoDeleteImportSpecAlias.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoDeleteImportSpecAlias.$$$reportNull$$$0(2);
            }
            if ((element = (GoImportSpec)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), GoImportSpec.class)) != null && element.isValid()) {
                PsiElement dot = element.getDot();
                if (dot != null) {
                    dot.delete();
                    return;
                }
                PsiElement identifier = element.getIdentifier();
                if (identifier != null) {
                    identifier.delete();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoInvalidPackageImportInspection$GoDeleteImportSpecAlias";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidPackageImportInspection$GoDeleteImportSpecAlias";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

