/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.highlighting.legacyErrorInspections.GoTypeCheckingUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoKey;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMapType;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoValue;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.fake.GoFieldNameBasedFakeExpression;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedElement;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedType;
import com.goide.psi.impl.typesCompatibility.GoTypeCheckResult;
import com.goide.psi.impl.typesCompatibility.GoTypesNotCompatible;
import com.goide.quickfix.GoNavigateToQuickFix;
import com.goide.util.GoUtil;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoInvalidCompositeLiteralInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoInvalidCompositeLiteralInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoInvalidCompositeLiteralInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitCompositeLit(@NotNull GoCompositeLit o) {
        if (o == null) {
            GoInvalidCompositeLiteralInspection.$$$reportNull$$$0(1);
        }
        super.visitCompositeLit(o);
        GoLiteralValue value = o.getLiteralValue();
        if (value == null) {
            return;
        }
        this.process(value, GoReferenceBase.getSubstitutionContextOrSelf(value));
    }

    @Override
    public void visitLiteralValue(@NotNull GoLiteralValue o) {
        if (o == null) {
            GoInvalidCompositeLiteralInspection.$$$reportNull$$$0(2);
        }
        super.visitLiteralValue(o);
        if (!(o.getParent() instanceof GoCompositeLit)) {
            this.process(o, GoReferenceBase.getSubstitutionContextOrSelf(o));
        }
    }

    private void process(@Nullable GoLiteralValue o, @Nullable PsiElement context) {
        GoType type = GoPsiImplUtil.getLiteralType(o);
        if (type == null) {
            return;
        }
        GoType unwrappedType = GoPsiImplUtil.unwrapLiteralType(type, o.getParent() instanceof GoCompositeLit, context);
        if (GoTypeUtil.isCType(unwrappedType, context)) {
            return;
        }
        new CompositeLiteralValueChecker(this.myHolder, o, type, unwrappedType, context).check();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidCompositeLiteralInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCompositeLit";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteralValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CompositeLiteralValueChecker
    extends LiteralValueChecker {
        @NotNull
        private final GoType myType;
        @Nullable
        private final GoType myUnwrappedType;
        @Nullable
        private final PsiElement myContext;

        private CompositeLiteralValueChecker(@NotNull GoProblemsHolder holder, @NotNull GoLiteralValue value, @NotNull GoType type, @Nullable GoType unwrappedType, @Nullable PsiElement context) {
            if (holder == null) {
                CompositeLiteralValueChecker.$$$reportNull$$$0(0);
            }
            if (value == null) {
                CompositeLiteralValueChecker.$$$reportNull$$$0(1);
            }
            if (type == null) {
                CompositeLiteralValueChecker.$$$reportNull$$$0(2);
            }
            super(holder, value, type, type);
            this.myType = type;
            this.myUnwrappedType = unwrappedType;
            this.myContext = context;
        }

        @Override
        void check() {
            if (!GoPsiImplUtil.isValidLiteralType(this.myUnwrappedType)) {
                PsiElement parent = this.myValue.getParent();
                this.myHolder.registerProblem((PsiElement)(parent instanceof GoCompositeElement ? parent : this.myValue), GoInspectionProblemUtil.message("go.inspection.problem.invalid.composite.literal.type", this.myType.getPresentationText()), new LocalQuickFix[0]);
            } else {
                LiteralValueChecker checker = this.getChecker(this.myUnwrappedType);
                if (checker != null) {
                    checker.check();
                }
            }
        }

        @Nullable
        private LiteralValueChecker getChecker(@Nullable GoType type) {
            GoType unwrappedType = GoPsiImplUtil.unwrapInstantiation(type);
            if (unwrappedType instanceof GoStructType) {
                return new StructLiteralValueChecker(this.myHolder, this.myValue, (GoStructType)unwrappedType, type);
            }
            if (unwrappedType instanceof GoMapType) {
                return new MapLiteralValueChecker(this.myHolder, this.myValue, (GoMapType)unwrappedType, type, this.myContext);
            }
            if (unwrappedType instanceof GoArrayOrSliceType) {
                return new ArrayOrSliceLiteralValueChecker(this.myHolder, this.myValue, (GoArrayOrSliceType)unwrappedType, type);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidCompositeLiteralInspection$CompositeLiteralValueChecker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ArrayOrSliceLiteralValueChecker
    extends LiteralValueChecker {
        @NotNull
        private final GoArrayOrSliceType myType;

        private ArrayOrSliceLiteralValueChecker(@NotNull GoProblemsHolder holder, @NotNull GoLiteralValue value, @NotNull GoArrayOrSliceType type, @NotNull GoType originalType) {
            if (holder == null) {
                ArrayOrSliceLiteralValueChecker.$$$reportNull$$$0(0);
            }
            if (value == null) {
                ArrayOrSliceLiteralValueChecker.$$$reportNull$$$0(1);
            }
            if (type == null) {
                ArrayOrSliceLiteralValueChecker.$$$reportNull$$$0(2);
            }
            if (originalType == null) {
                ArrayOrSliceLiteralValueChecker.$$$reportNull$$$0(3);
            }
            super(holder, value, type, originalType);
            this.myType = type;
        }

        @Override
        void check() {
            this.checkIndexesInKeys();
            this.checkElements(this::checkValue);
        }

        private void checkIndexesInKeys() {
            int len = this.myType.getLength();
            long index = 0L;
            LongArrayList indices = new LongArrayList();
            for (GoElement element : this.myValue.getElementList()) {
                index = ArrayOrSliceLiteralValueChecker.getUpdatedIndexFromKey(element, index);
                indices.add(index);
                ++index;
            }
            LongOpenHashSet visited = new LongOpenHashSet();
            for (int i = 0; i < indices.size(); ++i) {
                GoElement element = this.myValue.getElementList().get(i);
                GoKey key = element.getKey();
                if (key != null) {
                    this.checkIndexInKey(key);
                }
                this.checkIndexForBoundsAndDuplicates(element, (LongSet)visited, len, indices.getLong(i), index);
            }
        }

        void checkValue(@NotNull GoElement e) {
            if (e == null) {
                ArrayOrSliceLiteralValueChecker.$$$reportNull$$$0(4);
            }
            GoType innerType = this.myType.getType();
            GoExpression valueExpr = (GoExpression)ObjectUtils.doIfNotNull((Object)e.getValue(), it -> it.getExpression());
            if (valueExpr == null) {
                return;
            }
            this.processExpressionTypeCompatibility(valueExpr, innerType);
        }

        private static long getUpdatedIndexFromKey(@NotNull GoElement element, long index) {
            GoKey key;
            if (element == null) {
                ArrayOrSliceLiteralValueChecker.$$$reportNull$$$0(5);
            }
            if ((key = element.getKey()) == null) {
                return index;
            }
            Value keyValue = key.getValue();
            Long integer = keyValue != null ? keyValue.getInteger() : null;
            return integer != null ? integer : index;
        }

        private void checkIndexInKey(@NotNull GoKey elementKey) {
            GoFieldName name;
            Long integer;
            Value keyValue;
            if (elementKey == null) {
                ArrayOrSliceLiteralValueChecker.$$$reportNull$$$0(6);
            }
            if ((keyValue = elementKey.getValue()) != null && (integer = keyValue.getInteger()) == null) {
                String valueText = keyValue.toString();
                GoInspectionMessage message = valueText != null ? GoInspectionProblemUtil.message("go.inspection.problem.cannot.convert.known.value.to.type", GoInspectionProblemUtil.code(valueText), GoInspectionProblemUtil.code("int")) : GoInspectionProblemUtil.message("go.inspection.problem.cannot.convert.value.to.type", GoInspectionProblemUtil.code("int"));
                this.myHolder.registerProblem((PsiElement)elementKey, message, new LocalQuickFix[0]);
            }
            PsiElement resolve = (name = elementKey.getFieldName()) != null ? name.resolve() : null;
            GoExpression keyExpression = elementKey.getExpression();
            if (resolve != null && !(resolve instanceof GoConstDefinition) || keyExpression != null && !GoExpressionUtil.isConstant(keyExpression)) {
                this.myHolder.registerProblem((PsiElement)elementKey, GoInspectionProblemUtil.message("go.inspection.problem.index.must.be.a.non.negative.integer.constant", elementKey.getText()), new LocalQuickFix[0]);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void checkIndexForBoundsAndDuplicates(@NotNull GoElement element, @NotNull LongSet visited, long length, long index, long l) {
            if (element == null) {
                ArrayOrSliceLiteralValueChecker.$$$reportNull$$$0(7);
            }
            if (visited == null) {
                ArrayOrSliceLiteralValueChecker.$$$reportNull$$$0(8);
            }
            if (index < 0L) {
                this.myHolder.registerProblem((PsiElement)ObjectUtils.notNull((Object)element.getKey(), (Object)element), GoInspectionProblemUtil.message("go.inspection.problem.negative.index", index), new LocalQuickFix[0]);
            } else if (length >= 0L && index >= length) {
                void requiredArraySize;
                this.myHolder.registerProblem((PsiElement)ObjectUtils.notNull((Object)element.getKey(), (Object)element), GoInspectionProblemUtil.message("go.inspection.problem.index.out.of.bounds", String.valueOf(index)), this.getChangeArrayQuickFix((long)requiredArraySize));
            } else if (!visited.add(index)) {
                this.myHolder.registerProblem((PsiElement)ObjectUtils.notNull((Object)element.getKey(), (Object)element), GoInspectionProblemUtil.message("go.inspection.problem.duplicate.index", index), new LocalQuickFix[0]);
            }
        }

        private @NotNull LocalQuickFix @Nullable [] getChangeArrayQuickFix(long requiredArraySize) {
            return this.myType.getExpression() instanceof GoLiteral ? GoInspectionProblemUtil.fixes(new LocalQuickFix[]{new GoChangeArraySizeQuickFix(this.myType, requiredArraySize)}) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementKey";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
            }
            objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidCompositeLiteralInspection$ArrayOrSliceLiteralValueChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUpdatedIndexFromKey";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIndexInKey";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIndexForBoundsAndDuplicates";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class GoChangeArraySizeQuickFix
        extends LocalQuickFixOnPsiElement {
            private final long myNewSize;

            protected GoChangeArraySizeQuickFix(@NotNull GoArrayOrSliceType typeToUpdate, long size) {
                if (typeToUpdate == null) {
                    GoChangeArraySizeQuickFix.$$$reportNull$$$0(0);
                }
                super((PsiElement)typeToUpdate);
                this.myNewSize = size;
            }

            @NotNull
            public String getText() {
                String string = GoBundle.message((String)"go.fix.change.array.size.to", (Object[])new Object[]{this.myNewSize});
                if (string == null) {
                    GoChangeArraySizeQuickFix.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = GoBundle.message((String)"go.fix.change.array.size.to.family.name", (Object[])new Object[0]);
                if (string == null) {
                    GoChangeArraySizeQuickFix.$$$reportNull$$$0(2);
                }
                return string;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                GoArrayOrSliceType typeToUpdate;
                if (project == null) {
                    GoChangeArraySizeQuickFix.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    GoChangeArraySizeQuickFix.$$$reportNull$$$0(4);
                }
                if (startElement == null) {
                    GoChangeArraySizeQuickFix.$$$reportNull$$$0(5);
                }
                if (endElement == null) {
                    GoChangeArraySizeQuickFix.$$$reportNull$$$0(6);
                }
                if ((typeToUpdate = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)startElement, GoArrayOrSliceType.class)) == null || !typeToUpdate.isArray() || typeToUpdate.getExpression() == null) {
                    return;
                }
                GoExpression expression = typeToUpdate.getExpression();
                expression.replace(GoElementFactory.createExpression(typeToUpdate.getProject(), String.valueOf(this.myNewSize)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeToUpdate";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoInvalidCompositeLiteralInspection$ArrayOrSliceLiteralValueChecker$GoChangeArraySizeQuickFix";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidCompositeLiteralInspection$ArrayOrSliceLiteralValueChecker$GoChangeArraySizeQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static final class MapLiteralValueChecker
    extends LiteralValueChecker {
        @NotNull
        private final GoMapType myType;
        @Nullable
        private final PsiElement myContext;

        private MapLiteralValueChecker(@NotNull GoProblemsHolder holder, @NotNull GoLiteralValue value, @NotNull GoMapType type, @NotNull GoType originalType, @Nullable PsiElement context) {
            if (holder == null) {
                MapLiteralValueChecker.$$$reportNull$$$0(0);
            }
            if (value == null) {
                MapLiteralValueChecker.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MapLiteralValueChecker.$$$reportNull$$$0(2);
            }
            if (originalType == null) {
                MapLiteralValueChecker.$$$reportNull$$$0(3);
            }
            super(holder, value, type, originalType);
            this.myType = type;
            this.myContext = context;
        }

        void checkElement(@NotNull GoElement e, @NotNull MultiMap<Value<?>, GoKey> keyExpressions) {
            GoKey key;
            if (e == null) {
                MapLiteralValueChecker.$$$reportNull$$$0(4);
            }
            if (keyExpressions == null) {
                MapLiteralValueChecker.$$$reportNull$$$0(5);
            }
            if ((key = e.getKey()) == null) {
                this.myHolder.registerProblem((PsiElement)e, GoInspectionProblemUtil.message("go.inspection.problem.missing.key.in.map.literal"), new LocalQuickFix[0]);
                return;
            }
            this.checkKeyInMap(key, keyExpressions);
            GoExpression valueExpr = (GoExpression)ObjectUtils.doIfNotNull((Object)e.getValue(), it -> it.getExpression());
            if (valueExpr != null) {
                this.processExpressionTypeCompatibility(valueExpr, this.myType.getValueType());
            }
        }

        @Override
        void check() {
            MultiMap keyExpressions = MultiMap.create();
            for (GoKey key : this.myKeyList) {
                Value value;
                GoExpression expression = MapLiteralValueChecker.getKeyExpression(key);
                if (expression == null || !expression.isConstant() || (value = expression.getValue()) == null) continue;
                keyExpressions.putValue((Object)value, (Object)key);
            }
            this.checkElements(element -> this.checkElement((GoElement)element, (MultiMap<Value<?>, GoKey>)keyExpressions));
        }

        private void checkKeyInMap(@NotNull GoKey currentKey, @NotNull MultiMap<Value<?>, GoKey> keyExpressions) {
            GoExpression currentExpression;
            if (currentKey == null) {
                MapLiteralValueChecker.$$$reportNull$$$0(6);
            }
            if (keyExpressions == null) {
                MapLiteralValueChecker.$$$reportNull$$$0(7);
            }
            if ((currentExpression = MapLiteralValueChecker.getKeyExpression(currentKey)) == null) {
                return;
            }
            GoType mapKeyType = this.myType.getKeyType();
            if (!this.processExpressionTypeCompatibility(currentExpression, mapKeyType, currentKey) || !currentExpression.isConstant()) {
                return;
            }
            Value value = currentExpression.getValue();
            for (GoKey key : keyExpressions.get((Object)value)) {
                GoExpression expression;
                if (key == currentKey || (expression = MapLiteralValueChecker.getKeyExpression(key)) == null || !GoTypeUtil.identical(expression.getGoType(null), currentExpression.getGoType(null), true, this.myContext)) continue;
                GoNavigateToQuickFix fix = new GoNavigateToQuickFix(key, GoBundle.message((String)"go.terms.duplicate", (Object[])new Object[0]));
                this.myHolder.registerProblem((PsiElement)currentKey, GoInspectionProblemUtil.message("go.inspection.problem.duplicate.key.in.map.literal", value), fix);
                return;
            }
        }

        @Nullable
        private static GoExpression getKeyExpression(@NotNull GoKey key) {
            GoExpression expression;
            if (key == null) {
                MapLiteralValueChecker.$$$reportNull$$$0(8);
            }
            if ((expression = key.getExpression()) != null) {
                return expression;
            }
            GoFieldName fieldName = key.getFieldName();
            return fieldName != null ? new GoFieldNameBasedFakeExpression(fieldName) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyExpressions";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentKey";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidCompositeLiteralInspection$MapLiteralValueChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkElement";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkKeyInMap";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getKeyExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class StructLiteralValueChecker
    extends LiteralValueChecker {
        @NotNull
        private final GoStructType myType;

        private StructLiteralValueChecker(@NotNull GoProblemsHolder holder, @NotNull GoLiteralValue value, @NotNull GoStructType type, @NotNull GoType originalType) {
            if (holder == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(0);
            }
            if (value == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(1);
            }
            if (type == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(2);
            }
            if (originalType == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(3);
            }
            super(holder, value, type, originalType);
            this.myType = type;
        }

        @Override
        void check() {
            List<GoElement> elements = this.myValue.getElementList();
            if (elements.isEmpty()) {
                return;
            }
            if (ContainerUtil.exists(elements, e -> e.getKey() != null)) {
                MultiMap keys = MultiMap.create();
                for (GoKey key : this.myKeyList) {
                    GoFieldName fieldName = key != null ? key.getFieldName() : null;
                    String name = fieldName != null ? fieldName.getText() : null;
                    if (name == null) continue;
                    keys.putValue((Object)name, (Object)key);
                }
                this.checkElements(element -> this.checkElementIfKeyExpected((GoElement)element, (MultiMap<String, GoKey>)keys));
            } else {
                this.checkElementsIfKeysUnexpected();
            }
        }

        private void checkElementsIfKeysUnexpected() {
            List<GoNamedElement> fields = this.myType.getFieldDefinitions();
            List<GoElement> elements = this.myValue.getElementList();
            boolean isStructFromCurrentPackage = GoUtil.isDirectlyAccessible(this.myType.getContainingFile(), this.myValue.getContainingFile());
            Iterator<GoElement> iterator = elements.iterator();
            for (GoNamedElement field : fields) {
                if (!iterator.hasNext()) break;
                this.checkField(iterator.next(), field, isStructFromCurrentPackage);
            }
            if (fields.size() != elements.size()) {
                this.myHolder.registerProblem((PsiElement)this.myValue, fields.size() > elements.size() ? GoInspectionProblemUtil.message("go.inspection.problem.too.few.values") : GoInspectionProblemUtil.message("go.inspection.problem.too.many.values"), new LocalQuickFix[0]);
            }
        }

        private void checkField(@NotNull GoElement element, @NotNull GoNamedElement field, boolean isStructFromCurrentPackage) {
            if (element == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(4);
            }
            if (field == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(5);
            }
            if (!GoInspectionUtil.canAccessField(field, isStructFromCurrentPackage)) {
                this.myHolder.registerProblem((PsiElement)element, field.isBlank() ? GoInspectionProblemUtil.message("go.inspection.problem.cannot.assign.value.to.blank.field") : GoInspectionProblemUtil.message("go.inspection.problem.cannot.assign.value.to.unexported.field", GoInspectionProblemUtil.code(Objects.requireNonNull(field.getName()))), new LocalQuickFix[0]);
                return;
            }
            GoExpression valueExpr = (GoExpression)ObjectUtils.doIfNotNull((Object)element.getValue(), it -> it.getExpression());
            if (valueExpr == null) {
                this.myHolder.registerProblem((PsiElement)element, GoInspectionProblemUtil.message("go.inspection.problem.missing.type.in.composite.literal"), new LocalQuickFix[0]);
                return;
            }
            this.processExpressionTypeCompatibility(valueExpr, field.getGoType(null));
        }

        private void checkElementIfKeyExpected(@NotNull GoElement e, @NotNull MultiMap<String, GoKey> keys) {
            GoFieldName fieldName;
            if (e == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(6);
            }
            if (keys == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(7);
            }
            this.checkKey(e, keys);
            GoKey key = e.getKey();
            GoFieldName goFieldName = fieldName = key != null ? key.getFieldName() : null;
            if (fieldName != null) {
                this.checkValue(e, fieldName);
            }
        }

        private void checkKey(@NotNull GoElement e, @NotNull MultiMap<String, GoKey> keys) {
            GoKey key;
            if (e == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(8);
            }
            if (keys == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(9);
            }
            if ((key = e.getKey()) == null) {
                this.myHolder.registerProblem((PsiElement)e, GoInspectionProblemUtil.message("go.inspection.problem.mixture.of.field"), new LocalQuickFix[0]);
                return;
            }
            GoFieldName fieldName = key.getFieldName();
            if (fieldName == null) {
                this.myHolder.registerProblem((PsiElement)key, GoInspectionProblemUtil.message("go.inspection.problem.invalid.field.name"), new LocalQuickFix[0]);
                return;
            }
            this.checkDuplicates(e, fieldName, keys);
        }

        private void checkDuplicates(@NotNull GoElement e, @NotNull GoFieldName fieldName, @NotNull MultiMap<String, GoKey> keys) {
            String name;
            if (e == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(10);
            }
            if (fieldName == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(11);
            }
            if (keys == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(12);
            }
            if ((name = fieldName.getText()) == null || name.isEmpty()) {
                return;
            }
            for (GoKey key : keys.get((Object)name)) {
                if (key == e.getKey()) continue;
                GoNavigateToQuickFix fix = new GoNavigateToQuickFix(key, GoBundle.message((String)"go.terms.duplicate", (Object[])new Object[0]));
                this.myHolder.registerProblem((PsiElement)e, GoInspectionProblemUtil.message("go.inspection.problem.duplicate.field", GoInspectionProblemUtil.code(name)), fix);
                return;
            }
        }

        private void checkValue(@NotNull GoElement e, @NotNull GoFieldName fieldName) {
            GoValue value;
            if (e == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(13);
            }
            if (fieldName == null) {
                StructLiteralValueChecker.$$$reportNull$$$0(14);
            }
            if ((value = e.getValue()) == null) {
                return;
            }
            GoExpression valueExpr = value.getExpression();
            if (valueExpr == null) {
                this.myHolder.registerProblem((PsiElement)value, GoInspectionProblemUtil.message("go.inspection.problem.missing.expression"), new LocalQuickFix[0]);
                return;
            }
            GoTypeOwner resolve = (GoTypeOwner)ObjectUtils.tryCast((Object)fieldName.resolve(), GoTypeOwner.class);
            if (resolve == null) {
                return;
            }
            this.processExpressionTypeCompatibility(valueExpr, resolve.getGoType(null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 7: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
            }
            objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidCompositeLiteralInspection$StructLiteralValueChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkField";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkElementIfKeyExpected";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkKey";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkDuplicates";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class LiteralValueChecker {
        @NotNull
        final GoLiteralValue myValue;
        @NotNull
        final List<GoKey> myKeyList;
        @NotNull
        final GoType myOriginalType;
        final GoProblemsHolder myHolder;

        private LiteralValueChecker(@NotNull GoProblemsHolder holder, @NotNull GoLiteralValue value, @NotNull GoType type, @NotNull GoType originalType) {
            if (holder == null) {
                LiteralValueChecker.$$$reportNull$$$0(0);
            }
            if (value == null) {
                LiteralValueChecker.$$$reportNull$$$0(1);
            }
            if (type == null) {
                LiteralValueChecker.$$$reportNull$$$0(2);
            }
            if (originalType == null) {
                LiteralValueChecker.$$$reportNull$$$0(3);
            }
            this.myValue = value;
            this.myKeyList = this.getKeyList(type);
            this.myHolder = holder;
            this.myOriginalType = originalType;
        }

        abstract void check();

        void checkElements(Consumer<GoElement> checkingConsumer) {
            this.myValue.getElementList().forEach(checkingConsumer);
        }

        @NotNull
        private List<GoKey> getKeyList(@NotNull GoType type) {
            if (type == null) {
                LiteralValueChecker.$$$reportNull$$$0(4);
            }
            if (type instanceof GoArrayOrSliceType) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    LiteralValueChecker.$$$reportNull$$$0(5);
                }
                return list;
            }
            List list = ContainerUtil.skipNulls((Collection)ContainerUtil.map(this.myValue.getElementList(), GoElement::getKey));
            if (list == null) {
                LiteralValueChecker.$$$reportNull$$$0(6);
            }
            return list;
        }

        void processExpressionTypeCompatibility(@NotNull GoExpression expr, @Nullable GoType type) {
            if (expr == null) {
                LiteralValueChecker.$$$reportNull$$$0(7);
            }
            this.processExpressionTypeCompatibility(expr, type, expr);
        }

        @Contract(value="_, null, _ -> true")
        boolean processExpressionTypeCompatibility(@NotNull GoExpression expr, @Nullable GoType type, @NotNull PsiElement originalElement) {
            GoTypeCheckResult result;
            if (expr == null) {
                LiteralValueChecker.$$$reportNull$$$0(8);
            }
            if (originalElement == null) {
                LiteralValueChecker.$$$reportNull$$$0(9);
            }
            if (type == null) {
                return true;
            }
            if (this.myOriginalType instanceof GoInstantiatedType) {
                type = type.withInstantiation((GoInstantiatedElement)((Object)this.myOriginalType));
            }
            if ((result = GoTypeUtil.checkAssignable(type, expr, false)) instanceof GoTypesNotCompatible) {
                GoInspectionMessage message = GoTypeCheckingUtil.commonErrorDescription(expr, type, result);
                GoTypeCheckingUtil.registerProblem(this.myHolder, originalElement, expr, message, type, result);
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoInvalidCompositeLiteralInspection$LiteralValueChecker";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoInvalidCompositeLiteralInspection$LiteralValueChecker";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeyList";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "processExpressionTypeCompatibility";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

