/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeCaseClause;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoNavigateToQuickFix;
import com.goide.util.Value;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.IdentityHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoDuplicateCaseInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoDuplicateCaseInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoDuplicateCaseInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitExprSwitchStatement(@NotNull GoExprSwitchStatement o) {
        if (o == null) {
            GoDuplicateCaseInspection.$$$reportNull$$$0(1);
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        SmartList list = new SmartList();
        o.getExprCaseClauseList().forEach(arg_0 -> GoDuplicateCaseInspection.lambda$visitExprSwitchStatement$0((List)list, arg_0));
        this.checkCollection((List)list, context);
    }

    @Override
    public void visitTypeSwitchStatement(@NotNull GoTypeSwitchStatement o) {
        if (o == null) {
            GoDuplicateCaseInspection.$$$reportNull$$$0(2);
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(o);
        SmartList types = new SmartList();
        for (GoTypeCaseClause clause : o.getTypeCaseClauseList()) {
            types.addAll(GoTypeUtil.getListOfTypesFromTypeList(clause.getType()));
        }
        this.checkCollection((List)types, context);
    }

    private <T extends PsiElement> void checkCollection(List<T> list, @Nullable PsiElement context) {
        IdentityHashMap<PsiElement, PsiElement> errors = new IdentityHashMap<PsiElement, PsiElement>();
        IdentityHashMap<PsiElement, PsiElement> warnings = new IdentityHashMap<PsiElement, PsiElement>();
        block0: for (int i = 0; i < list.size(); ++i) {
            PsiElement l = (PsiElement)list.get(i);
            if (l == null) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                ProblemHighlightType highlightType;
                PsiElement r = (PsiElement)list.get(j);
                if (l == r || r == null || (highlightType = GoDuplicateCaseInspection.getHighlightingType(l, r, context)) == null) continue;
                if (highlightType == ProblemHighlightType.WEAK_WARNING) {
                    warnings.put(r, l);
                } else {
                    errors.put(r, l);
                }
                this.registerProblem(l, highlightType, r);
                continue block0;
            }
        }
        errors.forEach((e, dup) -> this.registerProblem((PsiElement)e, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (PsiElement)dup));
        warnings.keySet().removeAll(errors.keySet());
        warnings.forEach((e, dup) -> this.registerProblem((PsiElement)e, ProblemHighlightType.WEAK_WARNING, (PsiElement)dup));
    }

    private void registerProblem(@NotNull PsiElement e, @NotNull ProblemHighlightType highlightType, @NotNull PsiElement duplicate) {
        if (e == null) {
            GoDuplicateCaseInspection.$$$reportNull$$$0(3);
        }
        if (highlightType == null) {
            GoDuplicateCaseInspection.$$$reportNull$$$0(4);
        }
        if (duplicate == null) {
            GoDuplicateCaseInspection.$$$reportNull$$$0(5);
        }
        this.myHolder.registerProblem(e, GoInspectionProblemUtil.message("go.inspection.problem.duplicate.case", e.getText()), highlightType, new GoNavigateToQuickFix(duplicate, GoBundle.message((String)"go.terms.duplicated.case", (Object[])new Object[0])));
    }

    @Nullable
    private static <T> ProblemHighlightType getHighlightingType(T l, T r, @Nullable PsiElement context) {
        if (l instanceof GoType && r instanceof GoType) {
            return GoTypeUtil.identical((GoType)l, (GoType)r, true, context) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : null;
        }
        if (l instanceof GoExpression) {
            GoExpression left = (GoExpression)l;
            if (r instanceof GoExpression) {
                GoExpression right = (GoExpression)r;
                Value value = left.getValue();
                if (value != null && value.equals(right.getValue())) {
                    return left.isConstant() && right.isConstant() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING;
                }
                if (GoExpressionUtil.identical(left, right, context)) {
                    return ProblemHighlightType.WEAK_WARNING;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void lambda$visitExprSwitchStatement$0(List list, GoExprCaseClause exprCase) {
        list.addAll(exprCase.getExpressionList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicate";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoDuplicateCaseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExprSwitchStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeSwitchStatement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

